/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ebook.util.prelayout;

import com.amazon.ebook.util.log.Log;
import com.amazon.ebook.util.log.Profiler;
import com.amazon.ebook.util.prelayout.CacheManager;
import com.amazon.ebook.util.thread.ThreadPoolRunnable;

public abstract class PrelayoutEngine {
    private static final Log LOG = Log.getInstance((String)"PrelayoutEngine");
    protected Object lock;
    private ThreadPoolRunnable backgroundThread;
    protected CacheManager cache;
    private boolean terminationFlag;
    private static Profiler p = new Profiler("PrelayoutEngine");

    public PrelayoutEngine(CacheManager a) {
        PrelayoutEngine a2;
        a2.cache = a;
        a2.lock = a2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startPrelayout(Object a) {
        try {
            PrelayoutEngine a2;
            if (Log.isDebugOn()) {
                LOG.debug("Entering startPrelayout {{{");
            }
            Object object = a2.lock;
            synchronized (object) {
                block11: {
                    if (a2.backgroundThread == null) break block11;
                    if (Log.isDebugOn()) {
                        LOG.debug("Still running on a previous job. Call stop before start");
                    }
                    return;
                }
                a2.terminationFlag = false;
                a2.backgroundThread = a2.new PrelayoutRunnable("Prelayout runnable", a);
            }
            a2.backgroundThread.start();
        }
        finally {
            if (Log.isDebugOn()) {
                LOG.debug("Exiting startPrelayout }}}");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopPrelayout(boolean a) {
        PrelayoutEngine a2;
        ThreadPoolRunnable a3 = a2.backgroundThread;
        Object object = a2.lock;
        synchronized (object) {
            a2.terminationFlag = true;
        }
        if (a3 != null) {
            try {
                if (a) {
                    if (Log.isDebugOn()) {
                        LOG.debug("Joining backgroundThread now..");
                    }
                    p.mark();
                    a3.join();
                    p.dump("Joining backgroundThread took");
                    if (Log.isDebugOn()) {
                        LOG.debug("Joined backgroundThread now.");
                    }
                }
            }
            catch (InterruptedException a4) {
                LOG.error(a4.getMessage());
            }
        }
        Object a4 = a2.lock;
        synchronized (a4) {
            a2.backgroundThread = null;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean shouldTerminate() {
        PrelayoutEngine a;
        Object object = a.lock;
        synchronized (object) {
            return a.terminationFlag;
        }
    }

    protected abstract void prelayoutAndCache(Object var1);

    private class PrelayoutRunnable
    extends ThreadPoolRunnable {
        private Object data;

        public PrelayoutRunnable(String a, Object a2) {
            PrelayoutRunnable a3;
            super(a);
            a3.data = a2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            String a = "PrelayoutRunnable.run()";
            if (Log.isDebugOn()) {
                LOG.debug("Entering run {{{");
            }
            try {
                PrelayoutRunnable a2;
                Object object = a2.PrelayoutEngine.this.lock;
                synchronized (object) {
                    if (a2.PrelayoutEngine.this.terminationFlag) {
                        return;
                    }
                }
                a2.PrelayoutEngine.this.prelayoutAndCache(a2.data);
                object = a2.PrelayoutEngine.this.lock;
                synchronized (object) {
                    a2.PrelayoutEngine.this.terminationFlag = false;
                    a2.PrelayoutEngine.this.backgroundThread = null;
                    return;
                }
            }
            finally {
                if (Log.isDebugOn()) {
                    LOG.debug("Exiting run }}}");
                }
            }
        }
    }
}

