/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ebook.util.prelayout;

import com.amazon.ebook.util.log.Log;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class CacheManager {
    private Map cache;
    private EvictionPolicy policy;
    private long size;
    private static final Log LOG = Log.getInstance((String)CacheManager.class.getName());

    public CacheManager(int a, float a2, EvictionPolicy a3) {
        CacheManager a4;
        a4.cache = Collections.synchronizedMap(new HashMap(a, a2));
        a4.policy = a3;
        a4.size = 0L;
    }

    public Object get(Object a) {
        CacheManager a2;
        return a2.cache.get(a);
    }

    public void put(Cacheable a) {
        Object a2;
        CacheManager a3;
        if (a3.policy.evictReqd(a3.cache, a) && (a2 = a3.evict(a3.cache, a)) != null) {
            if (Log.isDebugOn()) {
                LOG.debug("Removing " + a + " from cache.");
            }
            a3.cache.remove(a2);
        }
        if (Log.isDebugOn()) {
            LOG.debug("Inserting " + a + " into cache.");
        }
        if ((a2 = a3.cache.put(a.getId(), a.getValue())) instanceof CacheableValue) {
            a3.size -= ((CacheableValue)a2).getMass();
        }
        a3.size += a.getValue().getMass();
    }

    public void removeFromCache(Object a) {
        CacheManager a2;
        a2.cache.remove(a);
    }

    public void clear() {
        CacheManager a;
        a.cache.clear();
    }

    private Object evict(Map a, Cacheable a2) {
        CacheManager a3;
        return a3.policy.evict(a);
    }

    public static interface EvictionPolicy {
        public boolean evictReqd(Map var1, Cacheable var2);

        public Object evict(Map var1);
    }

    public static interface CacheableValue {
        public long getMass();
    }

    public static interface Cacheable {
        public Object getId();

        public CacheableValue getValue();
    }
}

