/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ebook.booklet.periodicals.ui.header;

import com.amazon.ebook.booklet.periodicals.PeriodicalBooklet;
import com.amazon.ebook.booklet.periodicals.ui.header.HeaderTextFactory;
import com.amazon.ebook.booklet.periodicals.ui.header.HeaderTextProvider;
import com.amazon.ebook.booklet.reader.sdk.ReaderSDK;
import com.amazon.ebook.booklet.reader.sdk.TOCException;
import com.amazon.ebook.booklet.reader.sdk.content.Element;
import com.amazon.ebook.booklet.reader.sdk.content.Position;
import com.amazon.ebook.booklet.reader.sdk.content.ScreenInfo;
import com.amazon.ebook.booklet.reader.sdk.content.TableOfContents;
import com.amazon.ebook.booklet.reader.sdk.content.TableOfContentsEntry;
import com.amazon.ebook.booklet.reader.sdk.content.Viewport;
import com.amazon.ebook.booklet.reader.sdk.content.annotation.Annotation;
import com.amazon.ebook.booklet.reader.sdk.ui.PageDecorator;
import com.amazon.ebook.booklet.reader.utils.TextUtils;
import com.amazon.ebook.util.log.Log;
import com.amazon.ebook.util.text.StringUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseListener;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.AbstractBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;

public class ReadingPaneHeader
extends JComponent
implements PageDecorator {
    private static final Log LOG = Log.getInstance((String)"ReadingPaneHeader");
    private static final String WIDGET_RESOURCE_NAME = "com.amazon.ebook.booklet.periodicals.ui.resources.ReadingPaneHeaderResources";
    private static ResourceBundle widgetResources;
    private ReaderSDK readerSDK;
    private Position lastScreenStartPosition;
    private JLabel notificationLabel;
    private HeaderTextProvider headerTextProvider;
    private TimerTask removeNotificationTask;
    private boolean showNotification;
    private String headerText;

    public ReadingPaneHeader(PeriodicalBooklet a) {
        ReadingPaneHeader a2;
        a2.readerSDK = a.getReaderSDK();
        a2.setLayout(new BorderLayout());
        widgetResources = ResourceBundle.getBundle(WIDGET_RESOURCE_NAME);
        a2.notificationLabel = new JLabel();
        a2.notificationLabel.setFont((Font)widgetResources.getObject("label.font"));
        a2.notificationLabel.setBorder(new CompoundBorder(new EmptyBorder((Insets)widgetResources.getObject("clip.label.margin")), a2.new ClipBorder((Integer)widgetResources.getObject("clip.label.shadow_thickness"))));
        a2.notificationLabel.setHorizontalAlignment(0);
        a2.addMouseListener((MouseListener)a.getPeriodicalsUI().getGestureDispatcher());
        a2.getActionMap().put(widgetResources.getString("event.gesture.tap"), a.getPeriodicalsUI().getContentSpecificUI().getShowChromeHeaderAction());
        a2.showNotification = false;
    }

    public void setPreferredSize(Dimension a) {
        ReadingPaneHeader a2;
        super.setPreferredSize(a);
    }

    public void setHeaderText(String a) {
        ReadingPaneHeader a2;
        widgetResources = ResourceBundle.getBundle(WIDGET_RESOURCE_NAME);
        Insets a3 = (Insets)widgetResources.getObject("label.margin");
        int a4 = a2.getPreferredSize().width - a3.left - a3.right;
        a2.headerText = TextUtils.getShortText((String)a, (FontMetrics)a2.getFontMetrics((Font)widgetResources.getObject("label.font")), (int)a4);
    }

    public void flashNotification(String a, int a2) {
        ReadingPaneHeader a3;
        widgetResources = ResourceBundle.getBundle(WIDGET_RESOURCE_NAME);
        a3.notificationLabel.setPreferredSize(null);
        Insets a4 = (Insets)widgetResources.getObject("clip.label.margin");
        int a5 = (Integer)widgetResources.getObject("clip.label.shadow_thickness");
        int a6 = a3.getPreferredSize().width - a4.left - a4.right - 2 * a5;
        a3.notificationLabel.setText(StringUtil.shortenText((FontMetrics)a3.notificationLabel.getFontMetrics(a3.notificationLabel.getFont()), (String)a, (int)a6));
        int a7 = a3.notificationLabel.getPreferredSize().height + a5 + a4.top + a4.bottom;
        int a8 = a3.notificationLabel.getPreferredSize().width + a4.left + a4.right + 2 * a5;
        a3.notificationLabel.setPreferredSize(new Dimension(a8, a7));
        a3.showNotification = true;
        a3.add((Component)a3.notificationLabel, "West");
        a3.validate();
        a3.repaint();
        if (a3.removeNotificationTask != null) {
            a3.removeNotificationTask.cancel();
        }
        a3.removeNotificationTask = new TimerTask(){
            {
                1 a;
            }

            public void run() {
                1 a;
                a.ReadingPaneHeader.this.showNotification = false;
                a.ReadingPaneHeader.this.removeAll();
                a.ReadingPaneHeader.this.validate();
                a.ReadingPaneHeader.this.repaint();
            }
        };
        new Timer().schedule(a3.removeNotificationTask, a2);
    }

    protected void paintComponent(Graphics a) {
        ReadingPaneHeader a2;
        if (a2.showNotification) {
            return;
        }
        Color a3 = a.getColor();
        Dimension a4 = a2.getPreferredSize();
        widgetResources = ResourceBundle.getBundle(WIDGET_RESOURCE_NAME);
        a.setColor((Color)widgetResources.getObject("color.foreground"));
        a.setFont((Font)widgetResources.getObject("label.font"));
        FontMetrics a5 = a.getFontMetrics(a.getFont());
        int a6 = a5.getLeading() + a5.getAscent() + (a4.height - a5.getHeight()) / 2;
        Insets a7 = (Insets)widgetResources.getObject("label.margin");
        a.drawString(a2.headerText, a7.left, a6);
        a.setColor(a3);
    }

    private void setUpHeader(ScreenInfo a) {
        Position a2;
        ReadingPaneHeader a3;
        TableOfContents a4 = a3.readerSDK.getCurrentBook().getTOC();
        widgetResources = ResourceBundle.getBundle(WIDGET_RESOURCE_NAME);
        if (a4 == null || a == null) {
            a3.setHeaderText(widgetResources.getString("message.default.string"));
            return;
        }
        Position position = a2 = a.getViewport() != null ? a.getViewport().getStartPosition() : null;
        if (a2 == null) {
            a3.setHeaderText(widgetResources.getString("message.default.string"));
            return;
        }
        TableOfContentsEntry a5 = a4.getTOCFromPosition(a2);
        TableOfContentsEntry a6 = a4.getCurrentTOCNodeEntry();
        if (a6 != null && a5 != null && !a2.equals((Object)a6.getPosition())) {
            Element a7;
            Element[] a8 = a.getElements();
            Element element = a7 = a8 != null && a8.length > 0 ? a8[0] : null;
            if (a7 != null) {
                TableOfContentsEntry a9 = a4.getTOCFromPosition(a7.getEndPosition());
                if (a9.equals(a5)) {
                    a2 = a7.getEndPosition();
                } else {
                    TableOfContentsEntry a10 = null;
                    try {
                        a10 = a4.getNextEntry(a5);
                    }
                    catch (TOCException a11) {
                        LOG.warning("Exception when getting nextEntry", (Throwable)a11);
                    }
                    a2 = a9.equals(a10) ? a7.getEndPosition() : a9.getPosition();
                }
            }
        }
        if (a3.lastScreenStartPosition != null && a3.lastScreenStartPosition.equals((Object)a2)) {
            return;
        }
        if (a3.headerTextProvider == null) {
            a3.headerTextProvider = HeaderTextFactory.getTextProviderInstance(a3.readerSDK);
        }
        if (a3.headerTextProvider != null) {
            a3.setHeaderText(a3.headerTextProvider.getHeaderText(a2));
        } else {
            a3.setHeaderText(widgetResources.getString("message.default.string"));
        }
        a3.lastScreenStartPosition = a2;
    }

    public boolean needsScreenInfo(Viewport a) {
        return true;
    }

    public List decoratePage(ScreenInfo a, Graphics2D a2, Rectangle a3) {
        ReadingPaneHeader a4;
        a4.setUpHeader(a);
        return null;
    }

    public List decoratePage(ScreenInfo a, Graphics2D a2, Rectangle a3, Annotation a4) {
        return null;
    }

    public boolean drawsOutsideContents() {
        return true;
    }

    public void setShowNotification(boolean a) {
        a.showNotification = a;
    }

    private class ClipBorder
    extends AbstractBorder {
        private int borderThickness;

        public ClipBorder(int a) {
            ClipBorder a2;
            a2.borderThickness = a;
        }

        public void paintBorder(Component a, Graphics a2, int a3, int a4, int a5, int a6) {
            ClipBorder a7;
            widgetResources = ResourceBundle.getBundle(ReadingPaneHeader.WIDGET_RESOURCE_NAME);
            Color a8 = (Color)widgetResources.getObject("clip.label.color_border");
            Color a9 = a2.getColor();
            a2.setColor(a8);
            a2.drawRect(a3, a4 + a7.borderThickness, a5 - a7.borderThickness, a6 - 2 * a7.borderThickness);
            a2.fillRect(a3 + a5 - a7.borderThickness, a4 + 2 * a7.borderThickness, a7.borderThickness, a6 - 2 * a7.borderThickness);
            a2.fillRect(a3 + a7.borderThickness, a4 + a6 - a7.borderThickness, a5 - 2 * a7.borderThickness, a7.borderThickness);
            a2.setColor(a9);
        }
    }
}

