/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ebook.booklet.periodicals.ui;

import com.amazon.ebook.booklet.reader.sdk.ReaderSDK;
import com.amazon.ebook.booklet.reader.sdk.TOCException;
import com.amazon.ebook.booklet.reader.sdk.content.Book;
import com.amazon.ebook.booklet.reader.sdk.content.Position;
import com.amazon.ebook.booklet.reader.sdk.content.TableOfContents;
import com.amazon.ebook.booklet.reader.sdk.content.TableOfContentsEntry;
import com.amazon.ebook.booklet.reader.sdk.content.Viewport;
import com.amazon.ebook.booklet.reader.sdk.ui.ProgressBar;
import com.amazon.ebook.booklet.reader.sdk.ui.ProgressStatusProvider;
import com.amazon.ebook.booklet.reader.utils.TextUtils;
import com.amazon.ebook.util.log.Log;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.text.MessageFormat;
import java.util.ResourceBundle;

public class ReadingPaneFooter
extends ProgressBar {
    private static final Log LOG = Log.getInstance((String)"ReadingPaneFooter");
    private static final String WIDGET_RESOURCE_NAME = "com.amazon.ebook.booklet.periodicals.ui.resources.ReadingPaneFooterResources";
    private static ResourceBundle widgetResources;
    private ReaderSDK readerSDK;
    private TableOfContentsEntry nextEntry;

    public ReadingPaneFooter(ReaderSDK a) {
        ReadingPaneFooter a2;
        a2.readerSDK = a;
        widgetResources = ResourceBundle.getBundle(WIDGET_RESOURCE_NAME);
        a2.setBackground((Color)widgetResources.getObject("color.background"));
    }

    public void paintComponent(Graphics a) {
        ReadingPaneFooter a2;
        super.paintComponent(a);
        Color a3 = a.getColor();
        a.setColor(a2.getBackground());
        a.fillRect(0, 0, a2.getPreferredSize().width, a2.getPreferredSize().height);
        a.setColor(a3);
        a2.paintProgress(a);
    }

    public TableOfContentsEntry getNextTableOfContentsEntry() {
        ReadingPaneFooter a;
        return a.nextEntry;
    }

    protected void paintProgress(Graphics a) {
        int a2;
        ReadingPaneFooter a3;
        Viewport a4 = a3.readerSDK.getBookNavigator().getViewport();
        Book a5 = a3.readerSDK.getCurrentBook();
        if (a4 == null || a5 == null) {
            return;
        }
        TableOfContents a6 = a5.getTOC();
        if (a6 == null) {
            return;
        }
        Position a7 = a4.getEndPosition();
        TableOfContentsEntry a8 = a6.getTOCFromPosition(a7);
        Double a9 = new Double(1.0);
        a3.nextEntry = a3.getNextEntryOutsideScreen(a6, a7, a8);
        if (a8 != null) {
            a9 = a3.getPercentCompletedInArticle(a8.getPosition(), a7, a5.getEndPosition(), a6, a3.nextEntry);
        }
        Dimension a10 = a3.getPreferredSize();
        widgetResources = ResourceBundle.getBundle(WIDGET_RESOURCE_NAME);
        a.setFont((Font)widgetResources.getObject("footer.font"));
        FontMetrics a11 = a.getFontMetrics();
        int a12 = a11.getHeight();
        Insets a13 = (Insets)widgetResources.getObject("footer.margin");
        int a14 = a10.width - (a13.left + a13.right);
        String a15 = ((MessageFormat)widgetResources.getObject("message.footer.percent")).format(new Object[]{a9});
        a.drawString(a15, a13.left, a12);
        int a16 = a11.stringWidth(a15);
        int a17 = (Integer)widgetResources.getObject("percent.article.gap");
        String a18 = a3.getFooterMessage(a3.nextEntry, a14 - (a16 + a17), a11);
        if (a18 != null && a18.length() > 0) {
            a2 = a10.width - a13.right - a11.stringWidth(a18);
            a.drawString(a18, a2, a12);
        }
        a2 = a12 + (Integer)widgetResources.getObject("text.bar.gap");
        int a19 = (Integer)widgetResources.getObject("bar.height");
        int a20 = (Integer)widgetResources.getObject("bar.edge.radius");
        a.drawRoundRect(a13.left, a2, a14, a19, a20, a20);
        int a21 = (Integer)widgetResources.getObject("bar.edge.thickness");
        int a22 = (Integer)widgetResources.getObject("bar.border.gap");
        long a23 = Math.round((double)a14 * a9) - (long)(2 * a22);
        a.fillRoundRect(a13.left + a21 + a22, a2 + a21 + a22, new Long(a23).intValue(), a19 - a22 - 2 * a21, a20, a20);
    }

    protected String getFooterMessage(TableOfContentsEntry a, int a2, FontMetrics a3) {
        widgetResources = ResourceBundle.getBundle(WIDGET_RESOURCE_NAME);
        if (a != null) {
            return TextUtils.getShortText((String)((MessageFormat)widgetResources.getObject("message.footer.article.next")).format(new Object[]{a.getLabel()}), (FontMetrics)a3, (int)a2);
        }
        return widgetResources.getString("message.default.string");
    }

    protected Double getPercentCompletedInArticle(Position a, Position a2, Position a3, TableOfContents a4, TableOfContentsEntry a5) throws IllegalStateException {
        Position a6 = a3;
        if (a5 != null) {
            a6 = a5.getPosition();
        }
        int a7 = a.createSortableIndexKey();
        return new Double((double)(a2.createSortableIndexKey() - a7) / (double)(a6.createSortableIndexKey() - a7));
    }

    private TableOfContentsEntry getNextEntryOutsideScreen(TableOfContents a, Position a2, TableOfContentsEntry a3) {
        ReadingPaneFooter a4;
        TableOfContentsEntry tableOfContentsEntry = a4.nextEntry = a4.getNextEntry(a, a3);
        while (tableOfContentsEntry != null && a4.nextEntry.getPosition().compareTo((Object)a2) < 0) {
            tableOfContentsEntry = a4.nextEntry = a4.getNextEntry(a, a3);
        }
        return a4.nextEntry;
    }

    private TableOfContentsEntry getNextEntry(TableOfContents a, TableOfContentsEntry a2) {
        if (a == null || a2 == null) {
            return null;
        }
        TableOfContentsEntry a3 = null;
        try {
            TableOfContentsEntry a4;
            TableOfContentsEntry a5;
            a3 = a.getNextEntry(a2);
            if (a3 == null && (a5 = a.getNextEntry(a4 = a.getParent(a2))) != null) {
                a3 = a.getChild(a5);
            }
        }
        catch (TOCException a6) {
            LOG.warning("Exception when getting next entry", (Throwable)a6);
        }
        return a3;
    }

    public ProgressStatusProvider setProgressStatusProvider(ProgressStatusProvider a) {
        return null;
    }
}

