/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ebook.booklet.periodicals.ui;

import com.amazon.agui.swing.CommandBar;
import com.amazon.ebook.booklet.periodicals.PeriodicalBooklet;
import com.amazon.ebook.booklet.periodicals.blogs.ui.BlogUI;
import com.amazon.ebook.booklet.periodicals.common.history.PeriodicalsViewContext;
import com.amazon.ebook.booklet.periodicals.common.ui.AbstractUI;
import com.amazon.ebook.booklet.periodicals.magazines.ui.MagazineUI;
import com.amazon.ebook.booklet.periodicals.ui.ReadingPaneFooter;
import com.amazon.ebook.booklet.periodicals.ui.ReadingPaneHistoryHandler;
import com.amazon.ebook.booklet.periodicals.ui.header.ReadingPaneHeader;
import com.amazon.ebook.booklet.reader.impl.ContentPanel;
import com.amazon.ebook.booklet.reader.sdk.ReaderSDK;
import com.amazon.ebook.booklet.reader.sdk.content.Book;
import com.amazon.ebook.booklet.reader.sdk.content.Element;
import com.amazon.ebook.booklet.reader.sdk.content.Position;
import com.amazon.ebook.booklet.reader.sdk.content.ScreenInfo;
import com.amazon.ebook.booklet.reader.sdk.content.TableOfContents;
import com.amazon.ebook.booklet.reader.sdk.content.TableOfContentsEntry;
import com.amazon.ebook.booklet.reader.sdk.event.EventHandler;
import com.amazon.ebook.booklet.reader.sdk.ui.MenuInserter;
import com.amazon.ebook.booklet.reader.sdk.ui.PageDecorator;
import com.amazon.ebook.booklet.reader.sdk.ui.ReaderAction;
import com.amazon.ebook.booklet.reader.sdk.ui.ReaderUI;
import com.amazon.ebook.booklet.reader.sdk.ui.ReaderUIContext;
import com.amazon.ebook.util.log.Log;
import com.amazon.ebook.util.log.PerformanceLog;
import com.amazon.ebook.util.log.Profiler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class PeriodicalReadingPane
extends PeriodicalsViewContext {
    private static final Log LOG = Log.getInstance((String)"PeriodicalReadingPane");
    public static final String VIEW_NAME = "periodicals.detail.view";
    private static final String UI_RESOURCE_NAME = "com.amazon.ebook.booklet.periodicals.ui.resources.PeriodicalsUIResources";
    private static ResourceBundle uiResources;
    private static final String WIDGET_RESOURCE_NAME = "com.amazon.ebook.booklet.periodicals.ui.resources.PeriodicalReadingPaneResources";
    private static ResourceBundle widgetResources;
    private PeriodicalBooklet periodicalBooklet;
    private ReadingPaneHistoryHandler readingPaneHistoryHandler;
    private ReadingPaneFooter periodicalFooter;
    private ReadingPaneHeader periodicalHeader;
    private AbstractAction nextArticleForFooterAction;
    private AbstractAction nextArticleAction;
    private Action originalNextArticleAction;
    private Action originalPrevArticleAction;
    private JPanel chromeFooter;

    public PeriodicalReadingPane(PeriodicalBooklet a) {
        super(a);
        PeriodicalReadingPane a2;
        a2.periodicalBooklet = a;
        a2.readingPaneHistoryHandler = ReadingPaneHistoryHandler.getRegisteredInstance(a.getReaderSDK(), a.getPeriodicalsUI());
        ReaderSDK a3 = a.getReaderSDK();
        a2.readingPaneHistoryHandler = ReadingPaneHistoryHandler.getRegisteredInstance(a3, a.getPeriodicalsUI());
        a2.periodicalFooter = new ReadingPaneFooter(a3);
        a2.periodicalFooter.addMouseListener((MouseListener)a.getPeriodicalsUI().getGestureDispatcher());
        ActionMap a4 = a2.periodicalFooter.getActionMap();
        widgetResources = ResourceBundle.getBundle(WIDGET_RESOURCE_NAME);
        a4.put(widgetResources.getString("event.gesture.article.footer.tap"), a2.getNextArticleForFooterAction());
        a2.periodicalHeader = new ReadingPaneHeader(a);
        a.getReaderSDK().getUI().setBookletDetailViewContext((ReaderUIContext)a2);
        a.registerHandler((EventHandler)a2);
    }

    public void gotoBeginning() {
        PeriodicalReadingPane a;
        a.periodicalBooklet.getReaderSDK().getBookNavigator().goToStartReading(false);
    }

    public void recordHistory() {
        PeriodicalReadingPane a;
        a.periodicalBooklet.getReaderSDK().getReaderHistoryManager().markHistory(a.readingPaneHistoryHandler.getID(), a.readingPaneHistoryHandler.createMap(a.periodicalBooklet.getReaderSDK().getBookNavigator().getCurrentPosition()));
    }

    public ReaderAction[] getMenuActions() {
        PeriodicalReadingPane a;
        List a2 = a.periodicalBooklet.getReaderSDK().getRegistry().getMenuInserters();
        if (a2 == null || a2.size() == 0) {
            return null;
        }
        ArrayList<ReaderAction> a3 = new ArrayList<ReaderAction>();
        int a4 = 0;
        int a5 = a2.size();
        int n = a4;
        while (n < a5) {
            ReaderAction[] a6 = ((MenuInserter)a2.get(a4)).getMenuActions();
            if (a6 != null && a6.length != 0) {
                int a7;
                int n2 = a7 = 0;
                while (n2 < a6.length) {
                    ReaderAction a8 = a6[a7];
                    if (a.isActionAcceptable(a8)) {
                        a3.add(a8);
                    }
                    n2 = ++a7;
                }
            }
            n = ++a4;
        }
        return a3.toArray(new ReaderAction[1]);
    }

    public String getName() {
        return VIEW_NAME;
    }

    private boolean isActionAcceptable(ReaderAction a) {
        PeriodicalReadingPane a2;
        return a.getType() == 4 && !(a2.periodicalBooklet.getPeriodicalsUI().getContentSpecificUI() instanceof BlogUI);
    }

    public ReaderAction[] getToolbarActions() {
        PeriodicalReadingPane a;
        AbstractUI a2 = a.periodicalBooklet.getPeriodicalsUI().getContentSpecificUI();
        a2.setFontActionEnabled(true);
        uiResources = ResourceBundle.getBundle(UI_RESOURCE_NAME);
        AbstractUI abstractUI = a2;
        abstractUI.getClass();
        AbstractUI.GoToBeginningAction a3 = new AbstractUI.GoToBeginningAction(abstractUI, uiResources.getString("footer.action.front.label.text"));
        if (a2 instanceof BlogUI) {
            AbstractUI abstractUI2 = a2;
            abstractUI2.getClass();
            a3 = new AbstractUI.GoToBeginningAction(abstractUI2, uiResources.getString("footer.action.front.blog.label.text"));
        } else if (a2 instanceof MagazineUI && a2.isCoverViewEnabled()) {
            AbstractUI abstractUI3 = a2;
            abstractUI3.getClass();
            a3 = new AbstractUI.GoToBeginningAction(abstractUI3, uiResources.getString("footer.action.front.magazine.label.text"));
        } else {
            AbstractUI abstractUI4 = a2;
            abstractUI4.getClass();
            a3 = new AbstractUI.GoToBeginningAction(abstractUI4, uiResources.getString("footer.action.front.label.text"));
        }
        if (a2.isContentsViewEnabled()) {
            AbstractUI abstractUI5 = a2;
            abstractUI5.getClass();
            AbstractUI.GoToContentsViewAction a4 = new AbstractUI.GoToContentsViewAction(abstractUI5, uiResources.getString("footer.action.contents.label.text"));
            return new ReaderAction[]{a3, a4};
        }
        return new ReaderAction[]{a3};
    }

    public void setContextLayout() {
        PeriodicalReadingPane a;
        super.setContextLayout();
        a.removeAll();
        AbstractUI a2 = a.periodicalBooklet.getPeriodicalsUI().getContentSpecificUI();
        a2.getClipArticleAction().setEnabled(true);
        int a3 = a2.getScreenDimension().width;
        widgetResources = ResourceBundle.getBundle(WIDGET_RESOURCE_NAME);
        a.periodicalFooter.setPreferredSize(new Dimension(a3, (Integer)widgetResources.getObject("footer.height")));
        a.periodicalHeader.setPreferredSize(new Dimension(a3, (Integer)widgetResources.getObject("header.height")));
        a.periodicalHeader.setShowNotification(false);
        a.add(a.periodicalHeader, "North");
        JPanel a4 = new JPanel(new BorderLayout());
        a4.add((Component)a.periodicalBooklet.getReaderSDK().getUI().getBookContentPanel(), "Center");
        a.add(a4, "Center");
    }

    public void setBookMargins() {
        PeriodicalReadingPane a;
        widgetResources = ResourceBundle.getBundle(WIDGET_RESOURCE_NAME);
        int a2 = a.periodicalBooklet.getReaderSDK().getUI().getContentBottomMargin();
        int a3 = a.periodicalBooklet.getReaderSDK().getUI().getContentRightMargin();
        int a4 = a.periodicalBooklet.getReaderSDK().getUI().getContentLeftMargin();
        a.periodicalBooklet.getReaderSDK().getUI().setContentMargin(((Integer)widgetResources.getObject("reader.pane.top.margin")).intValue(), a4, a3, a2, true);
    }

    public void setPageFooter() {
        PeriodicalReadingPane a;
        a.periodicalBooklet.getReaderSDK().getUI().setFooter((JComponent)((Object)a.periodicalFooter));
    }

    public void onHide() {
        PeriodicalReadingPane a;
        super.onHide();
        ActionMap a2 = a.readerSDK.getUI().getReadingPaneActionMap();
        widgetResources = ResourceBundle.getBundle(WIDGET_RESOURCE_NAME);
        a2.put(widgetResources.getString("event.gesture.article.next"), a.originalNextArticleAction);
        a2.put(widgetResources.getString("event.gesture.article.previous"), a.originalPrevArticleAction);
        a.originalNextArticleAction = null;
        a.originalPrevArticleAction = null;
        a.periodicalBooklet.getReaderSDK().getRegistry().deregisterPageDecorator((PageDecorator)a.periodicalHeader);
        a.removeAll();
    }

    public void onShow() {
        PeriodicalReadingPane a;
        ActionMap a2 = a.readerSDK.getUI().getReadingPaneActionMap();
        widgetResources = ResourceBundle.getBundle(WIDGET_RESOURCE_NAME);
        a.originalNextArticleAction = a2.get(widgetResources.getString("event.gesture.article.next"));
        a.originalPrevArticleAction = a2.get(widgetResources.getString("event.gesture.article.previous"));
        a2.put(widgetResources.getString("event.gesture.article.next"), a.getNextArticleAction());
        a2.put(widgetResources.getString("event.gesture.article.previous"), a.new PreviousArticleAction());
        super.onShow();
        a.periodicalBooklet.getReaderSDK().getRegistry().registerPageDecorator((PageDecorator)a.periodicalHeader);
    }

    public JPanel getChromeFooter() {
        PeriodicalReadingPane a;
        if (a.chromeFooter == null) {
            CommandBar a2 = new CommandBar();
            a2.setButtonWidthPreserved(false);
            widgetResources = ResourceBundle.getBundle(WIDGET_RESOURCE_NAME);
            a2.setHorizontalGap(((Integer)widgetResources.getObject("footer.button.gap")).intValue());
            a2.setBorder((Border)widgetResources.getObject("footer.border"));
            AbstractUI a3 = a.periodicalBooklet.getPeriodicalsUI().getContentSpecificUI();
            a3.setFontActionEnabled(true);
            a2.add((Action)a3.getFontAction());
            ReaderAction a4 = a3.getClipArticleAction();
            a4.setEnabled(true);
            a2.add((Action)a4);
            a.chromeFooter = new JPanel(new BorderLayout());
            a.chromeFooter.add((Component)a2, "North");
        }
        return a.chromeFooter;
    }

    public void flashArticleClipped(boolean a) {
        PeriodicalReadingPane a2;
        ResourceBundle a3 = ResourceBundle.getBundle("com.amazon.ebook.booklet.periodicals.ui.resources.ReadingPaneHeaderResources");
        String a4 = a3.getString("clip.label.success");
        if (!a) {
            a4 = a3.getString("clip.label.fail");
        }
        widgetResources = ResourceBundle.getBundle(WIDGET_RESOURCE_NAME);
        a2.periodicalHeader.flashNotification(a4, (Integer)widgetResources.getObject("notification.flash.time"));
    }

    /*
     * Enabled aggressive block sorting
     */
    public void notifyError(int a) {
        switch (a) {
            case 1: {
                PeriodicalReadingPane a2;
                if (!(a2.periodicalBooklet.getPeriodicalsUI().getContentSpecificUI() instanceof BlogUI)) return;
                widgetResources = ResourceBundle.getBundle(WIDGET_RESOURCE_NAME);
                a2.periodicalHeader.flashNotification(widgetResources.getString("blog.annotation.disabled.message"), (Integer)widgetResources.getObject("notification.flash.time"));
                return;
            }
        }
    }

    public boolean showDialogWithNoActions() {
        return false;
    }

    public boolean showFooter() {
        return true;
    }

    public boolean isFullScreen() {
        return true;
    }

    public TableOfContentsEntry getCurrentArticle() {
        TableOfContents a;
        PeriodicalReadingPane a2;
        Book a3 = a2.periodicalBooklet.getReaderSDK().getCurrentBook();
        if (a3 != null && (a = a3.getTOC()) != null) {
            return a.getCurrentTOCNodeEntry();
        }
        return null;
    }

    private AbstractAction getNextArticleForFooterAction() {
        PeriodicalReadingPane a;
        if (a.nextArticleForFooterAction == null) {
            a.nextArticleForFooterAction = a.new NextArticleForFooterAction();
        }
        return a.nextArticleForFooterAction;
    }

    private AbstractAction getNextArticleAction() {
        PeriodicalReadingPane a;
        if (a.nextArticleAction == null) {
            a.nextArticleAction = a.new NextArticleAction();
        }
        return a.nextArticleAction;
    }

    public void paint(Graphics a) {
        PeriodicalReadingPane a2;
        Profiler a3 = new Profiler("painting periodical reading pane");
        super.paint(a);
        a3.dump();
        PerformanceLog.logEvent((String)"ArticleDetailView_drawPage");
    }

    public boolean isChromePersistent() {
        return false;
    }

    public void gotoEntryAndRepaint(TableOfContentsEntry a) {
        if (a != null) {
            PeriodicalReadingPane a2;
            a2.recordHistory();
            a2.periodicalBooklet.getReaderSDK().getBookNavigator().goTo(a);
            a2.periodicalBooklet.getReaderSDK().getUI().getReaderPane().repaint();
        }
    }

    public void onScreenDimensionChange(Dimension a) {
    }

    public JComponent getView() {
        PeriodicalReadingPane a;
        return a;
    }

    public int availableMenuTypes() {
        return 21;
    }

    public void setRefreshSensitivity() {
        PeriodicalReadingPane a;
        a.periodicalBooklet.getBookletContext().setRefreshSensitivity(-2);
    }

    protected class PreviousArticleAction
    extends AbstractAction {
        protected PreviousArticleAction() {
            PreviousArticleAction a;
        }

        public void actionPerformed(ActionEvent a) {
            PreviousArticleAction a2;
            a2.PeriodicalReadingPane.this.periodicalBooklet.getReaderSDK().getUI().setFlashSuppressed(false);
            Book a3 = a2.PeriodicalReadingPane.this.periodicalBooklet.getReaderSDK().getCurrentBook();
            if (a3 != null) {
                Position a4;
                TableOfContentsEntry a5;
                ContentPanel a6 = (ContentPanel)a2.PeriodicalReadingPane.this.readerSDK.getUI().getBookContentPanel();
                TableOfContents a7 = a3.getTOC();
                if (a6.hideAllDialogs() || a7 == null) {
                    return;
                }
                ScreenInfo a8 = a2.PeriodicalReadingPane.this.readerSDK.getUI().getLastDrawnScreenInfo();
                Element[] a9 = a8 != null ? a8.getElements() : null;
                Element a10 = a9 != null && a9.length > 0 ? a9[0] : null;
                TableOfContentsEntry tableOfContentsEntry = a5 = a10 != null ? a7.getTOCFromPosition(a10.getEndPosition()) : a7.getCurrentTOCNodeEntry();
                if (a5 == null || "periodical".equals(a5.getNodeType())) {
                    if (Log.isDebugOn()) {
                        LOG.debug("Current TOCEntry is null or is of type periodical. So skipping jump to previous article");
                    }
                    return;
                }
                Position a11 = a2.PeriodicalReadingPane.this.periodicalBooklet.getReaderSDK().getBookNavigator().getCurrentPosition();
                TableOfContentsEntry a12 = a7.getPrevEntryOfType(a5, "article", true);
                if (a11 != null && a11.compareTo((Object)(a4 = a5.getPosition())) > 0) {
                    a12 = a5;
                }
                a2.PeriodicalReadingPane.this.gotoEntryAndRepaint(a12);
            }
        }
    }

    private class NextArticleAction
    extends AbstractAction {
        private NextArticleAction() {
            NextArticleAction a;
        }

        public void actionPerformed(ActionEvent a) {
            NextArticleAction a2;
            a2.PeriodicalReadingPane.this.periodicalBooklet.getReaderSDK().getUI().setFlashSuppressed(false);
            Book a3 = a2.PeriodicalReadingPane.this.periodicalBooklet.getReaderSDK().getCurrentBook();
            if (a3 != null) {
                TableOfContentsEntry a4;
                ContentPanel a5 = (ContentPanel)a2.PeriodicalReadingPane.this.readerSDK.getUI().getBookContentPanel();
                TableOfContents a6 = a3.getTOC();
                if (a5.hideAllDialogs() || a6 == null) {
                    return;
                }
                ScreenInfo a7 = a2.PeriodicalReadingPane.this.readerSDK.getUI().getLastDrawnScreenInfo();
                Element[] a8 = a7 != null ? a7.getElements() : null;
                Element a9 = a8 != null && a8.length > 0 ? a8[0] : null;
                TableOfContentsEntry tableOfContentsEntry = a4 = a9 != null ? a6.getTOCFromPosition(a9.getEndPosition()) : a6.getCurrentTOCNodeEntry();
                if (a4 != null && "periodical".equals(a4.getNodeType())) {
                    a4 = a6.getNextEntryOfType(a4, "article", true);
                }
                a2.PeriodicalReadingPane.this.gotoEntryAndRepaint(a6.getNextEntryOfType(a4, "article", true));
            }
        }
    }

    private class NextArticleForFooterAction
    extends AbstractAction {
        private NextArticleForFooterAction() {
            NextArticleForFooterAction a;
        }

        public void actionPerformed(ActionEvent a) {
            NextArticleForFooterAction a2;
            ReaderUI a3 = a2.PeriodicalReadingPane.this.periodicalBooklet.getReaderSDK().getUI();
            ContentPanel a4 = (ContentPanel)a3.getBookContentPanel();
            if (a4.hideAllDialogs() || a4.isTablePanningActive() || !a3.isUIEnabled()) {
                return;
            }
            a2.PeriodicalReadingPane.this.periodicalBooklet.getReaderSDK().getUI().setFlashSuppressed(false);
            TableOfContentsEntry a5 = a2.PeriodicalReadingPane.this.periodicalFooter.getNextTableOfContentsEntry();
            a2.PeriodicalReadingPane.this.gotoEntryAndRepaint(a5);
        }
    }
}

