/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ebook.booklet.periodicals.newspapers.ui.views.contentview;

import com.amazon.ebook.booklet.periodicals.PeriodicalBooklet;
import com.amazon.ebook.booklet.periodicals.blogs.ui.views.pooled.source.BasicPooledSource;
import com.amazon.ebook.booklet.periodicals.blogs.ui.views.pooled.widget.BasicWidget;
import com.amazon.ebook.booklet.periodicals.blogs.ui.views.prelayout.Prelayouter;
import com.amazon.ebook.booklet.periodicals.common.history.PeriodicalsViewContext;
import com.amazon.ebook.booklet.periodicals.common.ui.PeriodicalGridView_v2;
import com.amazon.ebook.booklet.periodicals.newspapers.ui.views.contentview.ContentsViewHistoryHandler;
import com.amazon.ebook.booklet.periodicals.newspapers.ui.views.contentview.widgets.ArticlePaneWidget_v2;
import com.amazon.ebook.booklet.periodicals.newspapers.ui.views.contentview.widgets.SectionPaneWidget_v2;
import com.amazon.ebook.booklet.reader.sdk.BookException;
import com.amazon.ebook.booklet.reader.sdk.TOCException;
import com.amazon.ebook.booklet.reader.sdk.content.Book;
import com.amazon.ebook.booklet.reader.sdk.content.Position;
import com.amazon.ebook.booklet.reader.sdk.content.TableOfContents;
import com.amazon.ebook.booklet.reader.sdk.content.TableOfContentsEntry;
import com.amazon.ebook.booklet.reader.sdk.ui.ReaderAction;
import com.amazon.ebook.util.log.Log;
import com.amazon.ebook.util.log.PerformanceLog;
import com.amazon.ebook.util.prelayout.CacheManager;
import com.amazon.ebook.util.thread.ThreadPool;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.JComponent;

public class ContentsView
extends PeriodicalsViewContext {
    public static final String VIEW_NAME = "periodicals.contents.view";
    private static final Log LOG = Log.getInstance((String)"ContentView");
    private static final String WIDGET_RESOURCE_NAME = "com.amazon.ebook.booklet.periodicals.newspapers.ui.views.contentview.resources.ContentViewResources";
    private static final int INITIAL_CACHE_SIZE = 60;
    private static final float CACHE_LOAD_FACTOR = 0.75f;
    private SectionPaneWidget_v2 sectionPaneWidget_v2;
    private ArticlePaneWidget_v2 articlesPaneWidget_v2;
    private PeriodicalBooklet controller;
    private TableOfContents tableOfContents;
    private BasicWidget lastSelectedWidget;
    private ContentsViewHistoryHandler contentViewHistoryHandler;
    private boolean clearCache;
    private Book currentPeriodical;
    private Prelayouter sectionsPrelayouter;
    private Prelayouter articlesPrelayouter;
    private Object lock = new Object();

    private static CacheManager getCacheMgr() {
        return new CacheManager(60, 0.75f, new CacheManager.EvictionPolicy(){
            {
                1 a;
            }

            public boolean evictReqd(Map a, CacheManager.Cacheable a2) {
                return false;
            }

            public Object evict(Map a) {
                return null;
            }
        });
    }

    public ContentsView(PeriodicalBooklet a) {
        super(a);
        ContentsView a2;
        a2.controller = a;
        a2.contentViewHistoryHandler = ContentsViewHistoryHandler.getRegisteredInstance(a.getReaderSDK(), a.getPeriodicalsUI());
        a2.articlesPrelayouter = new Prelayouter(ContentsView.getCacheMgr());
        a2.sectionsPrelayouter = new Prelayouter(ContentsView.getCacheMgr());
    }

    public String getName() {
        return VIEW_NAME;
    }

    public void initialize(Dimension a) {
        ContentsView a2;
        Book a3 = a2.controller.getReaderSDK().getCurrentBook();
        if (a3 == null || a == null || a3.equals(a2.currentPeriodical) && a.equals(a2.getPreferredSize())) {
            LOG.warning("Request to initialize is from the same book for same dimension. Skipping initialize.");
            a2.tableOfContents = a3.getTOC();
            return;
        }
        a2.currentPeriodical = a3;
        a2.setPreferredSize(a);
        a2.sectionPaneWidget_v2 = new SectionPaneWidget_v2(a2.controller, a2);
        a2.articlesPaneWidget_v2 = new ArticlePaneWidget_v2(a2.controller, a2);
        Dimension a4 = new Dimension(a.width / 2, a.height);
        a2.sectionPaneWidget_v2.initialize(a4, a, a2.sectionsPrelayouter);
        a2.tableOfContents = a3.getTOC();
        BasicPooledSource a5 = a2.sectionPaneWidget_v2.getView().getTocSource();
        TableOfContentsEntry a6 = a5.getFirstEntryInCurrentSet();
        a2.articlesPaneWidget_v2.initialize(a4, a, a2.articlesPrelayouter);
        BasicWidget a7 = a5.getWidgetWithEntry(a6);
        a2.setStyleToCurrentWidget(a2.lastSelectedWidget, a7);
        a2.setLayout(new BorderLayout());
        ResourceBundle a8 = ResourceBundle.getBundle(WIDGET_RESOURCE_NAME);
        a2.add(a2.sectionPaneWidget_v2.getView(), a8.getString("this.pane.section.layout"));
        a2.add(a2.articlesPaneWidget_v2.getView(), a8.getString("this.pane.article.layout"));
    }

    public void paint(Graphics a) {
        ContentsView a2;
        super.paint(a);
        a2.triggerPrelayout();
        PerformanceLog.logEvent((String)"SectionsAndArticles_drawPage");
    }

    private void triggerPrelayout() {
        ContentsView a;
        EventQueue.invokeLater(new Runnable(){
            {
                2 a;
            }

            public void run() {
                2 a;
                ThreadPool.getInstance().runIt(new Runnable(){
                    {
                        1 a;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        1 a;
                        try {
                            Thread.sleep(200L);
                        }
                        catch (InterruptedException a2) {
                            LOG.warning("Prelayout thread sleep interrupted", (Throwable)a2);
                        }
                        Object object = ContentsView.this.lock;
                        synchronized (object) {
                            ContentsView.this.articlesPrelayouter.stopPrelayout(true);
                            ContentsView.this.articlesPrelayouter.startPrelayout(null);
                            ContentsView.this.sectionsPrelayouter.stopPrelayout(true);
                            ContentsView.this.sectionsPrelayouter.startPrelayout(null);
                        }
                    }
                }, "Section Start prelayout");
            }
        });
    }

    public void recordHistory() {
        ContentsView a;
        TableOfContentsEntry a2 = a.sectionPaneWidget_v2.getView().getTocSource().getEntryWithIndex(0);
        TableOfContentsEntry a3 = a.articlesPaneWidget_v2.getView().getTocSource().getEntryWithIndex(0);
        Map a4 = a.contentViewHistoryHandler.createMapData(a2, a3);
        a.controller.getReaderSDK().getReaderHistoryManager().markHistory(a.contentViewHistoryHandler.getID(), a4);
    }

    public ReaderAction[] getMenuActions() {
        return null;
    }

    public TableOfContentsEntry getCurrentArticle() {
        ContentsView a;
        return a.articlesPaneWidget_v2.getFirstArticle();
    }

    public ReaderAction[] getToolbarActions() {
        return null;
    }

    public void loadFromState(TableOfContentsEntry a, TableOfContentsEntry a2) {
        ContentsView a3;
        if (a2 != null && !"article".equals(a2.getNodeType())) {
            a2 = a3.getFirstArticle();
            a = a3.getSectionOfEntry(a2);
        }
        PeriodicalGridView_v2 a4 = a3.sectionPaneWidget_v2.getView();
        a4.getTocSource().loadSetHavingTOCEntry(a);
        a4.layoutNewComponents();
        a3.sectionPaneWidget_v2.getViewMastheadWidget().layoutComponents(null);
        if (a == null) {
            a = a4.getTocSource().getEntryWithIndex(0);
        }
        if (a2 != null) {
            a = a3.getSectionOfEntry(a2);
        }
        BasicWidget a5 = a4.getTocSource().getWidgetWithEntry(a);
        a3.setStyleToCurrentWidget(a3.lastSelectedWidget, a5);
        a3.lastSelectedWidget = a5;
        PeriodicalGridView_v2 a6 = a3.articlesPaneWidget_v2.getView();
        if (a2 == null) {
            a2 = a3.getFirstArticle(a);
        }
        if (a6.getTocSource().loadSetHavingTOCEntry(a2)) {
            a6.layoutNewComponents();
            a3.articlesPaneWidget_v2.getViewMastheadWidget().layoutComponents(null);
        }
    }

    public void loadArticlesForSection(BasicWidget a, Position a2) {
        ContentsView a3;
        if (a3.currentPeriodical == null) {
            return;
        }
        TableOfContents a4 = a3.currentPeriodical.getTOC();
        a3.moveArticleSourceToSection(a, a4.getTOCFromPosition(a2));
        a3.layoutAndDrawComponents(false, true);
    }

    private void moveArticleSourceToSection(BasicWidget a, TableOfContentsEntry a2) {
        ContentsView a3;
        a3.setStyleToCurrentWidget(a3.lastSelectedWidget, a);
        a3.lastSelectedWidget = a;
        a3.articlesPaneWidget_v2.getView().getTocSource().loadSetHavingTOCEntry(a3.getFirstArticle(a2));
    }

    public void drawNextPageOfArticles() {
        ContentsView a;
        a.loadArticlesPane(true);
    }

    public void drawPreviousPageOfArticles() {
        ContentsView a;
        a.loadArticlesPane(false);
    }

    public void loadArticlesPane(boolean a) {
        ContentsView a2;
        a2.moveTOCSourceOfPane(a2.articlesPaneWidget_v2.getView(), a);
        TableOfContentsEntry a3 = a2.getSectionOfEntry(a2.articlesPaneWidget_v2.getView().getTocSource().getFirstEntryInCurrentSet());
        BasicPooledSource a4 = a2.sectionPaneWidget_v2.getView().getTocSource();
        boolean a5 = a4.loadSetHavingTOCEntry(a3);
        BasicWidget a6 = a4.getWidgetWithEntry(a3);
        a2.setStyleToCurrentWidget(a2.lastSelectedWidget, a6);
        a2.layoutAndDrawComponents(a5, true);
    }

    public void drawNextPageOfSections() {
        ContentsView a;
        a.loadSectionPane(true);
    }

    public void drawPreviousPageOfSections() {
        ContentsView a;
        a.loadSectionPane(false);
    }

    private void loadSectionPane(boolean a) {
        ContentsView a2;
        PeriodicalGridView_v2 a3 = a2.sectionPaneWidget_v2.getView();
        a2.moveTOCSourceOfPane(a3, a);
        TableOfContentsEntry a4 = a3.getTocSource().getEntryWithIndex(0);
        BasicWidget a5 = a3.getTocSource().getWidgetWithEntry(a4);
        a2.moveArticleSourceToSection(a5, a4);
        a2.layoutAndDrawComponents(true, true);
    }

    private void layoutAndDrawComponents(boolean a, boolean a2) {
        PeriodicalGridView_v2 a3;
        ContentsView a4;
        if (a) {
            a3 = a4.sectionPaneWidget_v2.getView();
            a3.removeAll();
            a3.layoutNewComponents();
            a4.sectionPaneWidget_v2.getViewMastheadWidget().layoutComponents(null);
        }
        if (a2) {
            a3 = a4.articlesPaneWidget_v2.getView();
            a3.removeAll();
            a3.layoutNewComponents();
            a4.articlesPaneWidget_v2.getViewMastheadWidget().layoutComponents(null);
        }
        if (a2 || a) {
            a4.controller.getBookletContext().getUIContainer().validate();
            a4.controller.getBookletContext().getUIContainer().repaint();
        }
    }

    private void setStyleToCurrentWidget(BasicWidget a, BasicWidget a2) {
        ResourceBundle a3 = ResourceBundle.getBundle(WIDGET_RESOURCE_NAME);
        if (a != null) {
            a.setOpaque((Boolean)a3.getObject("this.widget.section.opaque.off"));
        }
        if (a2 != null) {
            a2.setOpaque((Boolean)a3.getObject("this.widget.section.opaque.on"));
        }
        a.lastSelectedWidget = a2;
    }

    private void moveTOCSourceOfPane(PeriodicalGridView_v2 a, boolean a2) {
        if (a2) {
            a.getTocSource().loadNextSet();
        } else {
            a.getTocSource().loadPreviousSet();
        }
    }

    private TableOfContentsEntry getSectionOfEntry(TableOfContentsEntry a) {
        if (a == null || !"article".equals(a.getNodeType())) {
            return null;
        }
        try {
            ContentsView a2;
            return a2.tableOfContents.getParent(a);
        }
        catch (BookException a3) {
            LOG.error("Exception when getting child of current section :", (Throwable)a3);
            return null;
        }
    }

    private TableOfContentsEntry getFirstArticle(TableOfContentsEntry a) {
        if (a == null || !"section".equals(a.getNodeType())) {
            return null;
        }
        try {
            ContentsView a2;
            return a2.tableOfContents.getChild(a);
        }
        catch (BookException a3) {
            LOG.error("Exception when getting child of current section :", (Throwable)a3);
            return null;
        }
    }

    private TableOfContentsEntry getFirstArticle() {
        ContentsView a;
        TableOfContentsEntry a2 = null;
        try {
            a2 = a.tableOfContents.getNextEntry(null);
        }
        catch (TOCException a3) {
            LOG.error("Exception when getting periodical entry", (Throwable)a3);
        }
        return a.tableOfContents.getNextEntryOfType(a2, "article", true);
    }

    public boolean isNextSectionSetAvailable() {
        TableOfContentsEntry a;
        ContentsView a2;
        BasicPooledSource a3 = a2.sectionPaneWidget_v2.getView().getTocSource();
        return !a3.isLastTOCEntry(a = a3.getLastEntryInCurrentSet(), false);
    }

    public boolean isPreviousSectionSetAvailable() {
        TableOfContentsEntry a;
        ContentsView a2;
        BasicPooledSource a3 = a2.sectionPaneWidget_v2.getView().getTocSource();
        return !a3.isFirstTOCEntry(a = a3.getFirstEntryInCurrentSet(), false);
    }

    public boolean isNextArticleSetAvailable() {
        TableOfContentsEntry a;
        ContentsView a2;
        BasicPooledSource a3 = a2.articlesPaneWidget_v2.getView().getTocSource();
        return !a3.isLastTOCEntry(a = a3.getLastEntryInCurrentSet(), false);
    }

    public boolean isPreviousArticleSetAvailable() {
        TableOfContentsEntry a;
        ContentsView a2;
        BasicPooledSource a3 = a2.articlesPaneWidget_v2.getView().getTocSource();
        return !a3.isFirstTOCEntry(a = a3.getFirstEntryInCurrentSet(), false);
    }

    public JComponent getView() {
        ContentsView a;
        return a;
    }

    public void onShow() {
        ContentsView a;
        super.onShow();
        a.clearCache = true;
    }

    public void onHide() {
        ContentsView a;
        super.onHide();
        if (a.clearCache) {
            a.setStyleToCurrentWidget(a.lastSelectedWidget, null);
            a.tableOfContents = null;
            a.clearCache = false;
        }
    }

    public void onScreenDimensionChange(Dimension a) {
        ContentsView a2;
        TableOfContentsEntry a3 = a2.sectionPaneWidget_v2.getView().getTocSource().getEntryWithIndex(0);
        TableOfContentsEntry a4 = a2.articlesPaneWidget_v2.getView().getTocSource().getEntryWithIndex(0);
        a2.removeAll();
        a2.initialize(a);
        a2.loadFromState(a3, a4);
        a2.clearCache = false;
    }

    public void onPeriodicalClose() {
        ContentsView a;
        a.articlesPrelayouter.stopPrelayout(true);
        a.sectionsPrelayouter.stopPrelayout(true);
    }

    public void setRefreshSensitivity() {
        ContentsView a;
        a.controller.getBookletContext().setRefreshSensitivity(-3);
    }
}

