/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ebook.booklet.periodicals.magazines.ui.views.home;

import com.amazon.ebook.booklet.periodicals.PeriodicalBooklet;
import com.amazon.ebook.booklet.periodicals.blogs.ui.views.pooled.source.BasicPooledSource;
import com.amazon.ebook.booklet.periodicals.blogs.ui.views.pooled.source.MagazineHomePooledSource;
import com.amazon.ebook.booklet.periodicals.blogs.ui.views.prelayout.Prelayouter;
import com.amazon.ebook.booklet.periodicals.common.history.PeriodicalsViewContext;
import com.amazon.ebook.booklet.periodicals.common.ui.MastheadWidget;
import com.amazon.ebook.booklet.periodicals.common.ui.PeriodicalGridView_v2;
import com.amazon.ebook.booklet.periodicals.magazines.ui.views.home.widgets.MagazineHomeFooterWidget;
import com.amazon.ebook.booklet.periodicals.newspapers.ui.views.home.PeriodicalHomeHistoryHandler;
import com.amazon.ebook.booklet.periodicals.ui.PeriodicalsUI;
import com.amazon.ebook.booklet.reader.sdk.BookException;
import com.amazon.ebook.booklet.reader.sdk.BookNavigator;
import com.amazon.ebook.booklet.reader.sdk.TOCException;
import com.amazon.ebook.booklet.reader.sdk.content.Book;
import com.amazon.ebook.booklet.reader.sdk.content.BookMetadata;
import com.amazon.ebook.booklet.reader.sdk.content.TableOfContents;
import com.amazon.ebook.booklet.reader.sdk.content.TableOfContentsEntry;
import com.amazon.ebook.booklet.reader.sdk.ui.ReaderAction;
import com.amazon.ebook.util.log.Log;
import com.amazon.ebook.util.log.PerformanceLog;
import com.amazon.ebook.util.prelayout.CacheManager;
import com.amazon.ebook.util.thread.ThreadPool;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.MouseListener;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.border.AbstractBorder;

public class MagazineHome
extends PeriodicalsViewContext {
    public static final String VIEW_NAME = "periodicals.home.view";
    private static final Log LOG = Log.getInstance((String)"MagazineHome");
    private static final String WIDGET_RESOURCE_NAME = "com.amazon.ebook.booklet.periodicals.magazines.ui.views.home.resources.MagazineHomeResources";
    private static ResourceBundle widgetResources;
    private PeriodicalGridView_v2 mGridView;
    private PeriodicalHomeHistoryHandler mMagazineHomeHistoryHandler;
    private PeriodicalBooklet mController;
    private static final int INITIAL_CACHE_SIZE = 60;
    private static final float CACHE_LOAD_FACTOR = 0.75f;
    private static final int MASTHEAD_WIDGET_ID = 0;
    private Prelayouter prelayouter;
    private Book currentBook;
    private Object lock = new Object();

    public MagazineHome(PeriodicalBooklet a) {
        super(a);
        MagazineHome a2;
        a2.mController = a;
        widgetResources = ResourceBundle.getBundle(WIDGET_RESOURCE_NAME);
        a2.mGridView = new PeriodicalGridView_v2();
        a2.mGridView.setBackground((Color)widgetResources.getObject("color.background"));
        a2.mGridView.setPersistMasthead(true);
        a2.mGridView.addMouseListener((MouseListener)a2.mController.getPeriodicalsUI().getGestureDispatcher());
        a2.add(a2.mGridView);
        VerticalBorder a3 = new VerticalBorder();
        a2.mGridView.setBorders(BorderFactory.createEmptyBorder(), a3);
        a2.mGridView.setCompoundBorder(BorderFactory.createCompoundBorder(a3, new VerticalConnector()));
        a2.mMagazineHomeHistoryHandler = PeriodicalHomeHistoryHandler.getRegisteredInstance(a.getReaderSDK(), a.getPeriodicalsUI());
        a2.prelayouter = new Prelayouter(MagazineHome.getCacheMgr());
        ActionMap a4 = a2.mGridView.getActionMap();
        if (a4 != null) {
            a4.put(widgetResources.getString("event.gesture.previous"), a2.new PrevPageAction());
            a4.put(widgetResources.getString("event.gesture.next"), a2.new NextPageAction());
            a4.put(widgetResources.getString("event.gesture.previous.vertical"), a2.new PrevPageAction());
            a4.put(widgetResources.getString("event.gesture.next.vertical"), a2.new NextPageAction());
        }
    }

    public String getName() {
        return VIEW_NAME;
    }

    private static CacheManager getCacheMgr() {
        return new CacheManager(60, 0.75f, new CacheManager.EvictionPolicy(){
            {
                1 a;
            }

            public boolean evictReqd(Map a, CacheManager.Cacheable a2) {
                return false;
            }

            public Object evict(Map a) {
                return null;
            }
        });
    }

    public synchronized void initialize(Dimension a) {
        MagazineHome a2;
        Book a3 = a2.mController.getReaderSDK().getCurrentBook();
        if (a3 == null || a == null || a3.equals(a2.currentBook) && a.equals(a2.getPreferredSize())) {
            LOG.warning("Request to initialize is from the same book for same dimension. Skipping initialize.");
            return;
        }
        a2.currentBook = a3;
        a2.setupGrid(a);
        a2.setPreferredSize(a);
        BookNavigator a4 = a2.mController.getReaderSDK().getBookNavigator();
        widgetResources = ResourceBundle.getBundle(WIDGET_RESOURCE_NAME);
        Dimension a5 = new Dimension(a.width, (Integer)widgetResources.getObject("masthead.height"));
        int a6 = a.width - a2.mGridView.getMarginLeft() - a2.mGridView.getMarginRight();
        Dimension a7 = new Dimension(a6, (Integer)widgetResources.getObject("masthead.image.height"));
        a2.mGridView.setMastheadWidget(new MastheadWidget(0, a5, (Integer)widgetResources.getObject("masthead.span.column"), a2.mController.getReaderSDK(), a2.mController.getPeriodicalsUI(), a2.prelayouter, a7));
        BookMetadata a8 = a3.getMetadata();
        if (a8 != null) {
            a2.mGridView.getMastheadWidget().setMastheadTitle(a8.getTitle());
        }
        a2.mGridView.getMastheadWidget().layoutComponents(a2.getPeriodicalEntry(a3));
        a2.mGridView.setTocSource(new MagazineHomePooledSource(a2.readerSDK, a2.mController.getPeriodicalsUI(), a4, a3.getTOC(), a2.mGridView.getRows(), a2.mGridView.getColumns(), a2.prelayouter));
        int a9 = (Integer)widgetResources.getObject("footer.height");
        int a10 = a.height - a9 - a5.height;
        a2.mGridView.getTocSource().initialize(new Dimension(a6, a10));
        a2.mGridView.setFooterWidget(new MagazineHomeFooterWidget(new Dimension(a6, a9), a2.mGridView.getTocSource()));
    }

    public synchronized void initForDisplay(TableOfContentsEntry a) {
        MagazineHome a2;
        a2.mGridView.getTocSource().loadSetHavingTOCEntry(a);
        a2.mGridView.layoutNewComponents();
    }

    private void triggerPrelayout() {
        MagazineHome a;
        EventQueue.invokeLater(new Runnable(){
            {
                2 a;
            }

            public void run() {
                2 a;
                ThreadPool.getInstance().runIt(new Runnable(){
                    {
                        1 a;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        1 a;
                        try {
                            Thread.sleep(200L);
                        }
                        catch (InterruptedException a2) {
                            LOG.warning("Prelayout thread sleep interrupted", (Throwable)a2);
                        }
                        Object object = MagazineHome.this.lock;
                        synchronized (object) {
                            MagazineHome.this.prelayouter.stopPrelayout(true);
                            MagazineHome.this.prelayouter.startPrelayout(null);
                        }
                    }
                }, "Magazine Home prelayout");
            }
        });
    }

    public void setContextLayout() {
        MagazineHome a;
        a.mGridView.loadResources();
    }

    public void paint(Graphics a) {
        MagazineHome a2;
        super.paint(a);
        a2.triggerPrelayout();
        PerformanceLog.logEvent((String)"PeriodicalHome_drawPage");
    }

    protected void setupGrid(Dimension a) {
        MagazineHome a2;
        a2.mGridView.setViewDimension(a);
        widgetResources = ResourceBundle.getBundle(WIDGET_RESOURCE_NAME);
        a2.mGridView.setMarginLeft((Integer)widgetResources.getObject("margin.left"));
        a2.mGridView.setMarginRight((Integer)widgetResources.getObject("margin.right"));
        if (PeriodicalsUI.isPortrait(a)) {
            a2.mGridView.setRows((Integer)widgetResources.getObject("portrait.rows"));
            a2.mGridView.setColumns((Integer)widgetResources.getObject("portrait.columns"));
        } else {
            a2.mGridView.setRows((Integer)widgetResources.getObject("landscape.rows"));
            a2.mGridView.setColumns((Integer)widgetResources.getObject("landscape.columns"));
        }
    }

    public void recordHistory() {
        MagazineHome a;
        TableOfContentsEntry a2 = a.mGridView.getTocSource().getEntryWithIndex(0);
        Map a3 = a.mMagazineHomeHistoryHandler.createMapData(a2);
        a.mController.getReaderSDK().getReaderHistoryManager().markHistory(a.mMagazineHomeHistoryHandler.getID(), a3);
    }

    public ReaderAction[] getMenuActions() {
        return null;
    }

    public ReaderAction[] getToolbarActions() {
        return null;
    }

    public boolean isHomeActionEnabled() {
        MagazineHome a;
        return a.mGridView != null && a.mGridView.getTocSource() != null && !a.mGridView.getTocSource().isFirstPage();
    }

    public JComponent getView() {
        MagazineHome a;
        return a.mGridView;
    }

    public void onScreenDimensionChange(Dimension a) {
        MagazineHome a2;
        a2.initialize(a);
    }

    public void onPeriodicalClose() {
        MagazineHome a;
        a.prelayouter.stopPrelayout(true);
    }

    public TableOfContentsEntry getCurrentArticle() {
        MagazineHome a;
        TableOfContentsEntry a2 = a.mGridView.getTocSource().getEntryWithIndex(0);
        if (a.currentBook != null && a2 != null) {
            TableOfContents a3 = a.currentBook.getTOC();
            try {
                return a3.getChild(a2);
            }
            catch (TOCException a4) {
                LOG.warning("Exception when getting child of section entry", (Throwable)a4);
            }
        }
        return null;
    }

    public void clearCache() {
        MagazineHome a;
        a.prelayouter.getCacheManager().clear();
    }

    protected TableOfContentsEntry getPeriodicalEntry(Book a) {
        TableOfContents a2 = a.getTOC();
        try {
            TableOfContentsEntry a3 = a2.getNextEntry(null);
            if (a3 != null && "periodical".equals(a3.getNodeType())) {
                return a3;
            }
            return a2.getNextEntryOfType(a3, "periodical", true);
        }
        catch (BookException a4) {
            LOG.error("Exception when getting periodical entry", (Throwable)a4);
            return null;
        }
    }

    public void setRefreshSensitivity() {
        MagazineHome a;
        a.mController.getBookletContext().setRefreshSensitivity(-3);
    }

    private class NextPageAction
    extends AbstractAction {
        private NextPageAction() {
            NextPageAction a;
        }

        public void actionPerformed(ActionEvent a) {
            NextPageAction a2;
            PerformanceLog.logEvent((String)"PeriodicalHome_drawPage");
            a2.MagazineHome.this.mGridView.getTocSource().loadNextSet();
            a2.MagazineHome.this.mGridView.layoutNewComponents();
            a2.MagazineHome.this.mGridView.loadResources();
            a2.MagazineHome.this.validate();
            a2.MagazineHome.this.repaint();
            a2.MagazineHome.this.mController.getPeriodicalsUI().getContentSpecificUI().addChromeSearchBarButtons();
        }
    }

    private class PrevPageAction
    extends AbstractAction {
        private PrevPageAction() {
            PrevPageAction a;
        }

        public void actionPerformed(ActionEvent a) {
            PrevPageAction a2;
            PerformanceLog.logEvent((String)"PeriodicalHome_drawPage");
            BasicPooledSource a3 = a2.MagazineHome.this.mGridView.getTocSource();
            if (a3 != null && a3.isFirstPage() && a2.MagazineHome.this.mController.getPeriodicalsUI().getContentSpecificUI().isCoverViewEnabled()) {
                a2.MagazineHome.this.mController.getPeriodicalsUI().gotoCoverView();
            } else {
                a2.MagazineHome.this.mGridView.getTocSource().loadPreviousSet();
                a2.MagazineHome.this.mGridView.layoutNewComponents();
            }
            a2.MagazineHome.this.mGridView.loadResources();
            a2.MagazineHome.this.validate();
            a2.MagazineHome.this.repaint();
            a2.MagazineHome.this.mController.getPeriodicalsUI().getContentSpecificUI().addChromeSearchBarButtons();
        }
    }

    public static class VerticalConnector
    extends AbstractBorder {
        private Color borderColor;
        private int firstLineThickness;
        private int paddingTop;

        public VerticalConnector() {
            VerticalConnector a;
            widgetResources = ResourceBundle.getBundle(MagazineHome.WIDGET_RESOURCE_NAME);
            a.borderColor = (Color)widgetResources.getObject("separator.vertical.color");
            a.firstLineThickness = (Integer)widgetResources.getObject("separator.vertical.thickness");
            a.paddingTop = (Integer)widgetResources.getObject("separator.vertical.padding.top");
        }

        public void paintBorder(Component a, Graphics a2, int a3, int a4, int a5, int a6) {
            VerticalConnector a7;
            Color a8 = a2.getColor();
            a2.setColor(a7.borderColor);
            a2.fillRect(a3, a4, a7.firstLineThickness, a7.paddingTop);
            a2.setColor(a8);
        }
    }

    public static class VerticalBorder
    extends AbstractBorder {
        private Color borderColor;
        private int firstLineThickness;
        private int paddingTop;

        public VerticalBorder() {
            VerticalBorder a;
            widgetResources = ResourceBundle.getBundle(MagazineHome.WIDGET_RESOURCE_NAME);
            a.borderColor = (Color)widgetResources.getObject("separator.vertical.color");
            a.firstLineThickness = (Integer)widgetResources.getObject("separator.vertical.thickness");
            a.paddingTop = (Integer)widgetResources.getObject("separator.vertical.padding.top");
        }

        public void paintBorder(Component a, Graphics a2, int a3, int a4, int a5, int a6) {
            VerticalBorder a7;
            Color a8 = a2.getColor();
            a2.setColor(a7.borderColor);
            int a9 = a6;
            int a10 = a4 + a7.paddingTop;
            a2.fillRect(a3, a10, a7.firstLineThickness, a9);
            a2.setColor(a8);
        }
    }
}

