/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ebook.booklet.periodicals.magazines.ui.views.cover;

import com.amazon.agui.swing.event.GestureDispatcher;
import com.amazon.ebook.booklet.periodicals.PeriodicalBooklet;
import com.amazon.ebook.booklet.periodicals.common.history.PeriodicalsViewContext;
import com.amazon.ebook.booklet.periodicals.common.ui.AbstractUI;
import com.amazon.ebook.booklet.periodicals.magazines.ui.views.cover.CoverViewHistoryHandler;
import com.amazon.ebook.booklet.periodicals.ui.PeriodicalsUI;
import com.amazon.ebook.booklet.reader.sdk.BookException;
import com.amazon.ebook.booklet.reader.sdk.content.Book;
import com.amazon.ebook.booklet.reader.sdk.content.TableOfContents;
import com.amazon.ebook.booklet.reader.sdk.content.TableOfContentsEntry;
import com.amazon.ebook.booklet.reader.sdk.ui.ReaderAction;
import com.amazon.ebook.util.log.Log;
import com.amazon.ebook.util.log.Profiler;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class CoverView
extends PeriodicalsViewContext {
    public static final String VIEW_NAME = "periodicals.cover.view";
    private static final Log LOG = Log.getInstance((String)"CoverView");
    private static final String WIDGET_RESOURCE_NAME = "com.amazon.ebook.booklet.periodicals.magazines.ui.views.cover.resources.CoverViewResources";
    private static ResourceBundle widgetResources;
    JLabel imageLabel;
    PeriodicalBooklet mController;
    PeriodicalsUI mPeriodicalsUI;
    private Book associatedBook;
    private CoverViewHistoryHandler mCoverViewHistoryHandler;

    public CoverView(PeriodicalBooklet a) {
        super(a);
        CoverView a2;
        a2.mController = a;
        a2.mCoverViewHistoryHandler = CoverViewHistoryHandler.getRegisteredInstance(a.getReaderSDK(), a2.mController.getPeriodicalsUI());
    }

    public String getName() {
        return VIEW_NAME;
    }

    public synchronized void initialize(Dimension a) {
        CoverView a2;
        Book a3 = a2.mController.getReaderSDK().getCurrentBook();
        if (a3 == null || a == null || a3.equals(a2.associatedBook) && a.equals(a2.getPreferredSize())) {
            LOG.warning("Request to initialize cover is from the same book for same dimension. Skipping initialize.");
            return;
        }
        a2.associatedBook = a3;
        widgetResources = ResourceBundle.getBundle(WIDGET_RESOURCE_NAME);
        a2.setBackground((Color)widgetResources.getObject("this.color.background"));
        a2.setLayout(new BorderLayout());
        a2.mPeriodicalsUI = a2.mController.getPeriodicalsUI();
        a2.setPreferredDimension(a);
        GestureDispatcher a4 = new GestureDispatcher();
        a2.addMouseListener((MouseListener)a4);
        a2.getActionMap().put(widgetResources.getString("event.gesture.tap"), a2.new GotoHomeAction());
        a2.getActionMap().put(widgetResources.getString("event.gesture.next"), a2.new GotoHomeAction());
        a2.getActionMap().put(widgetResources.getString("event.gesture.next.alternate"), a2.new GotoHomeAction());
        Profiler a5 = new Profiler("Cover Image");
        Image a6 = a3.getMetadata().getCoverImage(a);
        a5.dump("Obtained cover image from metadata");
        if (a6 == null) {
            a2.mPeriodicalsUI.gotoPeriodicalsHome();
            return;
        }
        a5.mark();
        ImageIcon a7 = new ImageIcon(a6);
        a5.dump("Loaded cover image");
        a5.mark();
        a2.imageLabel = new JLabel(a7);
        a5.dump("Loaded final scaled cover image");
        a2.add(a2.imageLabel, "Center");
        PeriodicalsUI a8 = a2.mController.getPeriodicalsUI();
        if (a8 != null) {
            a2.imageLabel.addMouseListener((MouseListener)a4);
        }
    }

    public void recordHistory() {
        CoverView a;
        a.mController.getReaderSDK().getReaderHistoryManager().markHistory(a.mCoverViewHistoryHandler.getID(), new HashMap());
    }

    public ReaderAction[] getMenuActions() {
        return null;
    }

    public TableOfContentsEntry getCurrentArticle() {
        TableOfContents a;
        CoverView a2;
        Book a3 = a2.mController.getReaderSDK().getCurrentBook();
        if (a3 != null && (a = a3.getTOC()) != null) {
            return a.getCurrentTOCNodeEntry();
        }
        return null;
    }

    public ReaderAction[] getToolbarActions() {
        CoverView a;
        AbstractUI a2 = a.mController.getPeriodicalsUI().getContentSpecificUI();
        a2.setFontActionEnabled(false);
        widgetResources = ResourceBundle.getBundle(WIDGET_RESOURCE_NAME);
        AbstractUI abstractUI = a2;
        abstractUI.getClass();
        AbstractUI.GoToBeginningAction a3 = new AbstractUI.GoToBeginningAction(abstractUI, widgetResources.getString("footer.action.cover.label.text"));
        a3.setEnabled(false);
        if (a2.isContentsViewEnabled()) {
            AbstractUI abstractUI2 = a2;
            abstractUI2.getClass();
            AbstractUI.GoToContentsViewAction a4 = new AbstractUI.GoToContentsViewAction(abstractUI2, widgetResources.getString("footer.action.contents.label.text"));
            return new ReaderAction[]{a3, a4};
        }
        return new ReaderAction[]{a3};
    }

    public void layoutComponents() {
        CoverView a;
        a.add(a.imageLabel);
    }

    private double determineImageScale(int a, int a2, int a3, int a4) {
        double a5 = (double)a3 / (double)a;
        double a6 = (double)a4 / (double)a2;
        return Math.min(a5, a6);
    }

    public void setPreferredDimension(Dimension a) {
        CoverView a2;
        if (a == null) {
            return;
        }
        a2.setPreferredSize(a);
        a2.setMinimumSize(a2.getPreferredSize());
        a2.setMaximumSize(a2.getPreferredSize());
    }

    protected TableOfContentsEntry getPeriodicalEntry(Book a) {
        TableOfContents a2 = a.getTOC();
        try {
            TableOfContentsEntry a3 = a2.getNextEntry(null);
            if (a3 != null && "periodical".equals(a3.getNodeType())) {
                return a3;
            }
            return a2.getNextEntryOfType(a3, "periodical", true);
        }
        catch (BookException a4) {
            LOG.error("Exception when getting periodical entry", (Throwable)a4);
            return null;
        }
    }

    public void onScreenDimensionChange(Dimension a) {
        CoverView a2;
        a2.removeAll();
        a2.initialize(a);
    }

    public JComponent getView() {
        CoverView a;
        return a;
    }

    public class GotoHomeAction
    extends AbstractAction {
        private static final long serialVersionUID = 4340213593269415737L;

        public GotoHomeAction() {
            GotoHomeAction a;
        }

        public void actionPerformed(ActionEvent a) {
            GotoHomeAction a2;
            a2.CoverView.this.mPeriodicalsUI.gotoPeriodicalsHome();
        }
    }
}

