/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ebook.booklet.periodicals.common.ui;

import com.amazon.ebook.booklet.reader.sdk.BookException;
import com.amazon.ebook.booklet.reader.sdk.BookNavigator;
import com.amazon.ebook.booklet.reader.sdk.content.TableOfContents;
import com.amazon.ebook.booklet.reader.sdk.content.TableOfContentsEntry;
import com.amazon.ebook.util.log.Log;
import java.awt.Rectangle;
import java.util.ArrayList;

public abstract class BasicTOCSource {
    protected static final Log L = Log.getInstance((String)"BasicTOCSource");
    protected TableOfContentsEntry c;
    protected TableOfContentsEntry[] l;
    protected boolean k;
    protected boolean m;
    protected Rectangle h;
    protected TableOfContents A;
    protected BookNavigator H;
    protected int b;
    protected int K;
    protected int B;
    protected int D;

    public BasicTOCSource() {
        BasicTOCSource a;
    }

    public void resetSource() {
        a.l = null;
        a.c = null;
        a.m = false;
        a.k = false;
    }

    public void setCurrentEntry(TableOfContentsEntry a) {
        a.c = a;
    }

    public TableOfContentsEntry getCurrentEntry() {
        BasicTOCSource a;
        return a.c;
    }

    public TableOfContentsEntry getFirstEntryInCurrentSet() {
        BasicTOCSource a;
        if (a.l != null && a.l.length > 0) {
            return a.l[0];
        }
        return null;
    }

    public TableOfContentsEntry getLastEntryInCurrentSet() {
        BasicTOCSource a;
        if (a.l != null && a.l.length > 0) {
            return a.l[a.l.length - 1];
        }
        return null;
    }

    public void loadNextSet() {
        BasicTOCSource a;
        TableOfContents a2 = a.getTableOfContents();
        try {
            TableOfContentsEntry a3 = a.getEntryToBeginWithOnNext(a2);
            if (a3 == null) {
                return;
            }
            int a4 = a.h.y;
            ArrayList<TableOfContentsEntry> a5 = new ArrayList<TableOfContentsEntry>();
            int n = a4;
            BasicTOCSource basicTOCSource = a;
            while (n + basicTOCSource.B <= a.getMaxY() && a3 != null) {
                Rectangle a6;
                if ((a4 += a.addToMapAndReturnHeight(a6 = new Rectangle(a.h.x, a4, a.D, a.B), a3)) > a.getMaxY()) {
                    a.removeLastElementFromList();
                    break;
                }
                a5.add(a3);
                a3 = a2.getNextEntry(a3);
                n = a4;
                basicTOCSource = a;
            }
            a.l = a5.toArray(new TableOfContentsEntry[a5.size()]);
            a.initializeWidgets();
        }
        catch (BookException a7) {
            L.error("Got a book exception when loading next set :", (Throwable)a7);
        }
    }

    protected void removeLastElementFromList() {
    }

    public void loadPreviousSet() {
        BasicTOCSource a;
        TableOfContents a2 = a.getTableOfContents();
        try {
            int a3;
            Cloneable a4;
            TableOfContentsEntry a5 = a.getEntryToBeginWithOnPrev(a2);
            if (a5 == null) {
                return;
            }
            ArrayList<TableOfContentsEntry> a6 = new ArrayList<TableOfContentsEntry>();
            int a7 = a.h.y;
            TableOfContentsEntry tableOfContentsEntry = a5;
            while (tableOfContentsEntry != null && (a7 += a.addToMapAndReturnHeight((Rectangle)(a4 = new Rectangle(a.h.x, a7, a.D, a.B)), a5)) <= a.getMaxY()) {
                a6.add(a5);
                tableOfContentsEntry = a2.getPreviousEntry(a5);
            }
            a7 = a.h.y;
            a4 = new ArrayList();
            int n = a3 = a6.size() - 1;
            while (n >= 0) {
                Rectangle a8 = new Rectangle(a.h.x, a7, a.D, a.B);
                a5 = (TableOfContentsEntry)a6.get(a3);
                if (a5 == null || (a7 += a.addToMapAndReturnHeight(a8, a5)) > a.getMaxY()) break;
                ((ArrayList)a4).add(a5);
                n = --a3;
            }
            if (((ArrayList)a4).size() > 0) {
                a5 = a2.getNextEntry((TableOfContentsEntry)((ArrayList)a4).get(((ArrayList)a4).size() - 1));
            } else {
                L.debug("The currentEntry before the call for loading previous set was null");
                a5 = null;
            }
            int n2 = a7;
            BasicTOCSource basicTOCSource = a;
            while (n2 < basicTOCSource.getMaxY() && a5 != null && (a7 += a.addToMapAndReturnHeight(a = new Rectangle(a.h.x, a7, a.D, a.B), a5)) <= a.getMaxY()) {
                ((ArrayList)a4).add(a5);
                a5 = a2.getNextEntry(a5);
                n2 = a7;
                basicTOCSource = a;
            }
            a.l = ((ArrayList)a4).toArray(new TableOfContentsEntry[((ArrayList)a4).size()]);
            a.initializeWidgets();
        }
        catch (BookException a9) {
            L.error("Got a book exception when loading previous set :", (Throwable)a9);
        }
    }

    public boolean isNextSetAvailable() {
        BasicTOCSource a;
        TableOfContentsEntry a2 = a.getLastEntryInCurrentSet();
        TableOfContents a3 = a.getTableOfContents();
        try {
            if (a3 != null && a3.getNextEntry(a2) != null) {
                return true;
            }
        }
        catch (BookException a4) {
            L.error("Got a book exception when checking of next :", (Throwable)a4);
        }
        return false;
    }

    public boolean isPreviousSetAvailable() {
        BasicTOCSource a;
        TableOfContentsEntry a2 = a.getFirstEntryInCurrentSet();
        TableOfContents a3 = a.getTableOfContents();
        try {
            if (a3 != null && a3.getPreviousEntry(a2) != null) {
                return true;
            }
        }
        catch (BookException a4) {
            L.error("Got a book exception when checking of next :", (Throwable)a4);
        }
        return false;
    }

    public int getRows() {
        BasicTOCSource a;
        if (a.l == null) {
            return 0;
        }
        return a.l.length;
    }

    public int getIndexOfEntry(TableOfContentsEntry a) {
        BasicTOCSource a2;
        if (a2.l != null && a != null) {
            int a3;
            int n = a3 = 0;
            while (n < a2.l.length) {
                if (a2.l[a3] == a) {
                    return a3;
                }
                n = ++a3;
            }
        }
        return -1;
    }

    public TableOfContentsEntry getEntryWithIndex(int a) {
        BasicTOCSource a2;
        if (a2.l != null && a < a2.l.length && a >= 0) {
            return a2.l[a];
        }
        return null;
    }

    protected TableOfContentsEntry getEntryToBeginWithOnPrev(TableOfContents a) throws BookException {
        BasicTOCSource a2;
        TableOfContentsEntry a3 = a2.getFirstEntryInCurrentSet();
        if (a3 != null) {
            return a.getPreviousEntry(a3);
        }
        return a2.c;
    }

    protected TableOfContentsEntry getEntryToBeginWithOnNext(TableOfContents a) throws BookException {
        BasicTOCSource a2;
        TableOfContentsEntry a3 = a2.getLastEntryInCurrentSet();
        if (a3 != null) {
            return a.getNextEntry(a3);
        }
        return a2.c;
    }

    protected TableOfContents getTableOfContents() {
        BasicTOCSource a;
        return a.A;
    }

    protected abstract int addToMapAndReturnHeight(Rectangle var1, TableOfContentsEntry var2);

    protected abstract void initializeWidgets();

    public abstract void initialize(Rectangle var1);

    protected int getMaxY() {
        BasicTOCSource a;
        if (a.h == null) {
            return 0;
        }
        if (a.b != 0) {
            return a.h.y + a.b * a.h.height;
        }
        return a.h.y + a.h.height;
    }

    public void setAvailableBounds(Rectangle a) {
        a.h = a;
    }

    public Rectangle getAvailableBounds() {
        BasicTOCSource a;
        return a.h;
    }
}

