/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ebook.booklet.periodicals.blogs.ui.views.pooled.widget;

import com.amazon.ebook.booklet.periodicals.blogs.ui.views.pooled.PoolableObject;
import com.amazon.ebook.booklet.periodicals.blogs.ui.views.pooled.widget.EmptyBorder;
import com.amazon.ebook.booklet.periodicals.blogs.ui.views.prelayout.Prelayouter;
import com.amazon.ebook.booklet.periodicals.ui.PeriodicalsUI;
import com.amazon.ebook.booklet.reader.sdk.BookNavigator;
import com.amazon.ebook.booklet.reader.sdk.ReaderSDK;
import com.amazon.ebook.booklet.reader.sdk.content.Book;
import com.amazon.ebook.booklet.reader.sdk.content.Position;
import com.amazon.ebook.booklet.reader.sdk.content.TableOfContents;
import com.amazon.ebook.booklet.reader.sdk.content.TableOfContentsEntry;
import com.amazon.ebook.util.log.Log;
import com.amazon.ebook.util.text.AcceleratedFontMetrics;
import com.amazon.ebook.util.text.TextListFormat;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.event.ActionEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.util.Arrays;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JTextArea;

public abstract class BasicWidget
extends JComponent
implements PoolableObject {
    private static final Log LOG = Log.getInstance((String)"BasicWidget");
    protected static final String CREDIT_TAG_NAME = "credit";
    protected static final String CAPTION_TAG_NAME = "caption";
    protected static final int THUMBNAIL_INDEX_IN_TOCENTRY = 0;
    private static final String WIDGET_RESOURCE_NAME = "com.amazon.ebook.booklet.periodicals.common.ui.resources.TOCWidgetResources";
    private static ResourceBundle widgetResources;
    protected final double DEFAULT_GRID_WEIGHT_X;
    protected final double DEFAULT_GRID_WEIGHT_Y;
    protected final int DEFAULT_GRID_WIDTH;
    protected final int DEFAULT_GRID_HEIGHT;
    protected static final boolean WRAP_LINE = true;
    protected static final boolean WRAP_WORD_STYLE = true;
    protected static final boolean NOT_EDITABLE = false;
    protected int state;
    protected int widgetID;
    protected ReaderSDK readerSDK;
    protected PeriodicalsUI uiController;
    protected int colSpan;
    protected int rowSpan;
    protected Dimension imageDimension;
    protected Dimension widgetDimension;
    protected Image tocImage;
    protected Position positionInPeriodical;
    protected MediaTracker imageTracker;
    protected Prelayouter imageCache;
    protected boolean newImageAvailable;

    public BasicWidget(int a, Dimension a2, int a3, int a4, ReaderSDK a5, PeriodicalsUI a6, MediaTracker a7, Prelayouter a8) {
        BasicWidget a9;
        a9.widgetID = a;
        a9.readerSDK = a5;
        a9.uiController = a6;
        a9.imageTracker = a7;
        a9.imageCache = a8;
        a9.colSpan = a4;
        a9.rowSpan = a3;
        widgetResources = ResourceBundle.getBundle(WIDGET_RESOURCE_NAME);
        a9.DEFAULT_GRID_WIDTH = (Integer)widgetResources.getObject("widget.grid.width.default");
        a9.DEFAULT_GRID_HEIGHT = (Integer)widgetResources.getObject("widget.grid.height.default");
        a9.DEFAULT_GRID_WEIGHT_X = (Double)widgetResources.getObject("weight.grid.x.default");
        a9.DEFAULT_GRID_WEIGHT_Y = (Double)widgetResources.getObject("weight.grid.y.default");
        a9.widgetDimension = a2;
        a9.initialize();
    }

    protected void initSizeParams() {
        BasicWidget a;
        if (a.widgetDimension == null) {
            return;
        }
        a.setPreferredSize(a.widgetDimension);
        a.setMinimumSize(a.getPreferredSize());
        a.setMaximumSize(a.getPreferredSize());
    }

    protected void initActionMap() {
        BasicWidget a;
        widgetResources = ResourceBundle.getBundle(WIDGET_RESOURCE_NAME);
        a.addMouseListener((MouseListener)a.uiController.getGestureDispatcher());
        a.getActionMap().put(widgetResources.getString("event.gesture.tap"), a.new JumpToEntryAction());
    }

    public void initialize() {
        BasicWidget a;
        a.initSizeParams();
        a.initActionMap();
    }

    public void layoutComponents(TableOfContentsEntry a) {
        BasicWidget a2;
        if (a2.tocImage != null) {
            a2.imageTracker.removeImage(a2.tocImage);
            a2.tocImage = null;
        }
        a2.newImageAvailable = false;
        a2.positionInPeriodical = a.getPosition();
    }

    public int getState() {
        BasicWidget a;
        return a.state;
    }

    public void setState(int a) {
        a.state = a;
    }

    public Integer getID() {
        BasicWidget a;
        return new Integer(a.widgetID);
    }

    public void loadResources() {
        BasicWidget a;
        if (a.imageTracker != null && a.imageTracker.statusID(a.widgetID, true) != 0) {
            try {
                a.imageTracker.waitForID(a.widgetID);
            }
            catch (InterruptedException a2) {
                LOG.error("Image loading interrupted", (Throwable)a2);
            }
            a.imageTracker.removeImage(a.tocImage);
        }
    }

    protected void getImageFromEntryAsync(TableOfContentsEntry a, Dimension a2) {
        if (a != null && a2 != null) {
            BasicWidget a3;
            if (Log.isDebugOn()) {
                LOG.debug("Getting image asynchronously for :" + a.getLabel() + ":" + a2);
            }
            Image a4 = null;
            if (a3.imageCache != null) {
                a4 = a3.imageCache.get(a, a3.getPreferredSize());
            }
            if (a4 != null) {
                if (Log.isDebugOn()) {
                    LOG.debug("CACHE HIT: Retrieving image from cache");
                }
                a3.tocImage = a4;
                a3.newImageAvailable = true;
            } else {
                Image[] a5;
                if (Log.isDebugOn()) {
                    LOG.debug("Image not in cache.. checking if image is present at all!");
                }
                if ((a5 = a.getImages(a2)) != null && a5.length > 0) {
                    if (Log.isDebugOn()) {
                        LOG.debug("CACHE MISS: Adding image to cache");
                    }
                    a3.tocImage = a5[0];
                    a3.newImageAvailable = true;
                    if (a3.imageCache != null) {
                        a3.imageCache.put(a3.tocImage, a, a3.getPreferredSize());
                    }
                } else {
                    a3.tocImage = null;
                    if (Log.isDebugOn()) {
                        LOG.debug("There is no thumbnail image for this article");
                    }
                }
            }
            if (a3.tocImage != null) {
                a3.imageTracker.addImage(a3.tocImage, a3.widgetID);
                try {
                    a3.imageTracker.waitForID(a3.widgetID);
                }
                catch (InterruptedException a6) {
                    LOG.error("Image loading interrupted", (Throwable)a6);
                }
                a3.imageTracker.removeImage(a3.tocImage);
            }
        }
    }

    protected JTextArea getTextArea(String a, Font a2, boolean a3, boolean a4, boolean a5) {
        BasicWidget a6;
        JTextArea a7 = new JTextArea(a);
        a7.setFont(a2);
        a7.setEditable(a5);
        a7.setWrapStyleWord(a3);
        a7.setLineWrap(a4);
        a7.setFocusable(false);
        MouseListener[] a8 = a7.getMouseListeners();
        if (a8 != null) {
            int a9;
            int n = a9 = 0;
            while (n < a8.length) {
                a7.removeMouseListener(a8[a9]);
                n = ++a9;
            }
        }
        if (a6.uiController != null) {
            a7.addMouseListener((MouseListener)a6.uiController.getGestureDispatcher());
        }
        a7.setBorder(new EmptyBorder());
        return a7;
    }

    protected GridBagConstraints getGridConstraints(int a, int a2, int a3, int a4, Insets a5, double a6, double a7) {
        GridBagConstraints a8 = new GridBagConstraints();
        new GridBagConstraints().gridx = a;
        a8.gridy = a2;
        a8.gridwidth = a3;
        a8.gridheight = a4;
        a8.insets = a5;
        a8.weightx = a6;
        a8.weighty = a7;
        return a8;
    }

    protected int setTextAreaHeight(JTextArea a, int a2, Insets a3) {
        Serializable a4;
        if (a2 <= 0) {
            return a2;
        }
        int a5 = a2;
        int a6 = a.getPreferredSize().height;
        if (a6 > (a2 -= a3.top + a3.bottom)) {
            a4 = a.getFont();
            int a7 = AcceleratedFontMetrics.getInstance((Font)a4, (FontMetrics)a.getFontMetrics((Font)a4)).getHeight();
            int a8 = a2 / a7;
            if (a8 <= 0) {
                return a5;
            }
            a6 = a7 * a8;
        }
        a4 = new Dimension(a.getPreferredSize().width, a6);
        a.setPreferredSize((Dimension)a4);
        return a2 -= a6;
    }

    public String getAuthors(TableOfContentsEntry a) {
        String[] a2;
        if (a != null && (a2 = a.getAuthors()) != null && a2.length > 0) {
            return TextListFormat.getInstance().format(Arrays.asList(a2), TextListFormat.FormatListType.AND);
        }
        return null;
    }

    public void jumpToEntry() {
        BasicWidget a;
        BookNavigator a2 = a.readerSDK.getBookNavigator();
        if (a2 != null) {
            a2.goTo(a.positionInPeriodical);
        }
    }

    public String getImageCaption(TableOfContentsEntry a) {
        String[] a2;
        if (a != null && (a2 = a.getNamedTag(CAPTION_TAG_NAME)) != null && a2.length > 0) {
            return a2[0];
        }
        return null;
    }

    public String getImageCredits(TableOfContentsEntry a) {
        String[] a2;
        if (a != null && (a2 = a.getNamedTag(CREDIT_TAG_NAME)) != null && a2.length > 0) {
            return a2[0];
        }
        return null;
    }

    public int getColSpan() {
        BasicWidget a;
        return a.colSpan;
    }

    public int getRowSpan() {
        BasicWidget a;
        return a.rowSpan;
    }

    protected class JumpToEntryAction
    extends AbstractAction {
        protected JumpToEntryAction() {
            JumpToEntryAction a;
        }

        public void actionPerformed(ActionEvent a) {
            JumpToEntryAction a2;
            a2.BasicWidget.this.jumpToEntry();
            Book a3 = a2.BasicWidget.this.readerSDK.getCurrentBook();
            if (a3 == null) {
                return;
            }
            TableOfContents a4 = a3.getTOC();
            a2.BasicWidget.this.uiController.jumpToEntry(a4.getTOCFromPosition(a2.BasicWidget.this.positionInPeriodical));
        }
    }
}

