/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ebook.booklet.periodicals.blogs.ui.views.home.widgets;

import com.amazon.ebook.booklet.periodicals.blogs.ui.views.pooled.widget.BasicWidget;
import com.amazon.ebook.booklet.periodicals.blogs.ui.views.pooled.widget.TextDisplay;
import com.amazon.ebook.booklet.periodicals.blogs.ui.views.prelayout.Prelayouter;
import com.amazon.ebook.booklet.periodicals.ui.PeriodicalsUI;
import com.amazon.ebook.booklet.reader.sdk.ReaderSDK;
import com.amazon.ebook.booklet.reader.sdk.content.TableOfContentsEntry;
import com.amazon.ebook.util.log.Log;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.MediaTracker;
import java.awt.event.MouseListener;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.TimeZone;
import javax.swing.JLabel;

public class BlogWidget
extends BasicWidget {
    private static final Log LOG = Log.getInstance((String)"BlogWidget");
    private static final String WIDGET_RESOURCE_NAME = "com.amazon.ebook.booklet.periodicals.blogs.ui.views.home.resources.BlogHomeSpecialWidgetResources";
    private static ResourceBundle widgetResources;
    protected static final String UPDATED_TIME_TAG_NAME = "updatedTime";
    protected static final DateFormat UPDATED_TIME_FORMATTER;
    protected JLabel timeUpdated;
    protected TextDisplay articleTitleArea;

    public BlogWidget(int a, Dimension a2, int a3, int a4, ReaderSDK a5, PeriodicalsUI a6, MediaTracker a7, Prelayouter a8) {
        super(a, a2, a3, a4, a5, a6, a7, a8);
        BlogWidget a9;
    }

    public void initialize() {
        BlogWidget a;
        super.initialize();
        widgetResources = ResourceBundle.getBundle(WIDGET_RESOURCE_NAME);
        a.articleTitleArea = new TextDisplay();
        a.timeUpdated = new JLabel("");
        a.timeUpdated.setFont((Font)widgetResources.getObject("article.time.font"));
        a.timeUpdated.setForeground((Color)widgetResources.getObject("article.time.color.foreground"));
        if (a.uiController != null) {
            a.timeUpdated.addMouseListener((MouseListener)a.uiController.getGestureDispatcher());
        }
    }

    public void layoutComponents(TableOfContentsEntry a) {
        BlogWidget a2;
        a2.removeAll();
        a2.resetComponentSizes();
        super.layoutComponents(a);
    }

    protected void resetComponentSizes() {
        BlogWidget a;
        a.timeUpdated.setPreferredSize(null);
        a.articleTitleArea.setComponentSizes(null);
    }

    public String getUpdateTimeUIString(TableOfContentsEntry a) {
        Date a2 = BlogWidget.getUpdatedTimeFromEntry(a);
        if (a2 != null) {
            widgetResources = ResourceBundle.getBundle(WIDGET_RESOURCE_NAME);
            return ((MessageFormat)widgetResources.getObject("article.updated.date.time.format")).format(new Object[]{a2});
        }
        return "";
    }

    public static Date getUpdatedTimeFromEntry(TableOfContentsEntry a) {
        String[] a2 = a.getNamedTag(UPDATED_TIME_TAG_NAME);
        String a3 = null;
        if (a2.length > 0) {
            a3 = a2[0];
        }
        if (a3 == null) {
            return null;
        }
        try {
            return UPDATED_TIME_FORMATTER.parse(a3);
        }
        catch (ParseException a4) {
            LOG.error("Error when parsing publication date", (Throwable)a4);
            return null;
        }
    }

    static {
        UPDATED_TIME_FORMATTER = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ", Locale.US);
        UPDATED_TIME_FORMATTER.setTimeZone(TimeZone.getTimeZone("UTC"));
    }
}

