/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ebook.booklet.periodicals.blogs.ui.views.home;

import com.amazon.ebook.booklet.periodicals.PeriodicalBooklet;
import com.amazon.ebook.booklet.periodicals.blogs.ui.views.home.sources.BlogHomeSource_v2;
import com.amazon.ebook.booklet.periodicals.blogs.ui.views.home.widgets.BlogHomeFooterWidget;
import com.amazon.ebook.booklet.periodicals.blogs.ui.views.prelayout.Prelayouter;
import com.amazon.ebook.booklet.periodicals.common.history.PeriodicalsViewContext;
import com.amazon.ebook.booklet.periodicals.common.ui.AbstractUI;
import com.amazon.ebook.booklet.periodicals.common.ui.MastheadWidget;
import com.amazon.ebook.booklet.periodicals.common.ui.PeriodicalGridView_v2;
import com.amazon.ebook.booklet.periodicals.newspapers.ui.views.home.PeriodicalHomeHistoryHandler;
import com.amazon.ebook.booklet.periodicals.ui.PeriodicalsUI;
import com.amazon.ebook.booklet.reader.sdk.BookException;
import com.amazon.ebook.booklet.reader.sdk.BookNavigator;
import com.amazon.ebook.booklet.reader.sdk.content.Book;
import com.amazon.ebook.booklet.reader.sdk.content.BookMetadata;
import com.amazon.ebook.booklet.reader.sdk.content.TableOfContents;
import com.amazon.ebook.booklet.reader.sdk.content.TableOfContentsEntry;
import com.amazon.ebook.booklet.reader.sdk.ui.ReaderAction;
import com.amazon.ebook.util.log.Log;
import com.amazon.ebook.util.log.PerformanceLog;
import com.amazon.ebook.util.prelayout.CacheManager;
import com.amazon.ebook.util.thread.ThreadPool;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.MouseListener;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.border.AbstractBorder;

public class BlogHome
extends PeriodicalsViewContext {
    public static final String VIEW_NAME = "blogs.home.view";
    private static final Log LOG = Log.getInstance((String)"BlogsHome");
    private static final String WIDGET_RESOURCE_NAME = "com.amazon.ebook.booklet.periodicals.blogs.ui.views.home.resources.BlogHomeResources";
    private PeriodicalHomeHistoryHandler mBlogHomeHistoryHandler;
    private static final int INITIAL_CACHE_SIZE = 60;
    private static final float CACHE_LOAD_FACTOR = 0.75f;
    private static final int MASTHEAD_WIDGET_ID = 1;
    private Prelayouter prelayouter;
    private PeriodicalBooklet mController;
    private PeriodicalGridView_v2 mGridView;
    private Book currentBook;
    private Object lock = new Object();

    public BlogHome(PeriodicalBooklet a) {
        super(a);
        BlogHome a2;
        a2.mController = a;
        ResourceBundle a3 = ResourceBundle.getBundle(WIDGET_RESOURCE_NAME);
        a2.mGridView = new PeriodicalGridView_v2();
        a2.mGridView.setBackground((Color)a3.getObject("color.background"));
        a2.mGridView.setPersistMasthead(true);
        a2.mGridView.addMouseListener((MouseListener)a2.mController.getPeriodicalsUI().getGestureDispatcher());
        a2.add(a2.mGridView);
        ActionMap a4 = a2.mGridView.getActionMap();
        if (a4 != null) {
            a4.put(a3.getString("event.gesture.previous"), a2.new PrevPageAction());
            a4.put(a3.getString("event.gesture.next"), a2.new NextPageAction());
            a4.put(a3.getString("event.gesture.previous.vertical"), a2.new PrevPageAction());
            a4.put(a3.getString("event.gesture.next.vertical"), a2.new NextPageAction());
        }
        a2.mBlogHomeHistoryHandler = PeriodicalHomeHistoryHandler.getRegisteredInstance(a.getReaderSDK(), a.getPeriodicalsUI());
        a2.prelayouter = new Prelayouter(BlogHome.getCacheMgr());
    }

    public String getName() {
        return VIEW_NAME;
    }

    private static CacheManager getCacheMgr() {
        return new CacheManager(60, 0.75f, new CacheManager.EvictionPolicy(){
            {
                1 a;
            }

            public boolean evictReqd(Map a, CacheManager.Cacheable a2) {
                return false;
            }

            public Object evict(Map a) {
                return null;
            }
        });
    }

    public synchronized void initialize(Dimension a) {
        BlogHome a2;
        Book a3 = a2.mController.getReaderSDK().getCurrentBook();
        if (a3 == null || a == null || a3.equals(a2.currentBook) && a.equals(a2.getPreferredSize())) {
            LOG.warning("Request to initialize is from the same book for same dimension. Skipping initialize.");
            return;
        }
        a2.currentBook = a3;
        a2.setupGrid(a);
        a2.setPreferredSize(a);
        BookNavigator a4 = a2.mController.getReaderSDK().getBookNavigator();
        ResourceBundle a5 = ResourceBundle.getBundle(WIDGET_RESOURCE_NAME);
        Dimension a6 = new Dimension(a.width, (Integer)a5.getObject("masthead.height"));
        int a7 = a.width - a2.mGridView.getMarginLeft() - a2.mGridView.getMarginRight();
        Dimension a8 = new Dimension(a7, (Integer)a5.getObject("masthead.image.height"));
        a2.mGridView.setMastheadWidget(new MastheadWidget(1, a6, (Integer)a5.getObject("masthead.span.column"), a2.mController.getReaderSDK(), a2.mController.getPeriodicalsUI(), a2.prelayouter, a8));
        BookMetadata a9 = a3.getMetadata();
        if (a9 != null) {
            a2.mGridView.getMastheadWidget().setMastheadTitle(a9.getTitle());
        }
        a2.mGridView.getMastheadWidget().layoutComponents(a2.getPeriodicalEntry(a3));
        a2.mGridView.setTocSource(new BlogHomeSource_v2(a2.readerSDK, a2.mController.getPeriodicalsUI(), a4, a2.currentBook.getTOC(), a2.mGridView.getRows(), a2.mGridView.getColumns(), a2.prelayouter));
        int a10 = (Integer)a5.getObject("footer.height");
        int a11 = a.height - a10 - a2.mGridView.getMastheadWidget().getPreferredSize().height;
        a2.mGridView.getTocSource().initialize(new Dimension(a7, a11));
        a2.mGridView.setFooterWidget(new BlogHomeFooterWidget(new Dimension(a7, a10), a2.mGridView.getTocSource()));
        if (a2.mController.getPeriodicalsUI().getCurrentOrientation() == 2) {
            a2.mGridView.setBorders(a2.new HorizontalLandscapeBorder(), a2.new VerticalLandscapeBorder());
        } else {
            a2.mGridView.setBorders(a2.new HorizontalBorder(), a2.new VerticalBorder());
        }
    }

    public synchronized void initForDisplay(TableOfContentsEntry a) {
        BlogHome a2;
        a2.mGridView.getTocSource().loadSetHavingTOCEntry(a);
        a2.mGridView.layoutNewComponents();
    }

    public void setContextLayout() {
        BlogHome a;
        a.mGridView.loadResources();
    }

    public void paint(Graphics a) {
        BlogHome a2;
        super.paint(a);
        a2.triggerPrelayout();
        PerformanceLog.logEvent((String)"PeriodicalHome_drawPage");
    }

    private void triggerPrelayout() {
        BlogHome a;
        EventQueue.invokeLater(new Runnable(){
            {
                2 a;
            }

            public void run() {
                2 a;
                ThreadPool.getInstance().runIt(new Runnable(){
                    {
                        1 a;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        1 a;
                        try {
                            Thread.sleep(200L);
                        }
                        catch (InterruptedException a2) {
                            LOG.warning("Prelayout thread sleep interrupted", (Throwable)a2);
                        }
                        Object object = BlogHome.this.lock;
                        synchronized (object) {
                            BlogHome.this.prelayouter.stopPrelayout(true);
                            BlogHome.this.prelayouter.startPrelayout(null);
                        }
                    }
                }, "Blog Home prelayout");
            }
        });
    }

    protected void setupGrid(Dimension a) {
        BlogHome a2;
        a2.mGridView.setViewDimension(a);
        ResourceBundle a3 = ResourceBundle.getBundle(WIDGET_RESOURCE_NAME);
        a2.mGridView.setMarginLeft((Integer)a3.getObject("margin.left"));
        a2.mGridView.setMarginRight((Integer)a3.getObject("margin.right"));
        if (PeriodicalsUI.isPortrait(a)) {
            a2.mGridView.setRows((Integer)a3.getObject("portrait.rows"));
            a2.mGridView.setColumns((Integer)a3.getObject("portrait.columns"));
        } else {
            a2.mGridView.setRows((Integer)a3.getObject("landscape.rows"));
            a2.mGridView.setColumns((Integer)a3.getObject("landscape.columns"));
        }
    }

    public JComponent getView() {
        BlogHome a;
        return a.mGridView;
    }

    public boolean isHomeActionEnabled() {
        BlogHome a;
        return a.mGridView != null && a.mGridView.getTocSource() != null && !a.mGridView.getTocSource().isFirstPage();
    }

    public void onScreenDimensionChange(Dimension a) {
        BlogHome a2;
        a2.initialize(a);
    }

    public void onPeriodicalClose() {
        BlogHome a;
        a.prelayouter.stopPrelayout(true);
    }

    public void clearCache() {
        BlogHome a;
        a.prelayouter.getCacheManager().clear();
    }

    public void recordHistory() {
        BlogHome a;
        TableOfContentsEntry a2 = a.mGridView.getTocSource().getEntryWithIndex(0);
        a.mController.getReaderSDK().getReaderHistoryManager().markHistory(a.mBlogHomeHistoryHandler.getID(), a.mBlogHomeHistoryHandler.createMapData(a2));
    }

    public ReaderAction[] getMenuActions() {
        return null;
    }

    public TableOfContentsEntry getCurrentArticle() {
        BlogHome a;
        return a.mGridView.getTocSource().getEntryWithIndex(0);
    }

    public ReaderAction[] getToolbarActions() {
        BlogHome a;
        AbstractUI a2 = a.mController.getPeriodicalsUI().getContentSpecificUI();
        a2.setFontActionEnabled(false);
        ResourceBundle a3 = ResourceBundle.getBundle(WIDGET_RESOURCE_NAME);
        AbstractUI abstractUI = a2;
        abstractUI.getClass();
        AbstractUI.GoToBeginningAction a4 = abstractUI.new AbstractUI.GoToBeginningAction(a3.getString("footer.action.beginning.label.text"));
        a4.setEnabled(!a.mGridView.getTocSource().isFirstPage());
        return new ReaderAction[]{a4};
    }

    protected TableOfContentsEntry getPeriodicalEntry(Book a) {
        TableOfContents a2 = a.getTOC();
        try {
            TableOfContentsEntry a3 = a2.getNextEntry(null);
            if (a3 != null && "periodical".equals(a3.getNodeType())) {
                return a3;
            }
            return a2.getNextEntryOfType(a3, "periodical", true);
        }
        catch (BookException a4) {
            LOG.error("Exception when getting periodical entry", (Throwable)a4);
            return null;
        }
    }

    public void setRefreshSensitivity() {
        BlogHome a;
        a.mController.getBookletContext().setRefreshSensitivity(-3);
    }

    private class PrevPageAction
    extends AbstractAction {
        private PrevPageAction() {
            PrevPageAction a;
        }

        public void actionPerformed(ActionEvent a) {
            PrevPageAction a2;
            a2.BlogHome.this.mGridView.getTocSource().loadPreviousSet();
            a2.BlogHome.this.mGridView.relayoutComponents();
            a2.BlogHome.this.mController.getPeriodicalsUI().getContentSpecificUI().addChromeSearchBarButtons();
        }
    }

    private class NextPageAction
    extends AbstractAction {
        private NextPageAction() {
            NextPageAction a;
        }

        public void actionPerformed(ActionEvent a) {
            NextPageAction a2;
            a2.BlogHome.this.mGridView.getTocSource().loadNextSet();
            a2.BlogHome.this.mGridView.relayoutComponents();
            a2.BlogHome.this.mController.getPeriodicalsUI().getContentSpecificUI().addChromeSearchBarButtons();
        }
    }

    public class HorizontalLandscapeBorder
    extends AbstractBorder {
        private Color borderColor;
        private int firstLineThickness;
        private int paddingLeft;
        private int paddingRight;

        public HorizontalLandscapeBorder() {
            HorizontalLandscapeBorder a;
            ResourceBundle a2 = ResourceBundle.getBundle(BlogHome.WIDGET_RESOURCE_NAME);
            a.borderColor = (Color)a2.getObject("separator.horizontal.color");
            a.firstLineThickness = (Integer)a2.getObject("separator.horizontal.first.thickness");
            a.paddingLeft = (Integer)a2.getObject("separator.vertical.padding.left");
            a.paddingRight = (Integer)a2.getObject("separator.vertical.padding.right");
        }

        public void paintBorder(Component a, Graphics a2, int a3, int a4, int a5, int a6) {
            HorizontalLandscapeBorder a7;
            Color a8 = a2.getColor();
            int a9 = a5 - a7.paddingLeft - a7.paddingRight;
            int a10 = a3 + a7.paddingLeft;
            a2.setColor(a7.borderColor);
            a2.fillRect(a10, a4, a9, a7.firstLineThickness);
            a2.setColor(a8);
        }
    }

    public class VerticalLandscapeBorder
    extends AbstractBorder {
        private Color borderColor;
        private int firstLineThickness;

        public VerticalLandscapeBorder() {
            VerticalLandscapeBorder a;
            ResourceBundle a2 = ResourceBundle.getBundle(BlogHome.WIDGET_RESOURCE_NAME);
            a.borderColor = (Color)a2.getObject("separator.vertical.color");
            a.firstLineThickness = (Integer)a2.getObject("separator.vertical.first.thickness");
        }

        public void paintBorder(Component a, Graphics a2, int a3, int a4, int a5, int a6) {
            VerticalLandscapeBorder a7;
            Color a8 = a2.getColor();
            a2.setColor(a7.borderColor);
            a2.fillRect(a3, a4, a7.firstLineThickness, a6);
            a2.setColor(a8);
        }
    }

    public class HorizontalBorder
    extends AbstractBorder {
        private Color borderColor;
        private int firstLineThickness;

        public HorizontalBorder() {
            HorizontalBorder a;
            ResourceBundle a2 = ResourceBundle.getBundle(BlogHome.WIDGET_RESOURCE_NAME);
            a.borderColor = (Color)a2.getObject("separator.horizontal.color");
            a.firstLineThickness = (Integer)a2.getObject("separator.horizontal.first.thickness");
        }

        public void paintBorder(Component a, Graphics a2, int a3, int a4, int a5, int a6) {
            HorizontalBorder a7;
            Color a8 = a2.getColor();
            a2.setColor(a7.borderColor);
            a2.fillRect(a3, a4, a5, a7.firstLineThickness);
            a2.setColor(a8);
        }
    }

    public class VerticalBorder
    extends AbstractBorder {
        private Color borderColor;
        private int firstLineThickness;
        private int paddingTop;
        private int paddingBottom;

        public VerticalBorder() {
            VerticalBorder a;
            ResourceBundle a2 = ResourceBundle.getBundle(BlogHome.WIDGET_RESOURCE_NAME);
            a.borderColor = (Color)a2.getObject("separator.vertical.color");
            a.firstLineThickness = (Integer)a2.getObject("separator.vertical.first.thickness");
            a.paddingTop = (Integer)a2.getObject("separator.vertical.padding.top");
            a.paddingBottom = (Integer)a2.getObject("separator.vertical.padding.bottom");
        }

        public void paintBorder(Component a, Graphics a2, int a3, int a4, int a5, int a6) {
            VerticalBorder a7;
            Color a8 = a2.getColor();
            a2.setColor(a7.borderColor);
            int a9 = a6 - a7.paddingTop - a7.paddingBottom;
            int a10 = a4 + a7.paddingTop;
            a2.fillRect(a3, a10, a7.firstLineThickness, a9);
            a2.setColor(a8);
        }
    }
}

