/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ebook.booklet.periodicals;

import com.amazon.ebook.booklet.periodicals.KeepIssue;
import com.amazon.ebook.booklet.periodicals.common.history.PeriodicalsHistoryHandler;
import com.amazon.ebook.booklet.periodicals.events.handlers.AnnotationEventsHandler;
import com.amazon.ebook.booklet.periodicals.listeners.PeriodicalsPowerListener;
import com.amazon.ebook.booklet.periodicals.listeners.PeriodicalsStorageListener;
import com.amazon.ebook.booklet.periodicals.state.PeriodicalViewState;
import com.amazon.ebook.booklet.periodicals.state.PeriodicalsStateSaver;
import com.amazon.ebook.booklet.periodicals.ui.PeriodicalsUI;
import com.amazon.ebook.booklet.reader.errorhandler.ErrorHandler;
import com.amazon.ebook.booklet.reader.impl.ReaderSDKImpl;
import com.amazon.ebook.booklet.reader.sdk.BookException;
import com.amazon.ebook.booklet.reader.sdk.ReaderException;
import com.amazon.ebook.booklet.reader.sdk.ReaderPlugin;
import com.amazon.ebook.booklet.reader.sdk.ReaderSDK;
import com.amazon.ebook.booklet.reader.sdk.content.Book;
import com.amazon.ebook.booklet.reader.sdk.content.LastPageRead;
import com.amazon.ebook.booklet.reader.sdk.content.Position;
import com.amazon.ebook.booklet.reader.sdk.event.EventHandler;
import com.amazon.ebook.booklet.reader.sdk.internal.BookStateManager;
import com.amazon.ebook.booklet.reader.sdk.util.DataStoreFactory;
import com.amazon.ebook.booklet.reader.sdk.util.InvalidSideCarFileException;
import com.amazon.ebook.booklet.reader.sdk.util.State;
import com.amazon.ebook.booklet.reader.utils.FrameworkUtil;
import com.amazon.ebook.booklet.reader.utils.SwitchAppUtils;
import com.amazon.ebook.util.log.Log;
import com.amazon.ebook.util.log.PerformanceLog;
import com.amazon.ebook.util.log.Profiler;
import com.amazon.ebook.util.net.URIUtility;
import com.amazon.kindle.booklet.AbstractBooklet;
import com.amazon.kindle.booklet.BookletContext;
import com.amazon.kindle.booklet.LifecycleException;
import com.amazon.kindle.device.PowerManagementStateListener;
import com.amazon.kindle.device.PowerService;
import com.amazon.kindle.device.UserStoreListener;
import com.amazon.kindle.device.UserStoreService;
import com.sun.awt.WindowSurface;
import com.sun.awt.WindowSurfaceListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Window;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.JPanel;

public class PeriodicalBooklet
extends AbstractBooklet {
    private static final Log d = Log.getInstance((String)"PeriodicalBooklet");
    private static final String j = "location";
    private static final String g = "/reader.pref";
    private ReaderSDK e = null;
    private State I = null;
    private PeriodicalsStorageListener F;
    private PeriodicalsPowerListener L;
    private ErrorHandler c;
    private PeriodicalsUI l;
    private List k;
    private List m;
    private AnnotationEventsHandler h;
    private WindowSurface A;
    private ScreenUpdateListener H;
    private PeriodicalsStateSaver b;

    public PeriodicalBooklet() {
        PeriodicalBooklet a;
    }

    public void create(BookletContext a) {
        PeriodicalBooklet a2;
        Profiler a3 = new Profiler("Periodicals Booklet create");
        super.create(a);
        a2.e = (ReaderSDK)a.getService(ReaderSDK.class);
        if (a2.e == null) {
            d.error("Error getting Reader SDK implementation. Failed booklet creation");
            SwitchAppUtils.goHome();
            return;
        }
        a2.c = new ErrorHandler();
        a2.L = new PeriodicalsPowerListener(a2);
        PowerService a4 = (PowerService)a.getService(PowerService.class);
        if (a4 != null) {
            a4.addPowerManagementStateListener((PowerManagementStateListener)a2.L);
        } else {
            d.error("can not get Power service");
        }
        a2.F = new PeriodicalsStorageListener(a2);
        UserStoreService a5 = (UserStoreService)a.getService(UserStoreService.class);
        if (a5 != null) {
            a5.addUserStoreListener((UserStoreListener)a2.F);
        } else {
            d.error("can not get Storage service");
        }
        a2.m = new ArrayList();
        a2.k = new ArrayList();
        a2.l = new PeriodicalsUI(a2);
        a2.h = new AnnotationEventsHandler(a2);
        KeepIssue.setBooklet(a2);
        a2.A = new WindowSurface(PeriodicalBooklet.findWindow(a2.getBookletContext().getUIContainer()));
        a2.H = new ScreenUpdateListener();
        a2.H.setController(a2);
        a2.A.addWindowSurfaceListener((WindowSurfaceListener)a2.H);
        a2.b = new PeriodicalsStateSaver();
        a2.b.setController(a2);
        a3.dump();
    }

    public static Window findWindow(Component a) {
        Component component = a;
        while (component != null) {
            if (a instanceof Window) {
                return (Window)a;
            }
            component = a.getParent();
        }
        return null;
    }

    public void destroy() {
        PeriodicalBooklet a;
        d.info("PeriodicalsBooklet destroy");
        try {
            a.doStop();
        }
        catch (Exception a2) {
            d.error("Failed to stop ReaderSDK", (Throwable)a2);
        }
        UserStoreService a3 = (UserStoreService)a.getBookletContext().getService(UserStoreService.class);
        if (a3 != null && a.F != null) {
            a3.removeUserStoreListener((UserStoreListener)a.F);
        } else {
            d.error("Could not get Storage service");
        }
        PowerService a4 = (PowerService)a.getBookletContext().getService(PowerService.class);
        if (a4 != null && a.L != null) {
            a4.removePowerStateListener((PowerManagementStateListener)a.L);
        } else {
            d.error("Could not get Power service");
        }
        KeepIssue.reset();
        a.b.setController(null);
        super.destroy();
    }

    public void start(URI a) {
        PeriodicalBooklet a2;
        super.start(a);
        a2.doStart(a);
    }

    private boolean openForGoTo(URI a, Map a2) {
        PeriodicalBooklet a3;
        String a4 = (String)a2.get("gotoaction");
        if (a4 == null || !a4.equals("first") && !a4.equals("content")) {
            return false;
        }
        if (a4.equals("first")) {
            a3.l.gotoBeginning();
        } else if (a4.equals("content")) {
            a3.l.gotoContentsView();
        }
        return true;
    }

    public void doStart(URI a) {
        PeriodicalBooklet a2;
        Profiler a3 = new Profiler("Starting periodicals booklet", d);
        a2.comeBackFromUSB();
        a2.registerHandler((EventHandler)a2.c);
        a2.registerHandler((EventHandler)a2.h);
        a2.registerHandler((EventHandler)a2.b);
        if (Log.isDebugOn()) {
            d.debug("Starting Periodicals booklet");
        }
        a3.dump("Done with registering handlers");
        try {
            a2.I = a2.e.loadAppState(FrameworkUtil.getPreferenceDirectory() + g);
        }
        catch (ClassNotFoundException a4) {
            d.error("Failed to load AppState from user preference", (Throwable)a4);
            a2.I = null;
        }
        catch (IOException a5) {
            d.warning("User preference file not found or failed to read from disk", (Throwable)a5);
            a2.I = null;
        }
        catch (InvalidSideCarFileException a6) {
            d.error("Invalid user preference file for periodical preferences", (Throwable)a6);
            a2.I = null;
        }
        try {
            a2.e.switchContext((Object)a2, a2.I);
            a2.I = a2.e.getAppState();
        }
        catch (ReaderException a7) {
            throw new LifecycleException(true, a7.getLocalizedTitle(), a7.getLocalizedMessage());
        }
        catch (Throwable a8) {
            ReaderException a9 = new ReaderException(a8);
            throw new LifecycleException(true, a9.getLocalizedMessage(), a9.getLocalizedMessage());
        }
        if (a.getPath() == null) {
            return;
        }
        Map a10 = URIUtility.getQueryMap((URI)a);
        a3.dump("Obtained query map");
        try {
            Book a11 = null;
            if (a2.isBookOpen(a)) {
                a11 = a2.e.getCurrentBook();
                a2.l.setAlreadyInitialized(true);
            } else {
                a2.l.clearCache();
                a11 = a2.e.openBook(a.getPath());
                a2.l.setAlreadyInitialized(false);
            }
            BookStateManager a12 = a2.e.getBookStateManager();
            if (a12 != null) {
                a12.addFrequentUpdateBookStateFactory((DataStoreFactory)new PeriodicalViewState.PeriodicalViewDataFactory());
            }
            Position a13 = a2.getPositionToOpen(a11, a10);
            a2.getBookletContext().getUIContainer().removeAll();
            a2.getBookletContext().getUIContainer().add(a2.e.getUI().getReaderPane());
            a2.H.setNotificationEnabled(true);
            a3.dump("Done with switching to book");
            a2.e.getUI().replaceChromeFooterPanel(new JPanel(new BorderLayout()));
            a2.l.initialize(a11);
            a2.e.setTipsAndTricksURI(a);
            boolean a14 = a2.openWithPlugin(a, a10);
            a3.dump("Done with plugin open");
            if (!a14) {
                a2.e.switchToBook(a11, null, a13, false, true);
                a14 = a2.openForGoTo(a, a10);
            }
            a3.dump("Done with open for Go to");
            if (!a14) {
                a10.put("uiController", a2.l);
                a14 = a2.openWithReaderHistoryManager(a, a10);
            }
            a3.dump("Done with history manager open");
            if (!a14) {
                a2.openWithReader(a11, a13);
            }
            a3.dump("Opened with reader");
        }
        catch (ReaderException a15) {
            d.error("Failed to start Periodicals application", (Throwable)a15);
            ResourceBundle a16 = ResourceBundle.getBundle("com.amazon.ebook.booklet.reader.sdk.exception.resources.ReaderExceptionResources");
            throw new LifecycleException(true, a15.getLocalizedTitle(), a15.getLocalizedMessage());
        }
        catch (Exception a17) {
            ReaderException a18 = new ReaderException(0, (Throwable)a17);
            d.error("Failed to start Periodicals application", (Throwable)a17);
            ResourceBundle a19 = ResourceBundle.getBundle("com.amazon.ebook.booklet.reader.sdk.exception.resources.ReaderExceptionResources");
            throw new LifecycleException(true, a18.getLocalizedTitle(), a18.getLocalizedMessage());
        }
        a3.dump("Completed start method of periodicals");
    }

    public ReaderSDK getReaderSDK() {
        PeriodicalBooklet a;
        return a.e;
    }

    public void stop() {
        PeriodicalBooklet a;
        d.info("Periodicals Booklet stop");
        super.stop();
        a.doStop();
        PerformanceLog.logEvent((String)"PeriodicalBooklet_Stop");
    }

    public void doStop() {
        PeriodicalBooklet a;
        if (a.e.getActiveContext() == a.getBookletContext()) {
            Profiler a2 = new Profiler("Stopping periodicals booklet");
            a.deregisterHandlers();
            a.resetHistoryHandlers();
            a.saveOnUSBMode();
            a.l.onAppStop();
            try {
                a.e.switchContext(null, null);
            }
            catch (IllegalAccessException a3) {
                d.error("Failed to close SDK", (Throwable)a3);
            }
            catch (BookException a4) {
                d.error("Failed to close SDK", (Throwable)a4);
            }
            a.getBookletContext().setFooter(null);
            a2.dump();
        }
    }

    public void saveState() {
        PeriodicalBooklet a;
        a.l.getContentSpecificUI().saveState();
    }

    public void saveOnUSBMode() {
        ErrorHandler.setDoStopSkipState((boolean)true);
        try {
            PeriodicalBooklet a;
            a.I.save(FrameworkUtil.getPreferenceDirectory() + g, false);
        }
        catch (IOException a) {
            d.error("can not save reader state", (Throwable)a);
        }
    }

    public void comeBackFromUSB() {
        ErrorHandler.setDoStopSkipState((boolean)false);
    }

    public PeriodicalsUI getPeriodicalsUI() {
        PeriodicalBooklet a;
        return a.l;
    }

    protected Position getPositionToOpen(Book a, Map a2) {
        if (a == null) {
            return null;
        }
        Position a3 = null;
        String a4 = (String)a2.get(j);
        if (a4 != null) {
            try {
                PeriodicalBooklet a5;
                a3 = a5.e.getPositionFactory(a).createInstance(a4, a);
            }
            catch (Exception a6) {
                d.error("Invalid location: default to LPR", (Throwable)a6);
            }
        }
        if (a3 == null) {
            try {
                LastPageRead a7 = a.getLPR();
                if (a7 != null) {
                    a3 = a7.getLPRPosition();
                }
            }
            catch (InvalidSideCarFileException a8) {
                d.error("Invalid location", (Throwable)a8);
            }
        }
        return a3;
    }

    protected boolean isBookOpen(URI a) {
        PeriodicalBooklet a2;
        Book a3 = a2.e.getCurrentBook();
        if (a3 == null) {
            return false;
        }
        String a4 = a3.getPath();
        String a5 = a.getPath();
        return a4 != null && a5 != null && a4.equals(a5);
    }

    private boolean openWithPlugin(URI a, Map a2) throws BookException {
        PeriodicalBooklet a3;
        String a4 = (String)a2.get("plugin");
        if (a4 == null) {
            return false;
        }
        ReaderPlugin a5 = ((ReaderSDKImpl)a3.e).getReaderPluginByName(a4);
        if (a5 != null) {
            a3.l.setUpSDKState();
            return a5.openURI(a, a2);
        }
        return false;
    }

    private void openWithReader(Book a, Position a2) {
        PeriodicalBooklet a3;
        PeriodicalViewState a4;
        State a5 = null;
        try {
            a5 = a.getFreqUpdateBookState();
        }
        catch (InvalidSideCarFileException a6) {
            d.error("Invalid side car exception when getting the state", (Throwable)a6);
        }
        Position a7 = null;
        String a8 = null;
        if (a5 != null && (a4 = (PeriodicalViewState)a5.get("periodicals.view.state")) != null) {
            String a9 = a4.getPositionString();
            if (a9 != null) {
                try {
                    a7 = a3.e.getPositionFactory(a).createInstance(a9, a);
                }
                catch (Exception a10) {
                    d.error("Could not create a position object from the stored position", (Throwable)a10);
                }
            }
            a8 = a4.getViewName();
        }
        a3.l.showViewFromState(a, a8, a7, a2);
    }

    private boolean openWithReaderHistoryManager(URI a, Map a2) throws BookException {
        if (a2.get("readerHandlerId") != null) {
            PeriodicalBooklet a3;
            return a3.e.getReaderHistoryManager().start(a, a2);
        }
        return false;
    }

    public void registerHandler(EventHandler a) {
        PeriodicalBooklet a2;
        if (a2.e != null && a2.k != null && !a2.k.contains(a)) {
            a2.e.getRegistry().registerHandler(a);
            a2.k.add(a);
        }
    }

    public void deregisterHandlers() {
        PeriodicalBooklet a;
        if (a.e != null && a.k != null) {
            int a2;
            int n = a2 = 0;
            while (n < a.k.size()) {
                a.e.getRegistry().deregisterHandler((EventHandler)a.k.get(a2));
                n = ++a2;
            }
            a.k.clear();
        }
    }

    public void manageHistoryHandler(PeriodicalsHistoryHandler a) {
        PeriodicalBooklet a2;
        if (a2.m.contains((Object)a)) {
            return;
        }
        a2.m.add(a);
    }

    public void resetHistoryHandlers() {
        PeriodicalBooklet a;
        if (a.e != null && a.m != null) {
            int a2;
            int n = a2 = 0;
            while (n < a.m.size()) {
                ((PeriodicalsHistoryHandler)((Object)a.m.get(a2))).reset();
                n = ++a2;
            }
        }
    }

    public void preLayoutViews(ScreenUpdateListener a) {
        PeriodicalBooklet a2;
        EventQueue.invokeLater(new Runnable(){
            {
                1 a;
            }

            public void run() {
                1 a;
                d.info("Starting Prelayout");
                a.PeriodicalBooklet.this.l.preLayoutViews();
            }
        });
        a.setNotificationEnabled(false);
    }

    private static class ScreenUpdateListener
    implements WindowSurfaceListener {
        private PeriodicalBooklet controller;
        private boolean notificationEnabled;

        private ScreenUpdateListener() {
            ScreenUpdateListener a;
        }

        public void windowSurfaceBlitStarted() {
        }

        public void windowSurfaceBlitRegion(int a, int a2, int a3, int a4) {
        }

        public void windowSurfaceBlitEnded() {
            ScreenUpdateListener a;
            d.info("Completed updating the screen");
            new Profiler("windowSurfaceBlitEnded", d).dump();
            if (a.controller != null && a.notificationEnabled) {
                a.controller.preLayoutViews(a);
            }
        }

        public void setController(PeriodicalBooklet a) {
            a.controller = a;
        }

        public void setNotificationEnabled(boolean a) {
            a.notificationEnabled = a;
        }
    }
}

