/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.kindle.home.view.searchresults;

import com.amazon.agui.swing.ContentItemModel;
import com.amazon.agui.swing.IndexedListModel;
import com.amazon.ebook.util.log.Log;
import com.amazon.ebook.util.net.URIUtility;
import com.amazon.kindle.apps.util.MetadataUtils;
import com.amazon.kindle.content.catalog.CatalogEntry;
import com.amazon.kindle.content.catalog.CatalogItem;
import com.amazon.kindle.control.ContentBasedDisplayController;
import com.amazon.kindle.control.DisplayController;
import com.amazon.kindle.control.util.ActionUtils;
import com.amazon.kindle.control.util.DialogUtils;
import com.amazon.kindle.control.util.TransferUtils;
import com.amazon.kindle.home.HomeBooklet;
import com.amazon.kindle.home.action.DownloadAction;
import com.amazon.kindle.home.controller.DefaultHomeDisplayController;
import com.amazon.kindle.home.renderer.DefaultContentRendererFactory;
import com.amazon.kindle.home.view.searchresults.SearchResultsContentItemModel;
import com.amazon.kindle.home.view.searchresults.SearchResultsDisplayController;
import com.amazon.kindle.home.view.searchresults.SearchResultsUtils;
import com.amazon.kindle.home.view.unindexed.UnindexedDisplayController;
import java.awt.event.ActionEvent;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;

public class SearchResultsRendererFactory
extends DefaultContentRendererFactory {
    private static final Log B = Log.getInstance((String)"SearchResultsRendererFactory");
    private static final long D = 0L;

    public SearchResultsRendererFactory(DefaultHomeDisplayController a) {
        super(a);
        SearchResultsRendererFactory a2;
    }

    protected ContentItemModel getContentItemModel(int a) {
        SearchResultsRendererFactory a2;
        return new SearchResultsContentItemModel((ContentBasedDisplayController)a2.B, a);
    }

    protected boolean showDownloadStatus(CatalogItem a) {
        SearchResultsRendererFactory a2;
        return a.isArchived() && ((HomeBooklet)a2.B.getBooklet()).isActiveDownloading(TransferUtils.getItemUniqueKey((CatalogItem)a));
    }

    protected int getListViewModeStyle(IndexedListModel a, int a2) {
        SearchResultsRendererFactory a3;
        Object a4 = null;
        try {
            a4 = a.getElementAt(a.getCursor() + a2);
        }
        catch (IndexOutOfBoundsException a5) {
            // empty catch block
        }
        if (a4 == null || !(a4 instanceof CatalogItem)) {
            B.error("invalid entry");
            return 4;
        }
        CatalogItem a6 = (CatalogItem)a4;
        if (a3.suppressProgressBar((CatalogEntry)a6)) {
            return 9;
        }
        if (MetadataUtils.isUnindexedItems((CatalogEntry)a6)) {
            return 11;
        }
        return 4;
    }

    protected AbstractAction getTapAction(IndexedListModel a, int a2) {
        SearchResultsRendererFactory a3;
        return a3.new GotoExcerptsAction((SearchResultsDisplayController)a3.B, a, a2);
    }

    private class GotoExcerptsAction
    extends AbstractAction {
        private SearchResultsDisplayController mController;
        private IndexedListModel mModel;
        private int mOffset;

        public GotoExcerptsAction(SearchResultsDisplayController a, IndexedListModel a2, int a3) {
            GotoExcerptsAction a4;
            a4.mController = a;
            a4.mModel = a2;
            a4.mOffset = a3;
        }

        public void actionPerformed(ActionEvent a) {
            GotoExcerptsAction a2;
            Object a3 = null;
            try {
                a3 = a2.mModel.getElementAt(a2.mModel.getCursor() + a2.mOffset);
            }
            catch (IndexOutOfBoundsException a4) {
                return;
            }
            if (a3 instanceof CatalogItem) {
                CatalogItem a5 = (CatalogItem)a3;
                if (MetadataUtils.isUnindexedItems((CatalogEntry)a5)) {
                    UnindexedDisplayController.getInstance(a2.mController.getBooklet()).switchTo();
                } else if (a5.isArchived()) {
                    if (a2.SearchResultsRendererFactory.this.showDownloadStatus(a5)) {
                        DialogUtils.showDeferralDialog((DisplayController)a2.mController, (CatalogItem)a5);
                    } else {
                        DownloadAction.downloadItem((HomeBooklet)a2.mController.getBooklet(), a5, a2.mOffset);
                    }
                } else if (SearchResultsUtils.getNumNonMetaHits((CatalogEntry)a5) == 0L) {
                    ActionUtils.openBook((CatalogEntry)a5);
                } else {
                    String a6 = ResourceBundle.getBundle("com.amazon.kindle.home.resources.SearchResultsResources").getString("reader.searchexcerpts.uri.template.dnt");
                    String a7 = URIUtility.getEscapedString((String)a2.mController.getSearchTerm());
                    if (a5.getLocation() != null) {
                        try {
                            String a8 = MessageFormat.format(a6, URIUtility.getFileURI((String)a5.getLocation()).toString(), a7);
                            ActionUtils.sendLipcCommand((String)a8);
                        }
                        catch (URISyntaxException a9) {
                            B.error("invalid uri", (Throwable)a9);
                        }
                    }
                }
            }
        }
    }
}

