/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.kindle.home.view.importcollections;

import com.amazon.agui.swing.Description;
import com.amazon.agui.swing.HeaderBar;
import com.amazon.agui.swing.IndexedModelScrollPane;
import com.amazon.agui.swing.InteractiveList;
import com.amazon.ebook.util.log.Log;
import com.amazon.kindle.apps.util.ComponentUtils;
import com.amazon.kindle.control.widget.InteractiveListWrapper;
import com.amazon.kindle.home.view.importcollections.ImportCollectionsModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.Border;

public class ImportCollectionsPanel
extends InteractiveListWrapper {
    private static final Log LOG = Log.getInstance((String)"ImportCollectionsPanel");
    private String mDescription;
    private JPanel mNoDevicesLabel;
    private boolean mShowScrollPane = false;

    public ImportCollectionsPanel(InteractiveList a) {
        ImportCollectionsPanel a2;
        a2.interactiveList = a;
    }

    public void updateGUI() {
        ImportCollectionsPanel a;
        ImportCollectionsModel a2 = (ImportCollectionsModel)a.interactiveList.getModel();
        if (a2 == null || a2.getSize() == 0) {
            if (a.mShowScrollPane) {
                a.remove((Component)a.scrollPane);
                a.add(a.getNoDevicesLabel(), "Center");
                a.mShowScrollPane = false;
                a.repaint();
            }
        } else if (!a.mShowScrollPane) {
            a.remove(a.getNoDevicesLabel());
            a.add((Component)a.scrollPane, "Center");
            a.mShowScrollPane = true;
            a.repaint();
        }
    }

    public void setDescription(String a) {
        a.mDescription = a;
    }

    public void initGUI() {
        try {
            ImportCollectionsPanel a;
            BorderLayout a2 = new BorderLayout();
            a.setLayout(a2);
            if (a.mDescription == null) {
                super.initGUI();
            } else {
                a.mHeader = new HeaderBar();
                JPanel a3 = new JPanel(new BorderLayout());
                a3.add((Component)a.mHeader, "North");
                Description a4 = new Description(a.mDescription);
                ResourceBundle a5 = ResourceBundle.getBundle("com.amazon.kindle.home.resources.ImportCollectionsResources");
                a4.setMaxRows(((Integer)a5.getObject("description.max.rows")).intValue());
                a4.setBorder((Border)a5.getObject("description.border"));
                a4.setFont((Font)a5.getObject("description.font"));
                a3.add((Component)a4, "South");
                a.add(a3, "North");
                a.scrollPane = new IndexedModelScrollPane();
                a.scrollPane.setChild((JComponent)a.interactiveList);
                a.add((Component)a.scrollPane, "Center");
            }
        }
        catch (Exception a) {
            LOG.error(Log.CATCHALL_EX, null, "error adding pane", (Throwable)a);
        }
    }

    private JComponent getNoDevicesLabel() {
        ImportCollectionsPanel a;
        if (a.mNoDevicesLabel == null) {
            ResourceBundle a2 = ResourceBundle.getBundle("com.amazon.kindle.home.resources.ImportCollectionsResources");
            JTextArea a3 = ComponentUtils.getDefaultTextArea((String)a2.getString("no.devices.label"), (Font)((Font)a2.getObject("no.devices.font")), null, (Border)((Border)a2.getObject("no.devices.border")));
            a.mNoDevicesLabel = new JPanel();
            a.mNoDevicesLabel.setLayout(new BorderLayout());
            a.mNoDevicesLabel.add((Component)a3, "Center");
        }
        return a.mNoDevicesLabel;
    }
}

