/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.kindle.home.view.browse;

import com.amazon.agui.swing.event.GestureDispatcher;
import com.amazon.ebook.util.log.Log;
import com.amazon.ebook.util.log.LogMessage;
import com.amazon.ebook.util.log.LogSystem;
import com.amazon.ebook.util.text.StringUtil;
import com.amazon.kindle.ad.AdUnit;
import com.amazon.kindle.ad.odot.AdOdotMessage;
import com.amazon.kindle.booklet.BookletException;
import com.amazon.kindle.booklet.BookletServices;
import com.amazon.kindle.restricted.context.ContextImpl;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseListener;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.JComponent;

public class ImageBanner
extends JComponent {
    private static final Log LOG = LogSystem.getLog((String)"ImageBanner");
    private static final LogMessage NULL_AD_ERROR = new LogMessage("NULL_AD_ERROR");
    private static final LogMessage VIEW_AD_ERROR = new LogMessage("VIEW_AD_ERROR");
    private static final int IMAGE_RENDER_WAIT_TIME_MS = 5000;
    private static final String AD_VIEWER_LAUNCH_URI_SCHEME = "app";
    private static final String AD_VIEWER_LAUNCH_URI_AUTHORITY = "com.lab126.adviewer";
    private static final String AD_VIEWER_LAUNCH_URI_PATH = "/";
    private static final String RESOURCES = "com.amazon.kindle.home.resources.BrowseResources";
    private int bannerHeight;
    private int bannerWidth;
    private Insets margins;
    private AdUnit mCurrentAdUnit;
    private boolean adIsImpressed = false;
    static /* synthetic */ Class class$com$amazon$kindle$booklet$BookletServices;

    public ImageBanner() {
        ImageBanner a;
        ResourceBundle a2 = ResourceBundle.getBundle(RESOURCES);
        a.bannerHeight = (Integer)a2.getObject("banner.height");
        a.bannerWidth = (Integer)a2.getObject("banner.width");
        a.margins = (Insets)a2.getObject("banner.margins");
        a.setOpaque(true);
        ActionMap a3 = new ActionMap();
        a3.put("tap", a.new ViewAdDetailsAction());
        a.setActionMap(a3);
        a.addMouseListener((MouseListener)new GestureDispatcher());
    }

    public Dimension getPreferredSize() {
        ImageBanner a;
        Dimension a2 = new Dimension();
        Insets a3 = a.getInsets();
        if (a3 != null) {
            a2.width += a3.left + a3.right;
            a2.height += a3.top + a3.bottom;
        }
        a2.width += a.margins.left + a.margins.right;
        a2.height += a.margins.top + a.margins.bottom;
        int a4 = Toolkit.getDefaultToolkit().getScreenSize().width;
        a2.height += a.bannerHeight;
        a2.width += a.bannerWidth;
        if (a2.width > a4) {
            a2.width = a4;
        }
        return a2;
    }

    public void setAd(AdUnit a) {
        ImageBanner a2;
        if (a == null) {
            LOG.error(NULL_AD_ERROR);
            return;
        }
        AdUnit a3 = a2.mCurrentAdUnit;
        a2.mCurrentAdUnit = a;
        if (a2.adIsImpressed && a3 != null && !a2.mCurrentAdUnit.getAdID().equals(a3.getAdID())) {
            AdOdotMessage.creativeImpressionEndSuccess((AdUnit)a3, (int)2, (int)1);
            a2.adIsImpressed = false;
        }
    }

    protected void paintComponent(Graphics a) {
        Object a2;
        ImageBanner a3;
        BoundedImage a4 = new BoundedImage();
        a3.calculateRectangles(a, a3, a4);
        if (a3.isOpaque()) {
            a2 = a3.getSize();
            a.setColor(a3.getBackground());
            a.fillRect(0, 0, ((Dimension)a2).width, ((Dimension)a2).height);
        }
        if (StringUtil.isEmpty((String)a3.mCurrentAdUnit.getBannerImage().getFilePath())) {
            LOG.error(VIEW_AD_ERROR, "Empty banner image FilePath");
            return;
        }
        a2 = a3.getImage(a3.mCurrentAdUnit.getBannerImage().getFilePath());
        if (Log.isDebugOn()) {
            LOG.debug("Drawing image: " + a3.mCurrentAdUnit.getBannerImage().getFilePath() + " " + a4.x + " " + a4.y + " " + a4.height + " " + a4.width);
        }
        a3.mCurrentAdUnit.incrementViewCapCount();
        a3.drawImageSync((Image)a2, a, a4.x, a4.y, a4.width, a4.height);
        if (!a3.adIsImpressed && a3.mCurrentAdUnit != null) {
            AdOdotMessage.creativeImpressionStartSuccess((AdUnit)a3.mCurrentAdUnit, (int)2, (int)1);
            a3.adIsImpressed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean drawImageSync(Image a, Graphics a2, int a3, int a4, int a5, int a6) {
        ImageBanner a7;
        Component a8 = new Component(){
            {
                1 a;
            }
        };
        MediaTracker a9 = new MediaTracker(a8);
        a9.addImage(a, 0);
        try {
            a9.waitForID(0, 5000L);
            int a10 = a9.statusAll(false);
            if ((a10 & 4) != 0) {
                boolean bl = false;
                return bl;
            }
            a2.drawImage(a, a3, a4, a5, a6, null);
        }
        catch (InterruptedException a11) {
            LOG.error(Log.CATCHALL_EX, null, "", (Throwable)a11);
        }
        finally {
            a9.removeImage(a, 0);
        }
        return true;
    }

    private Image getImage(String a) {
        if (a != null) {
            return Toolkit.getDefaultToolkit().createImage(a);
        }
        return null;
    }

    private void calculateRectangles(Graphics a, JComponent a2, BoundedImage a3) {
        ImageBanner a4;
        ImageBanner a5 = (ImageBanner)a2;
        if (null == a3) {
            return;
        }
        a3.height = a5.bannerHeight;
        a3.width = a5.bannerWidth;
        Insets a6 = a2.getInsets();
        if (a6 != null) {
            a3.x += a6.left;
            a3.y += a6.top;
            a3.height -= a6.top + a6.bottom;
            a3.width -= a6.left + a6.right;
        }
        a3.y += a4.margins.top;
    }

    public void endAdImpression() {
        ImageBanner a;
        if (a.adIsImpressed) {
            AdOdotMessage.creativeImpressionEndSuccess((AdUnit)a.mCurrentAdUnit, (int)2, (int)1);
            a.adIsImpressed = false;
        }
    }

    private class ViewAdDetailsAction
    extends AbstractAction {
        private ViewAdDetailsAction() {
            ViewAdDetailsAction a;
        }

        public void actionPerformed(ActionEvent a) {
            ViewAdDetailsAction a2;
            if (a2.ImageBanner.this.mCurrentAdUnit == null || StringUtil.isEmpty((String)a2.ImageBanner.this.mCurrentAdUnit.getDetailHTML().getFilePath()) || StringUtil.isEmpty((String)a2.ImageBanner.this.mCurrentAdUnit.getAdID())) {
                LOG.error(VIEW_AD_ERROR, "Null Ad init, empty HTML FilePath, or empty AdID");
                return;
            }
            BookletServices a3 = (BookletServices)new ContextImpl().getService(class$com$amazon$kindle$booklet$BookletServices == null ? (class$com$amazon$kindle$booklet$BookletServices = ImageBanner.class$("com.amazon.kindle.booklet.BookletServices")) : class$com$amazon$kindle$booklet$BookletServices);
            StringBuffer a4 = new StringBuffer().append("adId=").append(a2.ImageBanner.this.mCurrentAdUnit.getAdID());
            try {
                URI a5 = new URI(ImageBanner.AD_VIEWER_LAUNCH_URI_SCHEME, ImageBanner.AD_VIEWER_LAUNCH_URI_AUTHORITY, ImageBanner.AD_VIEWER_LAUNCH_URI_PATH, a4.toString(), null);
                try {
                    AdOdotMessage.userClicksCreative((AdUnit)a2.ImageBanner.this.mCurrentAdUnit, (int)2, (int)1, (long)0L);
                    a3.switchToBooklet(null, a5, null);
                }
                catch (BookletException a6) {
                    LOG.error(VIEW_AD_ERROR, null, "Failed to switch booklet", (Throwable)a6);
                }
            }
            catch (URISyntaxException a7) {
                LOG.error(VIEW_AD_ERROR, null, "Failed to parse ad URI", (Throwable)a7);
            }
        }
    }

    protected static class BoundedImage
    extends Rectangle {
        public Image bannerImage;

        protected BoundedImage() {
            BoundedImage a;
        }
    }
}

