/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.kindle.home.controller;

import com.amazon.agui.swing.InteractiveList;
import com.amazon.ebook.util.log.Log;
import com.amazon.ebook.util.log.LogMessage;
import com.amazon.kindle.ad.AdAsset;
import com.amazon.kindle.ad.AdUnit;
import com.amazon.kindle.ad.manager.AdManager;
import com.amazon.kindle.control.widget.InteractiveListWrapper;
import com.amazon.kindle.home.controller.AdDisplayController;
import com.amazon.kindle.home.view.browse.ImageBanner;
import java.awt.Graphics;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class AdPanel
extends InteractiveListWrapper {
    private static final Log LOG = Log.getInstance((String)"AdPanel");
    private static final LogMessage MISSING_REQUIRED_REFERENCE = new LogMessage("MisssingRequiredReference", new String[]{"ref"});
    private AdDisplayController mAdDisplayController;
    private AdManager mAdManager;
    private JComponent mFooterImageBanner;
    private AdUnit mCurrentAd;

    public AdPanel(AdDisplayController a, InteractiveList a2, AdManager a3) {
        AdPanel a4;
        if (a == null) {
            LOG.error(MISSING_REQUIRED_REFERENCE, new String[]{"AdDisplayController"}, "AdDisplayController cannot be null");
            return;
        }
        if (a2 == null) {
            LOG.error(MISSING_REQUIRED_REFERENCE, new String[]{"InteractiveList"}, "InteractiveList cannot be null");
            return;
        }
        if (a3 == null) {
            LOG.error(MISSING_REQUIRED_REFERENCE, new String[]{"AdManager"}, "AdManager cannot be null");
            return;
        }
        a4.mAdDisplayController = a;
        a4.mAdManager = a3;
        a4.interactiveList = a2;
        a4.initGUI();
    }

    protected void initGUI() {
        AdPanel a;
        super.initGUI();
        a.updateBannerAndList();
    }

    public void updateGUI() {
        AdPanel a;
        super.updateGUI();
        a.updateBannerAndList();
    }

    private void updateBannerAndList() {
        AdPanel a;
        final boolean a2 = a.isBannerMissing();
        final boolean a3 = a.isBannerExtraneous();
        if (a2 || a3) {
            if (SwingUtilities.isEventDispatchThread()) {
                if (Log.isDebugOn()) {
                    LOG.debug("updating banner on event dispatch thread");
                }
                a.doUpdateBannerAndList(a2, a3);
            } else {
                if (Log.isDebugOn()) {
                    LOG.debug("putting banner update on event queue");
                }
                SwingUtilities.invokeLater(new Runnable(){
                    {
                        1 a;
                    }

                    public void run() {
                        1 a;
                        a.AdPanel.this.doUpdateBannerAndList(a.a2, a.a3);
                    }
                });
            }
        }
    }

    private void doUpdateBannerAndList(boolean a, boolean a2) {
        AdPanel a3;
        if (a) {
            a3.mFooterImageBanner = a3.getImageBanner();
            a3.add(a3.mFooterImageBanner, "South");
        } else if (a2) {
            a3.remove(a3.mFooterImageBanner);
            a3.mFooterImageBanner = null;
        }
        if (a || a2) {
            if (Log.isDebugOn()) {
                LOG.debug("banner has been added or removed");
            }
            if (a3.interactiveList != null) {
                int a4 = a3.mAdDisplayController.getColumnOrRowCount(0);
                int a5 = a3.mAdDisplayController.getColumnOrRowCount(1);
                if (a4 != a3.interactiveList.getVisibleColumnCount()) {
                    a3.interactiveList.setVisibleColumnCount(a4);
                }
                if (a5 != a3.interactiveList.getVisibleRowCount()) {
                    a3.interactiveList.setVisibleRowCount(a5);
                }
            }
            a3.revalidate();
            a3.repaint();
        }
    }

    private synchronized JComponent getImageBanner() {
        return new ImageBanner();
    }

    protected void paintChildren(Graphics a) {
        AdPanel a2;
        if (a2.mFooterImageBanner != null) {
            AdAsset a3;
            if (a2.mCurrentAd == null || a2.mCurrentAd.isExpired(a2.mAdManager.getTimeToUse())) {
                if (Log.isDebugOn()) {
                    LOG.debug("current ad is null or has expired");
                }
                a2.refreshAd();
            }
            if ((a3 = a2.mCurrentAd.getBannerImage()) != null && !new File(a3.getFilePath()).exists()) {
                if (Log.isDebugOn()) {
                    LOG.debug("ad banner image does not exist -- refreshing ad");
                }
                a2.refreshAd();
            }
            ((ImageBanner)a2.mFooterImageBanner).setAd(a2.mCurrentAd);
        }
        super.paintChildren(a);
    }

    public void endAdImpression() {
        AdPanel a;
        if (a.mFooterImageBanner != null) {
            ((ImageBanner)a.mFooterImageBanner).endAdImpression();
        }
    }

    private boolean isBannerMissing() {
        AdPanel a;
        return a.mAdManager.isAdUnitDevice() && a.mFooterImageBanner == null;
    }

    private boolean isBannerExtraneous() {
        AdPanel a;
        return !a.mAdManager.isAdUnitDevice() && a.mFooterImageBanner != null;
    }

    public synchronized void refreshAd() {
        AdPanel a;
        a.mCurrentAd = a.mAdManager.getStrategy(1).getCurrentAd();
        if (a.mCurrentAd.isExpired(a.mAdManager.getTimeToUse())) {
            if (Log.isDebugOn()) {
                LOG.debug("current ad has expired, retrieving next ad");
            }
            a.mCurrentAd = a.mAdManager.getStrategy(1).getNextAd(false);
        }
    }
}

