/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.kindle.home.behavior;

import com.amazon.agui.swing.ConfirmationDialog;
import com.amazon.agui.swing.ContentItemModel;
import com.amazon.agui.swing.ContentItemView;
import com.amazon.agui.swing.IndexedListModel;
import com.amazon.agui.swing.InteractiveList;
import com.amazon.agui.swing.PendingStateModel;
import com.amazon.agui.swing.StateModel;
import com.amazon.ebook.util.text.StringUtil;
import com.amazon.kindle.apps.util.ComponentUtils;
import com.amazon.kindle.apps.util.LogUtils;
import com.amazon.kindle.booklet.BookletContext;
import com.amazon.kindle.content.AbstractCatalogContentItemModel;
import com.amazon.kindle.content.catalog.CatalogEntry;
import com.amazon.kindle.content.catalog.CatalogItem;
import com.amazon.kindle.control.ContentBasedDisplayController;
import com.amazon.kindle.control.DCBooklet;
import com.amazon.kindle.control.DisplayController;
import com.amazon.kindle.control.action.URIActions;
import com.amazon.kindle.control.behavior.TransferClientData;
import com.amazon.kindle.control.behavior.TransferStatusImpl;
import com.amazon.kindle.control.behavior.ViewBehavior;
import com.amazon.kindle.control.behavior.event.BehaviorEvent;
import com.amazon.kindle.control.behavior.event.DataChangedEvent;
import com.amazon.kindle.control.behavior.event.PageTurnEvent;
import com.amazon.kindle.control.behavior.event.PostLoadViewEvent;
import com.amazon.kindle.control.behavior.event.TransferEvent;
import com.amazon.kindle.control.content.ContentManager;
import com.amazon.kindle.control.util.ActionUtils;
import com.amazon.kindle.control.util.TransferUtils;
import com.amazon.kindle.control.widget.InteractiveListWrapper;
import com.amazon.kindle.home.behavior.ErrorMessageData;
import com.amazon.kindle.home.view.browse.BrowseContentManager;
import com.amazon.kindle.home.view.browse.BrowseDisplayController;
import com.amazon.kindle.home.view.browse.BrowseListModel;
import com.amazon.kindle.restricted.net.transfer.Transfer;
import com.amazon.kindle.restricted.net.transfer.TransferService;
import com.amazon.kindle.restricted.net.transfer.TransferStatus;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class DisplayDownloadProgress
extends ViewBehavior {
    private static final String H = "AMAZON_PERMISSIONS_ERROR";
    protected Map b = new HashMap();
    private Set K = new HashSet();
    protected BehaviorEvent[] B;

    public DisplayDownloadProgress(ContentBasedDisplayController a) {
        super((DisplayController)a);
        DisplayDownloadProgress a2;
    }

    public synchronized BehaviorEvent[] getSubscribedEvents() {
        DisplayDownloadProgress a;
        if (a.B == null) {
            a.B = new BehaviorEvent[]{PostLoadViewEvent.getInstance(), PageTurnEvent.getInstance(), DataChangedEvent.getInstance(), TransferEvent.getInstance()};
        }
        return a.B;
    }

    public void onUnload() {
        DisplayDownloadProgress a;
        super.onUnload();
        a.b.clear();
        a.K.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(BehaviorEvent a, Object a2) {
        DisplayDownloadProgress a3;
        if (a instanceof TransferEvent && a2 instanceof TransferStatus) {
            TransferStatus a4 = (TransferStatus)a2;
            int a5 = a4.getStatus();
            if (TransferUtils.isCanceled((int)a5)) {
                IndexedListModel a6;
                ContentManager a7;
                if (a3.getController() instanceof BrowseDisplayController && (a7 = ((BrowseDisplayController)a3.getController()).getContentManager()) != null && (a6 = ((BrowseContentManager)a7).getModel()) != null) {
                    ((BrowseListModel)a6).refresh();
                }
            } else {
                ComponentUtils.waitToEmptyAWTEventQueue();
                Map map = a3.b;
                synchronized (map) {
                    if (a3.b.isEmpty()) {
                        a3.initCache(false);
                    }
                    a3.showProgressOfTransferStatus(a4);
                    if (TransferUtils.isFailed((int)a5)) {
                        a3.showErrorDialogOnCurrentPage(a4);
                    }
                }
            }
        } else {
            if (a instanceof PageTurnEvent || a instanceof DataChangedEvent) {
                ComponentUtils.waitToEmptyAWTEventQueue();
                Map map = a3.b;
                synchronized (map) {
                    a3.initCache(true);
                }
            }
            if (a instanceof PostLoadViewEvent) {
                ComponentUtils.waitToEmptyAWTEventQueue();
                Map map = a3.b;
                synchronized (map) {
                    if (a3.b.isEmpty()) {
                        a3.initCache(false);
                    }
                }
            }
        }
    }

    protected void initCache(boolean a) {
        JPanel a2;
        DisplayDownloadProgress a3;
        if (a) {
            a3.b.clear();
        }
        if ((a2 = a3.getController().getPanel()) instanceof InteractiveListWrapper) {
            DisplayController a4 = a3.getController();
            if (a4 == null) {
                LogUtils.logControllerIsNull();
                return;
            }
            DCBooklet a5 = a4.getBooklet();
            if (a5 == null) {
                LogUtils.logBookletIsNull();
                return;
            }
            BookletContext a6 = a5.getBookletContext();
            if (a6 == null) {
                LogUtils.logBookletContextIsNull();
                return;
            }
            Map a7 = ((TransferService)a6.getService(TransferService.class)).getPendingTransfers();
            if (a7 != null && a7.size() > 0) {
                InteractiveList a8 = ((InteractiveListWrapper)a2).getInteractiveList();
                a3.loadAllVisiblePendingItems(a8);
                a3.showProgressOfVisibleTransfers(a7);
            }
        }
    }

    private void loadAllVisiblePendingItems(InteractiveList a) {
        int a2;
        if (a == null) {
            return;
        }
        int a3 = a.getCurrentPageItemCount();
        int n = a2 = 0;
        while (n < a3) {
            StateModel a4;
            String a5;
            CatalogEntry a6;
            ContentItemModel a7;
            JComponent a8 = a.getRenderer(a2);
            if (a8 instanceof ContentItemView && (a7 = ((ContentItemView)a8).getDataModel()) instanceof AbstractCatalogContentItemModel && (a6 = ((AbstractCatalogContentItemModel)a7).getCatalogEntry()) instanceof CatalogItem && StringUtil.isNotEmpty((String)(a5 = TransferUtils.getItemUniqueKey((CatalogItem)((CatalogItem)a6)))) && (a4 = a7.getStateModel()) instanceof PendingStateModel) {
                DisplayDownloadProgress a9;
                a9.b.put(a5, a4);
            }
            n = ++a2;
        }
    }

    private void showProgressOfVisibleTransfers(Map a) {
        DisplayDownloadProgress a2;
        Transfer a3;
        Object a4;
        Object a5;
        HashSet<String> a6 = new HashSet<String>();
        Iterator<Object> a7 = a.values().iterator();
        while (a7.hasNext()) {
            a5 = a7.next();
            if (!(a5 instanceof Transfer) || (a4 = TransferClientData.getInstance((String)(a3 = (Transfer)a5).getClientData())) == null) continue;
            a6.add(a4.getUniqueKey());
            a2.showProgressOfTransferStatus((TransferStatus)new TransferStatusImpl(a3));
        }
        if (!a2.b.isEmpty() && a2.b.size() > a6.size()) {
            a7 = a2.b.keySet().iterator();
            while (a7.hasNext()) {
                a5 = a7.next();
                if (a5 == null || !a2.b.containsKey(a5) || a6.contains(a5)) continue;
                a3 = (PendingStateModel)a2.b.get(a5);
                a4 = ResourceBundle.getBundle("com.amazon.kindle.control.resources.UtilResources");
                a3.setProperties(((ResourceBundle)a4).getString("download.status.complete"), 0, false);
            }
        }
    }

    protected void showProgressOfTransferStatus(TransferStatus a) {
        DisplayDownloadProgress a2;
        PendingStateModel a3 = a2.getPendingStateModel(a);
        if (a3 != null) {
            TransferUtils.populatePendingStateModel((PendingStateModel)a3, (TransferStatus)a);
        }
    }

    private PendingStateModel getPendingStateModel(TransferStatus a) {
        Object a2;
        DisplayDownloadProgress a3;
        if (a == null) {
            return null;
        }
        TransferClientData a4 = TransferClientData.getInstance((String)a.getClientData());
        if (a4 == null) {
            return null;
        }
        String a5 = a4.getUniqueKey();
        if (a3.b.containsKey(a5) && (a2 = a3.b.get(a5)) instanceof PendingStateModel) {
            return (PendingStateModel)a2;
        }
        return null;
    }

    protected void showErrorDialogOnCurrentPage(TransferStatus a) {
        DisplayDownloadProgress a2;
        final TransferClientData a3 = TransferClientData.getInstance((String)a.getClientData());
        if (a3 != null && TransferUtils.isFailed((int)a.getStatus()) && a2.b.containsKey(a3.getUniqueKey()) && !a2.K.contains(a3.getUniqueKey())) {
            String a4 = a.getErrorResponseBody();
            if (StringUtil.isEmpty((String)a4)) {
                return;
            }
            final ErrorMessageData a5 = ErrorMessageData.getInstance(a4);
            int a6 = a.getResponseCode();
            if (a5 == null) {
                return;
            }
            if (a6 == 403) {
                a2.K.add(a3.getUniqueKey());
                SwingUtilities.invokeLater(new Runnable(){
                    {
                        1 a;
                    }

                    public void run() {
                        1 a;
                        a.DisplayDownloadProgress.this.doAction(a.a5, a.a3);
                    }
                });
            }
        }
    }

    protected void doAction(ErrorMessageData a, TransferClientData a2) {
        DisplayDownloadProgress a3;
        if (a == null || a2 == null) {
            return;
        }
        DisplayController a4 = a3.getController();
        if (a4 == null) {
            LogUtils.logControllerIsNull();
            return;
        }
        DCBooklet a5 = a4.getBooklet();
        if (a5 == null) {
            LogUtils.logBookletIsNull();
            return;
        }
        if (H.equals(a.getCode()) && StringUtil.isNotEmpty((String)a.getLinkTitle()) && StringUtil.isNotEmpty((String)a.getLinkURL())) {
            a3.showLicenseExceedDialog(a, a2);
        } else {
            ResourceBundle a6 = ResourceBundle.getBundle("com.amazon.kindle.home.resources.BehaviorResources");
            int a7 = (Integer)a6.getObject("close.index");
            String a8 = MessageFormat.format(a6.getString("error.message.template"), a2.getTitle(), a.getMessage());
            ConfirmationDialog.showDialog((String)a5.getName(), (String)a8, (String)a.getTitle(), (String[])a6.getStringArray("fail.default.labels"), (int[])new int[]{a7});
        }
        a3.K.remove(a2.getUniqueKey());
    }

    protected void showLicenseExceedDialog(ErrorMessageData a, TransferClientData a2) {
        DisplayDownloadProgress a3;
        if (a == null || a2 == null) {
            return;
        }
        DisplayController a4 = a3.getController();
        if (a4 == null) {
            LogUtils.logControllerIsNull();
            return;
        }
        DCBooklet a5 = a4.getBooklet();
        if (a5 == null) {
            LogUtils.logBookletIsNull();
            return;
        }
        ResourceBundle a6 = ResourceBundle.getBundle("com.amazon.kindle.home.resources.BehaviorResources");
        int a7 = (Integer)a6.getObject("cancel.index");
        int a8 = (Integer)a6.getObject("purchase.index");
        String a9 = MessageFormat.format(a6.getString("error.message.template"), a2.getTitle(), a.getMessage());
        if (ConfirmationDialog.showDialog((String)a5.getName(), (String)a9, (String)a.getTitle(), (String[])a6.getStringArray("fail.licenseexceeds.labels"), (int[])new int[]{a7, a8}) == a8) {
            ActionUtils.sendLipcCommand((String)URIActions.getViewBookDescriptionURI((String)a2.getCdeKey()));
        }
    }
}

