/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.kindle.home.action;

import com.amazon.agui.swing.ContentItemModel;
import com.amazon.agui.swing.IndexedListModel;
import com.amazon.agui.swing.KDialog;
import com.amazon.kindle.apps.util.LogUtils;
import com.amazon.kindle.booklet.Booklet;
import com.amazon.kindle.booklet.BookletContext;
import com.amazon.kindle.content.catalog.CatalogEntry;
import com.amazon.kindle.content.catalog.CatalogEntryCollection;
import com.amazon.kindle.content.catalog.CatalogItem;
import com.amazon.kindle.content.catalog.CatalogService;
import com.amazon.kindle.control.DCBooklet;
import com.amazon.kindle.home.action.CommonActions;
import com.amazon.kindle.home.dialog.CollectionDetailViewFactory;
import com.amazon.kindle.home.dialog.OobeDetailViewFactory;
import com.amazon.kindle.home.view.archive.detail.ArchiveDetailViewFactory;
import com.amazon.kindle.restricted.device.ApplicationRegistry;
import com.amazon.kindle.swing.DetailView;
import com.amazon.kindle.swing.DetailViewDialog;
import java.awt.event.ActionEvent;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JComponent;

public class OpenDetailsAction
extends AbstractAction {
    private DCBooklet mBooklet;
    private IndexedListModel mModel;
    private int mOffset;

    public OpenDetailsAction(DCBooklet a, IndexedListModel a2, int a3) {
        OpenDetailsAction a4;
        a4.mBooklet = a;
        a4.mModel = a2;
        a4.mOffset = a3;
    }

    public void actionPerformed(ActionEvent a) {
        OpenDetailsAction a2;
        Object a3 = null;
        try {
            a3 = a2.mModel.getElementAt(a2.mModel.getCursor() + a2.mOffset);
        }
        catch (IndexOutOfBoundsException a4) {
            return;
        }
        if (a2.mBooklet == null) {
            LogUtils.logBookletIsNull();
            return;
        }
        BookletContext a5 = a2.mBooklet.getBookletContext();
        if (a5 == null) {
            LogUtils.logBookletContextIsNull();
            return;
        }
        if (a3 instanceof CatalogItem) {
            KDialog a6;
            CatalogItem a7 = (CatalogItem)a3;
            String a8 = a7.getEntryType();
            if (a8.equals("Entry:Item:OOBE")) {
                a2.showOOBEDetailedView((CatalogItem)a3);
                return;
            }
            if (a8.equals("Entry:Item:AI") || a8.equals("Entry:Item:PBI") || a8.equals("Entry:Item:NI")) {
                return;
            }
            if (a7.isArchived()) {
                a2.showArchiveDetailView((CatalogItem)a3);
                return;
            }
            Map a9 = CommonActions.getItemDetailActions(a2.mBooklet, a7);
            a9.put("Open", CommonActions.getOpenItemAction(a2.mBooklet, a2.mModel, a2.mOffset));
            a9.put("ShowCollections", CommonActions.getShowCollectionsAction(a2.mBooklet, a7));
            ApplicationRegistry a10 = (ApplicationRegistry)a5.getService(ApplicationRegistry.class);
            if (a10 != null && (a6 = a10.getDetailViewDialog(a2.mBooklet.getBookletContext(), a7, a9)) != null) {
                a6.postDialog(a2.mBooklet.getBookletContext().getName());
            }
        } else if (a3 instanceof CatalogEntryCollection) {
            CatalogEntryCollection a11 = (CatalogEntryCollection)a3;
            Map a12 = CommonActions.getCollectionDetailActions(a2.mBooklet, a11);
            a12.put("Open", CommonActions.getOpenItemAction(a2.mBooklet, a2.mModel, a2.mOffset));
            CatalogService a13 = (CatalogService)a5.getService(CatalogService.class);
            CollectionDetailViewFactory a14 = new CollectionDetailViewFactory(a13);
            ContentItemModel a15 = a14.getModel((CatalogEntry)a11);
            KDialog a16 = (KDialog)a14.getDetails(a5, a15, a12);
            if (a16 != null) {
                a16.postDialog(a2.mBooklet.getName());
            }
        }
    }

    private void showArchiveDetailView(CatalogItem a) {
        OpenDetailsAction a2;
        if (a2.mBooklet == null) {
            LogUtils.logBookletIsNull();
            return;
        }
        BookletContext a3 = a2.mBooklet.getBookletContext();
        if (a3 == null) {
            LogUtils.logBookletContextIsNull();
            return;
        }
        Map a4 = CommonActions.getArchiveDetailActions(a2.mBooklet, a);
        ArchiveDetailViewFactory a5 = new ArchiveDetailViewFactory();
        ContentItemModel a6 = a5.getModel((CatalogEntry)a);
        JComponent a7 = a5.getDetails(a3, a6, a4);
        Object a8 = null;
        a8 = a7 instanceof KDialog ? (KDialog)a7 : new DetailViewDialog(a2.mBooklet.getName(), (DetailView)a7);
        if (a8 != null) {
            a8.postDialog(a2.mBooklet.getName());
        }
    }

    private void showOOBEDetailedView(CatalogItem a) {
        OpenDetailsAction a2;
        if (a2.mBooklet == null) {
            LogUtils.logBookletIsNull();
            return;
        }
        BookletContext a3 = a2.mBooklet.getBookletContext();
        if (a3 == null) {
            LogUtils.logBookletContextIsNull();
            return;
        }
        OobeDetailViewFactory a4 = new OobeDetailViewFactory((Booklet)a2.mBooklet, (CatalogEntry)a);
        KDialog a5 = (KDialog)a4.getDetails(a3, a4.getModel((CatalogEntry)a), null);
        if (a5 != null) {
            a5.postDialog(a2.mBooklet.getName());
        }
    }
}

