/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.kindle.home.action;

import com.amazon.agui.swing.ConfirmationDialog;
import com.amazon.ebook.booklet.reader.sdk.util.PeriodicalsUtil;
import com.amazon.ebook.util.log.Log;
import com.amazon.ebook.util.log.LogMessage;
import com.amazon.ebook.util.net.URIUtility;
import com.amazon.ebook.util.thread.ThreadPool;
import com.amazon.kindle.apps.util.CommunicationUtils;
import com.amazon.kindle.apps.util.LogUtils;
import com.amazon.kindle.apps.util.MetadataUtils;
import com.amazon.kindle.booklet.Booklet;
import com.amazon.kindle.booklet.BookletContext;
import com.amazon.kindle.booklet.BookletException;
import com.amazon.kindle.booklet.BookletServices;
import com.amazon.kindle.content.catalog.CatalogEntry;
import com.amazon.kindle.content.catalog.CatalogItem;
import com.amazon.kindle.content.catalog.CatalogService;
import com.amazon.kindle.control.DCBooklet;
import com.amazon.kindle.control.action.URIActions;
import com.amazon.kindle.control.util.ActionUtils;
import com.amazon.kindle.home.HomeBooklet;
import com.amazon.kindle.home.action.AddCollectionDialogAction;
import com.amazon.kindle.home.action.DownloadAction;
import com.amazon.kindle.home.view.addtocollections.AddToCollectionsDisplayController;
import com.amazon.kindle.home.view.itemstocollection.ItemsToCollectionDisplayController;
import com.amazon.kindle.restricted.device.ApplicationRegistry;
import java.awt.event.ActionEvent;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;

public class DetailsActions {
    private static final Log F = Log.getInstance((String)"DetailsActions");
    private static final String L = "application";
    private static final String c = "app";
    private static final String l = "action=resume";
    private static final String k = "action=startplay";
    private static final int m = -1;
    private static final String h = "MT:";
    private static final LogMessage A = new LogMessage("InvalidURI");
    private static final LogMessage H = new LogMessage("CantSwitchBooklet", new String[]{"URI"});
    private static final LogMessage b = new LogMessage("UnknownResultCode", new String[]{"result"});
    static /* synthetic */ Class K;
    static /* synthetic */ Class B;
    static /* synthetic */ Class D;

    public DetailsActions() {
        DetailsActions a;
    }

    public static Action getAddToCollectionsAction(DCBooklet a, CatalogEntry a2) {
        AddToCollectionsAction a3 = new AddToCollectionsAction(a, a2);
        if (CommunicationUtils.isRegistered((Booklet)a)) {
            a3.setEnabled(true);
        } else {
            a3.setEnabled(false);
        }
        return a3;
    }

    public static Action getSearchAction(CatalogItem a) {
        return new SearchThisBookAction(a);
    }

    public static Action getGotoDialogAction(CatalogItem a) {
        return new GotoDialogAction(a);
    }

    public static Action getNotesAndMarksAction(CatalogItem a) {
        return new NotesAndMarksAction(a);
    }

    public static Action getViewBookDescription(DCBooklet a, CatalogItem a2) {
        return new ViewBookDescriptionAction(a, a2);
    }

    public static Action getShareThisBookAction(CatalogItem a) {
        return new ShareThisBookAction(a);
    }

    public static Action getBuyThisBookAction(DCBooklet a, CatalogItem a2) {
        return new BuyThisBookAction(a, a2);
    }

    public static Action getKeepThisIssueAction(DCBooklet a, CatalogItem a2) {
        return new KeepThisIssueAction(a, a2, true);
    }

    public static Action getDontKeepThisIssueAction(DCBooklet a, CatalogItem a2) {
        return new KeepThisIssueAction(a, a2, false);
    }

    public static Action getDeleteItemAction(DCBooklet a, CatalogItem a2) {
        return DetailsActions.getDeleteAction(a, (CatalogEntry)a2);
    }

    public static Action getRemoveItemAction(DCBooklet a, CatalogItem a2) {
        return DetailsActions.getDeleteAction(a, (CatalogEntry)a2);
    }

    public static Action getRemoveCollectionAction(DCBooklet a, CatalogItem a2) {
        return DetailsActions.getDeleteAction(a, (CatalogEntry)a2);
    }

    public static Action getDeleteSampleAction(DCBooklet a, CatalogItem a2) {
        return DetailsActions.getDeleteAction(a, (CatalogEntry)a2);
    }

    public static Action getDeleteIssueAction(DCBooklet a, CatalogItem a2) {
        return DetailsActions.getDeleteAction(a, (CatalogEntry)a2);
    }

    public static Action getDeleteBlogAction(DCBooklet a, CatalogItem a2) {
        return DetailsActions.getDeleteAction(a, (CatalogEntry)a2);
    }

    public static Action getDeleteDocumentAction(DCBooklet a, CatalogItem a2) {
        return DetailsActions.getDeleteAction(a, (CatalogEntry)a2);
    }

    public static Action getDeleteAction(DCBooklet a, CatalogEntry a2) {
        return new DeleteItemAction(a, a2);
    }

    public static Action getRemoveAction(DCBooklet a, CatalogEntry a2) {
        return new RemoveItemAction(a, a2);
    }

    public static Action getResumePlayingAction(DCBooklet a, CatalogEntry a2) {
        return new ResumePlayingAction(a, a2);
    }

    public static Action getPlayFromBeginningAction(DCBooklet a, CatalogEntry a2) {
        return new PlayFromBeginningAction(a, a2);
    }

    public static Action getEditThisCollection(DCBooklet a, CatalogEntry a2) {
        EditThisCollectionAction a3 = new EditThisCollectionAction(a, a2);
        if (CommunicationUtils.isRegistered((Booklet)a)) {
            a3.setEnabled(true);
        } else {
            a3.setEnabled(false);
        }
        return a3;
    }

    public static Action getRenameThisCollection(Booklet a, CatalogEntry a2) {
        String a3 = "";
        if (a2.getTitles() != null && a2.getTitles().length > 0) {
            a3 = a2.getTitles()[0].getDisplay();
        }
        return AddCollectionDialogAction.getDetailsViewAction(a, a3, a2.getUUID());
    }

    public static Action getUpdate(DCBooklet a, CatalogItem a2) {
        return new UpdateAction(a, a2);
    }

    public static Action getAddToHome(DCBooklet a, CatalogItem a2) {
        return new AddToHomeAction(a, a2);
    }

    private static class AddToHomeAction
    extends AbstractAction {
        private DCBooklet booklet;
        private CatalogItem cItem;

        public AddToHomeAction(DCBooklet a, CatalogItem a2) {
            AddToHomeAction a3;
            a3.booklet = a;
            a3.cItem = a2;
        }

        public void actionPerformed(ActionEvent a) {
            AddToHomeAction a2;
            if (a2.cItem != null && a2.booklet != null) {
                DownloadAction.downloadItem((HomeBooklet)a2.booklet, a2.cItem, -1);
            }
        }
    }

    private static class UpdateAction
    extends AbstractAction {
        private DCBooklet booklet;
        private final CatalogItem item;

        public UpdateAction(DCBooklet a, CatalogItem a2) {
            UpdateAction a3;
            a3.booklet = a;
            a3.item = a2;
        }

        /*
         * Enabled aggressive block sorting
         */
        public void actionPerformed(ActionEvent a) {
            UpdateAction a2;
            ResourceBundle a3 = ResourceBundle.getBundle("com.amazon.kindle.home.resources.ActionResources");
            String a4 = a3.getString("update.dialog.title");
            String a5 = a3.getString("update.dialog.message");
            String[] a6 = new String[]{a3.getString("update.cancel.button.label"), a3.getString("update.seedetails.button.label"), a3.getString("update.update.button.label")};
            int a7 = ConfirmationDialog.showDialog((String)a2.booklet.getName(), (String)a5, (String)a4, (String[])a6);
            switch (a7) {
                case -1: 
                case 0: {
                    return;
                }
                case 1: {
                    if (a2.item != null) {
                        ThreadPool.getInstance().runIt(new Runnable(){
                            {
                                1 a;
                            }

                            public void run() {
                                1 a;
                                URI a2 = null;
                                if (a.UpdateAction.this.booklet == null) {
                                    LogUtils.logBookletIsNull();
                                    return;
                                }
                                BookletContext a3 = a.UpdateAction.this.booklet.getBookletContext();
                                if (a3 == null) {
                                    LogUtils.logBookletContextIsNull();
                                    return;
                                }
                                try {
                                    a2 = new URI(URIActions.getViewReleaseNotesURI((String)a.UpdateAction.this.item.getCDEKey()));
                                    if (a2 != null) {
                                        BookletServices a4 = (BookletServices)a3.getService(K == null ? (K = DetailsActions.class$("com.amazon.kindle.booklet.BookletServices")) : K);
                                        a4.switchToBooklet((Booklet)a.UpdateAction.this.booklet, a2, null);
                                    }
                                }
                                catch (URISyntaxException a5) {
                                    F.error(A, null, null, (Throwable)a5);
                                }
                                catch (BookletException a6) {
                                    F.error(H, null, null, (Throwable)a6);
                                }
                            }
                        }, "switch booklet");
                    }
                    return;
                }
                case 2: {
                    a2.doUpdate();
                    return;
                }
            }
            F.error(b, new String[]{Integer.toString(a7)}, null);
        }

        private void doUpdate() {
            UpdateAction a;
            if (a.booklet == null) {
                LogUtils.logBookletIsNull();
                return;
            }
            DownloadAction.downloadItem((HomeBooklet)a.booklet, a.item, -1);
        }
    }

    private static class EditThisCollectionAction
    extends AbstractAction {
        private DCBooklet booklet;
        private CatalogEntry cItem;

        public EditThisCollectionAction(DCBooklet a, CatalogEntry a2) {
            EditThisCollectionAction a3;
            a3.booklet = a;
            a3.cItem = a2;
        }

        public void actionPerformed(ActionEvent a) {
            EditThisCollectionAction a2;
            if (a2.cItem != null) {
                ItemsToCollectionDisplayController.getInstance(a2.booklet).switchTo(a2.cItem);
            }
        }
    }

    private static class PlayFromBeginningAction
    extends AbstractAction {
        private DCBooklet booklet;
        private CatalogEntry cItem;

        public PlayFromBeginningAction(DCBooklet a, CatalogEntry a2) {
            PlayFromBeginningAction a3;
            a3.booklet = a;
            a3.cItem = a2;
        }

        public void actionPerformed(ActionEvent a) {
            PlayFromBeginningAction a2;
            if (a2.booklet == null) {
                LogUtils.logBookletIsNull();
                return;
            }
            BookletContext a3 = a2.booklet.getBookletContext();
            if (a3 == null) {
                LogUtils.logBookletContextIsNull();
                return;
            }
            if (a2.cItem != null) {
                URI a4 = null;
                try {
                    ApplicationRegistry a5 = (ApplicationRegistry)a3.getService(D == null ? (D = DetailsActions.class$("com.amazon.kindle.restricted.device.ApplicationRegistry")) : D);
                    String a6 = a5.getHandlerIdFor(DetailsActions.L, DetailsActions.h + ((CatalogItem)a2.cItem).getMimeType());
                    a4 = new URI(DetailsActions.c, a6, a2.cItem.getLocation(), DetailsActions.k, null);
                    ((BookletServices)a3.getService(K == null ? (K = DetailsActions.class$("com.amazon.kindle.booklet.BookletServices")) : K)).switchToBooklet((Booklet)a2.booklet, a4, null);
                }
                catch (URISyntaxException a7) {
                    F.error("Invalid URI syntax when resume playing, stack trace:" + a7);
                }
                catch (BookletException a8) {
                    F.error("Can't find a booklet with the given content URI, stack trace:" + (Object)((Object)a8));
                }
                catch (NullPointerException a9) {
                    F.error("Can't switch to a null content, stack trace:" + a9);
                }
            }
        }
    }

    private static class ResumePlayingAction
    extends AbstractAction {
        private DCBooklet booklet;
        private CatalogEntry cItem;

        public ResumePlayingAction(DCBooklet a, CatalogEntry a2) {
            ResumePlayingAction a3;
            a3.booklet = a;
            a3.cItem = a2;
        }

        public void actionPerformed(ActionEvent a) {
            ResumePlayingAction a2;
            if (a2.booklet == null) {
                LogUtils.logBookletIsNull();
                return;
            }
            BookletContext a3 = a2.booklet.getBookletContext();
            if (a3 == null) {
                LogUtils.logBookletContextIsNull();
                return;
            }
            if (a2.cItem != null) {
                URI a4 = null;
                try {
                    ApplicationRegistry a5 = (ApplicationRegistry)a3.getService(D == null ? (D = DetailsActions.class$("com.amazon.kindle.restricted.device.ApplicationRegistry")) : D);
                    String a6 = a5.getHandlerIdFor(DetailsActions.L, DetailsActions.h + ((CatalogItem)a2.cItem).getMimeType());
                    a4 = new URI(DetailsActions.c, a6, a2.cItem.getLocation(), DetailsActions.l, null);
                    ((BookletServices)a3.getService(K == null ? (K = DetailsActions.class$("com.amazon.kindle.booklet.BookletServices")) : K)).switchToBooklet((Booklet)a2.booklet, a4, null);
                }
                catch (URISyntaxException a7) {
                    F.error("Invalid URI syntax when resume playing, stack trace:" + a7);
                }
                catch (BookletException a8) {
                    F.error("Can't find a booklet with the given content URI, stack trace:" + (Object)((Object)a8));
                }
                catch (NullPointerException a9) {
                    F.error("Can't switch to a null content, stack trace:" + a9);
                }
            }
        }
    }

    private static class RemoveItemAction
    extends AbstractAction {
        private DCBooklet booklet;
        private CatalogEntry cItem;

        public RemoveItemAction(DCBooklet a, CatalogEntry a2) {
            RemoveItemAction a3;
            a3.booklet = a;
            a3.cItem = a2;
        }

        public void actionPerformed(ActionEvent a) {
            RemoveItemAction a2;
            if (a2.cItem != null) {
                ActionUtils.removeItem((Booklet)a2.booklet, (CatalogEntry)a2.cItem);
            }
        }
    }

    private static class DeleteItemAction
    extends AbstractAction {
        private DCBooklet booklet;
        private CatalogEntry cItem;

        public DeleteItemAction(DCBooklet a, CatalogEntry a2) {
            DeleteItemAction a3;
            a3.booklet = a;
            a3.cItem = a2;
        }

        public void actionPerformed(ActionEvent a) {
            DeleteItemAction a2;
            ActionUtils.deleteItem((Booklet)a2.booklet, (CatalogEntry)a2.cItem);
        }
    }

    private static class KeepThisIssueAction
    extends AbstractAction {
        private CatalogItem mCatalogItem;
        private DCBooklet mBooklet;
        private boolean mKeepThisIssue;

        public KeepThisIssueAction(DCBooklet a, CatalogItem a2, boolean a3) {
            KeepThisIssueAction a4;
            a4.mBooklet = a;
            a4.mCatalogItem = a2;
            a4.mKeepThisIssue = a3;
        }

        public void actionPerformed(ActionEvent a) {
            KeepThisIssueAction a2;
            if (a2.mBooklet == null) {
                LogUtils.logBookletIsNull();
                return;
            }
            BookletContext a3 = a2.mBooklet.getBookletContext();
            if (a3 == null) {
                LogUtils.logBookletContextIsNull();
                return;
            }
            if (a2.mCatalogItem != null && a2.mBooklet != null) {
                PeriodicalsUtil.keepIssue((CatalogService)((CatalogService)a3.getService(B == null ? (B = DetailsActions.class$("com.amazon.kindle.content.catalog.CatalogService")) : B)), (CatalogItem)a2.mCatalogItem, (boolean)a2.mKeepThisIssue);
            }
        }
    }

    private static class BuyThisBookAction
    extends AbstractAction {
        private DCBooklet mBooklet;
        private CatalogItem mItem;

        public BuyThisBookAction(DCBooklet a, CatalogItem a2) {
            BuyThisBookAction a3;
            a3.mItem = a2;
            a3.mBooklet = a;
        }

        public void actionPerformed(ActionEvent a) {
            BuyThisBookAction a2;
            if (a2.mBooklet == null) {
                LogUtils.logBookletIsNull();
                return;
            }
            BookletContext a3 = a2.mBooklet.getBookletContext();
            if (a3 == null) {
                LogUtils.logBookletContextIsNull();
                return;
            }
            if (a2.mItem != null) {
                URI a4 = null;
                try {
                    a4 = new URI(URIActions.getBuyThisBookURI((String)a2.mItem.getCDEKey()));
                    BookletServices a5 = (BookletServices)a3.getService(K == null ? (K = DetailsActions.class$("com.amazon.kindle.booklet.BookletServices")) : K);
                    a5.switchToBooklet((Booklet)a2.mBooklet, a4, null);
                }
                catch (URISyntaxException a6) {
                    F.error("Invalid URI syntax when buy this book, stack trace:" + a6);
                }
                catch (BookletException a7) {
                    F.error("Can't find a booklet with the give content URI, stack trace:" + (Object)((Object)a7));
                }
                catch (NullPointerException a8) {
                    F.error("Can't switch to a null content, stack trace:" + a8);
                }
            }
        }
    }

    private static class ShareThisBookAction
    extends AbstractAction {
        private CatalogItem cItem;

        public ShareThisBookAction(CatalogItem a) {
            ShareThisBookAction a2;
            a2.cItem = a;
        }

        public void actionPerformed(ActionEvent a) {
            ShareThisBookAction a2;
            if (a2.cItem != null) {
                ActionUtils.sendLipcCommand((String)URIActions.getShareThisBookURI((String)a2.cItem.getCDEKey()));
            }
        }
    }

    private static class ViewBookDescriptionAction
    extends AbstractAction {
        private CatalogItem mItem;
        private DCBooklet mBooklet;

        public ViewBookDescriptionAction(DCBooklet a, CatalogItem a2) {
            ViewBookDescriptionAction a3;
            a3.mItem = a2;
            a3.mBooklet = a;
        }

        public void actionPerformed(ActionEvent a) {
            ViewBookDescriptionAction a2;
            if (a2.mBooklet == null) {
                LogUtils.logBookletIsNull();
                return;
            }
            BookletContext a3 = a2.mBooklet.getBookletContext();
            if (a3 == null) {
                LogUtils.logBookletContextIsNull();
                return;
            }
            if (a2.mItem != null) {
                URI a4 = null;
                try {
                    a4 = new URI(URIActions.getViewBookDescriptionURI((String)a2.mItem.getCDEKey()));
                    BookletServices a5 = (BookletServices)a3.getService(K == null ? (K = DetailsActions.class$("com.amazon.kindle.booklet.BookletServices")) : K);
                    a5.switchToBooklet((Booklet)a2.mBooklet, a4, null);
                }
                catch (URISyntaxException a6) {
                    F.error("Invalid URI syntax when go to book description, stack trace:" + a6);
                }
                catch (BookletException a7) {
                    F.error("Can't find a booklet with the given content URI, stack trace:" + (Object)((Object)a7));
                }
                catch (NullPointerException a8) {
                    F.error("Can't switch to a null content, stack trace:" + a8);
                }
            }
        }
    }

    private static class NotesAndMarksAction
    extends AbstractAction {
        private CatalogItem mCatalogItem;

        public NotesAndMarksAction(CatalogItem a) {
            NotesAndMarksAction a2;
            a2.mCatalogItem = a;
        }

        public void actionPerformed(ActionEvent a) {
            NotesAndMarksAction a2;
            if (a2.mCatalogItem != null) {
                try {
                    ActionUtils.sendLipcCommand((String)URIActions.getNotesAndMarksURI((String)URIUtility.getFileURI((String)a2.mCatalogItem.getLocation()).toString()));
                }
                catch (URISyntaxException a3) {
                    F.error(Log.CATCHALL_EX, null, "URICreation Failed", (Throwable)a3);
                }
            }
        }
    }

    private static class GotoDialogAction
    extends AbstractAction {
        private CatalogItem mCatalogItem;

        public GotoDialogAction(CatalogItem a) {
            GotoDialogAction a2;
            a2.mCatalogItem = a;
        }

        public void actionPerformed(ActionEvent a) {
            GotoDialogAction a2;
            if (a2.mCatalogItem != null) {
                try {
                    ActionUtils.sendLipcCommand((String)URIActions.getGotoDialogURI((String)URIUtility.getFileURI((String)a2.mCatalogItem.getLocation()).toString()));
                }
                catch (URISyntaxException a3) {
                    F.error(Log.CATCHALL_EX, null, "URICreation Failed", (Throwable)a3);
                }
            }
        }
    }

    private static class SearchThisBookAction
    extends AbstractAction {
        private CatalogItem cItem;

        public SearchThisBookAction(CatalogItem a) {
            SearchThisBookAction a2;
            a2.cItem = a;
            a2.setEnabled(MetadataUtils.isContentIndexed((CatalogEntry)a2.cItem));
        }

        public void actionPerformed(ActionEvent a) {
            SearchThisBookAction a2;
            if (a2.cItem != null) {
                try {
                    ActionUtils.sendLipcCommand((String)URIActions.getSearchThisBookURI((String)URIUtility.getFileURI((String)a2.cItem.getLocation()).toString()));
                }
                catch (URISyntaxException a3) {
                    F.error(Log.CATCHALL_EX, null, "URICreation Failed", (Throwable)a3);
                }
            }
        }
    }

    private static class AddToCollectionsAction
    extends AbstractAction {
        private DCBooklet booklet;
        private CatalogEntry cItem;

        public AddToCollectionsAction(DCBooklet a, CatalogEntry a2) {
            AddToCollectionsAction a3;
            a3.booklet = a;
            a3.cItem = a2;
        }

        public void actionPerformed(ActionEvent a) {
            AddToCollectionsAction a2;
            AddToCollectionsDisplayController.getInstance(a2.booklet).switchTo(a2.cItem);
        }
    }
}

