/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.kindle.home;

import com.amazon.agui.swing.KindleFrameFactory;
import com.amazon.ebook.util.log.Log;
import com.amazon.ebook.util.log.LogMessage;
import com.amazon.ebook.util.net.URIUtility;
import com.amazon.kindle.ad.event.AdEvent;
import com.amazon.kindle.ad.event.AdEventListener;
import com.amazon.kindle.ad.manager.AdManager;
import com.amazon.kindle.apps.util.DebugUtils;
import com.amazon.kindle.apps.util.LogUtils;
import com.amazon.kindle.apps.util.ReaderUtils;
import com.amazon.kindle.booklet.Booklet;
import com.amazon.kindle.booklet.BookletContext;
import com.amazon.kindle.control.ContentBasedDisplayController;
import com.amazon.kindle.control.DCBooklet;
import com.amazon.kindle.control.DisplayController;
import com.amazon.kindle.control.behavior.BookletBehavior;
import com.amazon.kindle.control.behavior.TransferClientData;
import com.amazon.kindle.control.behavior.event.AdDisabledEvent;
import com.amazon.kindle.control.behavior.event.AdEnabledEvent;
import com.amazon.kindle.control.behavior.event.EnteringScreensaverEvent;
import com.amazon.kindle.control.behavior.event.ExitingScreensaverEvent;
import com.amazon.kindle.control.behavior.event.ExitingUserShutdownEvent;
import com.amazon.kindle.control.behavior.event.TransferEvent;
import com.amazon.kindle.control.content.ContentManager;
import com.amazon.kindle.control.util.ActionUtils;
import com.amazon.kindle.control.util.TransferUtils;
import com.amazon.kindle.home.behavior.EndBannerAdImpression;
import com.amazon.kindle.home.behavior.GoToPendingPurchases;
import com.amazon.kindle.home.behavior.InvalidateAdCache;
import com.amazon.kindle.home.behavior.PostLoadDialog;
import com.amazon.kindle.home.behavior.ShowSpinningBallWhileDownloading;
import com.amazon.kindle.home.behavior.event.AdRemovedEvent;
import com.amazon.kindle.home.behavior.event.HomeUIShownEvent;
import com.amazon.kindle.home.util.HomePreferences;
import com.amazon.kindle.home.view.addtocollections.AddToCollectionsDisplayController;
import com.amazon.kindle.home.view.archive.ArchiveDisplayController;
import com.amazon.kindle.home.view.backissues.BackIssuesDisplayController;
import com.amazon.kindle.home.view.browse.BrowseDisplayController;
import com.amazon.kindle.home.view.collection.CollectionDisplayController;
import com.amazon.kindle.home.view.experimental.ExperimentalDisplayController;
import com.amazon.kindle.home.view.importcollections.ImportCollectionsDisplayController;
import com.amazon.kindle.home.view.itemstocollection.ItemsToCollectionDisplayController;
import com.amazon.kindle.home.view.searchresults.SearchResultsDisplayController;
import com.amazon.kindle.home.view.unindexed.UnindexedDisplayController;
import com.amazon.kindle.restricted.net.transfer.TransferListener;
import com.amazon.kindle.restricted.net.transfer.TransferService;
import com.amazon.kindle.restricted.net.transfer.TransferStatus;
import com.amazon.kindle.restricted.runtime.Const;
import com.amazon.kindle.restricted.runtime.PowerTarget;
import com.amazon.kindle.swing.events.BookletUIEvent;
import com.amazon.kindle.swing.events.BookletUIListener;
import com.amazon.kindle.util.lipc.LipcEvent;
import com.amazon.kindle.util.lipc.LipcEventListener;
import com.amazon.kindle.util.lipc.LipcException;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;

public class HomeBooklet
extends DCBooklet
implements Booklet,
LipcEventListener,
AdEventListener,
TransferListener,
BookletUIListener {
    private static final Log u = Log.getInstance((String)"HomeBooklet");
    private static final LogMessage y = new LogMessage("NullAdEventError");
    private static final LogMessage O = new LogMessage("NullAdEventTypeError");
    private static final LogMessage x = new LogMessage("KugPathUnavailable");
    private static final LogMessage f = new LogMessage("HomeViewSwitch", new String[]{"view"});
    private static final LogMessage M = new LogMessage("HomeBookletDestroyed", new String[]{"HomeBooklet", "stacktrace"});
    private static final String J = "com.lab126.booklet.oobe";
    private static final String G = "context";
    private static final String a = "/var/local/system/no_transitions";
    private List i = new ArrayList();
    private BookletBehavior[] E;
    private boolean C = false;
    private volatile URI d;
    private boolean j = false;
    private boolean g = false;
    private static final String e = "getInstance";
    private static Map I;
    private boolean F = false;

    public HomeBooklet() {
        HomeBooklet a;
    }

    public void create(BookletContext a) {
        HomeBooklet a2;
        super.create(a);
        ReaderUtils.loadAnnotationsBackupState((Booklet)a2);
        HomePreferences.init(a2);
        a2.getDefaultController();
    }

    public void destroy() {
        ContentManager a;
        HomeBooklet a2;
        u.info(M, new String[]{((Object)((Object)a2)).toString(), DebugUtils.getCompactStackTrace()}, null);
        DisplayController a3 = a2.getDefaultController();
        if (a3 != null && (a = ((ContentBasedDisplayController)a3).getContentManager()) != null) {
            a.setAutoUpdateEnabled(false);
            a.removeListeners();
            a.dispose();
        }
        a2.deregisterPersistentListeners();
        super.destroy();
    }

    public void stop() {
        HomeBooklet a;
        if (a.C) {
            a.C = false;
        } else {
            super.stop();
            if (a.mBookletContext == null) {
                LogUtils.logBookletContextIsNull();
                return;
            }
            a.deregisterListeners();
        }
    }

    public DisplayController getDefaultController() {
        HomeBooklet a;
        return BrowseDisplayController.getInstance(a);
    }

    private static void preloadResources() {
        int a;
        String[] a2 = new String[]{"com.amazon.kindle.home.resources.MenuResources", "com.amazon.kindle.control.resources.MenuResources", "com.amazon.agui.swing.resources.ComponentResources", "com.amazon.kindle.home.resources.RendererResources", "com.amazon.kindle.home.resources.ArchiveResources"};
        int n = a = 0;
        while (n < a2.length) {
            ResourceBundle.getBundle(a2[a]);
            n = ++a;
        }
    }

    public String getViewMode() {
        return HomePreferences.getProperty("VIEW_MODE", "LIST_VIEW_MODE");
    }

    public void start(URI a) {
        HomeBooklet a2;
        Object a3;
        if (HomePreferences.isFirstBoot()) {
            a3 = new File(a);
            if (a3.exists() && !a3.delete()) {
                u.critical("Delete failed, file:/var/local/system/no_transitions");
            }
            if (a2.showKindleUserGuide()) {
                return;
            }
        }
        if (a2.mBookletContext == null) {
            LogUtils.logBookletContextIsNull();
            return;
        }
        if (!a2.isActive()) {
            a2.registerListeners();
        }
        super.start(a);
        a2.registerPersistentListeners();
        if (!a2.F) {
            a3 = BrowseDisplayController.getInstance(a2);
            InvalidateAdCache.invalidateAdCache((DisplayController)a3);
            a2.F = true;
        }
        a2.d = a;
        a2.j = false;
    }

    private boolean showKindleUserGuide() {
        String a = Const.getInstance().getFirstBootBook();
        if (a == null) {
            u.error(x);
            return false;
        }
        if (new File(a).exists()) {
            try {
                URI a2 = URIUtility.getFileURI((String)a);
                ActionUtils.sendLipcCommand((String)(a2.toString() + "?autoOpen=true"));
                return true;
            }
            catch (URISyntaxException a3) {
                u.error(Log.CATCHALL_EX, null, "URISyntax", (Throwable)a3);
                return false;
            }
        }
        u.warning("Could not find KUG");
        return false;
    }

    protected void loadView(URI a) {
        HomeBooklet a2;
        super.loadView(a);
    }

    protected void doLoadView(Map a) {
        HomeBooklet a2;
        DisplayController a3 = a2.getDisplayControllerFromMap(a);
        if (a3 != null) {
            a3.loadHistory(a);
            a2.loadBaseView(a3, null, false);
        } else if (a != null && !a.containsKey(G) && !a.containsKey("dialog")) {
            if (a.containsKey("searchTerm")) {
                Object a4 = a.get("searchTerm");
                if (a4 instanceof String) {
                    SearchResultsDisplayController.getInstance(a2).switchTo((String)a4);
                }
            } else if (a.containsKey("viewRequest")) {
                String a5;
                Object a6 = a.get("viewRequest");
                if (a6 instanceof String && "VIEW_REQUEST_ID_ARCHIVED_ITEMS".equals(a5 = (String)a6)) {
                    ArchiveDisplayController.getInstance(a2).switchTo();
                }
            } else {
                u.error("Unhandled URI while loading view.");
            }
        } else {
            Object a7 = null;
            if (a != null) {
                a7 = a.get(G);
            }
            if (!a2.isDefaultView()) {
                a2.loadBaseView(a2.getDefaultController(), a7, true);
            } else {
                KindleFrameFactory.cleanUpApplicationDialogs((String)a2.getName());
            }
        }
        a2.mapGlobalGestures();
    }

    public void loadBaseView(DisplayController a, Object a2, boolean a3) {
        HomeBooklet a4;
        if (a4.mBookletContext == null) {
            LogUtils.logBookletContextIsNull();
            return;
        }
        if (a != null) {
            u.info(f, new String[]{a.getViewKey()}, null);
        }
        super.loadBaseView(a, a2, a3);
    }

    private boolean isDefaultView() {
        HomeBooklet a;
        if (a.isActive() && a.getActiveController() instanceof ContentBasedDisplayController) {
            ContentBasedDisplayController a2 = (ContentBasedDisplayController)a.getActiveController();
            return a2 == a.getDefaultController() && a2.getContentManager().getCursor() == 0;
        }
        return false;
    }

    public void setViewMode(String a) {
        HomeBooklet a2;
        if (a == null) {
            throw new NullPointerException("view mode");
        }
        if (!a.equals("LIST_VIEW_MODE") && !a.equals("COVER_VIEW_MODE")) {
            throw new IllegalArgumentException("illegal view mode");
        }
        if (!a2.getViewMode().equals(a)) {
            HomePreferences.saveProperty("VIEW_MODE", a);
        }
    }

    protected DisplayController getDisplayControllerFromMap(Map a) {
        HomeBooklet a2;
        if (a != null && a.containsKey("mostRecentCollection")) {
            return CollectionDisplayController.getInstance(a2);
        }
        return super.getDisplayControllerFromMap(a);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void populateActiveDownloadItems() {
        HomeBooklet a;
        List list = a.i;
        synchronized (list) {
            a.i.clear();
            a.i.addAll(TransferUtils.getUniqueKeysOfCurrentTransfers((Booklet)a));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getActiveDownloadingItems() {
        HomeBooklet a;
        List list = a.i;
        synchronized (list) {
            return a.i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isActiveDownloading(String a) {
        HomeBooklet a2;
        List list = a2.i;
        synchronized (list) {
            return a2.i.contains(a);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addActiveDownloadingItem(String a) {
        HomeBooklet a2;
        List list = a2.i;
        synchronized (list) {
            a2.i.add(a);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeActiveDownloadingItem(String a, boolean a2) {
        HomeBooklet a3;
        List list = a3.i;
        synchronized (list) {
            a3.i.remove(a);
            if (a3.mActiveController instanceof ArchiveDisplayController && a2) {
                ((ArchiveDisplayController)a3.mActiveController).addDownloaded(a);
            }
        }
    }

    public synchronized BookletBehavior[] getBehaviors() {
        HomeBooklet a;
        if (a.E == null) {
            a.E = new BookletBehavior[]{new ShowSpinningBallWhileDownloading(a), new GoToPendingPurchases(a), new EndBannerAdImpression(a), new PostLoadDialog(a)};
        }
        return a.E;
    }

    public void onLipcEvent(LipcEvent a) {
        HomeBooklet a2;
        a2.F = false;
        if (a2.isActive()) {
            String a3 = a.getEventName();
            if ("outOfScreenSaver".equals(a3)) {
                ExitingScreensaverEvent.getInstance().fireEvent();
            } else if ("goingToScreenSaver".equals(a3)) {
                EnteringScreensaverEvent.getInstance().fireEvent();
            } else if ("userShutdown".equals(a3)) {
                ExitingUserShutdownEvent.getInstance().fireEvent();
            }
        }
    }

    public void onAdEvent(AdEvent a) {
        if (a == null) {
            u.error(y);
            return;
        }
        AdEvent.Type a2 = a.getType();
        if (a2 == null) {
            u.error(O);
            return;
        }
        if (a2.equals((Object)AdEvent.Type.K)) {
            AdEnabledEvent.getInstance().fireEvent();
        } else if (a2.equals((Object)AdEvent.Type.B)) {
            AdDisabledEvent.getInstance().fireEvent();
        } else if (a2.equals((Object)AdEvent.Type.D)) {
            AdRemovedEvent.getInstance().fireEvent();
        }
    }

    public void onProgress(TransferStatus a) {
        if (TransferClientData.getInstance((String)a.getClientData()) != null) {
            TransferEvent.getInstance().fireEvent((Object)a);
        }
    }

    private void registerListeners() {
        HomeBooklet a;
        ((AdManager)a.mBookletContext.getService(AdManager.class)).addAdEventListener((AdEventListener)a);
        TransferService a2 = (TransferService)a.mBookletContext.getService(TransferService.class);
        a2.addGlobalTransferListener((TransferListener)a);
        a.mBookletContext.addUIListener((BookletUIListener)a);
    }

    private void deregisterListeners() {
        HomeBooklet a;
        ((AdManager)a.mBookletContext.getService(AdManager.class)).removeAdEventListener((AdEventListener)a);
        TransferService a2 = (TransferService)a.mBookletContext.getService(TransferService.class);
        a2.removeGlobalTransferListener((TransferListener)a);
        a.mBookletContext.removeUIListener((BookletUIListener)a);
    }

    private void registerPersistentListeners() {
        HomeBooklet a;
        if (!a.g) {
            try {
                new PowerTarget().addLipcEventListener("outOfScreenSaver", (LipcEventListener)a);
                new PowerTarget().addLipcEventListener("goingToScreenSaver", (LipcEventListener)a);
                new PowerTarget().addLipcEventListener("userShutdown", (LipcEventListener)a);
            }
            catch (LipcException a2) {
                u.error(Log.LIPC_EX, new String[]{Integer.toString(a2.getErrorCode())}, "COM_LAB126_POWERD_LIPC_FAILED", null);
            }
            a.g = true;
        }
    }

    private void deregisterPersistentListeners() {
        try {
            HomeBooklet a;
            new PowerTarget().removeLipcEventListener("outOfScreenSaver", (LipcEventListener)a);
            new PowerTarget().removeLipcEventListener("goingToScreenSaver", (LipcEventListener)a);
            new PowerTarget().removeLipcEventListener("userShutdown", (LipcEventListener)a);
        }
        catch (LipcException a) {
            u.error(Log.LIPC_EX, new String[]{Integer.toString(a.getErrorCode())}, "COM_LAB126_POWERD_LIPC_FAILED", null);
        }
        a.g = false;
    }

    public void onUIContainerStateChange(BookletUIEvent a) {
        HomeBooklet a2;
        if (a.getEvent() == 1 && !a2.j && a2.d != null) {
            HomeUIShownEvent.getInstance().fireEvent(a2.d);
            a2.j = true;
        }
    }

    protected DisplayController recreateDisplayController(String a) {
        HomeBooklet a2;
        Class a3 = (Class)I.get(a);
        if (a3 == null) {
            u.error("Class not found");
            return a2.getDefaultController();
        }
        Method a4 = null;
        try {
            a4 = a3.getMethod(e, DCBooklet.class);
            return (DisplayController)a4.invoke(null, new Object[]{a2});
        }
        catch (Exception a5) {
            u.error("", (Throwable)a5);
            return a2.getDefaultController();
        }
    }

    static {
        HomeBooklet.preloadResources();
        BreakIterator.getLineInstance(Locale.getDefault());
        I = new HashMap();
        I.put("ARCHIVE", ArchiveDisplayController.class);
        I.put("BROWSE", BrowseDisplayController.class);
        I.put("IMPORT_COLLECTIONS", ImportCollectionsDisplayController.class);
        I.put("EXPERIMENTAL", ExperimentalDisplayController.class);
        I.put("ITEMS_TO_COLLECTION", ItemsToCollectionDisplayController.class);
        I.put("ADD_TO_COLLECTIONS", AddToCollectionsDisplayController.class);
        I.put("UNINDEXED", UnindexedDisplayController.class);
        I.put("BACK_ISSUES", BackIssuesDisplayController.class);
        I.put("COLLECTION", CollectionDisplayController.class);
    }
}

