/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ebook.booklet.reader.impl.ui;

import com.amazon.agui.swing.KDialog;
import com.amazon.ebook.booklet.reader.impl.ContentPanel;
import com.amazon.ebook.booklet.reader.impl.ReaderSDKImpl;
import com.amazon.ebook.booklet.reader.sdk.content.Book;
import com.amazon.ebook.booklet.reader.sdk.content.Position;
import com.amazon.ebook.booklet.reader.sdk.event.CloseBookHandler;
import com.amazon.ebook.booklet.reader.sdk.event.EventHandler;
import com.amazon.ebook.util.log.Log;
import com.amazon.ebook.util.log.LogSystem;
import com.amazon.kindle.booklet.BookletContext;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.net.URL;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ImageIcon;
import javax.swing.JButton;

public class TableDialog
extends KDialog {
    public static final char DIRECTION_NOT_SPECIFIED = 'x';
    public static final char DIRECTION_NORTH = 'n';
    public static final char DIRECTION_SOUTH = 's';
    public static final char DIRECTION_EAST = 'e';
    public static final char DIRECTION_WEST = 'w';
    private static final int NORTH_REF_PT_X = 50;
    private static final int NORTH_REF_PT_Y = 75;
    private static final int SOUTH_REF_PT_X = 50;
    private static final int SOUTH_REF_PT_Y = 725;
    private static final int ITERATION_LIMIT = 15;
    private static final int INITIAL_ITERATIONS = 4;
    private static final int SPACIAL_THRESHOLD = 25;
    private static final Log LOG = LogSystem.getLog((String)"TableDialog");
    private static final String RB_IMAGE = "com.amazon.ebook.booklet.reader.impl.ui.resources.UIResourcesDNT";
    private static final String RB_TEXT = "com.amazon.ebook.booklet.reader.impl.ui.resources.UIResources";
    private ReaderSDKImpl readerSDK;
    private Rectangle tableRect;
    private ContentPanel contentPanel;
    private Point refLoc;
    private Position leftMostPosition;
    private boolean isTop = false;
    private boolean isBottom = false;
    private boolean isLeftMost = false;
    private boolean isRightMost = false;
    private boolean isTablePanningActive = false;
    private TableDoneDialog doneDialog;
    private Rectangle iconLocAndSize;
    private ImageIcon icon = null;
    private Rectangle doneLocAndSize;
    private Action saveNorthAction;
    private Action saveSouthAction;
    private Action saveEastAction;
    private Action saveWestAction;

    public TableDialog(ReaderSDKImpl a, Rectangle a2, Point a3, ContentPanel a4) {
        super(((BookletContext)a.getActiveContext()).getName(), false);
        TableDialog a5;
        a5.readerSDK = a;
        a5.tableRect = a2;
        a5.refLoc = a3;
        a5.contentPanel = a4;
        a5.isTop = !a.getBookNavigator().canTableMoveUp(a2);
        a5.isBottom = !a.getBookNavigator().canTableMoveDown(a2);
        a5.isLeftMost = !a.getBookNavigator().canTableMoveHorizontally(2);
        a5.isRightMost = !a.getBookNavigator().canTableMoveHorizontally(0);
        ResourceBundle a6 = ResourceBundle.getBundle(RB_IMAGE);
        a5.iconLocAndSize = (Rectangle)a6.getObject("image.one.icon.panel.rect");
        if (a5.icon == null) {
            String a7 = a6.getString("image.icon.pan.img");
            URL a8 = ((Object)((Object)a5)).getClass().getResource(a7);
            a5.icon = new ImageIcon(a8);
        }
        a.getBookNavigator().clearSelection();
        a5.initGUI();
    }

    private void initGUI() {
        TableDialog a;
        AbstractAction a2 = new AbstractAction(){
            {
                1 a;
            }

            public void actionPerformed(ActionEvent a) {
                1 a2;
                if (Log.isDebugOn()) {
                    LOG.debug("User has selected table pan icon so carry out action.");
                }
                a2.TableDialog.this.getCloseAction().actionPerformed(a);
                a2.TableDialog.this.contentPanel.hideAllDialogs();
                ActionMap a3 = a2.TableDialog.this.readerSDK.getUI().getReadingPaneActionMap();
                a2.TableDialog.this.saveNorthAction = a3.get("north");
                a2.TableDialog.this.saveSouthAction = a3.get("south");
                a2.TableDialog.this.saveEastAction = a3.get("east");
                a2.TableDialog.this.saveWestAction = a3.get("west");
                a3.put("north", a2.TableDialog.this.saveWestAction);
                a3.put("south", a2.TableDialog.this.saveEastAction);
                a3.put("east", new ContentPanel.TablePanLeftAction(a2.TableDialog.this.contentPanel));
                a3.put("west", new ContentPanel.TablePanRightAction(a2.TableDialog.this.contentPanel));
                a2.TableDialog.this.leftMostPosition = a2.TableDialog.this.readerSDK.getBookNavigator().getCurrentPosition();
                a2.TableDialog.this.doneDialog = new TableDoneDialog();
                a2.TableDialog.this.doneDialog.postDialog();
                a2.TableDialog.this.isTablePanningActive = true;
                a2.TableDialog.this.readerSDK.getUI().getReaderPane().repaint();
            }
        };
        Container a3 = a.getContentPane();
        a3.setLayout(new GridLayout(1, 1));
        JButton a4 = new JButton(a2);
        a4.setIcon(a.icon);
        a4.setEnabled(true);
        a3.add(a4);
        a.setCommandBarPosition(-1);
        a.setAutoCenteredEnabled(false);
        int a5 = a.readerSDK.getUI().getContentLeftMargin();
        int a6 = a.readerSDK.getUI().getContentTopMargin();
        int a7 = a.tableRect.width;
        if (a.tableRect.width > a.contentPanel.getBounds().width) {
            a7 = a.contentPanel.getBounds().width;
        }
        if (a.tableRect.x < 0) {
            a.tableRect.x = 0;
        }
        Point a8 = a.contentPanel.getLocationOnScreen();
        int a9 = a8.x;
        int a10 = a8.y;
        a.iconLocAndSize.x = a5 + a.tableRect.x + a7 / 2 - a.iconLocAndSize.width / 2 + a9;
        a.iconLocAndSize.y = a6 + a.tableRect.y + a.tableRect.height / 2 - a.iconLocAndSize.height / 2 + a10;
        if (Log.isDebugOn()) {
            LOG.debug("JFrame offset x,y = " + a9 + "," + a10 + "  Offset left,top margins = " + a5 + "," + a6 + "  Positioned image icon rectangle = " + a.iconLocAndSize);
        }
        a.setDialogBounds(a.iconLocAndSize);
    }

    public Rectangle getTableRect() {
        TableDialog a;
        return a.tableRect;
    }

    public boolean isTop() {
        TableDialog a;
        return a.isTop;
    }

    public boolean isBottom() {
        TableDialog a;
        return a.isBottom;
    }

    public boolean isLeftMost() {
        TableDialog a;
        return a.isLeftMost;
    }

    public boolean isRightMost() {
        TableDialog a;
        return a.isRightMost;
    }

    public boolean isTablePanningActive() {
        TableDialog a;
        return a.isTablePanningActive;
    }

    public void terminateTablePanning() {
        TableDialog a;
        if (a.isTablePanningActive) {
            a.doneDialog.getCloseAction().actionPerformed(null);
            a.doneDialog.dismissTablePanningMode();
        }
    }

    public void recomputeTableRect(char a) {
        int a2;
        TableDialog a3;
        if (a == 'x') {
            return;
        }
        a3.contentPanel.hideAllDialogs();
        if (a == 'n') {
            a3.refLoc = new Point(50, 75);
        } else if (a == 's') {
            a3.refLoc = new Point(50, 725);
        }
        boolean a4 = a3.readerSDK.getBookNavigator().isInsideTable(a3.refLoc, a3.tableRect);
        int a5 = a2 = a3.contentPanel.getBounds().height / 2;
        int a6 = a2 / 2;
        int a7 = 0;
        block0: while (true) {
            boolean bl = a4;
            while (!(bl || a != 's' && a != 'n')) {
                if (++a7 > 15 || a5 > a3.contentPanel.getBounds().height || a5 < 0) {
                    LOG.error("Iteration limits reached and table not located.  This means that the panning boundaries shown to the user are not correct.  Last tableRect(valid) AND refLoc = " + a3.tableRect + " AND " + a3.refLoc);
                    break block0;
                }
                if (Log.isDebugOn()) {
                    LOG.debug("Direction, startY, incrY, computeY = " + a + ',' + a2 + ',' + a6 + ',' + a5);
                }
                a3.refLoc.y = a5;
                a4 = a3.readerSDK.getBookNavigator().isInsideTable(a3.refLoc, a3.tableRect);
                if (a4) break block0;
                if (a7 < 4 || a6 > 25) {
                    a6 /= 2;
                }
                if (a == 's') {
                    a5 += a6;
                    bl = a4;
                    continue;
                }
                if (a != 'n') continue block0;
                a5 -= a6;
                bl = a4;
            }
            break;
        }
        if (a == 's' || a == 'n') {
            a3.isTop = !a3.readerSDK.getBookNavigator().canTableMoveUp(a3.tableRect);
            a3.isBottom = !a3.readerSDK.getBookNavigator().canTableMoveDown(a3.tableRect);
            a3.leftMostPosition = a3.readerSDK.getBookNavigator().getCurrentPosition();
        }
        a3.isLeftMost = !a3.readerSDK.getBookNavigator().canTableMoveHorizontally(2);
        a3.isRightMost = !a3.readerSDK.getBookNavigator().canTableMoveHorizontally(0);
    }

    class TableDoneDialog
    extends KDialog
    implements CloseBookHandler,
    WindowListener {
        TableDoneDialog() {
            TableDoneDialog a;
            super(((BookletContext)a.TableDialog.this.readerSDK.getActiveContext()).getName(), false);
            ResourceBundle a2 = ResourceBundle.getBundle(TableDialog.RB_IMAGE);
            a.TableDialog.this.doneLocAndSize = (Rectangle)a2.getObject("table.panning.exit.button.panel.rect");
            AbstractAction a3 = new AbstractAction(){
                {
                    1 a;
                }

                public void actionPerformed(ActionEvent a) {
                    1 a2;
                    if (Log.isDebugOn()) {
                        LOG.debug("User has selected the DONE button to exit table panning mode");
                    }
                    a2.TableDoneDialog.this.getCloseAction().actionPerformed(a);
                    a2.TableDoneDialog.this.dismissTablePanningMode();
                    TableDialog.this.readerSDK.getBookNavigator().goTo(TableDialog.this.leftMostPosition);
                    TableDialog.this.readerSDK.getUI().getReaderPane().repaint();
                }
            };
            Container a4 = a.getContentPane();
            a4.setLayout(new GridLayout(1, 1));
            JButton a5 = new JButton(a3);
            a5.setText(ResourceBundle.getBundle(TableDialog.RB_TEXT).getString("table.panning.exit.button"));
            a5.setEnabled(true);
            a4.add(a5);
            a.setCommandBarPosition(-1);
            a.setAutoCenteredEnabled(false);
            Point a6 = a.TableDialog.this.contentPanel.getLocationOnScreen();
            int a7 = a6.x;
            int a8 = a6.y;
            ((TableDialog)a.TableDialog.this).doneLocAndSize.x += a7;
            ((TableDialog)a.TableDialog.this).doneLocAndSize.y = ((TableDialog)a.TableDialog.this).contentPanel.getBounds().height - ((TableDialog)a.TableDialog.this).doneLocAndSize.height + a8;
            if (Log.isDebugOn()) {
                LOG.debug("Positioned 'Done' button rectangle = " + a.TableDialog.this.doneLocAndSize);
            }
            a.setDialogBounds(a.TableDialog.this.doneLocAndSize);
            a.getFrame().addWindowListener(a);
            a.TableDialog.this.readerSDK.getEventManager().deregisterCloseBookHandler(a);
            a.TableDialog.this.readerSDK.getRegistry().registerHandler((EventHandler)a);
        }

        public boolean equals(Object a) {
            return a != null && a instanceof TableDoneDialog;
        }

        void dismissTablePanningMode() {
            TableDoneDialog a;
            a.TableDialog.this.isTablePanningActive = false;
            ActionMap a2 = a.TableDialog.this.readerSDK.getUI().getReadingPaneActionMap();
            a2.put("north", a.TableDialog.this.saveNorthAction);
            a2.put("south", a.TableDialog.this.saveSouthAction);
            a2.put("east", a.TableDialog.this.saveEastAction);
            a2.put("west", a.TableDialog.this.saveWestAction);
            a.getFrame().removeWindowListener(a);
            a.TableDialog.this.contentPanel.dismissTableDialog();
        }

        public void windowClosed(WindowEvent a) {
        }

        public void windowOpened(WindowEvent a) {
        }

        public void windowClosing(WindowEvent a) {
            TableDoneDialog a2;
            a2.dismissTablePanningMode();
            a2.TableDialog.this.readerSDK.getUI().getReaderPane().repaint();
        }

        public void windowIconified(WindowEvent a) {
        }

        public void windowDeiconified(WindowEvent a) {
        }

        public void windowActivated(WindowEvent a) {
        }

        public void windowDeactivated(WindowEvent a) {
        }

        public void closeBookEvent(Book a, boolean a2) {
            TableDoneDialog a3;
            if (a3.TableDialog.this.isTablePanningActive) {
                a3.getCloseAction().actionPerformed(null);
                a3.dismissTablePanningMode();
            }
        }
    }
}

