/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ebook.booklet.reader.impl.ui;

import com.amazon.agui.swing.ConfirmationDialog;
import com.amazon.ebook.booklet.reader.impl.ReaderSDKImpl;
import com.amazon.ebook.booklet.reader.impl.todo.handler.LprShownBookHandler;
import com.amazon.ebook.booklet.reader.sdk.ReaderException;
import com.amazon.ebook.booklet.reader.sdk.ReaderSDK;
import com.amazon.ebook.booklet.reader.sdk.content.BookMetadata;
import com.amazon.ebook.booklet.reader.sdk.content.ByteOffsetBasedPosition;
import com.amazon.ebook.booklet.reader.sdk.content.Position;
import com.amazon.ebook.booklet.reader.sdk.content.UpdatedLpr;
import com.amazon.ebook.booklet.reader.sdk.internal.BookController;
import com.amazon.ebook.booklet.reader.sdk.ui.ReaderAction;
import com.amazon.ebook.booklet.reader.sdk.ui.ReaderUI;
import com.amazon.ebook.booklet.reader.sdk.util.DataStoreObject;
import com.amazon.ebook.booklet.reader.sdk.util.InvalidSideCarFileException;
import com.amazon.ebook.booklet.reader.sdk.util.State;
import com.amazon.ebook.util.log.Log;
import com.amazon.ebook.util.thread.ThreadPoolRunnable;
import com.amazon.ebook.util.unicode.TimeZoneUtil;
import com.amazon.kindle.apps.util.CommunicationUtils;
import com.amazon.kindle.apps.util.ComponentUtils;
import com.amazon.kindle.booklet.Booklet;
import com.amazon.kindle.booklet.BookletContext;
import com.amazon.kindle.net.CommunicationException;
import com.ibm.icu.util.Calendar;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.Reader;
import java.io.StringReader;
import java.text.ChoiceFormat;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.ResourceBundle;
import java.util.TimeZone;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParserException;

public class SyncLPRDialogUtil {
    private static final Log I = Log.getInstance((String)"SyncLPRDialogUtil");
    private static ReaderSDKImpl F;
    private static ResourceBundle L;
    private static final int c = 10;
    private final int l = 0;
    private final String k = "book";
    private final String m = "last_read";
    private final String h = "version";
    private final String A = "pos";
    private final String H = "lto";
    private final String b = "country_code";
    private final String K = "source_device";
    private final String B = "annotation_time_utc";
    private RetrievingDialog D;

    public SyncLPRDialogUtil(ReaderSDKImpl a) {
        SyncLPRDialogUtil a2;
        F = a;
        L = ResourceBundle.getBundle("com.amazon.ebook.booklet.reader.resources.ReaderResources");
    }

    private boolean getLPRFromServer(Booklet a) {
        if (CommunicationUtils.isRegistered((Booklet)a)) {
            if (CommunicationUtils.ensureConnection((Booklet)a)) {
                State a2;
                SyncLPRDialogUtil a3;
                if (Log.isDebugOn()) {
                    I.debug("calling get.annotations on KindleAuthenticatedConnectionService for LPR");
                }
                HashMap<String, String> a4 = new HashMap<String, String>(3);
                BookMetadata a5 = F.getCurrentBook().getMetadata();
                a4.put("key", a5.getCdeKey());
                a4.put("type", a5.getCdeType());
                a4.put("filter", "last_read");
                String a6 = null;
                try {
                    a6 = CommunicationUtils.doAuthenticatedConnection((String)"cmd.get.annotations", a4, (Booklet)a);
                }
                catch (CommunicationException a7) {
                    I.error("Error connecting to server for sync LPR.", (Throwable)a7);
                    return false;
                }
                UpdatedLpr a8 = a3.parseResponseIntoLPR(a6);
                if (a8 == null) {
                    return false;
                }
                try {
                    a2 = F.getCurrentBook().getFreqUpdateBookState();
                    if (a2 == null) {
                        I.error("Unable to get frequently updated book state for current book for updated LPR");
                        return false;
                    }
                }
                catch (InvalidSideCarFileException a9) {
                    I.error("Unable to get frequently updated book state for current book for updated LPR", (Throwable)a9);
                    return false;
                }
                UpdatedLpr a10 = (UpdatedLpr)a2.get("updated_lpr");
                if (a10 == null) {
                    a2.add((DataStoreObject)a8);
                } else {
                    a10 = a8;
                }
                return true;
            }
        } else {
            ComponentUtils.showDeviceNotRegisteredDialog((String)a.getBookletContext().getName());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UpdatedLpr parseResponseIntoLPR(String a) {
        long a2;
        long a3;
        String a42;
        KXmlParser a5;
        String a6 = null;
        String a7 = null;
        String a8 = null;
        String a9 = null;
        String a10 = null;
        StringReader a11 = null;
        try {
            a11 = new StringReader(a);
            a5 = new KXmlParser();
            a5.setInput((Reader)a11);
            a42 = null;
            boolean a12 = false;
            int a13 = a5.getEventType();
            while (a13 != 1) {
                if (a13 == 2) {
                    a42 = a5.getName();
                    if (a12 && a42.equalsIgnoreCase("last_read")) {
                        int a14;
                        int a15 = a5.getAttributeCount();
                        int n = a14 = 0;
                        while (n < a15) {
                            String a16 = a5.getAttributeName(a14);
                            if (a16.equalsIgnoreCase("pos")) {
                                a6 = a5.getAttributeValue(a14);
                            } else if (a16.equalsIgnoreCase("lto")) {
                                a7 = a5.getAttributeValue(a14);
                            } else if (a16.equalsIgnoreCase("country_code")) {
                                a8 = a5.getAttributeValue(a14);
                            } else if (a16.equalsIgnoreCase("source_device")) {
                                a9 = a5.getAttributeValue(a14);
                            } else if (a16.equalsIgnoreCase("annotation_time_utc")) {
                                a10 = a5.getAttributeValue(a14);
                            } else if (a16.equalsIgnoreCase("version") && Integer.parseInt(a5.getAttributeValue(a14)) > 0) {
                                I.warning("attempting to parse get.annotation version higher than 0");
                            }
                            n = ++a14;
                        }
                    } else if (!a12 && a42.equalsIgnoreCase("book")) {
                        a12 = true;
                    } else {
                        I.error("Ignoring unknown tag parsing respose for updated LPR: " + a42);
                    }
                } else if (a13 == 3 && (a42 = a5.getName()).equalsIgnoreCase("book")) {
                    a12 = false;
                }
                a13 = a5.next();
            }
            Object var17_24 = null;
            if (a11 != null) {
                a11.close();
            }
        }
        catch (XmlPullParserException a17) {
            I.error("Unable to parse response XML from server for updated LPR.", (Throwable)a17);
            UpdatedLpr a42 = null;
            Object var17_25 = null;
            if (a11 != null) {
                a11.close();
            }
            return a42;
        }
        catch (IOException a18) {
            try {
                I.error("IOException when parsing response XML from server for updated LPR.", (Throwable)a18);
                UpdatedLpr a42 = null;
                Object var17_26 = null;
                if (a11 != null) {
                    a11.close();
                }
                return a42;
            }
            catch (Throwable throwable) {
                Object var17_27 = null;
                if (a11 != null) {
                    a11.close();
                }
                throw throwable;
            }
        }
        if (a6 == null) {
            I.error("Missing part of payload in LPR udpate. Response was: " + a);
            return null;
        }
        if (a10 == null) {
            I.error("Missing part of payload in LPR udpate. Response was: " + a);
            a10 = new Long(new Date().getTime()).toString();
            I.error("Because time was not reported with LPR, setting it to current time: " + a10);
        }
        if (a9 == null) {
            a9 = "";
        }
        if (a8 == null) {
            a8 = "";
        }
        if (a7 == null) {
            a7 = "0";
        }
        a5 = F.getCurrentPositionFactory();
        try {
            a42 = a5.createInstance(a6, F.getCurrentBook());
        }
        catch (InvalidObjectException a19) {
            I.error("Unable to create position for updated LPR.");
            return null;
        }
        catch (IOException a20) {
            I.error("Unable to create position for updated LPR.");
            return null;
        }
        if (a42.compareTo((Object)F.getCurrentBook().getEndPosition()) > 0) {
            I.error("LPR position is larger than expected, resetting it to end of book. Response was: " + a);
            return null;
        }
        try {
            a3 = Long.parseLong(a10);
            a2 = Long.parseLong(a7);
        }
        catch (NumberFormatException a21) {
            I.error("Unable parse longs for annotation time and local time offset for updated LPR");
            return null;
        }
        return new UpdatedLpr((Position)a42, a3, a2, a8, a9, (ReaderSDK)F);
    }

    private void checkServerAndPostDialog() {
        SyncLPRDialogUtil a;
        if (a.D != null && a.D.isShowing()) {
            return;
        }
        a.D = a.new RetrievingDialog(((BookletContext)F.getActiveContext()).getName(), a.new RetrievingDialogListener());
    }

    public static void showDialog(boolean a) {
        State a2;
        try {
            a2 = F.getCurrentBook().getFreqUpdateBookState();
            if (a2 == null) {
                throw new InvalidSideCarFileException("there was no frequently updated state to read the UpdatedLpr from for the dialog.");
            }
        }
        catch (InvalidSideCarFileException a3) {
            F.postException((ReaderException)a3);
            return;
        }
        UpdatedLpr a4 = (UpdatedLpr)a2.get("updated_lpr");
        if (a4 != null) {
            a2.remove((DataStoreObject)a4);
        }
        int a5 = -1;
        Position a6 = F.getBookNavigator().getCurrentPosition();
        if (a4 != null && a6 != null && a6.compareTo((Object)a4.getPosition()) < 0 && !SyncLPRDialogUtil.isPositionWithinRange(a6, a4.getPosition())) {
            String a7 = a6.getUIString();
            String a8 = a4.getPosition().getUIString();
            String a9 = a4.getSourceDeviceName();
            if (a9 == null) {
                a5 = 0;
            } else {
                Date a10 = new Date(a4.getTime());
                int a11 = SyncLPRDialogUtil.getLprDaysDiff(a4, new Date());
                StringBuffer a12 = new StringBuffer("sync.lpr.dialog.perform.sync.message");
                Object[] a13 = new Object[]{a7, "", a8, "", a9, a10, new Integer(a11), a10};
                if (a9.length() == 0) {
                    a12.append(".nodevice");
                }
                if (SyncLPRDialogUtil.isPageNumberSupported()) {
                    Object a14;
                    Object a15;
                    a13[0] = F.getPageNumberManager().getPageLabelForFirstPosition((ByteOffsetBasedPosition)a6);
                    a13[2] = F.getPageNumberManager().getPageLabelForFirstPosition((ByteOffsetBasedPosition)a4.getPosition());
                    Integer a16 = null;
                    Integer a17 = null;
                    if (((String)a13[0]).length() == 0 || ((String)a13[2]).length() == 0) {
                        a15 = new Double(Math.max(0.01, a6.getPercentage()));
                        a14 = new Double(Math.max(0.01, a4.getPosition().getPercentage()));
                        a16 = new Integer((int)((Double)a15 * 100.0));
                        a17 = new Integer((int)((Double)a14 * 100.0));
                        a13[1] = a15;
                        a13[3] = a14;
                    }
                    a15 = ((String)a13[0]).length() == 0 ? ".percent" : ".page";
                    a14 = ((String)a13[2]).length() == 0 ? ".percent" : ".page";
                    a12.append((String)a15).append((String)a14);
                    if (((String)a15).equals(a14) && (((String)a15).equals(".percent") && a16.equals(a17) || ((String)a15).equals(".page") && a13[0].equals(a13[2]))) {
                        a12.append(".minor");
                    }
                } else {
                    a12.append(".location");
                }
                a5 = ConfirmationDialog.showDialog((String)((BookletContext)F.getActiveContext()).getName(), (String)SyncLPRDialogUtil.formatSyncMessage(a12.toString(), a13, SyncLPRDialogUtil.getLprTimeZone(a4)), (String)L.getString("sync.lpr.dialog.perform.sync.title"), (int)1);
            }
        } else if (a) {
            ConfirmationDialog.showDialog((String)((BookletContext)F.getActiveContext()).getName(), (String)L.getString("sync.lpr.dialog.no.perform.sync.message"), (String)L.getString("sync.lpr.dialog.no.perform.sync.title"), (int)0);
        }
        if (a4 != null) {
            if (a5 == 0) {
                F.getUI().getUIContext().recordHistory();
                F.getBookNavigator().goTo(a4.getPosition());
                F.getUI().generateUserGoToEvent();
                F.getUI().showBook();
            }
        } else {
            I.error("UpdatedLpr was removed from State since dialog was posted!");
        }
    }

    private static boolean isPageNumberSupported() {
        BookController a = F.getBookController();
        if (a == null) {
            I.error("BookController is null!");
            return false;
        }
        return a.getCapabilities().isPageNumbersAvailable();
    }

    private static boolean isPositionWithinRange(Position a, Position a2) {
        int a3 = Math.abs(a.getIntegerOffset() - a2.getIntegerOffset());
        if (Log.isDebugOn()) {
            I.debug("locDiff = " + a3 + ",min=" + 10);
        }
        return a3 <= 10;
    }

    private static String formatSyncMessage(String a, Object[] a2, TimeZone a3) {
        int a4;
        MessageFormat a5 = new MessageFormat(L.getString(a));
        double[] a6 = (double[])L.getObject("sync.lpr.dialog.perform.sync.date.choice.limits");
        String[] a7 = (String[])L.getObject("sync.lpr.dialog.perform.sync.date.choice.formats");
        ChoiceFormat a8 = new ChoiceFormat(a6, a7);
        a5.setFormatByArgumentIndex(6, a8);
        Format[] a9 = a5.getFormatsByArgumentIndex();
        int n = a4 = 0;
        while (n < a9.length) {
            if (a9[a4] instanceof DateFormat) {
                DateFormat a10 = (DateFormat)a9[a4];
                a10.setTimeZone(a3);
                a5.setFormatByArgumentIndex(a4, a10);
            }
            n = ++a4;
        }
        return a5.format(a2, new StringBuffer(), (FieldPosition)null).toString();
    }

    private static int getLprDaysDiff(UpdatedLpr a, Date a2) {
        Calendar a3 = Calendar.getInstance();
        a3.setTime(a2);
        int a4 = a3.get(20);
        a3.setTime(new Date(a.getTime()));
        return a3.get(20) - a4;
    }

    private static TimeZone getLprTimeZone(UpdatedLpr a) {
        return TimeZone.getTimeZone(TimeZoneUtil.getOffsetZoneId((long)(a.getLocalTimeOffset() * 60000L), (boolean)false));
    }

    public ReaderAction getSyncLPRAction(String a) {
        SyncLPRDialogUtil a2;
        LPRAction a3 = a2.new LPRAction(a);
        a3.checkAndSetEnabled();
        return a3;
    }

    private class RetrievingDialog
    extends ConfirmationDialog {
        private GetLPRThread lprThread;
        private boolean bCancel;

        public RetrievingDialog(String a, WindowListener a2) {
            RetrievingDialog a3;
            super(a);
            a3.lprThread = null;
            a3.bCancel = false;
            a3.setTitleBarEnabled(true);
            a3.setTitle(L.getString("sync.lpr.dialog.perform.sync.title"));
            a3.setMessage(L.getString("sync.lpr.dialog.perform.sync.waiting"));
            a3.getCommandBar().setButtonWidthPreserved(true);
            a3.getCommandBar().add((Action)a3.new CloseAction());
            a3.setDialogBounds(a3.getPreferredDialogBounds());
            if (a2 != null) {
                a3.getFrame().addWindowListener(a2);
            }
            a3.postDialog(false);
            a3.invokeLPR();
        }

        public boolean isCanceled() {
            RetrievingDialog a;
            return a.bCancel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void closeDialog() {
            RetrievingDialog a;
            super.closeDialog();
            if (a.lprThread != null && !a.lprThread.B) {
                I.info("Canceling sync background thread.");
                Thread a2 = a.lprThread.getThread();
                GetLPRThread getLPRThread = a.lprThread;
                synchronized (getLPRThread) {
                    a.lprThread = null;
                }
                a2.interrupt();
            }
        }

        private void invokeLPR() {
            RetrievingDialog a;
            if (a.lprThread == null) {
                EventQueue.invokeLater(new Runnable(){
                    {
                        1 a;
                    }

                    public void run() {
                        1 a;
                        a.RetrievingDialog.this.lprThread = new GetLPRThread(a.getClass().getName());
                        a.RetrievingDialog.this.lprThread.start();
                    }
                });
            }
        }

        private class GetLPRThread
        extends ThreadPoolRunnable {
            boolean B;

            protected GetLPRThread(String a) {
                GetLPRThread a2;
                super(a);
                a2.B = false;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                GetLPRThread a;
                if (!SyncLPRDialogUtil.this.getLPRFromServer((Booklet)F.getActiveBooklet())) {
                    I.info("Cannot get LPR from server.");
                    a.B = true;
                    GetLPRThread getLPRThread = a.RetrievingDialog.this.lprThread;
                    synchronized (getLPRThread) {
                        if (a.RetrievingDialog.this.lprThread != null) {
                            a.RetrievingDialog.this.bCancel = true;
                            a.RetrievingDialog.this.closeDialog();
                            I.info("Cannot retrieve LPR from Server");
                            F.postException(new SyncLPRException());
                        }
                    }
                } else {
                    I.info("Get LPR from server.");
                    a.B = true;
                    a.RetrievingDialog.this.closeDialog();
                }
            }
        }

        private class CloseAction
        extends AbstractAction {
            public CloseAction() {
                CloseAction a;
                super(L.getString("sync.lpr.dialog.button.close.text"));
                a.setEnabled(true);
            }

            public void actionPerformed(ActionEvent a) {
                CloseAction a2;
                a2.RetrievingDialog.this.bCancel = true;
                a2.RetrievingDialog.this.closeDialog();
            }
        }
    }

    private class RetrievingDialogListener
    implements WindowListener {
        private RetrievingDialogListener() {
            RetrievingDialogListener a;
        }

        public void windowActivated(WindowEvent a) {
        }

        public void windowClosed(WindowEvent a) {
            RetrievingDialogListener a2;
            if (!a2.SyncLPRDialogUtil.this.D.isCanceled()) {
                SyncLPRDialogUtil.showDialog(true);
            }
        }

        public void windowClosing(WindowEvent a) {
        }

        public void windowDeactivated(WindowEvent a) {
        }

        public void windowDeiconified(WindowEvent a) {
        }

        public void windowIconified(WindowEvent a) {
        }

        public void windowOpened(WindowEvent a) {
        }
    }

    public class LPRAction
    extends ReaderAction {
        public LPRAction(String a) {
            LPRAction a2;
            super(a);
        }

        public void actionPerformed(ActionEvent a) {
            LPRAction a2;
            LprShownBookHandler.cancelLprTimer();
            a2.SyncLPRDialogUtil.this.checkServerAndPostDialog();
        }

        public int getPriority() {
            return 130;
        }

        public int getType() {
            return 2;
        }

        public void checkAndSetEnabled() {
            LPRAction a;
            BookMetadata a2 = F.getCurrentBook().getMetadata();
            String a3 = a2.getASIN();
            String a4 = a2.getCdeType();
            ReaderUI a5 = F.getUI();
            if (a3 == null || a3.length() == 0 || a4 == null || a5.getUIContext() != a5.getBookContentPanel() || a2.isSample()) {
                a.setEnabled(false);
            } else {
                a.setEnabled(true);
            }
        }
    }

    public class SyncLPRException
    extends ReaderException {
        public SyncLPRException() {
            SyncLPRException a;
            super(196656);
        }

        public SyncLPRException(String a) {
            SyncLPRException a2;
            super(196656, a);
        }
    }
}

