/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ebook.booklet.reader.impl.ui;

import com.amazon.agui.swing.event.GestureDispatcher;
import com.amazon.ebook.booklet.reader.sdk.content.Book;
import com.amazon.ebook.booklet.reader.sdk.content.Element;
import com.amazon.ebook.booklet.reader.sdk.content.ElementActionHandler;
import com.amazon.ebook.booklet.reader.sdk.content.Interval;
import com.amazon.ebook.booklet.reader.sdk.content.Position;
import com.amazon.ebook.booklet.reader.sdk.content.ScreenInfo;
import com.amazon.ebook.booklet.reader.sdk.content.Viewport;
import com.amazon.ebook.booklet.reader.sdk.content.WordEntry;
import com.amazon.ebook.booklet.reader.sdk.content.WordIterator;
import com.amazon.ebook.booklet.reader.sdk.content.WordIteratorFactory;
import com.amazon.ebook.booklet.reader.sdk.content.annotation.Annotation;
import com.amazon.ebook.booklet.reader.sdk.ui.ReaderUI;
import com.amazon.ebook.booklet.reader.sdk.ui.SnippetWidget;
import com.amazon.ebook.booklet.reader.utils.TextUtils;
import com.amazon.ebook.booklet.reader.utils.UIUtils;
import com.amazon.ebook.util.text.LanguageTag;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.ResourceBundle;

public class SnippetWidgetImpl
extends SnippetWidget {
    private ReaderUI readerUI;
    private SnippetScreenInfo snippetScreenInfo;
    private int[] fontSizes;
    private int[] linespacings;
    private int gap;
    private int margin;
    private int direction;
    private int labelHeight;
    private Font labelFont;
    private Element[] elements;
    private Position startPosition;
    private Position endPosition;

    public SnippetWidgetImpl(ReaderUI a, Viewport a2, WordIteratorFactory a3) {
        super(a2, a3);
        SnippetWidgetImpl a4;
        a4.readerUI = a;
        a4.snippetScreenInfo = a4.new SnippetScreenInfo();
        ResourceBundle a5 = ResourceBundle.getBundle("com.amazon.ebook.booklet.reader.resources.ReaderResources");
        a4.fontSizes = UIUtils.flatten((int[][])((int[][])a5.getObject("font.menu.size.list")));
        a4.linespacings = (int[])a5.getObject("font.default.linespacing.values");
        a4.gap = (Integer)a5.getObject("snippet.widget.gap");
        a4.margin = (Integer)a5.getObject("snippet.widget.margin");
        a4.labelHeight = (Integer)a5.getObject("snippet.widget.label.height");
        a4.labelFont = (Font)a5.getObject("snippet.widget.font");
        a4.addMouseListener((MouseListener)new GestureDispatcher());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintComponent(Graphics a) {
        SnippetWidgetImpl a2;
        super.paintComponent(a);
        WordIterator a3 = a2.getSnippetIterator();
        if (a3 == null) {
            return;
        }
        try {
            WordEntry a4;
            ArrayList<SnippetElement> a5 = null;
            Book a6 = a2.snippetScreenInfo.getBook();
            if (a6 != null) {
                a5 = new ArrayList<SnippetElement>();
                a2.direction = a6.getReadingDirection() == LanguageTag.TextDirection.RIGHT_TO_LEFT ? 2 : 1;
            } else {
                a2.direction = 1;
            }
            int a7 = a2.readerUI.getContentLeftMargin();
            int a8 = a2.readerUI.getContentRightMargin();
            int a9 = a2.getWidth() - a8;
            int a10 = a2.getHeight();
            int a11 = a7;
            int a12 = a2.labelHeight;
            a.setFont(a2.labelFont);
            String a13 = TextUtils.getShortText((String)a2.getLabel(), (FontMetrics)a.getFontMetrics(), (int)a9);
            a.drawString(a13, a2.margin, a12);
            a.setFont(new Font(a2.readerUI.getFontFamily(), 0, a2.fontSizes[a2.readerUI.getFontSize()]));
            FontMetrics a14 = a.getFontMetrics();
            int a15 = a14.getAscent();
            int a16 = a14.getDescent();
            int a17 = a14.getLeading();
            int a18 = 2 * a16 + a17 + a15 + a2.linespacings[a2.readerUI.getLineSpacing()];
            int a19 = a16 + a17 + a15;
            int a20 = a3.isSpaceIncluded() ? 0 : a14.stringWidth(" ");
            a12 += a2.gap + a17 + a15;
            a10 -= a16;
            a2.startPosition = null;
            a2.endPosition = null;
            int a21 = 0;
            WordIterator wordIterator = a3;
            while (wordIterator.hasNext()) {
                a4 = a3.next();
                String a22 = a4.B;
                int a23 = a14.stringWidth(a22);
                if (a11 + a23 > a9) {
                    a11 = a7;
                    a12 += a18;
                    ++a21;
                }
                if (a12 > a10) break;
                a.drawString(a22, a11, a12);
                if (a6 != null) {
                    Object a24;
                    a2.endPosition = a4.D;
                    if (a2.startPosition == null) {
                        a24 = a2.viewport.getStartPosition();
                        if (a2.endPosition.compareTo(a24) > 0) {
                            a2.endPosition = a24;
                        }
                        a2.startPosition = a2.endPosition;
                    }
                    a24 = new Rectangle(a11, a12 - a19, a23, a18);
                    SnippetElement a25 = a2.new SnippetElement(a2.endPosition, (Rectangle)a24, a21, a22);
                    a5.add(a25);
                }
                a11 += a23 + a20;
                wordIterator = a3;
            }
            if (a6 != null) {
                a2.elements = a5.toArray(new Element[a5.size()]);
                a4 = (Annotation)a2.getClientProperty("annotation");
                a2.readerUI.getCurrentPageDecorator().decoratePage((ScreenInfo)a2.snippetScreenInfo, (Graphics2D)a, a2.getBounds(), (Annotation)a4);
            }
            Object var26_25 = null;
        }
        catch (Throwable throwable) {
            Object var26_26 = null;
            a3.close();
            throw throwable;
        }
        a3.close();
    }

    public void reset() {
        a.elements = null;
        a.startPosition = null;
        a.endPosition = null;
    }

    class SnippetElement
    implements Element {
        Interval m;
        Rectangle h;
        int A;
        String B;

        public SnippetElement(Position a, Rectangle a2, int a3, String a4) {
            SnippetElement a5;
            a5.m = Interval.create((Position)a, (Position)a);
            a5.h = a2;
            a5.A = a3;
            a5.B = a4;
        }

        public Rectangle getBounds(int a) {
            SnippetElement a2;
            return a2.h;
        }

        public int getBoundsCount() {
            return 1;
        }

        public int getBoundsRunID(int a) {
            SnippetElement a2;
            return a2.A;
        }

        public int getPrimaryDirection() {
            SnippetElement a;
            return a.SnippetWidgetImpl.this.direction;
        }

        public int getSecondaryDirection() {
            return 0;
        }

        public Position getEndPosition() {
            SnippetElement a;
            return a.m.getEndPosition();
        }

        public Position getStartPosition() {
            SnippetElement a;
            return a.m.getStartPosition();
        }

        public Rectangle getTouchBounds(int a) {
            return null;
        }

        public String getWord() {
            SnippetElement a;
            return a.B;
        }

        public boolean isSelectable() {
            SnippetElement a;
            return a.getWord() != null && a.getWord().length() > 0;
        }

        public ElementActionHandler getActionHandler(int a) {
            return null;
        }

        public boolean supportsAction(int a) {
            return false;
        }

        public Interval getInterval() {
            SnippetElement a;
            return a.m;
        }

        public int compareTo(Object a) {
            SnippetElement a2;
            return a2.getInterval().compareTo((Object)((Interval.HasInterval)a).getInterval());
        }
    }

    class SnippetScreenInfo
    extends ScreenInfo
    implements Viewport {
        SnippetScreenInfo() {
            SnippetScreenInfo a;
        }

        public Element[] getElements() {
            SnippetScreenInfo a;
            return a.SnippetWidgetImpl.this.elements;
        }

        public Viewport getViewport() {
            SnippetScreenInfo a;
            return a;
        }

        public Book getBook() {
            SnippetScreenInfo a;
            Viewport a2 = a.SnippetWidgetImpl.this.viewport;
            return a2 == null ? null : a2.getBook();
        }

        public Position getEndPosition() {
            SnippetScreenInfo a;
            return a.SnippetWidgetImpl.this.endPosition;
        }

        public int getHeight() {
            SnippetScreenInfo a;
            return a.SnippetWidgetImpl.this.getHeight();
        }

        public Position getStartPosition() {
            SnippetScreenInfo a;
            return a.SnippetWidgetImpl.this.startPosition;
        }

        public Position getFirstElementStartPosition() {
            SnippetScreenInfo a;
            return a.getStartPosition();
        }

        public int getWidth() {
            SnippetScreenInfo a;
            return a.SnippetWidgetImpl.this.getWidth();
        }

        public boolean isPositionWithinView(Position a) {
            return true;
        }

        public void clearDirtyFlags() {
        }

        public int[] getHardPageNumber() {
            return null;
        }

        public String[] getPageName() {
            return null;
        }
    }
}

