/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ebook.booklet.reader.impl.ui;

import com.amazon.agui.swing.CaretDialog;
import com.amazon.agui.swing.CommandBar;
import com.amazon.agui.swing.ConfirmationDialog;
import com.amazon.agui.swing.KDialog;
import com.amazon.ebook.booklet.reader.impl.ContentPanel;
import com.amazon.ebook.booklet.reader.impl.annotation.personal.Highlight;
import com.amazon.ebook.booklet.reader.impl.annotation.personal.Note;
import com.amazon.ebook.booklet.reader.impl.ui.NoteEditorDialog;
import com.amazon.ebook.booklet.reader.impl.ui.NotesCard;
import com.amazon.ebook.booklet.reader.sdk.BookNavigator;
import com.amazon.ebook.booklet.reader.sdk.ReaderSDK;
import com.amazon.ebook.booklet.reader.sdk.content.Book;
import com.amazon.ebook.booklet.reader.sdk.content.BookMetadata;
import com.amazon.ebook.booklet.reader.sdk.content.Element;
import com.amazon.ebook.booklet.reader.sdk.content.Interval;
import com.amazon.ebook.booklet.reader.sdk.content.Position;
import com.amazon.ebook.booklet.reader.sdk.content.ScreenInfo;
import com.amazon.ebook.booklet.reader.sdk.content.Viewport;
import com.amazon.ebook.booklet.reader.sdk.content.ZoomViewport;
import com.amazon.ebook.booklet.reader.sdk.content.annotation.Annotation;
import com.amazon.ebook.booklet.reader.sdk.content.annotation.AnnotationException;
import com.amazon.ebook.booklet.reader.sdk.content.annotation.AnnotationManager;
import com.amazon.ebook.booklet.reader.sdk.event.CloseBookHandler;
import com.amazon.ebook.booklet.reader.sdk.event.EventHandler;
import com.amazon.ebook.booklet.reader.sdk.ui.ReaderUIContext;
import com.amazon.ebook.booklet.reader.sdk.ui.SelectionCardProvider;
import com.amazon.ebook.booklet.reader.sdk.ui.SelectionDialog;
import com.amazon.ebook.booklet.reader.utils.UIUtils;
import com.amazon.ebook.util.log.Log;
import com.amazon.kindle.booklet.BookletContext;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.WindowListener;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class SelectionDialogImpl
extends CaretDialog
implements SelectionDialog,
CloseBookHandler {
    private static final Log LOG = Log.getInstance((String)"SelectionDialog");
    private ReaderSDK readerSDK;
    private ResourceBundle rb;
    private HighlightAction highlightAction;
    private NoteAction noteAction;
    private ShareAction shareAction;
    private JPanel moreCard;
    private LinkedList cards;
    private Element currentElement;
    private Element selectStart;
    private Element selectEnd;
    private WindowListener windowListener;
    private JFrame currentFrame;
    private Annotation annotation;

    public SelectionDialogImpl(ReaderSDK a) {
        super(null, false);
        SelectionDialogImpl a2;
        a2.readerSDK = a;
        a2.rb = ResourceBundle.getBundle("com.amazon.ebook.booklet.reader.resources.ReaderResources");
        a2.setAutoCenteredEnabled(false);
        a2.getContentPane().setLayout(new BorderLayout());
        a2.cards = new LinkedList();
        CommandBar a3 = a2.getCommandBar();
        a3.setButtonWidthPreserved(false);
        a2.highlightAction = a2.new HighlightAction();
        a3.add((Action)a2.highlightAction);
        a2.noteAction = a2.new NoteAction();
        a3.add((Action)a2.noteAction);
        a2.shareAction = a2.new ShareAction();
        a3.add((Action)a2.shareAction);
        a2.moreCard = new JPanel();
        a2.moreCard.setLayout(new BoxLayout(a2.moreCard, 1));
        a2.readerSDK.getRegistry().registerHandler((EventHandler)a2);
    }

    public boolean selectionUpdated(ScreenInfo a) {
        int a2;
        SelectionDialogImpl a3;
        BookNavigator a4 = a3.readerSDK.getBookNavigator();
        a3.selectStart = a4.getSelectionStart();
        a3.selectEnd = a4.getSelectionEnd();
        if (a3.selectStart == null || a3.selectEnd == null) {
            return false;
        }
        a3.currentElement = a.findFirstElementInRange(a4.getCurrentPosition(), a4.getCurrentPosition());
        Iterator a5 = a3.readerSDK.getAnnotationManager().getAnnotationsInRange(a.getViewport().getBook(), a3.selectStart.getStartPosition(), a3.selectEnd.getEndPosition()).iterator();
        boolean a6 = true;
        Note a7 = null;
        a3.annotation = null;
        while (a5.hasNext()) {
            Annotation a8 = (Annotation)a5.next();
            if (a8 instanceof Highlight) {
                if (a8.getStartPosition().compareTo((Object)a3.selectStart.getStartPosition()) > 0 || a8.getEndPosition().compareTo((Object)a3.selectEnd.getEndPosition()) < 0) continue;
                a6 = false;
                a3.annotation = a8;
                continue;
            }
            if (!(a8 instanceof Note) || a8.getEndPosition().compareTo((Object)a3.selectEnd.getEndPosition()) < 0) continue;
            a7 = (Note)a8;
        }
        a3.highlightAction.setAddMode(a6);
        a3.noteAction.setNoteToView(a7);
        a3.moreCard.removeAll();
        int a9 = 0;
        int n = a2 = 0;
        while (n < a3.cards.size()) {
            int a10;
            SelectionCardProvider a11 = (SelectionCardProvider)a3.cards.get(a2);
            a11.update(a3.readerSDK);
            int a12 = a11.getCardCount();
            int n2 = a10 = 0;
            while (n2 < a12) {
                String a13 = a11.getCardTitle(a10);
                if (a13 != null) {
                    JButton a14 = new JButton(a3.new SelectCardAction(a13, a9));
                    a3.moreCard.add(a14);
                }
                ++a9;
                n2 = ++a10;
            }
            n = ++a2;
        }
        a3.getContentPane().removeAll();
        a3.moreCard.setVisible(false);
        List a22 = a4.getCurrentZoomableElements();
        if (a22 == null || a22.size() == 0) {
            a3.selectFirstCardThatHasResults();
        }
        return true;
    }

    public void removeTrackedWindowListener() {
        SelectionDialogImpl a;
        if (a.currentFrame != null) {
            a.currentFrame.removeWindowListener(a.windowListener);
            a.currentFrame = null;
        }
    }

    public void postDialog(Element a, boolean a2, WindowListener a3) {
        Book a4;
        SelectionDialogImpl a5;
        String a6 = ((BookletContext)a5.readerSDK.getActiveContext()).getName();
        String a7 = a5.getAppId();
        if (a7 != null && !a7.equals(a6)) {
            a5.closeDialog();
        }
        a5.setAppId(a6);
        a5.removeTrackedWindowListener();
        a5.currentFrame = a5.getFrame();
        a5.currentFrame.addWindowListener(a3);
        a5.windowListener = a3;
        a5.currentElement = a;
        if (!a5.readerSDK.getBookNavigator().hasSelection()) {
            return;
        }
        JComponent a8 = a5.readerSDK.getUI().getReaderPane();
        Rectangle a9 = a8.getBounds();
        Insets a10 = (Insets)a5.rb.getObject("select.insets");
        int a11 = a9.width - a10.left - a10.right;
        int a12 = a5.moreCard.isVisible() ? a9.height / 2 - a10.top - a10.bottom : (Integer)a5.rb.getObject("select.commandbar.height");
        Dimension a13 = new Dimension(a11, a12);
        Rectangle a14 = a5.currentElement.getBounds(0);
        Viewport a15 = a5.readerSDK.getBookNavigator().getViewport();
        int a16 = 0;
        int a17 = 0;
        if (a15 != null && a15 instanceof ZoomViewport) {
            ZoomViewport a18 = (ZoomViewport)a15;
            a16 = a18.getXOffset();
            a17 = a18.getYOffset();
        }
        int a19 = 0;
        if (a5.currentElement.supportsAction(4)) {
            a19 = 7;
        }
        a14 = new Rectangle(a14.x - a10.left - a16, a14.y - a17 - a19, a14.width, a14.height + 2 * a19);
        ReaderUIContext a20 = a5.readerSDK.getUI().getUIContext();
        UIUtils.setCaretDialog((CaretDialog)a5, (Dimension)a13, (Container)a8, (Container)a5.readerSDK.getUI().getBookContentPanel(), (Rectangle)a14, (boolean)true, (boolean)a20.isChromePersistent());
        boolean a21 = false;
        if (!(a5.highlightAction.isEnabled() || a5.noteAction.isEnabled() || a5.shareAction.isEnabled() || a20.showDialogWithNoActions())) {
            if (!a5.moreCard.isVisible()) {
                a5.getCloseAction().actionPerformed(null);
                if (!((ContentPanel)((Object)a5.readerSDK.getUI().getBookContentPanel())).isDialogShowing()) {
                    a20.notifyError(1);
                }
                return;
            }
            a21 = true;
        }
        if ((a4 = a5.readerSDK.getCurrentBook()) != null && a4.getMetadata() != null && a4.getMetadata().isSample()) {
            if (a5.getContentPane().getComponentCount() == 0) {
                ResourceBundle a22 = ResourceBundle.getBundle("com.amazon.ebook.booklet.reader.impl.ui.resources.UIResources");
                String a23 = a22.getString("annotation.disabled.reason.samplebook");
                String a24 = a22.getString("annotation.disabled.alert.title");
                ConfirmationDialog.showDialog((String)((BookletContext)a5.readerSDK.getActiveContext()).getName(), (String)a23, (String)a24, (int)4);
                a5.readerSDK.getBookNavigator().clearSelection();
                a20.repaint();
                return;
            }
            a21 = true;
        }
        if (a21) {
            a5.setCommandBarPosition(-1);
            ((JComponent)a5.getContentPane()).setBorder((Border)a5.rb.getObject("select.no.commandbar.border"));
        } else {
            ((JComponent)a5.getContentPane()).setBorder(null);
        }
        if (a2) {
            a5.postDialog();
        } else {
            a5.getFrame().setBounds(a5.getDialogBounds());
        }
    }

    private void selectFirstCardThatHasResults() {
        SelectionDialogImpl a;
        int a2;
        JComponent a3 = null;
        int n = a2 = 0;
        while (n < a.cards.size()) {
            int a4;
            SelectionCardProvider a5 = (SelectionCardProvider)a.cards.get(a2);
            int a6 = a5.getCardCount();
            int n2 = a4 = 0;
            while (n2 < a6) {
                if (a5.canBeShownAsDefaultCard(a4)) {
                    JComponent a7 = a5.getCard(a4);
                    a.getContentPane().add(a7);
                    a.moreCard.setVisible(true);
                    a3 = null;
                    return;
                }
                n2 = ++a4;
            }
            JComponent a22 = a5.getDefaultCard();
            if (a22 != null) {
                a3 = a22;
            }
            n = ++a2;
        }
        if (a3 != null && a.selectStart.getStartPosition().equals((Object)a.selectEnd.getStartPosition())) {
            a.getContentPane().add(a3);
            a.moreCard.setVisible(true);
            return;
        }
    }

    private JComponent selectCard(int a) {
        int a2;
        SelectionDialogImpl a3;
        a3.getContentPane().removeAll();
        a3.moreCard.setVisible(false);
        int n = a2 = 0;
        SelectionDialogImpl selectionDialogImpl = a3;
        while (n < selectionDialogImpl.cards.size() && a >= 0) {
            SelectionCardProvider a4 = (SelectionCardProvider)a3.cards.get(a2);
            int a5 = a4.getCardCount();
            if (a < a5) {
                return a4.getCard(a);
            }
            a -= a5;
            n = ++a2;
            selectionDialogImpl = a3;
        }
        return null;
    }

    private void checkAndSetEnabled() {
        SelectionDialogImpl a;
        if (a.readerSDK == null || a.readerSDK.getCurrentBook() == null) {
            return;
        }
        BookMetadata a2 = a.readerSDK.getCurrentBook().getMetadata();
        if (a2 == null) {
            return;
        }
        boolean a3 = a.readerSDK.getAnnotationManager().getSavesEnabled();
        a.highlightAction.setEnabled(a2.isAnnotationEnabled() && a3);
        a.noteAction.setEnabled(a2.isAnnotationEnabled() && a3);
        a.shareAction.setEnabled(a.readerSDK.getSharingManager().isSharingEnabled(a.readerSDK.getCurrentBook()));
    }

    public void doViewNotesAction(Element a) {
        SelectionDialogImpl a2;
        a2.currentElement = a;
        BookNavigator a3 = a2.readerSDK.getBookNavigator();
        List a4 = a2.readerSDK.getAnnotationManager().getAnnotationsInRange(a2.readerSDK.getCurrentBook(), a3.getSelectionEnd().getStartPosition(), a3.getSelectionEnd().getEndPosition());
        Iterator a5 = a4.iterator();
        while (a5.hasNext()) {
            Annotation a6 = (Annotation)a5.next();
            if (!(a6 instanceof Note)) continue;
            a2.annotation = a6;
        }
        a2.noteAction.setNoteToView((Note)a2.annotation);
        a2.noteAction.initialDialogOpen = true;
        a2.moreCard.setVisible(false);
        a2.noteAction.actionPerformed(null);
    }

    public void registerNoteCard(SelectionCardProvider a) {
        SelectionDialogImpl a2;
        int a3;
        int n = a3 = 0;
        while (n < a2.cards.size()) {
            SelectionCardProvider a4 = (SelectionCardProvider)a2.cards.get(a3);
            if (a4 == a) {
                return;
            }
            if (a4.getProviderPriority() > a.getProviderPriority()) {
                a2.cards.add(a3, a);
                return;
            }
            n = ++a3;
        }
        a2.cards.add(a);
    }

    public boolean deregisterNoteCard(SelectionCardProvider a) {
        SelectionDialogImpl a2;
        return a2.cards.remove(a);
    }

    public void dismiss() {
        SelectionDialogImpl a;
        a.getCloseAction().actionPerformed(null);
        if (a.readerSDK.getUI().getBookContentPanel() instanceof ContentPanel) {
            ((ContentPanel)((Object)a.readerSDK.getUI().getBookContentPanel())).hideAllDialogs();
        }
    }

    public void closeBookEvent(Book a, boolean a2) {
        a.currentElement = null;
        a.selectStart = null;
        a.selectEnd = null;
    }

    private class ShareAction
    extends AbstractAction {
        public ShareAction() {
            ShareAction a;
            super(ResourceBundle.getBundle("com.amazon.ebook.booklet.reader.plugin.notesandmarks.resources.AnnotationResources").getString("annotation.dialog.button.share"));
        }

        public void actionPerformed(ActionEvent a) {
            ShareAction a2;
            a2.SelectionDialogImpl.this.dismiss();
            boolean a3 = a2.SelectionDialogImpl.this.annotation == null;
            Interval a4 = a3 ? Interval.create((Position)a2.SelectionDialogImpl.this.selectStart.getStartPosition().convertToSerializablePosition(), (Position)a2.SelectionDialogImpl.this.selectEnd.getEndPosition().convertToSerializablePosition()) : a2.SelectionDialogImpl.this.annotation.getInterval();
            a2.SelectionDialogImpl.this.readerSDK.getSharingManager().shareBookText(a2.SelectionDialogImpl.this.readerSDK.getCurrentBook(), a4, a3, false, a2.SelectionDialogImpl.this.readerSDK.getAnnotationManager());
        }
    }

    private class SelectCardAction
    extends AbstractAction {
        private int index;

        public SelectCardAction(String a, int a2) {
            SelectCardAction a3;
            super(a);
            a3.index = a2;
        }

        public void actionPerformed(ActionEvent a) {
            SelectCardAction a2;
            JComponent a3 = a2.SelectionDialogImpl.this.selectCard(a2.index);
            if (a3 == null) {
                return;
            }
            if (a3 instanceof KDialog) {
                final KDialog a4 = (KDialog)a3;
                a2.SelectionDialogImpl.this.removeTrackedWindowListener();
                a2.SelectionDialogImpl.this.currentFrame = a4.getFrame();
                a2.SelectionDialogImpl.this.currentFrame.addWindowListener(a2.SelectionDialogImpl.this.windowListener);
                a2.SelectionDialogImpl.this.dismiss();
                a2.SelectionDialogImpl.this.readerSDK.invokeLater(new Runnable(){
                    {
                        1 a;
                    }

                    public void run() {
                        1 a;
                        a.a4.postDialog();
                    }
                });
            } else {
                Container a5 = a2.SelectionDialogImpl.this.getContentPane();
                a5.add(a3);
                a2.SelectionDialogImpl.this.moreCard.setVisible(true);
                a5.validate();
                a5.repaint();
                a2.SelectionDialogImpl.this.getFrame().repaint();
                a2.SelectionDialogImpl.this.readerSDK.invokeLater(new Runnable(){
                    {
                        2 a;
                    }

                    public void run() {
                        2 a;
                        SelectionDialogImpl.this.readerSDK.getBookNavigator().selectBegin(SelectionDialogImpl.this.selectStart, SelectionDialogImpl.this.selectStart);
                        SelectionDialogImpl.this.readerSDK.getBookNavigator().selectUpdate(SelectionDialogImpl.this.selectEnd, SelectionDialogImpl.this.selectEnd);
                        SelectionDialogImpl.this.postDialog(SelectionDialogImpl.this.currentElement, true, SelectionDialogImpl.this.windowListener);
                    }
                });
            }
        }
    }

    private class HighlightAction
    extends AbstractAction {
        boolean deleteNote;

        public HighlightAction() {
            HighlightAction a;
            super(a.SelectionDialogImpl.this.rb.getString("select.highlight.label"));
            a.deleteNote = false;
            a.SelectionDialogImpl.this.checkAndSetEnabled();
        }

        public void actionPerformed(ActionEvent a) {
            HighlightAction a2;
            a2.SelectionDialogImpl.this.dismiss();
            BookNavigator a3 = a2.SelectionDialogImpl.this.readerSDK.getBookNavigator();
            AnnotationManager a4 = a2.SelectionDialogImpl.this.readerSDK.getAnnotationManager();
            Element a5 = a3.getSelectionStart();
            Element a6 = a3.getSelectionEnd();
            if (a5 == null || a6 == null) {
                LOG.error("Attempting to perform SelectionDialog action on null selection");
                return;
            }
            if (a2.deleteNote) {
                List a7 = a4.getAnnotationsInRange(a2.SelectionDialogImpl.this.readerSDK.getCurrentBook(), a6.getStartPosition(), a6.getEndPosition());
                Iterator a8 = a7.iterator();
                while (a8.hasNext()) {
                    Annotation a9 = (Annotation)a8.next();
                    if (!(a9 instanceof Note)) continue;
                    a4.deleteAnnotation(a9, a2.SelectionDialogImpl.this.readerSDK.getCurrentBook());
                }
                return;
            }
            Position a10 = a5.getStartPosition();
            Position a11 = a6.getEndPosition();
            try {
                Highlight.addOrMergeHighlight(a2.SelectionDialogImpl.this.readerSDK, a4, a10, a11, true);
            }
            catch (AnnotationException a12) {
                LOG.error("Could not create highlight", (Throwable)a12);
            }
        }

        public void setAddMode(boolean a) {
            HighlightAction a2;
            a2.deleteNote = false;
            if (a) {
                a2.putValue("Name", a2.SelectionDialogImpl.this.rb.getString("select.highlight.label"));
            } else {
                a2.putValue("Name", a2.SelectionDialogImpl.this.rb.getString("select.highlight.remove"));
            }
            a2.SelectionDialogImpl.this.checkAndSetEnabled();
        }

        public void setDeleteNote() {
            HighlightAction a;
            a.deleteNote = true;
            a.putValue("Name", a.SelectionDialogImpl.this.rb.getString("select.note.delete"));
        }
    }

    private class NoteAction
    extends AbstractAction {
        boolean doEditNote;
        Note noteToEdit;
        NotesCard notesCard;
        boolean initialDialogOpen;

        public NoteAction() {
            NoteAction a;
            super(a.SelectionDialogImpl.this.rb.getString("select.note.label"));
            a.notesCard = new NotesCard(a.SelectionDialogImpl.this.readerSDK);
            a.doEditNote = true;
            a.noteToEdit = null;
            a.initialDialogOpen = false;
            a.SelectionDialogImpl.this.checkAndSetEnabled();
        }

        public void actionPerformed(ActionEvent a) {
            NoteAction a2;
            if (a2.doEditNote) {
                LOG.debug("add note");
                BookNavigator a3 = a2.SelectionDialogImpl.this.readerSDK.getBookNavigator();
                NoteEditorDialog a4 = new NoteEditorDialog(a2.SelectionDialogImpl.this.readerSDK, (Interval.HasInterval)a3.getSelectionStart(), (Interval.HasInterval)a3.getSelectionEnd(), a2.noteToEdit);
                a2.SelectionDialogImpl.this.removeTrackedWindowListener();
                a2.SelectionDialogImpl.this.currentFrame = a4.getFrame();
                a2.SelectionDialogImpl.this.currentFrame.addWindowListener(a2.SelectionDialogImpl.this.windowListener);
                a2.SelectionDialogImpl.this.dismiss();
                a4.postDialog();
            } else {
                boolean a5 = !a2.SelectionDialogImpl.this.moreCard.isVisible();
                a2.SelectionDialogImpl.this.moreCard.setVisible(true);
                Container a6 = a2.SelectionDialogImpl.this.getContentPane();
                a6.removeAll();
                a6.add(a2.notesCard);
                a6.validate();
                a6.repaint();
                if (a5) {
                    a2.SelectionDialogImpl.this.postDialog(a2.SelectionDialogImpl.this.currentElement, a2.initialDialogOpen, a2.SelectionDialogImpl.this.windowListener);
                } else {
                    a2.SelectionDialogImpl.this.getFrame().repaint();
                }
                a2.doEditNote = true;
                a2.putValue("Name", a2.SelectionDialogImpl.this.rb.getString("select.note.edit"));
                a2.SelectionDialogImpl.this.highlightAction.setDeleteNote();
            }
        }

        public void setNoteToView(Note a) {
            NoteAction a2;
            a2.doEditNote = a == null;
            a2.initialDialogOpen = false;
            a2.noteToEdit = a;
            a2.notesCard.setNote(a);
            if (a2.doEditNote) {
                a2.putValue("Name", a2.SelectionDialogImpl.this.rb.getString("select.note.label"));
            } else {
                a2.putValue("Name", a2.SelectionDialogImpl.this.rb.getString("select.note.view"));
            }
            a2.SelectionDialogImpl.this.checkAndSetEnabled();
        }
    }
}

