/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ebook.booklet.reader.impl.ui;

import com.amazon.ebook.booklet.reader.impl.ReaderSDKImpl;
import com.amazon.ebook.booklet.reader.sdk.BookNavigator;
import com.amazon.ebook.booklet.reader.sdk.content.Position;
import com.amazon.ebook.booklet.reader.sdk.content.Viewport;
import com.amazon.ebook.booklet.reader.sdk.internal.BookController;
import com.amazon.ebook.booklet.reader.sdk.internal.RendererCapabilities;
import com.amazon.ebook.booklet.reader.sdk.ui.ProgressBar;
import com.amazon.ebook.booklet.reader.sdk.ui.ProgressStatusProvider;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ResourceBundle;

public class ProgressBarImpl
extends ProgressBar {
    protected ResourceBundle rb;
    protected ReaderSDKImpl readerSDK;
    protected Color backgroundColor;
    protected boolean showFullInfo;
    protected int gap;
    protected int margin;
    protected int pageMargin;
    protected int nameMargin;
    protected Dimension infoHeight;
    protected NumberFormat percentFmt;
    protected ProgressStatusProvider progressProvider;

    public ProgressBarImpl(ReaderSDKImpl a, Color a2, boolean a3) {
        ProgressBarImpl a4;
        a4.readerSDK = a;
        a4.backgroundColor = a2;
        a4.showFullInfo = a3;
        a4.rb = ResourceBundle.getBundle("com.amazon.ebook.booklet.reader.resources.ReaderResources");
        a4.setFont((Font)a4.rb.getObject("reader.progressbar.font"));
        a4.infoHeight = new Dimension(a4.getWidth(), (Integer)a4.rb.getObject("reader.progressbar.footer.height"));
        a4.setPreferredSize(a4.infoHeight);
        a4.gap = (Integer)a4.rb.getObject("reader.progressbar.gap");
        a4.margin = (Integer)a4.rb.getObject("reader.progressbar.margin");
        a4.pageMargin = (Integer)a4.rb.getObject("reader.progressbar.page.margin");
        a4.nameMargin = (Integer)a4.rb.getObject("reader.progressbar.name.margin");
        a4.percentFmt = (NumberFormat)a4.rb.getObject("reader.progressbar.percentage");
        a4.progressProvider = null;
    }

    public void paintComponent(Graphics a) {
        ProgressBarImpl a2;
        super.paintComponent(a);
        Color a3 = a.getColor();
        Color a4 = a2.backgroundColor;
        if (a4 == null) {
            a4 = (Color)a2.rb.getObject("reader.progressbar.color.background");
        }
        a.setColor(a4);
        a.fillRect(0, 0, a2.getWidth(), a2.getHeight());
        a.setColor(a3);
        a2.paintProgress(a);
    }

    private void paintProgress(Graphics a) {
        BookController a2;
        ProgressBarImpl a3;
        if (a3.backgroundColor != null) {
            a3.getParent().setBackground(a3.backgroundColor);
        }
        if ((a2 = a3.readerSDK.getBookController()) != null) {
            String a4;
            Object a5;
            String a6;
            Viewport a7 = a2.getBookNavigator().getViewport();
            FontMetrics a8 = a.getFontMetrics();
            int a9 = (a3.getHeight() + a8.getAscent() - a8.getDescent()) / 2;
            RendererCapabilities a10 = a2.getCapabilities();
            if (a10.isPageNumbersAvailable() && a3.showFullInfo && (a6 = a3.getPageName(a7)) != null && a6.length() != 0) {
                a5 = a3.readerSDK.getPageNumberManager().getMaxPageLabel();
                if (a5 != null && ((String)a5).length() > 0) {
                    Object[] a11 = new Object[]{a6, a5};
                    a6 = MessageFormat.format(a3.rb.getString("reader.progressbar.itemof"), a11);
                }
                int a12 = (a3.getWidth() - a8.stringWidth(a6)) / 2;
                a.drawString(a6, a12, a9);
            }
            if ((a6 = a3.getLocation(a7, a10)) != null) {
                if (a3.showFullInfo && (a5 = String.valueOf(a3.readerSDK.getCurrentBook().getEndPosition().getUIString())) != null) {
                    Object[] a13 = new Object[]{a6, a5};
                    a6 = MessageFormat.format(a3.rb.getString("reader.progressbar.itemof"), a13);
                }
                a.drawString(a6, a3.margin, a9);
            }
            if ((a4 = a3.getPercent((BookNavigator)(a5 = a3.readerSDK.getBookNavigator()), a7)) != null) {
                int a14 = a8.stringWidth(a4);
                a.drawString(a4, a3.getWidth() - a14 - a3.margin, a9);
            }
        }
    }

    private String[] convertToStringArray(int[] a) {
        int a2;
        String[] a3 = new String[a.length];
        int n = a2 = 0;
        while (n < a.length) {
            a3[a2] = Integer.toString(a[a2] + 1);
            n = ++a2;
        }
        return a3;
    }

    protected String getLocation(Viewport a, RendererCapabilities a2) {
        ProgressBarImpl a3;
        if (a == null || !a2.isLocationsAvailable()) {
            return null;
        }
        String a4 = a.getStartPosition().getUIString();
        Object[] a5 = new Object[]{a4};
        return MessageFormat.format(a3.rb.getString("reader.progressbar.location"), a5);
    }

    protected String getPageName(Viewport a) {
        ProgressBarImpl a2;
        String a3 = null;
        if (a2.progressProvider != null) {
            a3 = a2.progressProvider.getPageName(a);
        }
        if (a3 == null && a != null) {
            int[] a4;
            String[] a5 = a.getPageName();
            if (a5 == null && (a4 = a.getHardPageNumber()) != null && a4.length > 0 && a4[0] >= 0) {
                a5 = a2.convertToStringArray(a4);
            }
            if (a5 != null) {
                a3 = a2.getUIPageString(a5);
            }
        }
        return a3;
    }

    private String getUIPageString(String[] a) {
        ProgressBarImpl a2;
        Object[] a3 = null;
        if (a == null || a.length == 0) {
            return null;
        }
        if (a.length == 1) {
            if (a[0].length() == 0) {
                return "";
            }
            a3 = new Object[]{a[0]};
        } else if (a.length == 2) {
            if (a[0].length() == 0) {
                if (a[1].length() == 0) {
                    return "";
                }
                a3 = new Object[]{a[1]};
            } else {
                a3 = new Object[]{a[0]};
            }
        }
        return MessageFormat.format(a2.rb.getString("reader.progressbar.pagename"), a3);
    }

    protected String getPercent(BookNavigator a, Viewport a2) {
        ProgressBarImpl a3;
        if (!a.isNextPageAvailable()) {
            return a3.percentFmt.format(1.0);
        }
        String a4 = null;
        if (a3.progressProvider != null) {
            a4 = a3.progressProvider.getProgress(a2);
        }
        if (a4 == null && a2 != null) {
            Position a5 = a2.getStartPosition();
            a4 = a5 == null ? "" : a3.percentFmt.format(new Double(a5.getPercentage()));
        }
        return a4;
    }

    public ProgressStatusProvider setProgressStatusProvider(ProgressStatusProvider a) {
        ProgressBarImpl a2;
        ProgressStatusProvider a3 = a2.progressProvider;
        a2.progressProvider = a;
        return a3;
    }
}

