/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ebook.booklet.reader.impl.ui;

import com.amazon.agui.swing.CommandBar;
import com.amazon.agui.swing.InputDialog;
import com.amazon.ebook.booklet.reader.impl.annotation.personal.Highlight;
import com.amazon.ebook.booklet.reader.impl.annotation.personal.Note;
import com.amazon.ebook.booklet.reader.sdk.ReaderSDK;
import com.amazon.ebook.booklet.reader.sdk.content.Interval;
import com.amazon.ebook.booklet.reader.sdk.content.Position;
import com.amazon.ebook.booklet.reader.sdk.content.annotation.Annotation;
import com.amazon.ebook.booklet.reader.sdk.content.annotation.AnnotationException;
import com.amazon.ebook.booklet.reader.sdk.content.annotation.AnnotationManager;
import com.amazon.ebook.booklet.reader.sdk.ui.ReaderUI;
import com.amazon.ebook.util.log.Log;
import com.amazon.kindle.booklet.BookletContext;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class NoteEditorDialog
extends InputDialog {
    private static final Log LOG = Log.getInstance((String)"NoteEditorDialog");
    private JTextArea noteArea;
    private ResourceBundle rb;
    private ReaderSDK readerSDK;
    private Note note;
    private Interval.HasInterval firstElement;
    private Interval.HasInterval lastElement;

    public NoteEditorDialog(ReaderSDK a, Interval.HasInterval a2, Interval.HasInterval a3, Note a4) {
        super(((BookletContext)a.getActiveContext()).getName());
        Object a5;
        NoteEditorDialog a6;
        a6.readerSDK = a;
        a6.note = a4;
        a6.firstElement = a2;
        a6.lastElement = a3;
        a6.rb = ResourceBundle.getBundle("com.amazon.ebook.booklet.reader.resources.ReaderResources");
        JPanel a7 = (JPanel)a6.getContentPane();
        a7.removeAll();
        a7.setLayout(new BorderLayout(0, (Integer)a6.rb.getObject("noteeditor.gap")));
        a7.setBorder((Border)a6.rb.getObject("noteeditor.border"));
        a6.setTitleBarEnabled(true);
        a6.setTitle(a6.rb.getString("noteeditor.title"));
        a6.noteArea = new JTextArea();
        if (a4 != null) {
            a5 = a4.getText();
            a6.noteArea.setText((String)a5);
            a6.noteArea.setCaretPosition(((String)a5).length());
        }
        a6.noteArea.setEditable(a.getAnnotationManager().getSavesEnabled());
        a6.noteArea.setLineWrap(true);
        a6.noteArea.setWrapStyleWord(true);
        a5 = new JScrollPane(a6.noteArea);
        ((JScrollPane)a5).setHorizontalScrollBarPolicy(31);
        a7.add((Component)a5, "Center");
        CommandBar a8 = a6.getCommandBar();
        DeleteAction a9 = a6.new DeleteAction();
        SaveAction a10 = a6.new SaveAction();
        if (a4 == null || a4.getText().length() == 0) {
            a9.setEnabled(false);
            a10.setEnabled(false);
        }
        a8.add((Action)a9);
        a8.add((Action)a6.new CancelAction());
        a8.add((Action)a10);
        a6.noteArea.getDocument().addDocumentListener(a10);
        a6.setDialogBounds((Dimension)a6.rb.getObject("noteeditor.panel.size"));
    }

    private class DeleteAction
    extends AbstractAction {
        public DeleteAction() {
            DeleteAction a;
            super(a.NoteEditorDialog.this.rb.getString("noteeditor.delete"));
        }

        public void actionPerformed(ActionEvent a) {
            DeleteAction a2;
            a2.NoteEditorDialog.this.readerSDK.getAnnotationManager().deleteAnnotation((Annotation)a2.NoteEditorDialog.this.note, a2.NoteEditorDialog.this.readerSDK.getCurrentBook());
            a2.NoteEditorDialog.this.getCloseAction().actionPerformed(null);
            ReaderUI a3 = a2.NoteEditorDialog.this.readerSDK.getUI();
            a3.getAnnotationView().removeData((Object)a2.NoteEditorDialog.this.note);
            a3.getReaderPane().repaint();
        }
    }

    private class CancelAction
    extends AbstractAction {
        public CancelAction() {
            CancelAction a;
            super(a.NoteEditorDialog.this.rb.getString("noteeditor.cancel"));
        }

        public void actionPerformed(ActionEvent a) {
            CancelAction a2;
            a2.NoteEditorDialog.this.getCloseAction().actionPerformed(null);
        }
    }

    private class SaveAction
    extends AbstractAction
    implements DocumentListener {
        public SaveAction() {
            SaveAction a;
            super(a.NoteEditorDialog.this.rb.getString("noteeditor.save"));
            a.setEnabled(a.NoteEditorDialog.this.readerSDK.getCurrentBook().getMetadata().isAnnotationEnabled() && a.NoteEditorDialog.this.readerSDK.getAnnotationManager().getSavesEnabled());
        }

        public void actionPerformed(ActionEvent a) {
            SaveAction a2;
            AnnotationManager a3 = a2.NoteEditorDialog.this.readerSDK.getAnnotationManager();
            if (a2.NoteEditorDialog.this.note == null) {
                Interval a4 = a2.NoteEditorDialog.this.firstElement.getInterval();
                Interval a5 = a2.NoteEditorDialog.this.lastElement.getInterval();
                Position a6 = a4.getStartPosition().convertToSerializablePosition();
                Position a7 = a5.getEndPosition().convertToSerializablePosition();
                try {
                    a2.NoteEditorDialog.this.note = new Note(a2.NoteEditorDialog.this.noteArea.getText(), a5.getStartPosition().convertToSerializablePosition(), a5.getEndPosition().convertToSerializablePosition());
                }
                catch (AnnotationException a8) {
                    LOG.error("Could not create note.", (Throwable)a8);
                    return;
                }
                a3.addAnnotation((Annotation)a2.NoteEditorDialog.this.note, a2.NoteEditorDialog.this.readerSDK.getCurrentBook());
                if (!a4.equals((Object)a5)) {
                    try {
                        Highlight.addOrMergeHighlight(a2.NoteEditorDialog.this.readerSDK, a3, a6, a7, false);
                    }
                    catch (AnnotationException a9) {
                        LOG.error("Could not create highlight.", (Throwable)a9);
                        return;
                    }
                }
            } else {
                a2.NoteEditorDialog.this.note.setText(a2.NoteEditorDialog.this.noteArea.getText());
                a3.markAnnotationAsUpdated((Annotation)a2.NoteEditorDialog.this.note, a2.NoteEditorDialog.this.readerSDK.getCurrentBook());
            }
            a2.NoteEditorDialog.this.getCloseAction().actionPerformed(null);
        }

        public void changedUpdate(DocumentEvent a) {
        }

        public void insertUpdate(DocumentEvent a) {
            SaveAction a2;
            a2.updateEnabled();
        }

        public void removeUpdate(DocumentEvent a) {
            SaveAction a2;
            a2.updateEnabled();
        }

        private void updateEnabled() {
            SaveAction a;
            boolean a2 = a.NoteEditorDialog.this.noteArea.getText().length() != 0;
            if (a.isEnabled() != a2) {
                a.setEnabled(a2);
                a.NoteEditorDialog.this.getCommandBar().repaint();
            }
        }
    }
}

