/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ebook.booklet.reader.impl.ui;

import com.amazon.ebook.booklet.reader.impl.ui.HighlightOverlayModel;
import com.amazon.ebook.booklet.reader.plugin.phls.PopularHighlight;
import com.amazon.ebook.booklet.reader.plugin.publicnotes.PublicHighlight;
import com.amazon.ebook.booklet.reader.sdk.ReaderSDK;
import com.amazon.ebook.booklet.reader.sdk.content.Element;
import com.amazon.ebook.booklet.reader.sdk.content.Position;
import com.amazon.ebook.booklet.reader.sdk.content.annotation.Annotation;
import com.amazon.ebook.util.log.Log;
import com.amazon.ebook.util.log.Profiler;
import com.amazon.ebook.util.text.FontCache;
import com.amazon.ebook.util.text.TextListFormat;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;

public class HighlightDrawer {
    private static final Log D = Log.getInstance((String)"HighlightDrawer");

    public HighlightDrawer() {
        HighlightDrawer a;
    }

    public static void drawHighlights(ReaderSDK a, Graphics2D a2, HighlightOverlayModel a3, Element[] a4, Rectangle a5) {
        if (!a3.hasPopularOrPublicHighlights() && !a3.hasUserHighlights()) {
            return;
        }
        Profiler a6 = new Profiler("drawHighlights", D);
        Resources a7 = new Resources();
        HighlightAttributionTextDrawer a8 = new HighlightAttributionTextDrawer(a7, a3, a4, a, a5);
        HighlightLineDrawer a9 = new HighlightLineDrawer(a7, a3, a4);
        List a10 = a8.drawText(a2);
        a9.drawPopularAndPublicHighlights(a2, a10);
        a6.dump();
    }

    private static class HighlightLineDrawer {
        private final Resources H;
        private final HighlightOverlayModel b;
        private final Element[] K;
        private List B;
        private int D;

        public HighlightLineDrawer(Resources a, HighlightOverlayModel a2, Element[] a3) {
            HighlightLineDrawer a4;
            a4.H = a;
            a4.b = a2;
            a4.K = a3;
        }

        public void drawPopularAndPublicHighlights(Graphics2D a, List a2) {
            int a3;
            HighlightLineDrawer a4;
            if (!a4.b.hasPopularOrPublicHighlights()) {
                return;
            }
            Color a5 = a.getColor();
            a.setColor(a4.H.k);
            a4.B = a2;
            int a6 = 0;
            Rectangle a7 = null;
            int n = a3 = 0;
            while (n < a4.K.length) {
                Element a8 = a4.K[a3];
                boolean a9 = a4.b.isPopularOrPublicHighlightStart(a3);
                boolean a10 = a4.b.isPopularOrPublicHighlightContinuation(a3);
                if (a7 != null && !a10) {
                    Rectangle a11 = a4.K[a3 - 1].getBounds(a4.K[a3 - 1].getBoundsCount() - 1);
                    a4.drawUnderlineSkippingTextRectangles(a, a7, a11, a6);
                    a7 = null;
                }
                if (a7 == null && (a9 || a10)) {
                    a7 = a8.getBounds(0);
                    a6 = a8.getBoundsRunID(0);
                }
                int a12 = a8.getBoundsCount();
                Rectangle rectangle = a7;
                for (int a13 = 0; rectangle != null && a13 < a12; ++a13) {
                    if (a8.getBoundsRunID(a13) != a6) {
                        Rectangle a14 = null;
                        a14 = a13 > 0 ? a8.getBounds(a13 - 1) : a4.K[a3 - 1].getBounds(a4.K[a3 - 1].getBoundsCount() - 1);
                        a4.drawUnderlineSkippingTextRectangles(a, a7, a14, a6);
                        if (a9 || a10) {
                            a7 = a8.getBounds(a13);
                            a6 = a8.getBoundsRunID(a13);
                        } else {
                            a7 = null;
                        }
                    }
                    rectangle = a7;
                }
                n = ++a3;
            }
            if (a7 != null) {
                Rectangle a15 = a4.K[a4.K.length - 1].getBounds(a4.K[a4.K.length - 1].getBoundsCount() - 1);
                a4.drawUnderlineSkippingTextRectangles(a, a7, a15, a6);
            }
            a.setColor(a5);
        }

        private void drawUnderlineSkippingTextRectangles(Graphics2D a, Rectangle a2, Rectangle a3, int a4) {
            Rectangle a5;
            HighlightLineDrawer a6;
            int a7 = a2.x;
            int a8 = a6.H.F + a6.b.getBaseYForLine(a4);
            int a9 = a3.x + a3.width;
            while (a6.D < a6.B.size()) {
                a5 = (Rectangle)a6.B.get(a6.D);
                if (a8 > a5.y + a5.height) {
                    ++a6.D;
                    continue;
                }
                if (a8 < a5.y || a8 > a5.y + a5.height || a7 <= a5.x + a5.width - 1) break;
                ++a6.D;
            }
            Rectangle rectangle = a5 = a6.D < a6.B.size() ? (Rectangle)a6.B.get(a6.D) : null;
            if (a5 == null || a5.y > a8) {
                a6.drawUnderline(a, a7, a8, a9);
            } else {
                int a10 = a5.x;
                int a11 = a5.x + a5.width - 1;
                if (a7 <= a11 && a9 >= a10) {
                    if (a7 < a10) {
                        a6.drawUnderline(a, a7, a8, a10 - 1);
                    }
                    if (a9 > a11) {
                        a6.drawUnderline(a, a11 + 1, a8, a9);
                    }
                } else {
                    a6.drawUnderline(a, a7, a8, a9);
                }
            }
        }

        private void drawUnderline(Graphics2D a, int a2, int a3, int a4) {
            HighlightLineDrawer a5;
            int a6 = a5.H.L;
            int a7 = a5.H.c;
            int a8 = a5.H.l;
            int n = a2;
            while (n < a4) {
                if (a2 + a7 < a4) {
                    a.fillRect(a2, a3, a7, a6);
                    n = a2 + (a7 + a8);
                    continue;
                }
                a.fillRect(a2, a3, a4 - a2, a6);
                break;
            }
        }
    }

    private static class HighlightAttributionTextDrawer {
        private final Resources i;
        private final HighlightOverlayModel E;
        private final Element[] C;
        private final int d;
        private final ReaderSDK j;
        private int g;
        private List e = new ArrayList();
        private HashSet I = new HashSet();
        private List F = new ArrayList();
        private int L;
        private Rectangle c;
        private boolean l;
        private int k;
        private int m;
        private String h;
        private FontMetrics A;
        private int H;
        private Graphics b;
        private Position K;
        private int B;
        private int D;

        public HighlightAttributionTextDrawer(Resources a, HighlightOverlayModel a2, Element[] a3, ReaderSDK a4, Rectangle a5) {
            HighlightAttributionTextDrawer a6;
            a6.i = a;
            a6.E = a2;
            a6.C = a3;
            a6.d = a5.width - a.D;
            a6.j = a4;
        }

        private void reset() {
            HighlightAttributionTextDrawer a;
            a.L = 0;
            a.I.clear();
            a.F.clear();
            a.c = null;
            a.l = false;
            a.k = 0;
            a.m = 0;
            a.h = null;
            a.H = 0;
            a.K = null;
        }

        public List drawText(Graphics2D a) {
            int a2;
            HighlightAttributionTextDrawer a3;
            a3.e.clear();
            if (!a3.E.hasPopularOrPublicHighlights()) {
                return a3.e;
            }
            a3.D = -1;
            a3.B = -1;
            a3.reset();
            a3.b = a;
            Color a4 = a.getColor();
            Font a5 = a.getFont();
            Rectangle a6 = a.getClipBounds();
            int a7 = a3.i.A[Math.min(a3.i.A.length - 1, Math.max(0, a3.j.getUI().getFontSize()))];
            a.setFont(FontCache.getInstance().get(a3.i.m, a3.i.h, a7));
            a.setColor(a3.i.B);
            a.setClip(null);
            a3.A = a.getFontMetrics();
            a3.g = a3.C.length > 0 ? a3.C[0].getBoundsRunID(0) : -1;
            Element a8 = null;
            int n = a2 = 0;
            while (n < a3.C.length) {
                Object a9;
                int a10;
                int a11;
                a8 = a3.C[a2];
                List a12 = a3.E.getAnnotationsStartingAt(a2);
                if (a3.c == null) {
                    a11 = 0;
                    a10 = a12.size();
                    int n2 = a11;
                    while (n2 < a10) {
                        a9 = (Annotation)a12.get(a11);
                        if (a9.getType() == 5 || a9.getType() == 7) {
                            a3.c = a8.getBounds(0);
                            a3.g = a8.getBoundsRunID(0);
                            break;
                        }
                        n2 = ++a11;
                    }
                }
                a10 = a8.getBoundsCount();
                Rectangle rectangle = a3.c;
                for (a11 = 0; rectangle != null && a11 < a10; ++a11) {
                    if (a8.getBoundsRunID(a11) != a3.g) {
                        a3.l = true;
                        break;
                    }
                    rectangle = a3.c;
                }
                if (a12.size() > 0 && a8.getBoundsRunID(0) == a3.g) {
                    a3.addAnnotations(a12);
                }
                if (a3.c != null && !a3.l && a3.K != null && a3.K.compareTo((Object)a8.getStartPosition()) < 0) {
                    a3.prepText();
                    a9 = a8.getBounds(a10 - 1);
                    if (a3.c.x + a3.H <= a9.x + a9.width) {
                        a3.l = true;
                    }
                }
                if (a3.l) {
                    a3.drawText();
                    a3.reset();
                }
                if (a12.size() > 0 && a8.getBoundsRunID(0) != a3.g) {
                    a3.addAnnotations(a12);
                }
                a3.g = a8.getBoundsRunID(a10 - 1);
                n = ++a2;
            }
            if (a3.c != null) {
                a3.drawText();
            }
            a.setFont(a5);
            a.setColor(a4);
            a.setClip(a6);
            return a3.e;
        }

        private void addAnnotations(List a) {
            int a2 = 0;
            int a3 = a.size();
            int n = a2;
            while (n < a3) {
                PublicHighlight a4;
                HighlightAttributionTextDrawer a5;
                Annotation a6 = (Annotation)a.get(a2);
                if (a6 instanceof PopularHighlight) {
                    a5.L += ((PopularHighlight)a6).getNumUsers();
                } else if (a6 instanceof PublicHighlight && !a5.I.contains((a4 = (PublicHighlight)a6).getCID())) {
                    a5.I.add(a4.getCID());
                    a5.F.add(a4.getUsername());
                }
                if (a6.getType() == 5 || a6.getType() == 7) {
                    a4 = a6.getEndPosition();
                    if (a5.K == null || a5.K.compareTo((Object)a4) < 0) {
                        a5.K = a4;
                    }
                }
                n = ++a2;
            }
        }

        private void prepText() {
            HighlightAttributionTextDrawer a;
            if (a.k != a.F.size() || a.m != a.L) {
                ArrayList a2 = new ArrayList(a.F.size() + 1);
                int a3 = a.F.size();
                if (a3 > 0 && a3 < 3) {
                    int a4;
                    int n = a4 = 0;
                    while (n < a3) {
                        a2.add(a.F.get(a4));
                        n = ++a4;
                    }
                } else if (a3 >= 3) {
                    a2.add(a.F.get(0));
                    String a5 = a.i.b.format(new Object[]{new Integer(a3 - 1)});
                    a2.add(a5);
                }
                if (a.L > 0) {
                    String a6 = a.i.H.format(new Object[]{new Integer(a.L)});
                    a2.add(a6);
                }
                TextListFormat a7 = TextListFormat.getInstance();
                a.h = a7.format(a2, TextListFormat.FormatListType.DEFAULT);
                a.H = a.A.stringWidth(a.h);
            }
        }

        private void drawText() {
            int a;
            HighlightAttributionTextDrawer a2;
            a2.prepText();
            int a3 = a2.c.x;
            int a4 = a3 + a2.H + 1;
            if (a4 > a2.d && (a2.D != a2.g || a2.B < a2.d - a2.H - 1)) {
                a4 = a2.d;
                a3 = a2.d - a2.H - 1;
            }
            int a5 = a2.A.getAscent() + a2.A.getDescent();
            int a6 = a2.E.getSpaceBetweenLineAndNextLine(a2.g);
            if (a6 == 0 || a6 > a5) {
                a = a2.E.getBaseYForLine(a2.g) + a2.i.F + a2.A.getAscent() / 2;
            } else {
                int a7;
                int a8 = a2.E.getBaseYForLine(a2.g) + a6 / 2;
                a = a7 = a8 + a5 / 2 - a2.A.getDescent();
            }
            a2.D = a2.g;
            a2.B = a4;
            a2.b.drawString(a2.h, a3, a);
            Rectangle a9 = new Rectangle(a3 - a2.i.K, a2.E.getBaseYForLine(a2.g), a2.H + 2 + a2.i.K * 2, a2.i.F + a2.i.L + 1);
            a2.e.add(a9);
        }
    }

    private static class Resources {
        private static ResourceBundle I;
        private final int F;
        private final int L;
        private final int c;
        private final int l;
        private final Color k;
        private final String m;
        private final int h;
        private final int[] A;
        private final MessageFormat H;
        private final MessageFormat b;
        private final int K;
        private final Color B;
        private final int D;

        private Resources() {
            Resources a;
            I = ResourceBundle.getBundle("com.amazon.ebook.booklet.reader.impl.ui.resources.HighlightDrawerResources");
            a.F = (Integer)I.getObject("highlight.vertical.padding");
            a.L = (Integer)I.getObject("highlight.height");
            a.c = (Integer)I.getObject("highlight.dash.width");
            a.l = (Integer)I.getObject("highlight.space.width");
            a.k = (Color)I.getObject("highlight.color");
            a.m = I.getString("font.family");
            a.h = (Integer)I.getObject("font.style");
            a.A = (int[])I.getObject("font.sizes");
            a.H = (MessageFormat)I.getObject("num.highlighters.format");
            a.b = (MessageFormat)I.getObject("num.others.format");
            a.K = (Integer)I.getObject("text.padding");
            a.B = (Color)I.getObject("text.color");
            a.D = (Integer)I.getObject("right.margin");
        }
    }
}

