/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ebook.booklet.reader.impl.ui;

import com.amazon.agui.swing.CommandBar;
import com.amazon.agui.swing.InputDialog;
import com.amazon.agui.swing.MenuDialog;
import com.amazon.ebook.booklet.reader.impl.ReaderSDKImpl;
import com.amazon.ebook.booklet.reader.impl.ReaderUIImpl;
import com.amazon.ebook.booklet.reader.impl.annotation.personal.EndReadingLocation;
import com.amazon.ebook.booklet.reader.sdk.BookNavigator;
import com.amazon.ebook.booklet.reader.sdk.TOCException;
import com.amazon.ebook.booklet.reader.sdk.content.Book;
import com.amazon.ebook.booklet.reader.sdk.content.PageNumberManager;
import com.amazon.ebook.booklet.reader.sdk.content.Position;
import com.amazon.ebook.booklet.reader.sdk.content.TableOfContents;
import com.amazon.ebook.booklet.reader.sdk.content.TableOfContentsEntry;
import com.amazon.ebook.booklet.reader.sdk.internal.BookController;
import com.amazon.ebook.booklet.reader.sdk.internal.RendererCapabilities;
import com.amazon.ebook.booklet.reader.sdk.ui.GotoDialog;
import com.amazon.ebook.booklet.reader.sdk.ui.GotoOption;
import com.amazon.ebook.booklet.reader.sdk.ui.ReaderAction;
import com.amazon.ebook.booklet.reader.sdk.util.InvalidSideCarFileException;
import com.amazon.ebook.booklet.reader.sdk.util.State;
import com.amazon.ebook.util.log.Log;
import com.amazon.kindle.booklet.BookletContext;
import com.amazon.kindle.keyboard.KeyboardUtils;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;

public class GotoDialogImpl
extends MenuDialog
implements GotoDialog {
    private static final Log LOG = Log.getInstance((String)"GotoDialogImpl");
    public static final int BASIC_STYLE = 1;
    public static final int TOC_STYLE = 2;
    public static final int HYBRID_STYLE = 3;
    private ReaderSDKImpl readerSDK;
    private ReaderUIImpl readerUI;
    private int style;
    private ArrayList gotoOptions;
    private ResourceBundle rb;
    private Rectangle panelSize;
    private Rectangle panelSizeGuide;
    private TableOfContents TOC;
    private List optionsActions;
    private List guideActions;
    private boolean numericalOnly;

    public GotoDialogImpl(ReaderSDKImpl a, ReaderUIImpl a2, int a3) {
        super(((BookletContext)a.getActiveContext()).getName());
        GotoDialogImpl a4;
        a4.readerSDK = a;
        a4.readerUI = a2;
        a4.style = a3;
        a4.rb = ResourceBundle.getBundle("com.amazon.ebook.booklet.reader.resources.ReaderResources");
        a4.panelSize = (Rectangle)a4.rb.getObject("goto.menu.panel.size");
        a4.panelSizeGuide = (Rectangle)a4.rb.getObject("goto.menu.panel.guide.size");
        a4.initOptions();
        a4.initUI();
    }

    public void postDialog() {
        GotoDialogImpl a;
        a.setDialog();
        a.setDialogBounds(a.style == 1 || a.guideActions == null || a.guideActions.size() == 0 ? a.panelSize : a.panelSizeGuide);
        super.postDialog(((BookletContext)a.readerSDK.getActiveContext()).getName());
    }

    private void setDialog() {
        GotoDialogImpl a;
        a.reset();
        int a2 = 0;
        int a3 = a.optionsActions.size();
        int n = a2;
        while (n < a3) {
            GotoOption a4 = (GotoOption)a.optionsActions.get(a2);
            boolean a5 = a4.isAvailable();
            a4.setEnabled(a5);
            if (a.gotoOptions.contains(a4)) {
                a.addAction((Action)a4);
            }
            if (a4 instanceof PageOption) {
                a.numericalOnly = !a5;
            }
            n = ++a2;
        }
        if ((a.style & 2) != 0) {
            a.addGuideItems();
        }
    }

    private void initOptions() {
        GotoDialogImpl a;
        a.optionsActions = new ArrayList();
        a.gotoOptions = new ArrayList();
        if ((a.style & 1) != 0) {
            a.gotoOptions.add(a.new CoverOption());
            a.gotoOptions.add(a.new BeginningOption());
            a.gotoOptions.add(a.new TOCOption());
            a.gotoOptions.add(a.new EndingOption());
            a.gotoOptions.add(a.new PageLocationOption());
        }
    }

    public static ReaderAction getGotoAction(String a, final String a2, final ReaderSDKImpl a3, final ReaderUIImpl a4, final int a5) {
        return new ReaderAction(a){
            GotoDialogImpl dialog;
            {
                1 a22;
                super(a);
            }

            public void actionPerformed(ActionEvent a) {
                1 a22;
                if (a22.dialog != null && a22.dialog.isShowing()) {
                    return;
                }
                a22.dialog = new GotoDialogImpl(a22.a3, a22.a4, a22.a5);
                a22.dialog.setTitle(a22.a2);
                a22.dialog.postDialog();
            }

            public int getPriority() {
                return 110;
            }

            public int getType() {
                return 2;
            }
        };
    }

    private ReaderAction getGotoAction(String a) {
        GotoDialogImpl a2;
        return new ReaderAction(a){
            {
                2 a2;
                super(a);
            }

            public void actionPerformed(ActionEvent a) {
                2 a2;
                a2.GotoDialogImpl.this.postDialog();
            }

            public int getPriority() {
                return 110;
            }

            public int getType() {
                return 2;
            }
        };
    }

    private void initUI() {
        int a;
        GotoDialogImpl a2;
        a2.setTitleBarEnabled(true);
        int n = a = 0;
        while (n < a2.gotoOptions.size()) {
            Action a3 = (Action)a2.gotoOptions.get(a);
            a2.addAction(a3);
            a2.optionsActions.add(a3);
            n = ++a;
        }
    }

    private void addGuideItems() {
        GotoDialogImpl a;
        Book a2 = a.readerSDK.getCurrentBook();
        if (a2 == null) {
            return;
        }
        TableOfContents a3 = a2.getTOC();
        if (a.TOC == a3) {
            return;
        }
        a.TOC = a3;
        if (a.guideActions != null) {
            a.guideActions = null;
        }
        if (a.TOC == null) {
            return;
        }
        a.guideActions = new ArrayList();
        a.addTOCItems(a.TOC, null);
    }

    private void addTOCItems(TableOfContents a, TableOfContentsEntry a2) {
        try {
            while ((a2 = a.getNextEntry(a2)) != null) {
                int a3;
                GotoDialogImpl a4;
                GuideItemOption a5 = a4.new GuideItemOption(a2.getLabel(), a2.getPosition());
                a4.addAction((Action)((Object)a5));
                a4.guideActions.add(a5);
                TableOfContentsEntry[] a6 = a.getChildren(a2);
                if (a6 == null) continue;
                int n = a3 = 0;
                while (n < a6.length) {
                    a4.addTOCItems(a, a6[a3]);
                    n = ++a3;
                }
            }
        }
        catch (TOCException a7) {
            LOG.warning("Cannot get TOC entry.");
        }
    }

    public void addOption(GotoOption a) {
        GotoDialogImpl a2;
        a2.gotoOptions.add(a);
    }

    public void addOption(GotoOption a, int a2) {
        GotoDialogImpl a3;
        a3.gotoOptions.add(a2, a);
    }

    public ArrayList getOptions() {
        GotoDialogImpl a;
        return a.gotoOptions;
    }

    public void removeOption(GotoOption a) {
        GotoDialogImpl a2;
        a2.gotoOptions.remove(a2.gotoOptions.indexOf(a));
    }

    public void recordPageHistory() {
        GotoDialogImpl a;
        a.readerSDK.getUI().getUIContext().recordHistory();
    }

    class GotoTextListener
    implements KeyListener {
        GotoTextListener() {
            GotoTextListener a;
        }

        public void keyPressed(KeyEvent a) {
            if (a.getKeyCode() == 10) {
                a.consume();
            }
        }

        public void keyReleased(KeyEvent a) {
        }

        public void keyTyped(KeyEvent a) {
            GotoTextListener a2;
            if (!a2.GotoDialogImpl.this.numericalOnly) {
                return;
            }
            char a3 = a.getKeyChar();
            if (a3 != '\b' && a3 != '\u007f' && !Character.isDigit(a3)) {
                a.consume();
            }
        }
    }

    class PageLocationDialog
    extends InputDialog {
        Rectangle panelSize;
        GotoOption pageOption;
        GotoOption locationOption;

        public PageLocationDialog() {
            PageLocationDialog a;
            super(((BookletContext)a.GotoDialogImpl.this.readerSDK.getActiveContext()).getName(), 1, "123");
            a.panelSize = (Rectangle)a.GotoDialogImpl.this.rb.getObject("goto.menu.input.panel.size");
            a.getTextArea().addKeyListener(new GotoTextListener());
            CommandBar a2 = a.getCommandBar();
            JButton a3 = a2.add(super.getCloseAction());
            a3.setText(a.GotoDialogImpl.this.rb.getString("goto.menu.action.cancel"));
            a.pageOption = new PageOption(a);
            a3 = a2.add((Action)a.pageOption);
            a3.addActionListener(super.getCloseAction());
            a.GotoDialogImpl.this.optionsActions.add(a.pageOption);
            a.locationOption = new LocationOption(a);
            a3 = a2.add((Action)a.locationOption);
            a3.addActionListener(super.getCloseAction());
            a.GotoDialogImpl.this.optionsActions.add(a.locationOption);
        }

        public void postDialog() {
            PageLocationDialog a;
            a.setDialog();
            a.setDialogBounds(a.panelSize);
            super.postDialog(((BookletContext)a.GotoDialogImpl.this.readerSDK.getActiveContext()).getName());
        }

        private void setDialog() {
            PageLocationDialog a;
            a.setInputText("");
            Book a2 = a.GotoDialogImpl.this.readerSDK.getCurrentBook();
            if (a2 == null) {
                return;
            }
            a.setDescription(a.getRangeText(a2));
            KeyboardUtils.configure((JComponent)a.getTextArea(), (String)":123:");
        }

        private String getRangeText(Book a) {
            PageLocationDialog a2;
            String a3 = null;
            String a4 = null;
            if (a2.locationOption.isAvailable()) {
                a3 = a.getStartPosition().getUIString();
                a4 = a.getEndPosition().getUIString();
            }
            if (a2.pageOption.isAvailable()) {
                PageNumberManager a5 = a2.GotoDialogImpl.this.readerSDK.getPageNumberManager();
                String a6 = a5.getPageRangeSummary();
                if (a6 != null && a6.length() > 0) {
                    if (a3 != null) {
                        Object[] a7 = new Object[]{a6, a3, a4};
                        return MessageFormat.format(a2.GotoDialogImpl.this.rb.getString("goto.menu.input.label.pagerange_location"), a7);
                    }
                    Object[] a8 = new Object[]{a6};
                    return MessageFormat.format(a2.GotoDialogImpl.this.rb.getString("goto.menu.input.label.pagerange"), a8);
                }
                String a9 = a5.getMaxPageLabel();
                if ((a9 == null || a9.length() == 0) && a.getType() == 3) {
                    a9 = Integer.toString(a.getBookLength());
                }
                if (a9 != null && a9.length() > 0) {
                    if (a3 != null) {
                        Object[] a10 = new Object[]{a9, a3, a4};
                        return MessageFormat.format(a2.GotoDialogImpl.this.rb.getString("goto.menu.input.label.pagemax_location"), a10);
                    }
                    Object[] a11 = new Object[]{a9};
                    return MessageFormat.format(a2.GotoDialogImpl.this.rb.getString("goto.menu.input.label.pagemax"), a11);
                }
                if (a3 != null) {
                    Object[] a12 = new Object[]{a3, a4};
                    return MessageFormat.format(a2.GotoDialogImpl.this.rb.getString("goto.menu.input.label.pageempty_location"), a12);
                }
                return a2.GotoDialogImpl.this.rb.getString("goto.menu.input.label.pageempty");
            }
            if (a3 != null) {
                Object[] a13 = new Object[]{a3, a4};
                return MessageFormat.format(a2.GotoDialogImpl.this.rb.getString("goto.menu.input.label.location"), a13);
            }
            return null;
        }
    }

    class PageLocationOption
    extends GotoOptionImpl {
        PageLocationDialog dialog;

        public PageLocationOption() {
            PageLocationOption a;
            super(a.GotoDialogImpl.this.rb.getString("goto.menu.action.input"));
            a.dialog = new PageLocationDialog();
            a.dialog.setTitleBarEnabled(true);
            a.dialog.setTitle(a.GotoDialogImpl.this.rb.getString("goto.menu.action.input.title"));
        }

        public boolean checkAvailable(RendererCapabilities a) {
            return a.isPageNumbersAvailable() || a.isLocationsAvailable();
        }

        public void actionPerformed(ActionEvent a) {
            PageLocationOption a2;
            a2.dialog.postDialog();
        }

        public boolean doNavigate(BookNavigator a) {
            return false;
        }
    }

    class GuideItemOption
    extends GotoOptionImpl {
        Position position;

        public GuideItemOption(String a, Position a2) {
            GuideItemOption a3;
            super(a);
            a3.position = a2;
        }

        public boolean checkAvailable(RendererCapabilities a) {
            return true;
        }

        public boolean doNavigate(BookNavigator a) {
            GuideItemOption a2;
            a.goTo(a2.position);
            return false;
        }
    }

    class EndingOption
    extends GotoOptionImpl {
        public EndingOption() {
            EndingOption a;
            super(a.GotoDialogImpl.this.rb.getString("goto.menu.action.ending"));
        }

        public boolean checkAvailable(RendererCapabilities a) {
            return true;
        }

        public boolean doNavigate(BookNavigator a) {
            EndReadingLocation a2 = null;
            try {
                EndingOption a3;
                State a4 = a3.GotoDialogImpl.this.readerSDK.getCurrentBook().getRareUpdateBookState();
                a2 = (EndReadingLocation)a4.get("erl");
            }
            catch (InvalidSideCarFileException invalidSideCarFileException) {
                // empty catch block
            }
            if (a2 != null) {
                a.goTo(a2.getPosition());
            } else {
                a.goToLastPage();
            }
            return false;
        }
    }

    class BeginningOption
    extends GotoOptionImpl {
        public BeginningOption() {
            BeginningOption a;
            super(a.GotoDialogImpl.this.rb.getString("goto.menu.action.beginning"));
        }

        public boolean checkAvailable(RendererCapabilities a) {
            return true;
        }

        public boolean doNavigate(BookNavigator a) {
            a.goToStartReading();
            return false;
        }
    }

    class TOCOption
    extends GotoOptionImpl {
        public TOCOption() {
            TOCOption a;
            super(a.GotoDialogImpl.this.rb.getString("goto.menu.action.toc"));
        }

        public boolean checkAvailable(RendererCapabilities a) {
            return a.isGuideItemTOCAvailable();
        }

        public boolean doNavigate(BookNavigator a) {
            a.goToTableOfContents();
            return false;
        }
    }

    class CoverOption
    extends GotoOptionImpl {
        public CoverOption() {
            CoverOption a;
            super(a.GotoDialogImpl.this.rb.getString("goto.menu.action.cover"));
        }

        public boolean checkAvailable(RendererCapabilities a) {
            return a.hasLargeCover();
        }

        public boolean doNavigate(BookNavigator a) {
            a.goToCover();
            return true;
        }
    }

    class PageOption
    extends GotoOptionImpl {
        PageLocationDialog dialog;

        public PageOption(PageLocationDialog a) {
            PageOption a2;
            super(a2.GotoDialogImpl.this.rb.getString("goto.menu.action.page"));
            a2.dialog = a;
        }

        public boolean checkAvailable(RendererCapabilities a) {
            return a.isPageNumbersAvailable();
        }

        public boolean doNavigate(BookNavigator a) {
            PageOption a2;
            String a3 = a2.dialog.getInputText();
            if (a3 == null) {
                return false;
            }
            if ((a3 = a3.trim()).length() == 0) {
                return false;
            }
            a.goTo(a3);
            return false;
        }
    }

    class LocationOption
    extends GotoOptionImpl {
        PageLocationDialog dialog;

        public LocationOption(PageLocationDialog a) {
            LocationOption a2;
            super(a2.GotoDialogImpl.this.rb.getString("goto.menu.action.location"));
            a2.dialog = a;
        }

        public boolean checkAvailable(RendererCapabilities a) {
            return a.isLocationsAvailable();
        }

        public boolean doNavigate(BookNavigator a) {
            int a2;
            LocationOption a3;
            String a4 = a3.dialog.getInputText();
            if (a4 == null) {
                return false;
            }
            if ((a4 = a4.trim()).length() == 0) {
                return false;
            }
            try {
                a2 = Integer.parseInt(a4);
            }
            catch (NumberFormatException a5) {
                return false;
            }
            a.goToUserLocation(a2);
            return false;
        }
    }

    public abstract class GotoOptionImpl
    extends GotoOption {
        public GotoOptionImpl(String a) {
            GotoOptionImpl a2;
            super(a, (GotoDialog)a2.GotoDialogImpl.this);
        }

        public boolean isAvailable() {
            GotoOptionImpl a;
            BookController a2 = a.GotoDialogImpl.this.readerSDK.getBookController();
            if (a2 == null) {
                return false;
            }
            RendererCapabilities a3 = a2.getCapabilities();
            return a3 == null ? false : a.checkAvailable(a3);
        }

        public abstract boolean checkAvailable(RendererCapabilities var1);

        public void doAction(ActionEvent a) {
            GotoOptionImpl a2;
            BookController a3 = a2.GotoDialogImpl.this.readerSDK.getBookController();
            if (a3 == null) {
                return;
            }
            BookNavigator a4 = a3.getBookNavigator();
            if (a4 == null) {
                return;
            }
            int a5 = 0;
            if (a2 instanceof BeginningOption) {
                a5 = 1;
            } else if (a2 instanceof EndingOption) {
                a5 = 2;
            }
            boolean a6 = a2.doNavigate(a4);
            a2.GotoDialogImpl.this.readerUI.generateUserGoToEvent(true, a5);
            if (!a6) {
                a2.GotoDialogImpl.this.readerUI.showBook();
            }
        }

        public abstract boolean doNavigate(BookNavigator var1);
    }
}

