/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ebook.booklet.reader.impl.ui;

import com.amazon.agui.swing.KDialog;
import com.amazon.agui.swing.event.GestureDispatcher;
import com.amazon.ebook.booklet.reader.impl.ContentPanel;
import com.amazon.ebook.booklet.reader.impl.ReaderSDKImpl;
import com.amazon.ebook.booklet.reader.sdk.ui.ReaderUI;
import com.amazon.ebook.util.log.Log;
import com.amazon.kindle.booklet.BookletContext;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ResourceBundle;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class FontResizeDialog
extends KDialog
implements MouseListener {
    private static final Log LOG = Log.getInstance((String)"FontResizeDialog");
    private ReaderSDKImpl readerSDK;
    private ReaderUI readerUI;
    private ResourceBundle rb;
    private ContentPanel contentPanel;
    private Rectangle panelSize;
    private JToggleButton[] fontSizeButtons;
    private int defaultFontSize;
    private String fontText;
    private String fontFamily;
    private int fontStyle;
    private int textHeight;
    private int horizontalMargin;
    private int verticalMargin;
    private Integer baselineGap;
    private int topMargin;
    private boolean canChangeSize = true;
    private boolean releaseBeforeShowing = false;
    private boolean relayoutScheduled = false;
    private boolean releaseOccured = false;
    private boolean firstChange;
    private Boolean singleChangeSynchronizer = new Boolean(false);
    private Timer dismissTimer;
    private Timer layoutContentTimer;
    private Timer successiveChangeTimer;
    private static final int INCREASE_SIZE = 1;
    private static final int DECREASE_SIZE = -1;
    private static final long DEFAULT_SUCCESSIVE_DELAY = 100L;
    private static final long DEFAULT_LAYOUT_DELAY = 500L;
    private static final long FIRST_SUCCESIVE_DELAY = 400L;
    private static final long FIRST_LAYOUT_DELAY = 900L;
    private static final long DEFAULT_DISMISS_DELAY = 1500L;

    public FontResizeDialog(ReaderSDKImpl a, ContentPanel a2) {
        super(null, false);
        FontResizeDialog a3;
        a3.readerSDK = a;
        a3.contentPanel = a2;
        a3.rb = ResourceBundle.getBundle("com.amazon.ebook.booklet.reader.resources.ReaderResources");
        a3.setAutoCenteredEnabled(false);
        a3.initUI();
        GestureDispatcher a4 = new GestureDispatcher();
        a3.addMouseListener((MouseListener)a4);
        a3.addMouseListener(a3);
        ActionMap a5 = a3.getActionMap();
        a5.put("shrink", a3.getDecreaseAction());
        a5.put("grow", a3.getIncreaseAction());
    }

    public Action getCloseAction() {
        FontResizeDialog a;
        final Action a2 = super.getCloseAction();
        return new AbstractAction(){
            {
                1 a;
            }

            public void actionPerformed(ActionEvent a) {
                1 a22;
                a22.FontResizeDialog.this.releaseOccured = false;
                a22.a2.actionPerformed(null);
                a22.FontResizeDialog.this.contentPanel.repaint();
            }
        };
    }

    public Action getDecreaseAction() {
        FontResizeDialog a;
        return new AbstractAction(){
            {
                2 a;
            }

            public void actionPerformed(ActionEvent a) {
                2 a2;
                a2.FontResizeDialog.this.changeFontSize(-1);
            }
        };
    }

    public Action getIncreaseAction() {
        FontResizeDialog a;
        return new AbstractAction(){
            {
                3 a;
            }

            public void actionPerformed(ActionEvent a) {
                3 a2;
                a2.FontResizeDialog.this.changeFontSize(1);
            }
        };
    }

    public void mouseClicked(MouseEvent a) {
    }

    public void mouseEntered(MouseEvent a) {
    }

    public void mouseExited(MouseEvent a) {
    }

    public void mousePressed(MouseEvent a) {
    }

    public void mouseReleased(MouseEvent a) {
        if (a.getButton() == 1) {
            FontResizeDialog a2;
            a2.releaseOccured = true;
            a2.handleDismiss();
        }
    }

    public void postDialog() {
        FontResizeDialog a;
        a.setDialog();
        super.postDialog(((BookletContext)a.readerSDK.getActiveContext()).getName());
        a.setVisible(true);
        a.releaseOccured = false;
    }

    public void repaint() {
        FontResizeDialog a;
        if (a.readerUI != null) {
            int a2 = a.readerUI.getFontSize();
            if (a2 < 0 || a2 >= a.fontSizeButtons.length) {
                a2 = a.defaultFontSize;
            }
            a.fontSizeButtons[a2].setSelected(true);
        }
        super.repaint();
        if (a.releaseBeforeShowing) {
            a.handleDismiss();
            a.releaseBeforeShowing = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeFontSize(int a) {
        FontResizeDialog a2;
        if (a2.readerSDK.getBookController().getCapabilities().isFontSizeChangeable()) {
            Boolean bl = a2.singleChangeSynchronizer;
            synchronized (bl) {
                int a3;
                a2.firstChange = false;
                if (a2.readerUI == null) {
                    a2.readerUI = a2.readerSDK.getUI();
                }
                if (!a2.contentPanel.isDialogShowing()) {
                    a2.firstChange = true;
                    a2.postDialog();
                } else if (!a2.isShowing()) {
                    a2.canChangeSize = false;
                }
                if (a2.dismissTimer != null) {
                    a2.dismissTimer.cancel();
                    a2.dismissTimer = null;
                }
                if ((a3 = a2.readerUI.getFontSize() + a) >= 0 && a3 < a2.fontSizeButtons.length && a2.canChangeSize) {
                    a2.canChangeSize = false;
                    a2.readerUI.setFontSize(a3, false);
                    a2.repaint();
                    if (a2.layoutContentTimer != null) {
                        a2.layoutContentTimer.cancel();
                    }
                    long a4 = 500L;
                    long a5 = 100L;
                    if (a2.firstChange) {
                        a5 = 400L;
                        a4 = 900L;
                    }
                    a2.relayoutScheduled = true;
                    a2.layoutContentTimer = new Timer();
                    a2.layoutContentTimer.schedule(new TimerTask(){
                        {
                            4 a;
                        }

                        public void run() {
                            4 a;
                            a.FontResizeDialog.this.relayoutScheduled = false;
                            a.FontResizeDialog.this.readerUI.setFontSize(a.a3, true);
                            a.FontResizeDialog.this.readerUI.getReaderPane().repaint();
                            a.FontResizeDialog.this.repaint();
                            a.FontResizeDialog.this.handleDismiss();
                        }
                    }, a4);
                    a2.successiveChangeTimer = new Timer();
                    a2.successiveChangeTimer.schedule(new TimerTask(){
                        {
                            5 a;
                        }

                        public void run() {
                            5 a;
                            a.FontResizeDialog.this.canChangeSize = true;
                        }
                    }, a5);
                }
            }
        }
    }

    private JPanel getFontMenu() {
        int a;
        int a2;
        FontResizeDialog a3;
        JPanel a4 = new JPanel();
        a4.setLayout(new BoxLayout(a4, 1));
        a4.setAlignmentX(0.0f);
        ButtonGroup a5 = new ButtonGroup();
        a3.fontText = a3.rb.getString("font.menu.text");
        a3.defaultFontSize = (Integer)a3.rb.getObject("font.menu.size.default");
        int[][] a6 = (int[][])a3.rb.getObject("font.menu.size.list");
        int a7 = 0;
        int n = a2 = 0;
        while (n < a6.length) {
            a7 += a6[a2].length;
            n = ++a2;
        }
        a3.fontSizeButtons = new JToggleButton[a7];
        a2 = 0;
        int n2 = a = 0;
        while (n2 < a6.length) {
            int[] a8 = a6[a];
            a4.add(a3.getFontMenuRow(a5, a2, a8));
            a2 += a8.length;
            n2 = ++a;
        }
        return a4;
    }

    private JPanel getFontMenuRow(ButtonGroup a, int a2, int[] a3) {
        int a4;
        FontResizeDialog a5;
        JPanel a6 = new JPanel();
        a5.setBorder(new EmptyBorder(a5.verticalMargin, a5.horizontalMargin, a5.verticalMargin, a5.horizontalMargin));
        a6.setLayout(new BoxLayout(a6, 0));
        a6.setAlignmentX(0.0f);
        a6.setPreferredSize(new Dimension(0, a5.textHeight));
        int n = a4 = 0;
        while (n < a3.length) {
            final int a7 = a4;
            JToggleButton a8 = new JToggleButton(new AbstractAction(){
                {
                    6 a;
                }

                public void actionPerformed(ActionEvent a) {
                    6 a2;
                    if (a2.a7 != a2.FontResizeDialog.this.readerUI.getFontSize()) {
                        a2.FontResizeDialog.this.readerUI.setFontSize(a2.a7, true);
                        a2.FontResizeDialog.this.readerUI.getReaderPane().repaint();
                        a2.FontResizeDialog.this.repaint();
                    }
                }
            });
            a8.setText(a5.fontText);
            a8.putClientProperty("classic.look", Boolean.TRUE);
            a8.putClientProperty("font.baseline.alignment", a5.baselineGap);
            a8.putClientProperty("classic.look.button.roundborder", Boolean.TRUE);
            a8.setBorder(null);
            a8.setFont(new Font(a5.fontFamily, a5.fontStyle, a3[a4]));
            a8.setAlignmentY(1.0f);
            a8.setVerticalAlignment(3);
            a8.addMouseListener(a5);
            a.add(a8);
            if (a4 != 0) {
                a6.add(Box.createHorizontalGlue());
            }
            a6.add(a8);
            a5.fontSizeButtons[a2 + a7] = a8;
            n = ++a4;
        }
        return a6;
    }

    private void handleDismiss() {
        FontResizeDialog a;
        if (a.isShowing() && !a.relayoutScheduled && a.releaseOccured) {
            if (a.dismissTimer != null) {
                a.dismissTimer.cancel();
            }
            a.dismissTimer = new Timer();
            a.dismissTimer.schedule(new TimerTask(){
                {
                    7 a;
                }

                public void run() {
                    7 a;
                    a.FontResizeDialog.this.getCloseAction().actionPerformed(null);
                }
            }, 1500L);
            a.canChangeSize = true;
        } else if (!a.relayoutScheduled && a.releaseOccured) {
            a.releaseBeforeShowing = true;
        }
    }

    private void initUI() {
        FontResizeDialog a;
        a.panelSize = (Rectangle)a.rb.getObject("font.menu.panel.size.onlySize");
        a.horizontalMargin = (Integer)a.rb.getObject("font.menu.horizontal.margin");
        a.verticalMargin = (Integer)a.rb.getObject("font.menu.vertical.margin");
        a.textHeight = (Integer)a.rb.getObject("font.menu.text.height");
        a.baselineGap = (Integer)a.rb.getObject("font.menu.baseline.gap");
        a.fontFamily = a.rb.getString("font.menu.family");
        a.fontStyle = (Integer)a.rb.getObject("font.menu.style");
        a.topMargin = (Integer)a.rb.getObject("reader.content.topMargin");
        JPanel a2 = (JPanel)a.getContentPane();
        a2.setLayout(new BorderLayout());
        a2.setBorder((Border)a.rb.getObject("font.menu.panel.border"));
        a2.add(a.getFontMenu());
    }

    private void setDialog() {
        int a;
        FontResizeDialog a2;
        if (a2.readerSDK.getBookController() == null) {
            return;
        }
        int n = a = 0;
        while (n < a2.fontSizeButtons.length) {
            a2.fontSizeButtons[a].setEnabled(true);
            n = ++a;
        }
        a = a2.readerUI.getFontSize();
        if (a < 0 || a >= a2.fontSizeButtons.length) {
            a = a2.defaultFontSize;
        }
        a2.fontSizeButtons[a].setSelected(true);
        Object a3 = a2.contentPanel;
        ContentPanel a4 = a3;
        ContentPanel contentPanel = a3;
        while (!(contentPanel instanceof JFrame)) {
            a4 = a3;
            a3 = ((Component)a3).getParent();
            contentPanel = a3;
        }
        int a5 = (a2.contentPanel.getWidth() - a2.panelSize.width) / 2 + (((Component)a3).getBounds().x + ((Component)((Object)a4)).getBounds().x);
        int a6 = a2.panelSize.y + a2.topMargin + ((Component)a3).getBounds().y + ((Component)((Object)a4)).getBounds().y;
        Rectangle a7 = new Rectangle(a5, a6, a2.panelSize.width, a2.panelSize.height);
        a2.setDialogBounds(a7);
    }
}

