/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ebook.booklet.reader.impl.ui;

import com.amazon.agui.swing.KDialog;
import com.amazon.agui.swing.MultiToggle;
import com.amazon.ebook.booklet.reader.impl.ReaderSDKImpl;
import com.amazon.ebook.booklet.reader.impl.ReaderUIImpl;
import com.amazon.ebook.booklet.reader.sdk.content.FontPreferences;
import com.amazon.ebook.booklet.reader.sdk.internal.BookController;
import com.amazon.ebook.booklet.reader.sdk.internal.RendererCapabilities;
import com.amazon.ebook.booklet.reader.sdk.ui.ReaderAction;
import com.amazon.ebook.booklet.reader.sdk.ui.ReaderUI;
import com.amazon.kindle.booklet.BookletContext;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class FontDialog
extends KDialog {
    private ReaderSDKImpl readerSDK;
    private ReaderUIImpl readerUI;
    private ResourceBundle rb;
    private Rectangle panelSize;
    private String fontText;
    private String fontFamily;
    private int fontStyle;
    private int horizontalMargin;
    private int verticalMargin;
    private int textHeight;
    private int textWidth;
    private Integer baselineGap;
    private JLabel fontSizeLabel;
    private JLabel typefaceLabel;
    private JLabel lineSpacingLabel;
    private JLabel wordsPerLineLabel;
    private FontToggleButton[] fontSizeButtons;
    private FontRadioButton[] typefaceButtons;
    private FontRadioButton[] lineSpacingButtons;
    private FontRadioButton[] wordsPerLineButtons;
    private int defaultFontSize;
    private int defaultTypeface;
    private int defaultLineSpacing;
    private int defaultWordsPerLine;
    private int[] marginList;
    private String[] typefaceList;
    private MultiToggle togglePane;
    private CardToggleButton styleButton;
    private CardToggleButton spacingButton;
    private JPanel cardPanel;
    private FontPreferences prevStates;
    private final long DELAY = 200L;
    private static final boolean useAlternateFonts = new File("/mnt/us/USE_ALT_FONTS").exists();

    public FontDialog(ReaderSDKImpl a, ReaderUIImpl a2) {
        FontDialog a3;
        a3.readerSDK = a;
        a3.readerUI = a2;
        a3.rb = ResourceBundle.getBundle("com.amazon.ebook.booklet.reader.resources.ReaderResources");
        a3.panelSize = (Rectangle)a3.rb.getObject("font.menu.panel.size");
        a3.initUI();
    }

    public void postDialog() {
        FontDialog a;
        a.setDialog();
        a.setDialogBounds(a.panelSize);
        super.postDialog(((BookletContext)a.readerSDK.getActiveContext()).getName());
    }

    private void setDialog() {
        int a;
        int a2;
        int a3;
        int a4;
        int a5;
        int a6;
        FontDialog a7;
        a7.prevStates = FontPreferences.getFontPrefsBasedOnCurrentState((ReaderUI)a7.readerUI);
        BookController a8 = a7.readerSDK.getBookController();
        if (a8 == null) {
            return;
        }
        RendererCapabilities a9 = a8.getCapabilities();
        if (a9 == null) {
            return;
        }
        boolean a10 = a7.readerUI.getUIContext().isFontChangeable();
        boolean a11 = a10 || a9.isFontSizeChangeable();
        a7.fontSizeLabel.setEnabled(a11);
        int n = a6 = 0;
        while (n < a7.fontSizeButtons.length) {
            a7.fontSizeButtons[a6].setEnabled(a11);
            n = ++a6;
        }
        a6 = a7.readerUI.getFontSize();
        if (a6 < 0 || a6 >= a7.fontSizeButtons.length) {
            a6 = a7.defaultFontSize;
        }
        a7.fontSizeButtons[a6].setSelected(true);
        boolean a12 = a10 || a9.isFontFamilyChangeable();
        a7.typefaceLabel.setEnabled(a12);
        int n2 = a5 = 0;
        while (n2 < a7.typefaceButtons.length) {
            a7.typefaceButtons[a5].setEnabled(a12);
            n2 = ++a5;
        }
        String a22 = a7.readerUI.getFontFamily();
        int a13 = a7.defaultTypeface;
        int n3 = a4 = 0;
        while (n3 < a7.typefaceList.length) {
            if (a7.typefaceList[a4].equals(a22)) {
                a13 = a4;
                break;
            }
            n3 = ++a4;
        }
        a7.typefaceButtons[a13].setSelected(true);
        a4 = a10 || a9.isLineSpacingChangeable() ? 1 : 0;
        a7.lineSpacingLabel.setEnabled(a4 != 0);
        int n4 = a3 = 0;
        while (n4 < a7.lineSpacingButtons.length) {
            a7.lineSpacingButtons[a3].setEnabled(a4 != 0);
            n4 = ++a3;
        }
        a3 = a7.readerUI.getLineSpacing();
        if (a3 < 0 || a3 >= a7.lineSpacingButtons.length) {
            a3 = a7.defaultLineSpacing;
        }
        a7.lineSpacingButtons[a3].setSelected(true);
        boolean a14 = a10 || a9.isContentMarginChangeable();
        a7.wordsPerLineLabel.setEnabled(a14);
        int n5 = a2 = 0;
        while (n5 < a7.wordsPerLineButtons.length) {
            a7.wordsPerLineButtons[a2].setEnabled(a14);
            n5 = ++a2;
        }
        a2 = a7.readerUI.getContentLeftMargin();
        a13 = a7.defaultWordsPerLine;
        int n6 = a = 0;
        while (n6 < a7.marginList.length) {
            if (a2 == a7.marginList[a]) {
                a13 = a;
                break;
            }
            n6 = ++a;
        }
        a7.wordsPerLineButtons[a13].setSelected(true);
        a7.styleButton.doClick();
    }

    private void initUI() {
        FontDialog a;
        a.horizontalMargin = (Integer)a.rb.getObject("font.menu.horizontal.margin");
        a.verticalMargin = (Integer)a.rb.getObject("font.menu.vertical.margin");
        a.textHeight = (Integer)a.rb.getObject("font.menu.text.height");
        a.textWidth = (Integer)a.rb.getObject("font.menu.text.width");
        a.baselineGap = (Integer)a.rb.getObject("font.menu.baseline.gap");
        a.fontFamily = a.rb.getString("font.menu.family");
        a.fontStyle = (Integer)a.rb.getObject("font.menu.style");
        a.setTitleBarEnabled(true);
        a.setTitle(a.rb.getString("font.menu.title"));
        a.setCommandBarPosition(-1);
        JPanel a2 = (JPanel)a.getContentPane();
        a2.setLayout(new BorderLayout());
        a2.setBorder((Border)a.rb.getObject("font.menu.panel.border"));
        String a3 = a.rb.getString("font.toggle.style");
        String a4 = a.rb.getString("font.toggle.spacing");
        a.togglePane = new MultiToggle();
        a.togglePane.setAlignmentX(0.0f);
        a.styleButton = a.new CardToggleButton(a3);
        a.styleButton.setSelected(true);
        a.togglePane.add((Component)a.styleButton);
        a.spacingButton = a.new CardToggleButton(a4);
        a.togglePane.add((Component)a.spacingButton);
        a2.add((Component)a.togglePane, "North");
        a.cardPanel = new JPanel(new CardLayout());
        JPanel a5 = new JPanel();
        a5.setLayout(new BoxLayout(a5, 1));
        a5.setBorder(new EmptyBorder((Insets)a.rb.getObject("font.menu.border.margin")));
        a.fontSizeLabel = new JLabel(a.rb.getString("font.menu.label.fontsize"));
        a5.add(a.fontSizeLabel);
        a5.add(a.getFontMenu());
        a5.add(Box.createVerticalStrut(a.verticalMargin));
        a5.add(new JSeparator(0));
        a.typefaceLabel = new JLabel(a.rb.getString("font.menu.label.typeface"));
        a5.add(a.typefaceLabel);
        a5.add(a.getTypefaceMenu());
        a.cardPanel.add((Component)a5, a3);
        JPanel a6 = new JPanel();
        a6.setLayout(new BoxLayout(a6, 1));
        a6.setBorder(new EmptyBorder((Insets)a.rb.getObject("font.menu.border.margin")));
        a.lineSpacingLabel = new JLabel(a.rb.getString("font.menu.label.linespacing"));
        a6.add(a.lineSpacingLabel);
        a6.add(a.getLineSpacingMenu());
        a5.add(Box.createVerticalStrut(a.verticalMargin));
        a6.add(new JSeparator(0));
        a.wordsPerLineLabel = new JLabel(a.rb.getString("font.menu.label.wordsperline"));
        a6.add(a.wordsPerLineLabel);
        a6.add(a.getWordsPerLineMenu());
        a.cardPanel.add((Component)a6, a4);
        a2.add((Component)a.cardPanel, "Center");
    }

    private JPanel getFontMenu() {
        int a;
        int a2;
        FontDialog a3;
        JPanel a4 = new JPanel();
        a4.setLayout(new BoxLayout(a4, 1));
        a4.setAlignmentX(0.0f);
        ButtonGroup a5 = new ButtonGroup();
        a3.fontText = a3.rb.getString("font.menu.text");
        a3.defaultFontSize = (Integer)a3.rb.getObject("font.menu.size.default");
        int[][] a6 = (int[][])a3.rb.getObject("font.menu.size.list");
        int a7 = 0;
        int n = a2 = 0;
        while (n < a6.length) {
            a7 += a6[a2].length;
            n = ++a2;
        }
        a3.fontSizeButtons = new FontToggleButton[a7];
        a2 = 0;
        int n2 = a = 0;
        while (n2 < a6.length) {
            int[] a8 = a6[a];
            a4.add(a3.getFontMenuRow(a5, a2, a8));
            a2 += a8.length;
            n2 = ++a;
        }
        return a4;
    }

    private JPanel getFontMenuRow(ButtonGroup a, int a2, int[] a3) {
        int a4;
        FontDialog a5;
        JPanel a6 = new JPanel();
        a6.setLayout(new BoxLayout(a6, 0));
        a6.setAlignmentX(0.0f);
        a6.setPreferredSize(new Dimension(0, a5.textHeight));
        int n = a4 = 0;
        while (n < a3.length) {
            FontToggleButton a7 = new FontToggleButton(a2, a5.fontText, new Font(a5.fontFamily, a5.fontStyle, a3[a4])){
                {
                    1 a4;
                    super(a, a2, a3);
                }

                public void actionPerformed(ActionEvent a) {
                    1 a2;
                    if (a2.index != a2.FontDialog.this.readerUI.getFontSize()) {
                        a2.FontDialog.this.readerUI.setFontSize(a2.index, true);
                        a2.FontDialog.this.updateReaderScreen();
                    }
                }
            };
            a7.setAlignmentY(1.0f);
            a7.setVerticalAlignment(3);
            a.add(a7);
            if (a4 != 0) {
                a6.add(Box.createHorizontalGlue());
            }
            a6.add(a7);
            a5.fontSizeButtons[a2++] = a7;
            n = ++a4;
        }
        return a6;
    }

    private JPanel getTypefaceMenu() {
        int a;
        FontDialog a2;
        JPanel a3 = new JPanel(new GridLayout(1, 0));
        a3.setAlignmentX(0.0f);
        ButtonGroup a4 = new ButtonGroup();
        a2.defaultTypeface = (Integer)a2.rb.getObject("font.menu.typeface.default");
        a2.typefaceList = (String[])a2.rb.getObject(useAlternateFonts ? "font.menu.typeface.altlist" : "font.menu.typeface.list");
        String[] a5 = (String[])a2.rb.getObject(useAlternateFonts ? "font.menu.typeface.display.altlist" : "font.menu.typeface.display.list");
        a2.typefaceButtons = new FontRadioButton[a5.length];
        int n = a = 0;
        while (n < a5.length) {
            FontRadioButton a6 = new FontRadioButton(a, a5[a]){
                {
                    2 a3;
                    super(a, a2);
                }

                public void actionPerformed(ActionEvent a) {
                    2 a2;
                    String a3 = a2.FontDialog.this.typefaceList[a2.index];
                    if (!a3.equals(a2.FontDialog.this.readerUI.getFontFamily())) {
                        a2.FontDialog.this.readerUI.setFontFamily(a3, true);
                        a2.FontDialog.this.updateReaderScreen();
                    }
                }
            };
            a4.add(a6);
            a3.add(a6);
            a2.typefaceButtons[a] = a6;
            n = ++a;
        }
        return a3;
    }

    private JPanel getLineSpacingMenu() {
        int a;
        FontDialog a2;
        JPanel a3 = new JPanel(new GridLayout(1, 0));
        a3.setAlignmentX(0.0f);
        ButtonGroup a4 = new ButtonGroup();
        a2.defaultLineSpacing = (Integer)a2.rb.getObject("font.linespacing.default");
        String[] a5 = (String[])a2.rb.getObject("font.linespacing.list");
        a2.lineSpacingButtons = new FontRadioButton[a5.length];
        int n = a = 0;
        while (n < a5.length) {
            FontRadioButton a6 = new FontRadioButton(a, a5[a]){
                {
                    3 a3;
                    super(a, a2);
                }

                public void actionPerformed(ActionEvent a) {
                    3 a2;
                    if (a2.index != a2.FontDialog.this.readerUI.getLineSpacing()) {
                        a2.FontDialog.this.readerUI.setLineSpacing(a2.index, true);
                        a2.FontDialog.this.updateReaderScreen();
                    }
                }
            };
            a4.add(a6);
            a3.add(a6);
            a2.lineSpacingButtons[a] = a6;
            n = ++a;
        }
        return a3;
    }

    private JPanel getWordsPerLineMenu() {
        int a;
        FontDialog a2;
        JPanel a3 = new JPanel(new GridLayout(1, 0));
        a3.setAlignmentX(0.0f);
        ButtonGroup a4 = new ButtonGroup();
        a2.marginList = (int[])a2.rb.getObject("font.wordsperline.margin.list");
        a2.defaultWordsPerLine = (Integer)a2.rb.getObject("font.wordsperline.default");
        String[] a5 = (String[])a2.rb.getObject("font.wordsperline.list");
        a2.wordsPerLineButtons = new FontRadioButton[a5.length];
        int n = a = 0;
        while (n < a5.length) {
            FontRadioButton a6 = new FontRadioButton(a, a5[a]){
                {
                    4 a3;
                    super(a, a2);
                }

                public void actionPerformed(ActionEvent a) {
                    4 a2;
                    int a3 = a2.FontDialog.this.marginList[a2.index];
                    if (a3 != a2.FontDialog.this.readerUI.getContentLeftMargin() || a3 != a2.FontDialog.this.readerUI.getContentRightMargin()) {
                        int a4 = a2.FontDialog.this.readerUI.getContentTopMargin();
                        int a5 = a2.FontDialog.this.readerUI.getContentBottomMargin();
                        a2.FontDialog.this.readerUI.setContentMargin(a4, a3, a3, a5, true);
                        a2.FontDialog.this.updateReaderScreen();
                    }
                }
            };
            a4.add(a6);
            a3.add(a6);
            a2.wordsPerLineButtons[a] = a6;
            n = ++a;
        }
        return a3;
    }

    private void updateReaderScreen() {
        FontDialog a;
        UpdateReaderAction a2 = a.new UpdateReaderAction();
        Timer a3 = new Timer(200, a2);
        a3.setRepeats(false);
        a3.start();
    }

    public ReaderAction getFontAction() {
        FontDialog a;
        return new ReaderAction(a.rb.getString("font.button.text")){
            {
                5 a2;
                super(a);
            }

            public void actionPerformed(ActionEvent a) {
                5 a2;
                a2.FontDialog.this.postDialog();
            }

            public int getPriority() {
                return 100;
            }

            public int getType() {
                return 2;
            }
        };
    }

    class UpdateReaderAction
    implements ActionListener {
        UpdateReaderAction() {
            UpdateReaderAction a;
        }

        public void actionPerformed(ActionEvent a) {
            UpdateReaderAction a2;
            a2.FontDialog.this.readerSDK.invokeLater(new Runnable(){
                {
                    1 a;
                }

                public void run() {
                    1 a;
                    FontDialog.this.readerUI.getReaderPane().repaint();
                }
            });
        }
    }

    class OKAction
    extends AbstractAction {
        public OKAction() {
            OKAction a;
            super(a.FontDialog.this.rb.getString("font.action.ok"));
        }

        public void actionPerformed(ActionEvent a) {
            OKAction a2;
            a2.FontDialog.this.getCloseAction().actionPerformed(null);
        }
    }

    class CancelAction
    extends AbstractAction {
        public CancelAction() {
            CancelAction a;
            super(a.FontDialog.this.rb.getString("font.action.cancel"));
        }

        public void actionPerformed(ActionEvent a) {
            CancelAction a2;
            a2.FontDialog.this.getCloseAction().actionPerformed(null);
            if (a2.FontDialog.this.prevStates.setFontPrefs((ReaderUI)a2.FontDialog.this.readerUI)) {
                a2.FontDialog.this.readerUI.getReaderPane().repaint();
            }
        }
    }

    abstract class FontRadioButton
    extends JRadioButton
    implements ActionListener {
        protected int index;

        public FontRadioButton(int a, String a2) {
            FontRadioButton a3;
            super(a2);
            a3.index = a;
            a3.setHorizontalTextPosition(4);
            a3.setHorizontalAlignment(2);
            a3.addActionListener(a3);
        }
    }

    abstract class FontToggleButton
    extends JToggleButton
    implements ActionListener {
        protected int index;

        public FontToggleButton(int a, String a2, Font a3) {
            FontToggleButton a4;
            super(a2);
            a4.putClientProperty("classic.look", Boolean.TRUE);
            a4.putClientProperty("font.baseline.alignment", a4.FontDialog.this.baselineGap);
            a4.putClientProperty("classic.look.button.roundborder", Boolean.TRUE);
            a4.setBorder(null);
            a4.index = a;
            a4.setFont(a3);
            a4.addActionListener(a4);
        }

        public Dimension getPreferredSize() {
            FontToggleButton a;
            Dimension a2 = super.getPreferredSize();
            if (a2.width < a.FontDialog.this.textWidth) {
                a2.width = a.FontDialog.this.textWidth;
            }
            return a2;
        }
    }

    class CardToggleButton
    extends JToggleButton
    implements ActionListener {
        public CardToggleButton(String a) {
            CardToggleButton a2;
            super(a);
            a2.putClientProperty("classic.look", Boolean.TRUE);
            a2.addActionListener(a2);
        }

        public void actionPerformed(ActionEvent a) {
            CardToggleButton a2;
            ((CardLayout)a2.FontDialog.this.cardPanel.getLayout()).show(a2.FontDialog.this.cardPanel, a2.getText());
        }
    }
}

