/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ebook.booklet.reader.impl.ui;

import com.amazon.agui.swing.KDialog;
import com.amazon.ebook.booklet.reader.impl.ReaderSDKImpl;
import com.amazon.ebook.booklet.reader.impl.ReaderUIImpl;
import com.amazon.ebook.booklet.reader.sdk.ui.ReaderAction;
import com.amazon.kindle.booklet.BookletContext;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class FontContrastDialog
extends KDialog {
    private ReaderSDKImpl readerSDK;
    private ReaderUIImpl readerUI;
    private ResourceBundle rb;
    private Rectangle panelSize;
    private int[] contrastList;
    private JSlider contrastSlider;

    public FontContrastDialog(ReaderSDKImpl a, ReaderUIImpl a2) {
        FontContrastDialog a3;
        a3.readerSDK = a;
        a3.readerUI = a2;
        a3.rb = ResourceBundle.getBundle("com.amazon.ebook.booklet.reader.resources.ReaderResources");
        a3.panelSize = (Rectangle)a3.rb.getObject("font.menu.panel.size");
        a3.initUI();
    }

    private void initUI() {
        FontContrastDialog a;
        a.setTitleBarEnabled(true);
        a.setTitle(a.rb.getString("font.toggle.contrast"));
        JPanel a2 = (JPanel)a.getContentPane();
        a2.setLayout(new BorderLayout());
        a2.setBorder((Border)a.rb.getObject("font.menu.panel.border"));
        JPanel a3 = new JPanel();
        a3.setLayout(new BoxLayout(a3, 1));
        a3.setBorder(new EmptyBorder((Insets)a.rb.getObject("font.menu.border.margin")));
        a2.add((Component)a3, "North");
        a2.add(a.getContrastSliderPanel());
    }

    /*
     * Enabled aggressive block sorting
     */
    private int _convertContrastToSlidervalue(int a) {
        int a2 = 2;
        switch (a) {
            case -2: {
                return 4;
            }
            case -1: {
                return 3;
            }
            case 0: {
                return 2;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 0;
            }
        }
        return 2;
    }

    private void setDialog() {
        FontContrastDialog a;
        a.contrastSlider.setValue(a._convertContrastToSlidervalue(a.readerUI.getContrast()));
    }

    public void postDialog() {
        FontContrastDialog a;
        a.setDialog();
        a.setDialogBounds(a.panelSize);
        super.postDialog(((BookletContext)a.readerSDK.getActiveContext()).getName());
    }

    /*
     * Enabled aggressive block sorting
     */
    private int _convertSliderValuetoContrastValue(int a) {
        int a2 = 0;
        switch (a) {
            case 0: {
                return 2;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 0;
            }
            case 3: {
                return -1;
            }
            case 4: {
                return -2;
            }
        }
        if (a2 > -2) {
            return -2;
        }
        if (a2 >= 2) return 0;
        return 2;
    }

    private JPanel getContrastSliderPanel() {
        FontContrastDialog a;
        JPanel a2 = new JPanel(new BorderLayout());
        a2.setBorder((Border)a.rb.getObject("pdfconrast.panel.border"));
        a.contrastList = (int[])a.rb.getObject("font.contrast.value.list");
        int a3 = a._convertContrastToSlidervalue(a.readerUI.getContrast());
        a.contrastSlider = new JSlider(0, 0, a.contrastList.length - 1, a3);
        a.contrastSlider.addChangeListener(new ChangeListener(){
            {
                1 a;
            }

            public void stateChanged(ChangeEvent a) {
                JSlider a2 = (JSlider)a.getSource();
                if (!a2.getValueIsAdjusting()) {
                    1 a3;
                    int a4 = a2.getValue();
                    if ((a4 = a3.FontContrastDialog.this._convertSliderValuetoContrastValue(a4)) != a3.FontContrastDialog.this.readerUI.getContrast()) {
                        a3.FontContrastDialog.this.readerUI.setContrast(a4);
                        a3.FontContrastDialog.this.readerUI.getReaderPane().repaint();
                    }
                }
            }
        });
        a2.add((Component)a.contrastSlider, "Center");
        LighterDarkerButton a4 = a.new LighterDarkerButton(a.rb.getString("pdf.makeLighter.text"), -1, a.contrastSlider);
        a2.add((Component)a4, "West");
        LighterDarkerButton a5 = a.new LighterDarkerButton(a.rb.getString("pdf.makeDarker.text"), 1, a.contrastSlider);
        a2.add((Component)a5, "East");
        GridLayout a6 = new GridLayout();
        JPanel a7 = new JPanel(a6);
        Object a8 = a.rb.getObject("pdf.horizontalGap.value");
        a6.setHgap((Integer)a8);
        JLabel a9 = new JLabel(a.rb.getString("pdf.lightest.text"));
        a7.add(a9);
        JLabel a10 = new JLabel(a.rb.getString("pdf.normal.text"));
        a7.add(a10);
        JLabel a11 = new JLabel(a.rb.getString("pdf.darkest.text"));
        a11.setHorizontalAlignment(4);
        a7.add(a11);
        a2.add((Component)a7, "South");
        return a2;
    }

    public ReaderAction getFontContrastAction(String a) {
        FontContrastDialog a2;
        return new ReaderAction(a){
            {
                2 a2;
                super(a);
            }

            public void actionPerformed(ActionEvent a) {
                2 a2;
                a2.FontContrastDialog.this.postDialog();
            }

            public int getPriority() {
                return 100;
            }

            public int getType() {
                return 2;
            }
        };
    }

    private class LighterDarkerButton
    extends JButton {
        public LighterDarkerButton(String a, final int a2, final JSlider a3) {
            LighterDarkerButton a4;
            super(a);
            a4.addActionListener(new ActionListener(){
                {
                    1 a;
                }

                public void actionPerformed(ActionEvent a) {
                    1 a22;
                    a22.a3.setValue(a22.a3.getValue() + a22.a2);
                }
            });
        }
    }
}

