/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ebook.booklet.reader.impl.ui;

import com.amazon.ebook.booklet.reader.impl.ReaderSDKImpl;
import com.amazon.ebook.booklet.reader.impl.annotation.AnnotationImpl;
import com.amazon.ebook.booklet.reader.impl.annotation.personal.Note;
import com.amazon.ebook.booklet.reader.impl.ui.AnnotationElement;
import com.amazon.ebook.booklet.reader.impl.ui.AnnotationElementActionHandler;
import com.amazon.ebook.booklet.reader.impl.ui.HighlightDrawer;
import com.amazon.ebook.booklet.reader.impl.ui.HighlightOverlayModel;
import com.amazon.ebook.booklet.reader.impl.ui.PublicNotesElement;
import com.amazon.ebook.booklet.reader.sdk.ReaderSDK;
import com.amazon.ebook.booklet.reader.sdk.content.Element;
import com.amazon.ebook.booklet.reader.sdk.content.ElementActionHandler;
import com.amazon.ebook.booklet.reader.sdk.content.Position;
import com.amazon.ebook.booklet.reader.sdk.content.ScreenInfo;
import com.amazon.ebook.booklet.reader.sdk.content.Viewport;
import com.amazon.ebook.booklet.reader.sdk.content.ZoomViewport;
import com.amazon.ebook.booklet.reader.sdk.content.annotation.Annotation;
import com.amazon.ebook.booklet.reader.sdk.content.annotation.AnnotationManager;
import com.amazon.ebook.booklet.reader.sdk.internal.BookView;
import com.amazon.ebook.booklet.reader.sdk.ui.PageDecorator;
import com.amazon.ebook.util.log.Log;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import javax.imageio.ImageIO;

public class AnnotationDecorator
implements PageDecorator {
    private static final Log c = Log.getInstance((String)"AnnotationDecorator");
    private static final int l = 2;
    private static final int k = 5;
    private static final int m = 2;
    private static final int h = 3;
    private static final AnnotationElementActionHandler A = new AnnotationElementActionHandler();
    private ReaderSDK H;
    private final ResourceBundle b = ResourceBundle.getBundle("com.amazon.ebook.booklet.reader.impl.ui.resources.UIResourcesDNT");
    private final String K = a2.b.getString("annotation.decoration.bookmark.img");
    private final URL B;
    private static Image D;

    public AnnotationDecorator(ReaderSDK a) {
        AnnotationDecorator a2;
        a2.B = a2.getClass().getResource(a2.K);
        a2.H = a;
        if (a2.B != null) {
            try {
                D = ImageIO.read(a2.B);
            }
            catch (IOException a3) {
                a3.printStackTrace();
                c.error("Failed loading image: ", (Throwable)a3);
            }
        } else {
            c.error("Failed finding URL: " + a2.B);
        }
    }

    public static ElementActionHandler getAnnotationElementActionHandler() {
        return A;
    }

    public List findAnnotations(Viewport a) {
        AnnotationDecorator a2;
        AnnotationManager a3 = a2.H.getAnnotationManager();
        if (Log.isDebugOn()) {
            c.debug("finding annotations with positions:" + a.getStartPosition() + ' ' + a.getEndPosition());
        }
        return a3.getAnnotationsInRange(a.getBook(), a.getStartPosition(), a.getEndPosition());
    }

    public List decoratePage(ScreenInfo a, Graphics2D a2, Rectangle a3) {
        AnnotationDecorator a4;
        if (a == null) {
            return null;
        }
        List a5 = a4.findAnnotations(a.getViewport());
        if (Log.isDebugOn()) {
            c.debug("drawing " + a5.size() + " annotations.");
        }
        if (a5.size() > 0) {
            return a4.drawAnnotations(a, a2, a3, a5);
        }
        return null;
    }

    public List decoratePage(ScreenInfo a, Graphics2D a2, Rectangle a3, Annotation a4) {
        AnnotationDecorator a5;
        if (a4 == null) {
            return a5.decoratePage(a, a2, a3);
        }
        ArrayList<Annotation> a6 = new ArrayList<Annotation>(1);
        a6.add(a4);
        return a5.drawAnnotations(a, a2, a3, a6);
    }

    public boolean needsScreenInfo(Viewport a) {
        AnnotationDecorator a2;
        List a3 = a2.findAnnotations(a);
        if (Log.isDebugOn()) {
            c.debug("Number of Annotations found in needsScreenInfo(): " + a3.size());
        }
        return a3.size() > 0;
    }

    public boolean drawsOutsideContents() {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public List drawAnnotations(ScreenInfo a, Graphics2D a2, Rectangle a3, List a4) {
        Object a5;
        AnnotationDecorator a6;
        if (a.getElements().length <= 0) {
            return null;
        }
        Collections.sort(a4, new Comparator(){
            {
                1 a;
            }

            public int compare(Object a, Object a2) {
                Annotation a3 = (Annotation)a;
                Annotation a4 = (Annotation)a2;
                int a5 = a3.getStartPosition().compareTo((Object)a4.getStartPosition());
                if (a5 == 0) {
                    a5 = a3.getEndPosition().compareTo((Object)a4.getEndPosition());
                }
                return a5;
            }
        });
        ArrayList<Annotation> a7 = new ArrayList<Annotation>(a4.size());
        ArrayList<Annotation> a8 = new ArrayList<Annotation>(a4.size());
        ArrayList<Annotation> a9 = new ArrayList<Annotation>(a4.size());
        ArrayList<Annotation> a10 = new ArrayList<Annotation>(a4.size());
        ArrayList<Annotation> a11 = new ArrayList<Annotation>(a4.size());
        ArrayList<Annotation> a12 = new ArrayList<Annotation>(a4.size());
        Position a13 = a.getViewport().getStartPosition();
        int a14 = 0;
        int a15 = a4.size();
        int n = a14;
        while (n < a15) {
            Annotation annotation = (Annotation)a4.get(a14);
            if (a13.compareTo((Object)annotation.getEndPosition()) <= 0) {
                switch (annotation.getType()) {
                    case 1: {
                        a7.add(annotation);
                        break;
                    }
                    case 5: {
                        a8.add(annotation);
                        break;
                    }
                    case 7: {
                        a9.add(annotation);
                        break;
                    }
                    case 2: {
                        a10.add(annotation);
                        break;
                    }
                    case 8: {
                        a11.add(annotation);
                        break;
                    }
                    case 0: {
                        a12.add(annotation);
                        break;
                    }
                    case 3: {
                        c.info("Passing AnnotationType Clip This Article");
                        break;
                    }
                    default: {
                        c.error("Attempting to draw unknown AnnotationType: " + annotation.getType());
                    }
                }
            }
            n = ++a14;
        }
        a14 = 0;
        a15 = 0;
        Rectangle rectangle = new Rectangle();
        boolean a16 = false;
        if (a.getViewport() instanceof ZoomViewport) {
            a5 = (ZoomViewport)a.getViewport();
            if (a5.getZoomLevel() != 1.0) {
                a16 = true;
            }
            a14 = a5.getXOffset();
            a15 = a5.getYOffset();
        }
        rectangle.x = a14;
        rectangle.y = a15;
        rectangle.width = a.getViewport().getWidth();
        rectangle.height = a.getViewport().getHeight();
        a5 = a6.new DrawingHelper(a2, a, rectangle, a3);
        ((DrawingHelper)a5).drawBookmark(a12, a16);
        ((DrawingHelper)a5).drawUserHighlights(a7);
        ((DrawingHelper)a5).drawPopularAndPublicHighlights(a8, a9);
        return ((DrawingHelper)a5).drawNotes(a10, a11, a);
    }

    private class DrawingHelper {
        private final String F;
        private final Font L;
        private final Color c;
        private final Color l;
        private final Color k;
        private final Font m;
        private final int h;
        private Graphics2D A;
        private ScreenInfo H;
        private Rectangle b;
        private Rectangle K;
        private Element[] B;

        public DrawingHelper(Graphics2D a, ScreenInfo a2, Rectangle a3, Rectangle a4) {
            DrawingHelper a5;
            a5.A = a;
            a5.H = a2;
            a5.b = a3;
            a5.K = a4;
            a5.B = a2.getElements();
            ResourceBundle a6 = ResourceBundle.getBundle("com.amazon.ebook.booklet.reader.impl.ui.resources.UIResources");
            a5.F = a6.getString("annotation.decoration.public.note.marker.text");
            a5.L = (Font)a6.getObject("annotation.decoration.public.note.marker.font");
            a5.c = (Color)a6.getObject("annotation.decoration.note.marker.color");
            a5.l = (Color)a6.getObject("annotation.decoration.note.marker.border.color");
            a5.k = (Color)a6.getObject("annotation.decoration.note.marker.text.color");
            a5.m = (Font)a6.getObject("annotation.decoration.note.marker.font");
            a5.h = (Integer)a6.getObject("annotation.decoration.note.marker.rounding.arc");
        }

        public void drawBookmark(List a, boolean a2) {
            if (a.size() > 0) {
                if (D != null) {
                    DrawingHelper a3;
                    Rectangle a4 = a3.A.getClipBounds();
                    a3.A.setClip(null);
                    int a5 = a3.K.width;
                    if (a2) {
                        a5 -= 11;
                    }
                    a3.A.drawImage(D, a5 - D.getWidth(null), 0, null);
                    a3.A.setClip(a4);
                } else {
                    c.error("Attempt to draw Bookmark failed because there was no image");
                }
            }
        }

        public void drawUserHighlights(List a) {
            int a2 = 0;
            int a3 = a.size();
            int n = a2;
            while (n < a3) {
                DrawingHelper a4;
                Annotation a5 = (Annotation)a.get(a2);
                Composite a6 = a4.A.getComposite();
                a4.A.setComposite(AlphaComposite.getInstance(3, 0.3f));
                int a7 = a4.H.findFirstElementIndexInRange(a5.getStartPosition(), a5.getEndPosition());
                if (a7 != -1) {
                    BookView a8;
                    Rectangle a9;
                    ArrayList<Rectangle> a10 = new ArrayList<Rectangle>();
                    Rectangle a11 = null;
                    int a12 = -1;
                    Rectangle a13 = a4.A.getClipBounds();
                    if (((ReaderSDKImpl)a4.AnnotationDecorator.this.H).getUI().getUIContext() == ((ReaderSDKImpl)a4.AnnotationDecorator.this.H).getUI().getBookContentUIContext() && (a9 = (a8 = ((ReaderSDKImpl)a4.AnnotationDecorator.this.H).getBookController().getBookView()).getBounds()) != null) {
                        a4.A.setClip(a9);
                    }
                    int n2 = a7;
                    DrawingHelper drawingHelper = a4;
                    while (n2 < drawingHelper.B.length && a4.B[a7].getEndPosition().compareTo((Object)a5.getEndPosition()) <= 0) {
                        if (a4.B[a7].isSelectable()) {
                            int a14 = 0;
                            int a15 = a4.B[a7].getBoundsCount();
                            int n3 = a14;
                            while (n3 < a15) {
                                Rectangle a16 = a4.B[a7].getBounds(a14);
                                if (a11 == null) {
                                    a11 = a16;
                                } else if (a12 != a4.B[a7].getBoundsRunID(a14)) {
                                    a10.add(a11);
                                    a11 = a16;
                                } else {
                                    a11.add(a16);
                                }
                                a12 = a4.B[a7].getBoundsRunID(a14);
                                n3 = ++a14;
                            }
                        }
                        n2 = ++a7;
                        drawingHelper = a4;
                    }
                    if (a11 != null) {
                        a10.add(a11);
                        if (a10.size() > 0) {
                            int a17;
                            int n4 = a17 = 0;
                            while (n4 < a10.size()) {
                                a9 = (Rectangle)a10.get(a17);
                                a9.x -= a4.b.x;
                                a9.y -= a4.b.y;
                                a4.A.fillRect(a9.x, a9.y, a9.width, a9.height);
                                n4 = ++a17;
                            }
                        }
                    }
                    a4.A.setComposite(a6);
                    a4.A.setClip(a13);
                }
                n = ++a2;
            }
        }

        public void drawPopularAndPublicHighlights(List a, List a2) {
            DrawingHelper a3;
            HighlightOverlayModel a4 = new HighlightOverlayModel();
            a4.updateForNewPage(a3.B, null, a2, a);
            if (a4.hasPopularOrPublicHighlights()) {
                HighlightDrawer.drawHighlights(a3.AnnotationDecorator.this.H, a3.A, a4, a3.B, a3.K);
            }
        }

        public List drawNotes(List a, List a2, ScreenInfo a3) {
            Element a4;
            Object a5;
            DrawingHelper a6;
            ArrayList a7 = new ArrayList(a.size() + a2.size());
            int a8 = 0;
            int a9 = 0;
            int a10 = 0;
            int a11 = a.size();
            int a12 = 0;
            int a13 = a2.size();
            int a14 = -1;
            int a15 = -1;
            int a16 = -1;
            int a17 = -1;
            Color a18 = a6.A.getColor();
            Font a19 = a6.A.getFont();
            Rectangle a20 = a6.A.getClipBounds();
            a6.A.setFont(a6.m);
            a6.A.setClip(null);
            block0: while (!(a10 == a14 && a12 == a15 || a10 >= a11 && a12 >= a13)) {
                a5 = null;
                a14 = a10;
                a15 = a12;
                if (a10 < a11) {
                    a5 = ((Annotation)a.get(a10)).getEndPosition();
                }
                if (a12 < a13) {
                    Position a21 = ((Annotation)a2.get(a12)).getEndPosition();
                    if (a5 == null || a5.compareTo((Object)a21) > 0) {
                        a5 = a21;
                    }
                }
                int n = a8;
                while (n < a6.B.length) {
                    int a22;
                    a4 = a6.B[a22];
                    Position a23 = a4.getEndPosition();
                    int a24 = a23.compareTo(a5);
                    int a25 = -1;
                    if (a24 > 0 && a9 < 0) {
                        a25 = a22 - 1;
                        a8 = a22;
                    } else if (a24 >= 0) {
                        a25 = a22;
                        a8 = a22 + 1;
                    }
                    a9 = a24;
                    if (a25 != -1) {
                        Annotation a26;
                        Object a27;
                        Note a28 = null;
                        if (a10 < a11 && a23.compareTo((Object)((AnnotationImpl)(a27 = (Note)a.get(a10))).getEndPosition()) >= 0) {
                            ++a10;
                            a28 = a27;
                            a16 = a25;
                        }
                        a27 = null;
                        int n2 = a12;
                        int n3 = a13;
                        while (n2 < n3 && a23.compareTo((Object)(a26 = (Annotation)a2.get(a12)).getEndPosition()) >= 0) {
                            if (a27 == null) {
                                a27 = new LinkedList();
                            }
                            a27.add(a26);
                            n2 = ++a12;
                            n3 = a13;
                        }
                        if (a27 != null) {
                            a17 = a25;
                        }
                        a6.drawNotes(a4, a28, (List)a27, a7, a3);
                        continue block0;
                    }
                    n = ++a22;
                }
            }
            a8 = a6.B.length - 1;
            a5 = null;
            if (a16 != a8 && a10 < a11) {
                a5 = (Note)a.get(a10);
            }
            LinkedList<Element> a29 = null;
            if (a17 != a8 && a12 < a13) {
                a29 = new LinkedList<Element>();
                int n = a12;
                while (n < a13) {
                    a4 = (Annotation)a2.get(a12);
                    a29.add(a4);
                    n = ++a12;
                }
            }
            a6.drawNotes(a6.B[a8], (Note)a5, a29, a7, a3);
            a6.A.setFont(a19);
            a6.A.setColor(a18);
            a6.A.setClip(a20);
            return a7;
        }

        /*
         * Enabled aggressive block sorting
         */
        private void drawNotes(Element a, Note a2, List a3, List a4, ScreenInfo a5) {
            DrawingHelper a6;
            if (a2 == null && a3 == null) {
                return;
            }
            Rectangle a7 = a.getBounds(a.getBoundsCount() - 1);
            Rectangle a8 = null;
            if (a5.getViewport() instanceof ZoomViewport) {
                ZoomViewport zoomViewport = (ZoomViewport)a5.getViewport();
                a8 = new Rectangle();
                new Rectangle().x = zoomViewport.getXOffset();
                a8.y = zoomViewport.getYOffset();
                a8.width = zoomViewport.getWidth();
                a8.height = zoomViewport.getHeight();
            }
            Rectangle rectangle = new Rectangle();
            new Rectangle().width = rectangle.height = a6.m.getSize() + 6;
            int a9 = 0;
            String a10 = "";
            if (a2 != null) {
                a10 = Integer.toString(a2.getNumber());
                rectangle.width = a9 = a6.A.getFontMetrics().stringWidth(a10) - 2 + 6;
            }
            switch (a.getPrimaryDirection()) {
                case 0: 
                case 1: {
                    rectangle.y = a7.y - 5;
                    rectangle.x = (int)a7.getMaxX() + 2 - rectangle.width / 2;
                    break;
                }
                case 2: {
                    rectangle.y = a7.y - 5;
                    rectangle.x = a7.x - rectangle.width - 2;
                    break;
                }
                case 3: {
                    rectangle.x = a7.x;
                    rectangle.y = (int)a7.getMaxY() + 2;
                    break;
                }
                case 4: {
                    rectangle.x = a7.x;
                    rectangle.y = a7.y - rectangle.height - 2;
                    break;
                }
            }
            if (a2 != null) {
                a6.drawNoteMarker(a10, rectangle, a8);
                a4.add(new AnnotationElement(a, a2, rectangle));
                switch (a.getPrimaryDirection()) {
                    case 0: 
                    case 1: {
                        rectangle.x += rectangle.width + 2;
                        break;
                    }
                    case 2: {
                        rectangle.x -= rectangle.width + 2;
                        break;
                    }
                    case 3: {
                        rectangle.y += rectangle.height + 2;
                        break;
                    }
                    case 4: {
                        rectangle.y -= rectangle.height + 2;
                        break;
                    }
                }
            }
            if (a3 != null) {
                a6.A.setFont(a6.L);
                a6.drawNoteMarker(a6.F, rectangle, a8);
                a6.A.setFont(a6.m);
                a4.add(new PublicNotesElement(a, a3, rectangle));
            }
        }

        private void drawNoteMarker(String a, Rectangle a2, Rectangle a3) {
            DrawingHelper a4;
            Rectangle a5 = a3 != null ? a3 : a4.K;
            if (a5.intersects(a2)) {
                int a6;
                int a7;
                if (a3 != null) {
                    a7 = a3.x;
                    a6 = a3.y;
                } else {
                    a7 = a4.b.x;
                    a6 = a4.b.y;
                }
                a4.A.setColor(a4.c);
                a4.A.fillRoundRect(a2.x - a7, a2.y - a6, a2.width, a2.height, a4.h, a4.h);
                a4.A.setColor(a4.l);
                a4.A.drawRoundRect(a2.x - a7, a2.y - a6, a2.width, a2.height, a4.h, a4.h);
                a4.A.setColor(a4.k);
                FontMetrics a8 = a4.A.getFontMetrics();
                int a9 = a8.stringWidth(a) - 2;
                int a10 = (a2.width - a9) / 2;
                int a11 = a8.getAscent() + (a2.height - a8.getAscent()) / 2;
                a4.A.drawString(a, a2.x - a7 + a10, a2.y - a6 + a11);
            }
        }
    }
}

