/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ebook.booklet.reader.impl.todo.handler;

import com.amazon.ebook.booklet.reader.impl.ContentPanel;
import com.amazon.ebook.booklet.reader.impl.ReaderUIImpl;
import com.amazon.ebook.booklet.reader.impl.ui.SyncLPRDialogUtil;
import com.amazon.ebook.booklet.reader.sdk.ReaderSDK;
import com.amazon.ebook.booklet.reader.sdk.content.Book;
import com.amazon.ebook.booklet.reader.sdk.content.BookMetadata;
import com.amazon.ebook.booklet.reader.sdk.content.UpdatedLpr;
import com.amazon.ebook.booklet.reader.sdk.content.Viewport;
import com.amazon.ebook.booklet.reader.sdk.event.CloseBookHandler;
import com.amazon.ebook.booklet.reader.sdk.event.ContextSwitchHandler;
import com.amazon.ebook.booklet.reader.sdk.event.EventHandler;
import com.amazon.ebook.booklet.reader.sdk.event.NavigationHandler;
import com.amazon.ebook.booklet.reader.sdk.event.ShownBookHandler;
import com.amazon.ebook.booklet.reader.sdk.ui.ReaderUIContext;
import com.amazon.ebook.booklet.reader.sdk.util.DataStoreFactory;
import com.amazon.ebook.booklet.reader.sdk.util.DataStoreObject;
import com.amazon.ebook.booklet.reader.sdk.util.InvalidSideCarFileException;
import com.amazon.ebook.booklet.reader.sdk.util.State;
import com.amazon.ebook.util.log.Log;
import com.amazon.kindle.device.PowerManagementStateEvent;
import com.amazon.kindle.device.PowerManagementStateListener;
import com.amazon.kindle.device.PowerService;
import java.awt.EventQueue;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;

public class LprShownBookHandler
implements DataStoreFactory,
ShownBookHandler,
PowerManagementStateListener,
CloseBookHandler,
ContextSwitchHandler,
NavigationHandler {
    private static Timer h;
    private static long A;
    private ReaderSDK H;
    private final long b = 60000L;
    private final long K = 6000L;
    private static final Log B;

    public static void cancelLprTimer() {
        if (h != null) {
            h.cancel();
            A = 0L;
            h = null;
        }
    }

    public LprShownBookHandler(ReaderSDK a) {
        LprShownBookHandler a2;
        a2.H = a;
        a2.H.getRegistry().addFrequentUpdateBookStateFactory((DataStoreFactory)a2);
        a2.H.getRegistry().registerHandler((EventHandler)a2);
        PowerService a3 = (PowerService)a2.H.getService(PowerService.class);
        if (a3 != null) {
            a3.addPowerManagementStateListener((PowerManagementStateListener)a2);
        } else {
            B.error("Unalbe to get PowerService");
        }
    }

    public DataStoreObject getEmptyObject(Object a) {
        LprShownBookHandler a2;
        return new UpdatedLpr(a2.H);
    }

    public String getKey() {
        return "updated_lpr";
    }

    public HashMap getSupportedDataStoreFactories() {
        return null;
    }

    private synchronized void showLprDialog(Book a) {
        State a2;
        try {
            a2 = a.getFreqUpdateBookState();
        }
        catch (InvalidSideCarFileException a3) {
            B.error("Failed to retrieve sidecar");
            return;
        }
        UpdatedLpr a4 = (UpdatedLpr)a2.get("updated_lpr");
        if (a4 != null) {
            if (a4.getSourceDeviceName() != null) {
                LprShownBookHandler a5;
                B.debug("There is updated lpr, canceling timer");
                a5.cancelTimer();
                EventQueue.invokeLater(new Runnable(){
                    {
                        1 a;
                    }

                    public void run() {
                        1 a;
                        SyncLPRDialogUtil.showDialog(false);
                        a.LprShownBookHandler.this.H.getUI().getReaderPane().repaint();
                    }
                });
            } else {
                B.warning("UpdatedLPR found at OpenBookEvent without source device name. skipping.");
            }
        }
    }

    public void shownBookEvent(Book a) {
        LprShownBookHandler a2;
        if (a2.isSyncLprAvailable(a)) {
            a2.scheduleTimer();
            a2.showLprDialog(a);
        }
    }

    public void setSupportedDataStoreFactories(HashMap a) {
    }

    public void onPowerManagementStateChange(PowerManagementStateEvent a) {
        LprShownBookHandler a2;
        if (a2.H.getActiveContext() != null && a2.H.getCurrentBook() != null) {
            if (a.getEvent() == "outOfScreenSaver") {
                B.debug("LPR update listener exiting screen saver checking for LPR");
                if (a2.isSyncLprAvailable(a2.H.getCurrentBook())) {
                    a2.scheduleTimer();
                    a2.checkAndShowDialog();
                }
            } else if (a.getEvent() == "goingToScreenSaver") {
                B.debug("Entering screen saver, canceling timer");
                a2.cancelTimer();
            }
        }
    }

    public void closeBookEvent(Book a, boolean a2) {
        LprShownBookHandler a3;
        B.debug("Close book, canceling previous timer");
        a3.cancelTimer();
    }

    public void contextSwitch(ReaderUIContext a, ReaderUIContext a2) {
        LprShownBookHandler a3;
        if (a3.isTimerStillRunning() && a2 == a3.H.getUI().getBookContentPanel()) {
            B.debug("Context switch, timer running & context is ContentPanel");
            a3.checkAndShowDialog();
        }
    }

    public void navigationEvent(Viewport a) {
        LprShownBookHandler a2;
        if (a2.isTimerStillRunning()) {
            B.debug("Navigation Event, timer running & context is ContentPanel");
            a2.checkAndShowDialog();
        }
    }

    private boolean isSyncLprAvailable(Book a) {
        if (a != null) {
            BookMetadata a2 = a.getMetadata();
            String a3 = a2.getASIN();
            return a3 != null && a3.length() > 0 && !a2.isSample() && a2.getContentType() != 4;
        }
        return false;
    }

    private boolean isTimerStillRunning() {
        return System.currentTimeMillis() - A < 60000L;
    }

    private void scheduleTimer() {
        LprShownBookHandler a;
        a.cancelTimer();
        h = new Timer();
        A = System.currentTimeMillis();
        h.scheduleAtFixedRate((TimerTask)a.new CheckUpdatedLprTask(), 6000L, 6000L);
    }

    private void cancelTimer() {
        a.cancelLprTimer();
    }

    private void checkAndShowDialog() {
        LprShownBookHandler a;
        Book a2 = a.H.getCurrentBook();
        if (a2 != null && a.H.getUI().getBookContentPanel() == a.H.getUI().getUIContext() && !((ContentPanel)((Object)a.H.getUI().getBookContentPanel())).isDialogShowing() && !((ReaderUIImpl)a.H.getUI()).isMenuDialogShowing()) {
            B.debug("Check for updated lpr");
            a.showLprDialog(a2);
        }
    }

    static {
        A = 0L;
        B = Log.getInstance((String)"LprShownBookHandler");
    }

    private class CheckUpdatedLprTask
    extends TimerTask {
        private int K = 0;
        private final int B = 10;

        private CheckUpdatedLprTask() {
            CheckUpdatedLprTask a;
        }

        public void run() {
            CheckUpdatedLprTask a;
            ++a.K;
            B.debug("Check lpr timer task runs: " + Integer.toString(a.K));
            if (a.K >= 10) {
                B.debug("Check lpr timer task runs " + Integer.toString(10) + " times, canceling");
                a.LprShownBookHandler.this.cancelTimer();
            }
            a.LprShownBookHandler.this.checkAndShowDialog();
        }
    }
}

