/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ebook.booklet.reader.impl.annotation;

import com.amazon.ebook.booklet.reader.sdk.BookException;
import com.amazon.ebook.booklet.reader.sdk.ReaderPlugin;
import com.amazon.ebook.booklet.reader.sdk.ReaderSDK;
import com.amazon.ebook.booklet.reader.sdk.content.Book;
import com.amazon.ebook.booklet.reader.sdk.content.LastPageRead;
import com.amazon.ebook.booklet.reader.sdk.content.annotation.Annotation;
import com.amazon.ebook.booklet.reader.sdk.content.annotation.AnnotationExport;
import com.amazon.ebook.booklet.reader.sdk.event.AnnotationEventHandler;
import com.amazon.ebook.booklet.reader.sdk.event.EventHandler;
import com.amazon.ebook.booklet.reader.sdk.event.SaveStateHandler;
import com.amazon.ebook.booklet.reader.sdk.util.InvalidSideCarFileException;
import com.amazon.ebook.util.log.Log;
import com.amazon.ebook.util.log.LogSystem;
import com.amazon.kindle.booklet.BookletContext;
import com.amazon.kindle.content.journal.JournalAction;
import com.amazon.kindle.content.journal.JournalEntry;
import com.amazon.kindle.content.journal.JournalType;
import com.amazon.kindle.content.journal.JournalUtil;
import com.amazon.kindle.content.journal.JournaledBook;
import com.amazon.kindle.content.journal.JournalingService;
import com.amazon.kindle.context.Context;
import com.amazon.kindle.restricted.webservices.whispersync.v1.WhisperSyncV1;

public class AnnotationSync
extends ReaderPlugin
implements AnnotationEventHandler,
SaveStateHandler {
    private static final Log b = LogSystem.getLog((String)"AnnotationJournal");
    private static ReaderSDK K;

    public AnnotationSync(ReaderSDK a) {
        AnnotationSync a2;
        K = a;
    }

    private static JournaledBook getJournaledBookInstance(Book a) {
        JournaledBook a2 = null;
        String a3 = null;
        String a4 = null;
        String a5 = null;
        int a6 = 0;
        String a7 = null;
        a3 = a.getPath();
        a4 = a.getMetadata().getCdeKey();
        a5 = a.getMetadata().getCdeType();
        a6 = a.getMetadata().getVersion();
        a7 = a.getMetadata().getGUID();
        a2 = JournalUtil.getJournaledBookInstance((Context)((Context)K.getActiveContext()), (String)a3, (String)a4, (String)a5, (int)a6, (String)a7);
        return a2;
    }

    public static void journal(JournalType a, JournalAction a2, AnnotationExport a3) {
        AnnotationSync.journal(a, a2, a3.H, a3.b, a3.D, a3.K, a3.B);
    }

    public static void journal(JournalType a, JournalAction a2, int a3, int a4, String a5, int a6, byte[] a7) {
        JournalingService a8 = (JournalingService)((BookletContext)K.getActiveContext()).getService(JournalingService.class);
        if (Log.isDebugOn() && a8 == null) {
            b.info("Attempting Journal but service is *null*!");
            b.info("**** action: " + a2.name() + "  type: " + a.name() + "  startPos: " + a3 + "  endPos: " + a4 + "  text: " + a5 + "  pos: " + a6 + "  hasState? " + (a7 != null));
        }
        if (a8 != null) {
            JournaledBook a9 = AnnotationSync.getJournaledBookInstance(K.getCurrentBook());
            if (a9 == null) {
                b.error("unable to create a Journaled Book.");
                return;
            }
            long a10 = -1L;
            long a11 = -1L;
            if (a == JournalType.LASTREADPOS) {
                a10 = K.getBookNavigator().getSavedStartingPosition().createSortableIndexKey();
                a11 = K.getBookNavigator().getSavedStartingTime().getTime();
            }
            JournalEntry a12 = a8.getJournalEntry(a, a2, a3, a4, a5, a6, a11, a10, a7);
            a8.journal(a9, a12);
        }
    }

    public void addAnnotationEvent(Annotation a) {
        if (a.canBeJournaled()) {
            AnnotationSync.journal(a.getJournalType(), JournalAction.CREATE, a.createJournalExport());
        }
    }

    public void deleteAnnotationEvent(Annotation a) {
        if (a.canBeJournaled()) {
            AnnotationSync.journal(a.getJournalType(), JournalAction.DELETE, a.createJournalExport());
        }
    }

    public void updateAnnotationEvent(Annotation a) {
        if (a.canBeJournaled()) {
            AnnotationSync.journal(a.getJournalType(), JournalAction.MODIFY, a.createJournalExport());
        }
    }

    public String getName() {
        AnnotationSync a;
        return ((Object)((Object)a)).getClass().getName();
    }

    public void pluginLoad(ReaderSDK a) throws BookException {
        AnnotationSync a2;
        K = a;
        K.getRegistry().registerHandler((EventHandler)a2);
    }

    public void pluginUnload() {
        AnnotationSync a;
        K.getRegistry().deregisterHandler((EventHandler)a);
    }

    public void saveState(Book a) {
        LastPageRead a2 = null;
        try {
            a2 = a.getLPR();
        }
        catch (InvalidSideCarFileException a3) {
            b.error("Unable to use read LPR from sidecar");
        }
        if (a2.canBeJournaled()) {
            AnnotationSync.journal(JournalType.LASTREADPOS, JournalAction.CREATE, a2.createJournalExport());
        }
        if ((a = (WhisperSyncV1)((BookletContext)K.getActiveContext()).getService(WhisperSyncV1.class)) != null) {
            a.uploadJournal();
        } else {
            b.error("Unable to get WhisperSyncV1 service, Journal not uploaded.");
        }
    }
}

