/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ebook.booklet.reader.impl.annotation;

import com.amazon.ebook.booklet.reader.impl.ReaderSDKImpl;
import com.amazon.ebook.booklet.reader.sdk.ReaderException;
import com.amazon.ebook.booklet.reader.sdk.ReaderSDK;
import com.amazon.ebook.booklet.reader.sdk.content.Book;
import com.amazon.ebook.booklet.reader.sdk.content.Interval;
import com.amazon.ebook.booklet.reader.sdk.content.Position;
import com.amazon.ebook.booklet.reader.sdk.content.PositionFactory;
import com.amazon.ebook.booklet.reader.sdk.content.annotation.Annotation;
import com.amazon.ebook.booklet.reader.sdk.content.annotation.AnnotationException;
import com.amazon.ebook.booklet.reader.sdk.content.annotation.AnnotationExport;
import com.amazon.ebook.booklet.reader.sdk.util.DataStoreObject;
import com.amazon.ebook.booklet.reader.sdk.util.ReaderDataInput;
import com.amazon.ebook.booklet.reader.sdk.util.ReaderDataOutput;
import com.amazon.ebook.util.log.Log;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;

public abstract class AnnotationImpl
implements Annotation,
DataStoreObject {
    private static final String k = "annotation.abstract";
    private static final Log m = Log.getInstance((String)"AbstractAnnotation");
    protected boolean h;
    protected Interval A;
    protected Set H;
    protected Date b;
    protected List K;
    protected Date B;

    protected AnnotationImpl(Position a, Position a2) throws AnnotationException {
        a3(a, a2, null, null, null, null);
        AnnotationImpl a3;
    }

    protected AnnotationImpl(Position a, Position a2, Set a3, List a4, Date a5, Date a6) throws AnnotationException {
        AnnotationImpl a7;
        a7.A = Interval.create((Position)a, (Position)a2);
        if (a7.A == null) {
            throw new AnnotationException(a7.getLabel(), "Unable to create Interval in Annotation");
        }
        a7.H = a3 != null ? new HashSet(a3) : new HashSet();
        a7.K = a4 != null ? new ArrayList(a4) : new ArrayList();
        a7.b = a5 != null ? a5 : new Date();
        a7.B = a6 == null || a6.before(a7.b) ? new Date(a7.b.getTime()) : a6;
        a7.h = true;
    }

    protected AnnotationImpl() {
        AnnotationImpl a;
    }

    public Position getStartPosition() {
        AnnotationImpl a;
        return a.A.getStartPosition();
    }

    public Position getEndPosition() {
        AnnotationImpl a;
        return a.A.getEndPosition();
    }

    public Interval getInterval() {
        AnnotationImpl a;
        return a.A;
    }

    public Set getTags() {
        AnnotationImpl a;
        return a.H;
    }

    public Date getCreationDate() {
        AnnotationImpl a;
        return a.b;
    }

    public Date getLastModifiedDate() {
        AnnotationImpl a;
        return a.B;
    }

    public List getFlags() {
        AnnotationImpl a;
        return a.K;
    }

    public Object getAuxData() {
        return null;
    }

    public void setAuxData(Object a) {
        m.error("Attempting to set an object into a field that does not exist.");
    }

    public String toString() {
        AnnotationImpl a;
        StringBuffer a2 = new StringBuffer("Type: " + a.getType());
        a2.append(" Positions: ").append(a.A);
        return a2.toString();
    }

    private String makeFlagsAndTagsString() {
        Iterator a;
        AnnotationImpl a2;
        StringBuffer a3 = new StringBuffer();
        a3.append(a2.K.size());
        Iterator iterator = a = a2.K.iterator();
        while (iterator.hasNext()) {
            a3.append('\ufffc').append(a.toString());
            iterator = a;
        }
        a3.append('\ufffc').append(a2.H.size());
        a = a2.H.iterator();
        Iterator iterator2 = a;
        while (iterator2.hasNext()) {
            a3.append('\ufffc').append(a.toString());
            iterator2 = a;
        }
        return a3.toString();
    }

    private void makeFlagsAndTagsFromString(String a) {
        AnnotationImpl a2;
        int a3;
        a2.H = new HashSet();
        a2.K = new ArrayList();
        StringTokenizer a4 = new StringTokenizer(a, "\ufffc");
        ArrayList<String> a5 = new ArrayList<String>();
        StringTokenizer stringTokenizer = a4;
        while (stringTokenizer.hasMoreTokens()) {
            a5.add(a4.nextToken());
            stringTokenizer = a4;
        }
        if (a5.size() < 2) {
            m.error("Unable to parse tags and flags, expected at least token count for both.");
            return;
        }
        int a6 = 0;
        int n = a3 = Integer.parseInt((String)a5.get(0));
        while (n > 0) {
            a2.K.add((String)a5.get(++a6));
            n = --a3;
        }
        int n2 = a3 = Integer.parseInt((String)a5.get(a6));
        while (n2 > 0) {
            a2.H.add((String)a5.get(++a6));
            n2 = --a3;
        }
    }

    public void serialize(ReaderDataOutput a) throws IOException {
        AnnotationImpl a2;
        a.writeUTF(a2.getStartPosition().store());
        a.writeUTF(a2.getEndPosition().store());
        a.writeLong(a2.b.getTime());
        a.writeLong(a2.B.getTime());
        a.writeUTF(a2.makeFlagsAndTagsString());
    }

    public void deserialize(ReaderDataInput a, Object a2, HashMap a3) throws IOException {
        AnnotationImpl a4;
        ReaderSDK a5;
        try {
            a5 = (ReaderSDK)ReaderSDKImpl.getBundleService(ReaderSDK.class);
        }
        catch (ReaderException a6) {
            throw new IOException(a6.getMessage());
        }
        Book a7 = (Book)a2;
        PositionFactory a8 = a5.getPositionFactory(a7);
        Position a9 = a8.createInstance(a.readUTF(), a7);
        Position a10 = a8.createInstance(a.readUTF(), a7);
        a4.A = Interval.create((Position)a9, (Position)a10);
        a4.b = new Date(a.readLong());
        a4.B = new Date(a.readLong());
        a4.makeFlagsAndTagsFromString(a.readUTF());
    }

    public boolean isDirty() {
        AnnotationImpl a;
        return a.h;
    }

    public void setDirty(boolean a) {
        a.h = a;
    }

    public boolean canBeJournaled() {
        AnnotationImpl a;
        return a.A.getStartPosition().canBeJournaled();
    }

    public AnnotationExport createJournalExport() {
        AnnotationImpl a;
        if (a.canBeJournaled()) {
            AnnotationExport a2 = new AnnotationExport();
            new AnnotationExport().H = a.A.getStartPosition().createSortableIndexKey();
            a2.b = a.A.getEndPosition().createSortableIndexKey();
            a2.K = a.A.getStartPosition().journalPosField();
            a2.D = a.getJournalUserText();
            a2.B = a.A.getStartPosition().journalState();
            return a2;
        }
        m.warning("Attempted to create Journal entry for a type that cannot be Journaled.");
        return null;
    }

    protected abstract String getJournalUserText();

    public String getFactoryKey() {
        m.error("Using FACTORY_KEY in abstract class Annotation, inherited classes key expected.");
        return k;
    }

    public boolean equals(Object a) {
        AnnotationImpl a2;
        if (a2 == a) {
            return true;
        }
        if (a instanceof Annotation) {
            Annotation a3 = (Annotation)a;
            if (a2.getType() == a3.getType() && a2.getInterval().equals((Object)a3.getInterval()) && ((Object)a2.getTags()).equals(a3.getTags()) && ((Object)a2.getFlags()).equals(a3.getFlags())) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        AnnotationImpl a;
        int a2 = 211;
        int a3 = 211 * a.getType();
        a3 = a2 * a3 + a.A.hashCode();
        a3 = a2 * a3 + ((Object)a.H).hashCode();
        return a2 * a3 + ((Object)a.K).hashCode();
    }

    protected int compareMainAnnotationFields(Annotation a) {
        AnnotationImpl a2;
        int a3 = a2.getInterval().compareTo((Object)a.getInterval());
        if (a3 == 0) {
            a3 = a2.getType() - a.getType();
        }
        return a3;
    }

    protected int compareRemainingAnnotationFields(Annotation a) {
        AnnotationImpl a2;
        if (a2 == a) {
            return 0;
        }
        int a3 = ((Object)a2.getTags()).hashCode() - ((Object)a.getTags()).hashCode();
        if (a3 == 0) {
            a3 = ((Object)a2.getFlags()).hashCode() - ((Object)a.getFlags()).hashCode();
        }
        return a3;
    }

    public int compareTo(Object a) {
        if (a instanceof Annotation) {
            AnnotationImpl a2;
            int a3 = a2.compareMainAnnotationFields((Annotation)a);
            if (a3 == 0) {
                a3 = a2.compareRemainingAnnotationFields((Annotation)a);
            }
            return a3;
        }
        throw new ClassCastException(a.getClass().toString() + ' ' + a.toString());
    }
}

