/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ebook.booklet.reader.impl.annotation;

import com.amazon.ebook.booklet.reader.sdk.BookException;
import com.amazon.ebook.booklet.reader.sdk.ReaderPlugin;
import com.amazon.ebook.booklet.reader.sdk.ReaderSDK;
import com.amazon.ebook.booklet.reader.sdk.content.AVLIntervalTree;
import com.amazon.ebook.booklet.reader.sdk.content.Book;
import com.amazon.ebook.booklet.reader.sdk.content.Interval;
import com.amazon.ebook.booklet.reader.sdk.content.Position;
import com.amazon.ebook.booklet.reader.sdk.content.annotation.Annotation;
import com.amazon.ebook.booklet.reader.sdk.content.annotation.AnnotationAVLIntervalTreeFactory;
import com.amazon.ebook.booklet.reader.sdk.content.annotation.AnnotationAccessorInterface;
import com.amazon.ebook.booklet.reader.sdk.content.annotation.AnnotationCacheObject;
import com.amazon.ebook.booklet.reader.sdk.content.annotation.AnnotationFilter;
import com.amazon.ebook.booklet.reader.sdk.content.annotation.AnnotationProvider;
import com.amazon.ebook.booklet.reader.sdk.util.Cache;
import com.amazon.ebook.booklet.reader.sdk.util.Cacheable;
import com.amazon.ebook.booklet.reader.sdk.util.DataStoreFactory;
import com.amazon.ebook.booklet.reader.sdk.util.DataStoreObject;
import com.amazon.ebook.booklet.reader.sdk.util.State;
import com.amazon.ebook.util.log.Log;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class AnnotationCacheImpl
extends ReaderPlugin
implements AnnotationAccessorInterface,
DataStoreFactory {
    private static final Log h = Log.getInstance((String)"AnnotationCacheImpl");
    private ReaderSDK A;
    private static final int H = 16;
    private Cache b;
    private final List K = new ArrayList();
    private final HashMap B;
    private final HashMap D = new HashMap(7);

    AnnotationCacheImpl() {
        AnnotationCacheImpl a;
        a.B = new HashMap(7);
    }

    public String getName() {
        return "Annotataion Cache";
    }

    public void addAnnotationProvider(AnnotationProvider a) {
        AnnotationCacheImpl a2;
        a2.K.add(a);
    }

    public void removeAnnotationProvider(AnnotationProvider a) {
        AnnotationCacheImpl a2;
        a2.K.remove(a);
    }

    public void addAnnotationCacheFactory(DataStoreFactory a) {
        AnnotationCacheImpl a2;
        a2.B.put(a.getKey(), a);
    }

    public void removeAnnotationCacheFactory(DataStoreFactory a) {
        AnnotationCacheImpl a2;
        a2.B.remove(a.getKey());
    }

    public void addAnnotationTreeFactory(AnnotationAVLIntervalTreeFactory a, List a2) {
        AnnotationCacheImpl a3;
        Iterator a4;
        Iterator iterator = a4 = a2.iterator();
        while (iterator.hasNext()) {
            a3.D.put(a4.next(), a);
            iterator = a4;
        }
        if (a instanceof DataStoreFactory) {
            a3.addAnnotationCacheFactory((DataStoreFactory)a);
            ((DataStoreFactory)a).setSupportedDataStoreFactories(a3.B);
        }
    }

    public void removeAnnotationTreeFactory(List a) {
        Iterator a2 = a.iterator();
        while (a2.hasNext()) {
            AnnotationCacheImpl a3;
            AnnotationAVLIntervalTreeFactory a4 = (AnnotationAVLIntervalTreeFactory)a3.D.remove(a2.next());
            if (a4 == null || !(a4 instanceof DataStoreFactory)) continue;
            a3.removeAnnotationCacheFactory((DataStoreFactory)a4);
        }
    }

    private AnnotationCacheObject getCacheForBook(Book a) {
        AnnotationCacheImpl a2;
        if (a == null) {
            h.error("Attempting to get tree for null Book");
            return null;
        }
        if (a2.b == null) {
            h.error("Attempting to get an Annotation Cache when none have been created");
            return null;
        }
        AnnotationCacheObject a3 = (AnnotationCacheObject)a2.b.get(a.getPath());
        if (a3 == null) {
            h.error("No annotation cache was created for book");
        }
        return a3;
    }

    static void doubleInsert(Cache a, String a2, AnnotationCacheObject a3) {
        a.put(a2, (Cacheable)a3);
        a.put(a2, (Cacheable)a3);
    }

    private AVLIntervalTree getTreeForType(int a, Book a2) {
        AVLIntervalTree a3;
        AnnotationCacheObject a4;
        AnnotationCacheImpl a5;
        if (a5.b == null) {
            h.warning("Attempting to get/add trees from cache when cache is null. This is only valid during unit tests.");
            a5.b = new Cache(1);
            AnnotationCacheImpl.doubleInsert(a5.b, a2.getPath(), new AnnotationCacheObject());
        }
        if ((a4 = a5.getCacheForBook(a2)) == null) {
            h.warning("Attempting to get/add trees from cache when no entry exists. This is only valid during unit tests.");
            a4 = new AnnotationCacheObject();
            AnnotationCacheImpl.doubleInsert(a5.b, a2.getPath(), a4);
        }
        if ((a3 = (AVLIntervalTree)a4.get((Object)new Integer(a))) == null) {
            AnnotationAVLIntervalTreeFactory a6 = (AnnotationAVLIntervalTreeFactory)a5.D.get(new Integer(a));
            if (a6 == null) {
                h.error("Using Default AVL Tree. Unable to get tree factory for annotation type: " + a);
                a3 = new AVLIntervalTree();
                a4.put((Object)new Integer(a), (Object)a3);
            } else {
                a3 = a6.getNewTree();
                a4.put((Object)new Integer(a), (Object)a3);
            }
        }
        return a3;
    }

    public void importAnnotation(Annotation a, Book a2) {
        AnnotationCacheImpl a3;
        a3.addAnnotation(a, a2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAnnotation(Annotation a, Book a2) {
        AnnotationCacheImpl a3;
        AnnotationCacheImpl annotationCacheImpl = a3;
        synchronized (annotationCacheImpl) {
            a3.getTreeForType(a.getType(), a2).add((Interval.HasInterval)a);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAnnotation(Annotation a, Book a2) {
        AnnotationCacheImpl a3;
        AnnotationCacheImpl annotationCacheImpl = a3;
        synchronized (annotationCacheImpl) {
            a3.getTreeForType(a.getType(), a2).remove((Interval.HasInterval)a);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markAnnotationAsUpdated(Annotation a, Book a2) {
        AnnotationCacheImpl a3;
        AnnotationCacheImpl annotationCacheImpl = a3;
        synchronized (annotationCacheImpl) {
            a3.getTreeForType(a.getType(), a2).setDirty(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getFilteredAnnotations(AnnotationFilter a) {
        AnnotationCacheImpl a2;
        ArrayList a3 = new ArrayList();
        Book a4 = a.getCurrentBook();
        if (a4 == null) {
            a4 = a2.A.getCurrentBook();
        }
        AnnotationCacheImpl annotationCacheImpl = a2;
        synchronized (annotationCacheImpl) {
            Interval a5;
            ArrayList<AVLIntervalTree> a6;
            if (a.getAnnotationFilterType() == Integer.MIN_VALUE) {
                a6 = a2.getCacheForBook(a4).getList();
                if (a6 == null) {
                    a6 = new ArrayList(0);
                }
            } else {
                a6 = new ArrayList<AVLIntervalTree>(1);
                a6.add(a2.getTreeForType(a.getAnnotationFilterType(), a4));
            }
            if ((a5 = Interval.create((Position)a.getAnnotationStart(), (Position)a.getAnnotationEnd())) == null) {
                Iterator a7;
                Iterator iterator = a7 = a6.iterator();
                while (iterator.hasNext()) {
                    a3.addAll(((AVLIntervalTree)a7.next()).getAll());
                    iterator = a7;
                }
            } else {
                Iterator a8;
                Iterator iterator = a8 = a6.iterator();
                while (iterator.hasNext()) {
                    a3.addAll(((AVLIntervalTree)a8.next()).getItemsThatOverlap(a5));
                    iterator = a8;
                }
            }
        }
        return a3;
    }

    public int getNumberOfAnnotationsOfTypeInBook(int a, Book a2) {
        AnnotationCacheImpl a3;
        return a3.getTreeForType(a, a2).size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseCache(Book a) {
        AnnotationCacheImpl a2;
        if (a == null) {
            h.error("Attempting to get tree for null Book");
            return;
        }
        if (a2.b == null) {
            h.error("Attempting to clear Annotation Caches when none have been created");
            return;
        }
        AnnotationCacheImpl annotationCacheImpl = a2;
        synchronized (annotationCacheImpl) {
            Iterator a3;
            AnnotationCacheObject a4 = (AnnotationCacheObject)a2.b.get(a.getPath());
            if (a4 == null) {
                h.error("No annotation cache was created for book, so it cannot be released");
                return;
            }
            if (Log.isDebugOn()) {
                h.debug("Clearing an annotation cache");
            }
            Iterator iterator = a3 = a4.getList().iterator();
            while (iterator.hasNext()) {
                ((AVLIntervalTree)a3.next()).clear();
                iterator = a3;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeCache(Book a) {
        AnnotationCacheImpl a2;
        if (a == null) {
            h.error("Attempting to get tree for null Book");
            return;
        }
        if (a2.b == null) {
            h.error("Attempting to clear Annotation Caches when none have been created");
            return;
        }
        AnnotationCacheImpl annotationCacheImpl = a2;
        synchronized (annotationCacheImpl) {
            AnnotationCacheObject a3 = (AnnotationCacheObject)a2.b.get(a.getPath());
            if (a3 == null) {
                h.error("No annotation cache was created for book so it cannot be closed");
                return;
            }
            try {
                a3.close();
                a3.close();
            }
            catch (IOException a4) {
                h.error("Failed closing cache", (Throwable)a4);
            }
            if (a3.getReferenceCount() <= 0) {
                a2.releaseCache(a);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadCacheFromSaveState(Book a, State a2) throws IOException {
        AnnotationCacheImpl a3;
        if (a == null || a2 == null) {
            h.error("Attempting to get tree for null Book/State");
            return;
        }
        AnnotationCacheObject a4 = (AnnotationCacheObject)a2.get(a3.getKey());
        if (a4 == null) {
            a4 = new AnnotationCacheObject(7);
            a2.add((DataStoreObject)a4);
            if (Log.isDebugOn()) {
                h.debug("Creating new AnnotationCacheObject and adding it to state");
            }
        }
        AnnotationCacheImpl annotationCacheImpl = a3;
        synchronized (annotationCacheImpl) {
            if (a3.b == null) {
                a3.b = new Cache(16);
                if (Log.isDebugOn()) {
                    h.debug("Creating backingCache object in AnnotationCacheImpl");
                }
            }
            AnnotationCacheImpl.doubleInsert(a3.b, a.getPath(), a4);
        }
    }

    public DataStoreObject getEmptyObject(Object a) {
        return new AnnotationCacheObject();
    }

    public String getKey() {
        return "annotation.cache.object";
    }

    public HashMap getSupportedDataStoreFactories() {
        AnnotationCacheImpl a;
        return a.B;
    }

    public void setSupportedDataStoreFactories(HashMap a) {
        h.error("Attempting to re-set factories on AnnotationCacheFactory");
    }

    public void pluginLoad(ReaderSDK a) throws BookException {
        AnnotationCacheImpl a2;
        a2.A = a;
        a.getRegistry().addRareUpdateBookStateFactory((DataStoreFactory)a2);
    }

    public void pluginUnload() {
        AnnotationCacheImpl a;
        a.A.getRegistry().removeRareUpdateBookStateFactory((DataStoreFactory)a);
    }
}

