/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ebook.booklet.reader.impl;

import com.amazon.ebook.booklet.reader.impl.ReaderSDKImpl;
import com.amazon.ebook.booklet.reader.sdk.BookException;
import com.amazon.ebook.booklet.reader.sdk.ReaderPlugin;
import com.amazon.ebook.booklet.reader.sdk.ReaderSDK;
import com.amazon.ebook.booklet.reader.sdk.content.Book;
import com.amazon.ebook.util.log.Log;
import com.amazon.kindle.device.PowerManagementStateEvent;
import com.amazon.kindle.device.PowerManagementStateListener;
import com.amazon.kindle.device.PowerService;
import com.amazon.kindle.device.UserStoreEvent;
import com.amazon.kindle.device.UserStoreListener;
import com.amazon.kindle.device.UserStoreService;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;

public class ReaderSDKStorageListener
extends ReaderPlugin
implements UserStoreListener,
PowerManagementStateListener {
    private static final Log H = Log.getInstance((String)"ReaderSDKStorageListener");
    private ReaderSDKImpl b;
    private boolean K = false;

    public ReaderSDKStorageListener(ReaderSDKImpl a) {
        ReaderSDKStorageListener a2;
        a2.b = a;
    }

    public synchronized void onAvailabilityChange(UserStoreEvent a) {
        ReaderSDKStorageListener a2;
        if (a2.b.getActiveContext() != null && a2.b.getCurrentBook() != null && a.getEvent() == UserStoreEvent.Event.LIKELY_TO_UNMOUNT) {
            H.info("enter usb mode");
            a2.performSaveState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performSaveState() {
        a2.K = false;
        Timer a = new Timer();
        try {
            ReaderSDKStorageListener a2;
            a.scheduleAtFixedRate((TimerTask)a2.new CheckPostSaveCompleteTask(), 500L, 1000L);
            a2.saveState();
            a2.K = true;
        }
        finally {
            a.cancel();
        }
    }

    public String getName() {
        return "storage";
    }

    public void pluginLoad(ReaderSDK a) throws BookException {
        PowerService a2;
        ReaderSDKStorageListener a3;
        UserStoreService a4 = (UserStoreService)a.getService(UserStoreService.class);
        if (a4 != null) {
            a4.addUserStoreListener((UserStoreListener)a3);
        }
        if ((a2 = (PowerService)a.getService(PowerService.class)) != null) {
            a2.addPowerManagementStateListener((PowerManagementStateListener)a3);
        }
    }

    public void pluginUnload() {
        PowerService a;
        ReaderSDKStorageListener a2;
        UserStoreService a3 = (UserStoreService)a2.b.getService(UserStoreService.class);
        if (a3 != null) {
            a3.removeUserStoreListener((UserStoreListener)a2);
        }
        if ((a = (PowerService)a2.b.getService(PowerService.class)) != null) {
            a.removePowerStateListener((PowerManagementStateListener)a2);
        }
    }

    public void onPowerManagementStateChange(PowerManagementStateEvent a) {
        ReaderSDKStorageListener a2;
        if (a2.b.getActiveContext() != null && (a.getEvent() == "goingToScreenSaver" || a.getEvent() == "readyToSuspend")) {
            a2.saveState();
        }
    }

    private void saveState() {
        ReaderSDKStorageListener a;
        Book a2 = a.b.getCurrentBook();
        a.b.getEventManager().postSaveStateEvent(a2);
        try {
            a2.saveSideCars();
        }
        catch (IOException a3) {
            H.error("Error while saving book sidecar, data could be lost", (Throwable)a3);
        }
    }

    private class CheckPostSaveCompleteTask
    extends TimerTask {
        private CheckPostSaveCompleteTask() {
            CheckPostSaveCompleteTask a;
        }

        public void run() {
            CheckPostSaveCompleteTask a;
            if (a.ReaderSDKStorageListener.this.K) {
                H.info("PostSave Completed, reset timer");
                a.cancel();
            } else {
                H.info("Request defer 1s for unmount");
                UserStoreService a2 = (UserStoreService)a.ReaderSDKStorageListener.this.b.getService(B == null ? (B = ReaderSDKStorageListener.class$("com.amazon.kindle.device.UserStoreService")) : B);
                if (a2 != null) {
                    a2.requestDeferUnmount();
                } else {
                    H.error("Cannot request defer unmount.");
                }
            }
        }
    }
}

