/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ebook.booklet.reader.impl;

import com.amazon.ebook.booklet.reader.impl.DictionaryManagerImpl;
import com.amazon.ebook.booklet.reader.impl.EventManager;
import com.amazon.ebook.booklet.reader.impl.LastPageReadProvider;
import com.amazon.ebook.booklet.reader.impl.ReaderSDKStorageListener;
import com.amazon.ebook.booklet.reader.impl.ReaderStateData;
import com.amazon.ebook.booklet.reader.impl.ReaderStateFactory;
import com.amazon.ebook.booklet.reader.impl.ReaderStateManager;
import com.amazon.ebook.booklet.reader.impl.ReaderUIImpl;
import com.amazon.ebook.booklet.reader.impl.RegistryImpl;
import com.amazon.ebook.booklet.reader.impl.annotation.AnnotationManagerImpl;
import com.amazon.ebook.booklet.reader.impl.annotation.AnnotationSync;
import com.amazon.ebook.booklet.reader.impl.annotation.personal.EndReadingLocation;
import com.amazon.ebook.booklet.reader.impl.history.ReaderHistoryManagerImpl;
import com.amazon.ebook.booklet.reader.impl.history.ReaderPageHistoryHandlerImpl;
import com.amazon.ebook.booklet.reader.impl.todo.handler.ContentToDoHandler;
import com.amazon.ebook.booklet.reader.impl.todo.handler.LprShownBookHandler;
import com.amazon.ebook.booklet.reader.impl.todo.handler.LprToDoHandler;
import com.amazon.ebook.booklet.reader.impl.todo.handler.PageNumbersToDoHandler;
import com.amazon.ebook.booklet.reader.impl.ui.AnnotationDecorator;
import com.amazon.ebook.booklet.reader.impl.ui.PagePositionIndicators;
import com.amazon.ebook.booklet.reader.plugin.clippings.ClippingsManager;
import com.amazon.ebook.booklet.reader.plugin.pagenumbers.PageNumberManagerImpl;
import com.amazon.ebook.booklet.reader.plugin.sharing.SharingManagerImpl;
import com.amazon.ebook.booklet.reader.plugin.tipsandtricks.TipsAndTricksViewProvider;
import com.amazon.ebook.booklet.reader.sdk.BookException;
import com.amazon.ebook.booklet.reader.sdk.BookNavigator;
import com.amazon.ebook.booklet.reader.sdk.ReaderException;
import com.amazon.ebook.booklet.reader.sdk.ReaderPlugin;
import com.amazon.ebook.booklet.reader.sdk.ReaderSDK;
import com.amazon.ebook.booklet.reader.sdk.ReaderSplashPlugin;
import com.amazon.ebook.booklet.reader.sdk.Registry;
import com.amazon.ebook.booklet.reader.sdk.content.Book;
import com.amazon.ebook.booklet.reader.sdk.content.LastPageRead;
import com.amazon.ebook.booklet.reader.sdk.content.Link;
import com.amazon.ebook.booklet.reader.sdk.content.PageNumberManager;
import com.amazon.ebook.booklet.reader.sdk.content.Position;
import com.amazon.ebook.booklet.reader.sdk.content.PositionFactory;
import com.amazon.ebook.booklet.reader.sdk.content.SharingManager;
import com.amazon.ebook.booklet.reader.sdk.content.TableOfContentsEntry;
import com.amazon.ebook.booklet.reader.sdk.content.annotation.Annotation;
import com.amazon.ebook.booklet.reader.sdk.content.annotation.AnnotationException;
import com.amazon.ebook.booklet.reader.sdk.content.annotation.AnnotationFactory;
import com.amazon.ebook.booklet.reader.sdk.content.annotation.AnnotationManager;
import com.amazon.ebook.booklet.reader.sdk.content.annotation.AnnotationProvider;
import com.amazon.ebook.booklet.reader.sdk.content.dictionary.DictionaryManager;
import com.amazon.ebook.booklet.reader.sdk.event.PositionNotificationHandler;
import com.amazon.ebook.booklet.reader.sdk.exception.BookInvalidException;
import com.amazon.ebook.booklet.reader.sdk.exception.CoreServiceException;
import com.amazon.ebook.booklet.reader.sdk.exception.FailedClosingPrevBookException;
import com.amazon.ebook.booklet.reader.sdk.exception.PluginLoadFailedException;
import com.amazon.ebook.booklet.reader.sdk.exception.ReaderAuthenticationException;
import com.amazon.ebook.booklet.reader.sdk.history.ContextualReaderHistoryMarker;
import com.amazon.ebook.booklet.reader.sdk.history.ReaderHistoryHandler;
import com.amazon.ebook.booklet.reader.sdk.history.ReaderHistoryManager;
import com.amazon.ebook.booklet.reader.sdk.history.ReaderPageHistoryHandler;
import com.amazon.ebook.booklet.reader.sdk.internal.BookController;
import com.amazon.ebook.booklet.reader.sdk.internal.BookStateManager;
import com.amazon.ebook.booklet.reader.sdk.internal.RendererCapabilities;
import com.amazon.ebook.booklet.reader.sdk.ui.ReaderUI;
import com.amazon.ebook.booklet.reader.sdk.ui.ReaderUIContext;
import com.amazon.ebook.booklet.reader.sdk.util.ContentCatalogDAO;
import com.amazon.ebook.booklet.reader.sdk.util.DataStoreFactory;
import com.amazon.ebook.booklet.reader.sdk.util.InvalidSideCarFileException;
import com.amazon.ebook.booklet.reader.sdk.util.State;
import com.amazon.ebook.booklet.reader.security.ReaderSecurity;
import com.amazon.ebook.booklet.reader.utils.FrameworkUtil;
import com.amazon.ebook.booklet.reader.utils.SwitchAppUtils;
import com.amazon.ebook.pl.SystemServices;
import com.amazon.ebook.util.log.Log;
import com.amazon.ebook.util.log.LogMessage;
import com.amazon.ebook.util.log.PerformanceLog;
import com.amazon.kindle.booklet.AbstractBooklet;
import com.amazon.kindle.booklet.Booklet;
import com.amazon.kindle.booklet.BookletContext;
import com.amazon.kindle.booklet.BookletServices;
import com.amazon.kindle.booklet.ChromeException;
import com.amazon.kindle.booklet.ChromeHeaderBar;
import com.amazon.kindle.booklet.History;
import com.amazon.kindle.content.catalog.CatalogService;
import com.amazon.kindle.content.journal.JournalingService;
import com.amazon.kindle.device.MemoryService;
import com.amazon.kindle.device.PowerService;
import com.amazon.kindle.device.ScreenRotationService;
import com.amazon.kindle.device.UserStoreService;
import com.amazon.kindle.restricted.webservices.todo.ToDo;
import com.amazon.kindle.restricted.webservices.whispersync.v1.WhisperSyncV1;
import com.amazon.kindle.util.lipc.LipcEventListener;
import com.amazon.kindle.util.lipc.LipcException;
import com.amazon.kindle.util.lipc.LipcService;
import com.amazon.kindle.util.lipc.LipcTarget;
import com.amazon.kindle.util.osgi.AbstractSimpleService;
import com.amazon.kindle.util.osgi.SimpleService;
import java.awt.Toolkit;
import java.awt.event.InvocationEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.Reader;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.kxml2.io.KXmlParser;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.xmlpull.v1.XmlPullParserException;

public class ReaderSDKImpl
extends AbstractSimpleService
implements ReaderSDK,
BundleActivator {
    private static final Log jA = Log.getInstance((String)"ReaderSDKImpl");
    private static final String IA = "reader_plugins.xml";
    private static final String KA = "BookController";
    private static final String EA = "Plugins";
    private static final String gA = "Plugin";
    private static final String q = "class";
    private static final String s = "jar";
    private static final String z = "legacy.UPD_ANOT.EBOK";
    private static final String W = "legacy.UPD_ANOT.PDOC";
    private static final String n = "_ALLOW_USERSTORE_PLUGIN_LOADING_";
    private static final String r = "plugins";
    private final EventManager U;
    private final RegistryImpl N;
    private final ReaderUIImpl P;
    private final DictionaryManagerImpl Y;
    private final AnnotationManager X;
    private final PageNumberManagerImpl v;
    private final SharingManagerImpl S;
    private final AnnotationSync T;
    private final ClippingsManager R;
    private BookController Z;
    private final ArrayList p = new ArrayList();
    private final HashMap w = new HashMap();
    private final HashMap o = new HashMap();
    private final HashMap t = new HashMap();
    private final List Q = new ArrayList();
    private volatile Booklet V = null;
    private ReaderHistoryManagerImpl u;
    private ReaderPageHistoryHandlerImpl y;
    private ReaderStateFactory O;
    private ReaderStateManager x;
    private BookStateManager f;
    private ReaderSDKStorageListener M;
    private LastPageReadProvider J;
    private LprShownBookHandler G;
    private boolean a = false;
    private boolean i = false;
    private ContentCatalogDAO E;
    private static ReaderSDKImpl C;
    private static BundleContext d;
    private static final LogMessage j;
    private static final LogMessage g;

    public ReaderSDKImpl() {
        ReaderSDKImpl a;
        a.U = new EventManager(a);
        a.N = new RegistryImpl(a);
        a.u = new ReaderHistoryManagerImpl(a);
        a.x = new ReaderStateManager(a);
        a.f = new BookStateManager();
        a.P = new ReaderUIImpl(a);
        a.Y = new DictionaryManagerImpl(a);
        a.X = new AnnotationManagerImpl(a);
        a.T = new AnnotationSync(a);
        a.R = new ClippingsManager((ReaderSDK)a);
        a.y = new ReaderPageHistoryHandlerImpl(a);
        a.M = new ReaderSDKStorageListener(a);
        a.J = new LastPageReadProvider();
        a.E = new ContentCatalogDAO();
        a.O = new ReaderStateFactory();
        a.N.registerHistoryHandler((ReaderHistoryHandler)a.y);
        a.N.addReaderStateDataStoreFactory(a.O);
        a.N.registerPageDecorator(new AnnotationDecorator(a));
        a.N.registerPageDecorator(new PagePositionIndicators(a));
        a.v = new PageNumberManagerImpl();
        a.S = new SharingManagerImpl();
        C = a;
    }

    private void doLoad(String a) {
        KXmlParser a2 = new KXmlParser();
        try {
            a2.setInput((Reader)new BufferedReader(new FileReader(a + IA)));
            a2.nextTag();
            int a3 = a2.getEventType();
            while (a3 != 1) {
                if (a3 == 2) {
                    String a4 = a2.getName();
                    if (!KA.equals(a4) && !gA.equals(a4)) {
                        if (!EA.equals(a4)) {
                            jA.warning("Unknown plugin type:" + a4);
                        }
                    } else {
                        String a5;
                        int a6;
                        String a7 = null;
                        String a8 = null;
                        int n = a6 = 0;
                        while (n < a2.getAttributeCount()) {
                            a5 = a2.getAttributeName(a6);
                            if (q.equals(a5)) {
                                a7 = a2.getAttributeValue(a6);
                            } else if (s.equals(a5) && (a8 = a2.getAttributeValue(a6)) != null) {
                                a8 = a8.charAt(0) == File.separatorChar ? a8 : a + a8;
                            }
                            n = ++a6;
                        }
                        jA.info("ReaderPluginAdd:tag=" + a4 + ",classname=" + a7 + ",jarpath=" + a8);
                        try {
                            ReaderSDKImpl a9;
                            Object a10 = a9.addPlugin(a7, a8);
                            if (a10 instanceof BookController) {
                                a9.addBookController((BookController)a10);
                            } else if (a10 instanceof ReaderPlugin && !a9.t.containsKey(a5 = ((ReaderPlugin)a10).getName())) {
                                a9.t.put(a5, a10);
                                if (a10 instanceof ReaderSplashPlugin) {
                                    a9.Q.add(a10);
                                }
                                ((ReaderPlugin)a10).pluginLoad((ReaderSDK)a9);
                            }
                        }
                        catch (Throwable a11) {
                            jA.warning("ReaderPluginInit: " + a7, a11);
                        }
                    }
                }
                a3 = a2.next();
            }
        }
        catch (XmlPullParserException a12) {
            jA.warning("ReaderConfigParser", (Throwable)a12);
        }
        catch (IOException a13) {
            jA.warning("ReaderConfigParser", (Throwable)a13);
        }
    }

    private void load() {
        ReaderSDKImpl a;
        try {
            a.X.pluginLoad((ReaderSDK)a);
            a.t.put(a.X.getName(), a.X);
            a.T.pluginLoad(a);
            a.t.put(a.T.getName(), a.T);
            a.J.pluginLoad(a);
            a.t.put(a.J.getName(), a.J);
            a.v.pluginLoad((ReaderSDK)a);
            a.S.pluginLoad((ReaderSDK)a);
            a.t.put(a.v.getName(), a.v);
            a.R.pluginLoad((ReaderSDK)a);
            a.t.put(a.R.getName(), a.R);
            a.M.pluginLoad(a);
            a.t.put(a.M.getName(), a.M);
            a.E.pluginLoad((ReaderSDK)a);
            a.t.put(a.E.getName(), a.E);
        }
        catch (BookException a2) {
            a.postIgnoreException((ReaderException)new PluginLoadFailedException());
        }
        a.doLoad(FrameworkUtil.getConfigDirectory() + File.separator);
        C.getRegistry().addRareUpdateBookStateFactory((DataStoreFactory)new EndReadingLocation());
        a.x.loadGlobalState();
        a.Y.loadDictionaries();
        a.a = true;
    }

    private Object addPlugin(String a, String a2) {
        String a3 = a;
        if (a3 == null) {
            jA.warning("Cannot find obfuscated name for " + a);
            return null;
        }
        try {
            if (a2 != null && a2.length() > 0) {
                ReaderSDKImpl a4;
                a4.addJarIntoClasspath(a2);
            }
            Class<?> a5 = Class.forName(a3);
            return a5.newInstance();
        }
        catch (Exception a6) {
            jA.error(null, new String[]{a3}, "addPlugin()", (Throwable)a6);
            return null;
        }
    }

    private void addJarIntoClasspath(String a) throws Exception {
        int a2;
        URLClassLoader a3 = (URLClassLoader)ClassLoader.getSystemClassLoader();
        URL[] a4 = a3.getURLs();
        URL a5 = new File(a).toURI().toURL();
        String a6 = a5.toString();
        int n = a2 = 0;
        while (n < a4.length) {
            if (a6.equals(a4[a2].toString())) {
                return;
            }
            n = ++a2;
        }
        try {
            Method a7 = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            a7.setAccessible(true);
            a7.invoke((Object)a3, a5);
            jA.info("Successfully add plugin jar to the system class loader: " + a);
        }
        catch (Exception a8) {
            jA.error(null, new String[]{a}, "addJarIntoClasspath()", (Throwable)a8);
            throw a8;
        }
    }

    public void addBookController(BookController a) {
        int a2;
        ReaderSDKImpl a3;
        if (a3.p.contains(a)) {
            return;
        }
        a.initialize((ReaderSDK)a3);
        RendererCapabilities a4 = a.getCapabilities();
        if (a4 == null) {
            return;
        }
        a3.p.add(a);
        String a5 = a4.getAnnotationExtension();
        String[] a6 = a4.getSupportedFileExtensions();
        int n = a2 = 0;
        while (n < a6.length) {
            String a7 = a6[a2].toLowerCase(Locale.US);
            a3.w.put(a7, a);
            if (a5 != null) {
                a3.o.put(a7, a5);
            }
            n = ++a2;
        }
    }

    public BookController getBookController() {
        ReaderSDKImpl a;
        return a.Z;
    }

    public boolean canOpenFile(File a) {
        ReaderSDKImpl a2;
        return a == null ? false : a2.getBookControllerByExt(a2.getExtension(a.getPath())) != null;
    }

    public BookController getBookControllerByExt(String a) {
        ReaderSDKImpl a2;
        if (a == null || "".equals(a)) {
            return null;
        }
        return (BookController)a2.w.get(a.toLowerCase(Locale.US));
    }

    public BookController getBookControllerByPath(String a) {
        ReaderSDKImpl a2;
        return a2.getBookControllerByExt(a2.getExtension(a));
    }

    public ReaderPlugin getReaderPluginByName(String a) {
        ReaderSDKImpl a2;
        return (ReaderPlugin)a2.t.get(a);
    }

    public List getReaderSplashPlugins() {
        ReaderSDKImpl a;
        return a.Q;
    }

    public EventManager getEventManager() {
        ReaderSDKImpl a;
        return a.U;
    }

    public Link createLink(URI a) {
        return null;
    }

    public Book openBook(String a) throws BookException {
        ReaderSDKImpl a2;
        BookController a3 = a2.getBookControllerByPath(a);
        if (a3 == null) {
            throw new BookInvalidException("Unknown book type");
        }
        Book a4 = a3.loadBook(a, a2.f);
        jA.info("Opened Book:" + a2.getBookIdentifier(a4));
        return a4;
    }

    public Book getCurrentBook() {
        ReaderSDKImpl a;
        return a.Z == null ? null : a.Z.getCurrentBook();
    }

    public BookNavigator getBookNavigator() {
        ReaderSDKImpl a;
        return a.Z == null ? null : a.Z.getBookNavigator();
    }

    public Registry getRegistry() {
        ReaderSDKImpl a;
        return a.N;
    }

    public ReaderUI getUI() {
        ReaderSDKImpl a;
        return a.P;
    }

    public RendererCapabilities getCapabilities() {
        ReaderSDKImpl a;
        return a.Z == null ? null : a.Z.getCapabilities();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeOpenBook(boolean a) throws IOException {
        ReaderSDKImpl a2;
        if (a2.Z != null && a2.i) {
            PerformanceLog.logStart((String)"BookController_getCurrentBook");
            Book a3 = a2.Z.getCurrentBook();
            PerformanceLog.logEnd((String)"BookController_getCurrentBook");
            if (a3 == null) {
                jA.warning("Attempted to close a non-existent book.");
                return;
            }
            ContextualReaderHistoryMarker a4 = a2.getReaderHistoryManager().startHistoryEventContext();
            PerformanceLog.logStart((String)"ReaderUI_closeBookCleanup");
            a2.P.closeBookCleanup();
            PerformanceLog.logEnd((String)"ReaderUI_closeBookCleanup");
            PerformanceLog.logStart((String)"postSaveStateEvent");
            a2.U.postSaveStateEvent(a3);
            PerformanceLog.logEnd((String)"postSaveStateEvent");
            a2.getReaderHistoryManager().setContextualHistoryMarker(a4);
            try {
                ReaderUIContext a5;
                PerformanceLog.logStart((String)"postCloseBookEvent");
                a2.U.postCloseBookEvent(a3, true);
                if (a && !a4.wasHistoryMarked() && (a5 = a2.P.getUIContext()) != null) {
                    a5.recordHistory();
                }
            }
            finally {
                PerformanceLog.logEnd((String)"postCloseBookEvent");
                a2.getReaderHistoryManager().endContextualHistory();
            }
            PerformanceLog.logStart((String)"saveSideCars");
            a3.saveSideCars();
            PerformanceLog.logEnd((String)"saveSideCars");
            PerformanceLog.logStart((String)"BookController_closeBook");
            a2.Z.closeBook();
            PerformanceLog.logEnd((String)"BookController_closeBook");
            PerformanceLog.logStart((String)"Book_close");
            a3.close();
            PerformanceLog.logEnd((String)"Book_close");
            PerformanceLog.logStart((String)"AnnotationManager_closeCache");
            a2.X.closeCache(a3);
            PerformanceLog.logEnd((String)"AnnotationManager_closeCache");
            a2.i = false;
        }
    }

    public boolean loadLegacySidecar(Book a, State a2, AnnotationProvider a3) throws IOException {
        if (a3 == null) {
            jA.error("Unable to load Legacy Sidecar Provider for current book controller.");
            return false;
        }
        List a4 = a3.importAnnotations(a);
        if (a4 != null) {
            Iterator a5;
            ReaderSDKImpl a6;
            a6.X.loadCacheFromSaveState(a, a2);
            a6.X.releaseCache(a);
            a6.X.loadCacheFromSaveState(a, a2);
            Iterator iterator = a5 = a4.iterator();
            while (iterator.hasNext()) {
                a6.X.importAnnotation((Annotation)a5.next(), a);
                iterator = a5;
            }
            a2.save(true);
            a3.deleteLegacySidecar(a);
            if (a4.size() > 0) {
                a6.U.postAnnotationImportedEvent(a);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSwitchBook(BookController a, Book a2, String a3, Position a4, boolean a5, boolean a6) throws BookException {
        ReaderSDKImpl a7;
        PerformanceLog.logStart((String)"ReaderSDKImpl_doSwitchBook");
        try {
            PerformanceLog.logStart((String)"ReaderSDKImpl_closeOpenBook");
            a7.closeOpenBook(false);
        }
        catch (IOException a8) {
            jA.error("Failed to Close book", (Throwable)a8);
            PerformanceLog.logEnd((String)"ReaderSDKImpl_doSwitchBook");
            throw new FailedClosingPrevBookException((Throwable)a8);
        }
        finally {
            PerformanceLog.logEnd((String)"ReaderSDKImpl_closeOpenBook");
        }
        a7.Z = a;
        boolean a9 = false;
        try {
            State a10 = a2.getRareUpdateBookState();
            try {
                a9 = a7.loadLegacySidecar(a2, a10, a7.Z.getLegacyProvider());
            }
            catch (IOException a11) {
                jA.error("Unable to save current Book State to disk when loading legacy sidecar.", (Throwable)a11);
            }
            if (a4 == null && (a14 = a2.getLPR()) != null) {
                a4 = a14.getLPRPosition();
            }
            try {
                PerformanceLog.logStart((String)"ReaderSDKImpl_openBook");
                try {
                    a7.i = a.openBook(a2, a3, a4, a6);
                }
                finally {
                    PerformanceLog.logEnd((String)"ReaderSDKImpl_openBook");
                }
            }
            catch (ReaderAuthenticationException a12) {
                a7.Z = null;
                SwitchAppUtils.goHome();
                PerformanceLog.logEnd((String)"ReaderSDKImpl_doSwitchBook");
                return;
            }
            if (!a9) {
                try {
                    a7.X.loadCacheFromSaveState(a2, a10);
                }
                catch (IOException a13) {
                    jA.error("Unable to open rarely updated sidecar.");
                }
            }
            PerformanceLog.logStart((String)"ReaderSDKImpl_postOpenBook");
            try {
                a7.U.postOpenBookEvent(a2, true);
            }
            finally {
                PerformanceLog.logEnd((String)"ReaderSDKImpl_postOpenBook");
            }
            PerformanceLog.logStart((String)"ReaderSDKImpl_showBook");
            try {
                if (a5) {
                    LastPageRead a14 = a2 != null && a2.getMetadata() != null ? a2.getMetadata().getTitle() : null;
                    a7.setTitlebarText(null, (String)a14);
                    a7.P.showBook();
                }
                a7.P.updateBookView();
            }
            finally {
                PerformanceLog.logEnd((String)"ReaderSDKImpl_showBook");
            }
            a7.getBookNavigator().markStartingInfo();
            int a15 = a7.N.getPageInserterCount();
            for (int a16 = 0; a16 < a15; ++a16) {
                a7.getBookNavigator().attachPagerInserter(a7.N.getPageInserter(a16));
            }
        }
        catch (BookException a17) {
            a7.Z = null;
            throw a17;
        }
        catch (RuntimeException a18) {
            a7.Z = null;
            throw a18;
        }
        finally {
            PerformanceLog.logEnd((String)"ReaderSDKImpl_doSwitchBook");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchToBook(String a, Position a2) throws BookException {
        ReaderSDKImpl a3;
        Book a4 = a3.openBook(a);
        boolean a5 = false;
        try {
            a3.switchToBook(a4, null, a2);
            a5 = true;
        }
        finally {
            if (!a5) {
                try {
                    a4.close();
                }
                catch (Exception a6) {
                    jA.warning("Failed to close book.", (Throwable)a6);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchToBook(String a, String a2) throws BookException {
        ReaderSDKImpl a3;
        Book a4 = a3.openBook(a);
        boolean a5 = false;
        try {
            a3.switchToBook(a4, a2, null);
            a5 = true;
        }
        finally {
            if (!a5) {
                try {
                    a4.close();
                }
                catch (Exception a6) {
                    jA.warning("Failed to close book.", (Throwable)a6);
                }
            }
        }
    }

    public void switchToBook(Book a, String a2, Position a3) throws BookException {
        ReaderSDKImpl a4;
        a4.switchToBook(a, a2, a3, true, false);
    }

    public synchronized void switchToBook(Book a, String a2, Position a3, boolean a4, boolean a5) throws BookException {
        ReaderSDKImpl a6;
        if (a6.V == null) {
            return;
        }
        Book a7 = a6.getCurrentBook();
        if (a7 == null || !a7.equals(a)) {
            BookController a8 = a6.getBookControllerByPath(a.getPath());
            if (a8 == null) {
                throw new BookException((Throwable)new CoreServiceException("No handler avaialable for book."));
            }
            a6.doSwitchBook(a8, a, a2, a3, a4, a5);
            if (Log.isDebugOn()) {
                String a9 = a6.getBookIdentifier(a7);
                String a10 = a6.getBookIdentifier(a);
                jA.debug(j, new String[]{a9, a10}, "Doing the switch since the current book is different from the one being switched to");
            }
        } else {
            String a11;
            if (Log.isDebugOn()) {
                a11 = a6.getBookIdentifier(a7);
                jA.debug(j, new String[]{a11, a11}, "Not doing the switch since the new book is same as the active book");
            }
            if (a4) {
                if (a3 == null && (a11 = a.getLPR()) != null) {
                    a3 = a11.getLPRPosition();
                }
                if (a3 != null) {
                    a6.getBookNavigator().goTo(a3);
                    a6.U.postNavigationEvent(a6.Z.getBookNavigator().getViewport(), PositionNotificationHandler.UserNavigationEvent.D);
                }
            }
        }
    }

    private String getBookIdentifier(Book a) {
        String a2 = "";
        if (a != null && a.getMetadata() != null) {
            a2 = a.getMetadata().getASIN();
        }
        if (a != null && (a2 == null || a2.length() == 0)) {
            a2 = a.getPath() == null ? "" : String.valueOf(a.getPath().hashCode());
        }
        return a2;
    }

    public String getExtension(String a) {
        int a2 = a.lastIndexOf(46);
        return a2 == -1 ? null : a.substring(a2 + 1);
    }

    public DictionaryManager getDictionaryManager() {
        ReaderSDKImpl a;
        return a.Y;
    }

    public synchronized void switchContext(Object a, State a2) throws IllegalAccessException {
        ReaderSDKImpl a3;
        AbstractBooklet a4 = (AbstractBooklet)a;
        if (a4 == null) {
            try {
                PerformanceLog.logStart((String)"closeOpenBook");
                a3.closeOpenBook(true);
                PerformanceLog.logEnd((String)"closeOpenBook");
            }
            catch (IOException a5) {
                jA.warning("Failed to close previously open book", (Throwable)a5);
            }
            if (a3.P != null) {
                a3.P.tearDown();
            }
            a3.V = null;
            a3.Z = null;
        } else {
            if (a4 == a3.V) {
                return;
            }
            if (a3.P != null) {
                PerformanceLog.logStart((String)"ReaderUI_setUp");
                a3.P.setUp();
                PerformanceLog.logEnd((String)"ReaderUI_setUp");
            }
            if (!a4.isActive()) {
                throw new IllegalAccessException("Booklet must be active booklet in order to switchContext.");
            }
            a3.V = a4;
        }
        a3.x.setCurrentState(a2);
    }

    public Object getActiveContext() {
        ReaderSDKImpl a;
        return a.V == null ? null : a.V.getBookletContext();
    }

    public ReaderStateManager getReaderStateManager() {
        ReaderSDKImpl a;
        return a.x;
    }

    public State loadAppState(String a) throws ClassNotFoundException, InvalidSideCarFileException, IOException {
        ReaderSDKImpl a2;
        return a2.x.loadAppState(a);
    }

    public State getAppState() {
        ReaderSDKImpl a;
        return a.x.getCurrentState();
    }

    public ReaderStateData getAppStateData() {
        ReaderSDKImpl a;
        State a2 = a.getAppState();
        if (a2 != null) {
            return (ReaderStateData)a2.get("reader.state.preferences");
        }
        jA.error("getAppState returned null State object for current context");
        return null;
    }

    public State getGlobalState() {
        ReaderSDKImpl a;
        return a.x.getGlobalState();
    }

    public void recordPageHistory() {
        ReaderSDKImpl a;
        if (a.Z == null) {
            return;
        }
        BookNavigator a2 = a.Z.getBookNavigator();
        if (a2 == null) {
            return;
        }
        Position a3 = a2.getViewport().getStartPosition();
        Map a4 = a.y.createMapData(a.P.getUIContext(), a3);
        if (a4 != null) {
            a.u.markHistory(a.y.getID(), a4);
        }
    }

    public ReaderHistoryManager getReaderHistoryManager() {
        ReaderSDKImpl a;
        return a.u;
    }

    public ReaderPageHistoryHandler getDefaultPageHistoryHandler() {
        ReaderSDKImpl a;
        return a.y;
    }

    public BookStateManager getBookStateManager() {
        ReaderSDKImpl a;
        return a.f;
    }

    public Object getActiveBooklet() {
        ReaderSDKImpl a;
        return a.V;
    }

    public PositionFactory getCurrentPositionFactory() {
        ReaderSDKImpl a;
        return a.Z.getPositionFactory();
    }

    public PositionFactory getPositionFactory(Book a) {
        ReaderSDKImpl a2;
        PositionFactory a3 = a2.getPositionFactory(a.getPath());
        if (a3 == null) {
            jA.error(g, new String[]{a2.getBookIdentifier(a)}, "Unable to get book Controller for book");
        }
        return a3;
    }

    public PositionFactory getPositionFactory(String a) {
        ReaderSDKImpl a2;
        BookController a3 = a2.getBookControllerByPath(a);
        if (a3 != null) {
            return a3.getPositionFactory();
        }
        jA.error(g, null, "Unable to get book Controller for book");
        return null;
    }

    public AnnotationManager getAnnotationManager() {
        ReaderSDKImpl a;
        return a.X;
    }

    public void setTitlebarText(String a, String a2) {
        ReaderSDKImpl a3;
        BookletContext a4 = (BookletContext)a3.getActiveContext();
        if (a4 == null) {
            return;
        }
        ChromeHeaderBar a5 = (ChromeHeaderBar)a4.getService(ChromeHeaderBar.class);
        try {
            a5.setTitlebarText(a3.V, a, a2);
        }
        catch (ChromeException a6) {
            jA.error("Could not update title", (Throwable)a6);
        }
    }

    public static Object getBundleService(Class a) throws ReaderException {
        if (C != null) {
            return C.getService(a);
        }
        throw new CoreServiceException("ReaderSDK not yet initialized");
    }

    public BundleContext getBundleContext() {
        return d;
    }

    public static ReaderSDK fauxStart(BundleContext a) throws InvalidSyntaxException, ReaderException {
        jA.info("ReaderSDK Bundle Starting through a fauxStart");
        String a2 = "(objectclass=" + BookletServices.class.getName() + ")";
        d = a;
        C = new ReaderSDKImpl();
        a.registerService(a2, (Object)C, null);
        C.load();
        return C;
    }

    protected void dependenciesSatisfied() {
        ReaderSDKImpl a;
        d = super.getBundleContext();
        a.registerAs(ReaderSDK.class);
        C.load();
        a.G = new LprShownBookHandler(a);
        ContentToDoHandler.installHandler();
        C.getRegistry().registerSidecarToDoTopic(z, true, true, false, null);
        C.getRegistry().registerSidecarToDoTopic(W, true, true, false, null);
        LprToDoHandler.installHandler();
        PageNumbersToDoHandler.installHandler();
        LipcTarget a2 = LipcService.getInstance().getDefaultSource().getTarget("com.lab126.kaf");
        if (a2 != null) {
            try {
                a2.addLipcEventListener("dictionariesUpdated", (LipcEventListener)a.Y);
            }
            catch (LipcException a3) {
                jA.error("Unable to add dictionariesUpdated listener.", (Throwable)a3);
            }
        }
    }

    protected Class[] getDependencies() {
        return new Class[]{ToDo.class, BookletServices.class, CatalogService.class, WhisperSyncV1.class, JournalingService.class, UserStoreService.class, PowerService.class, ChromeHeaderBar.class, ScreenRotationService.class, SystemServices.class, History.class, MemoryService.class};
    }

    public void deregisterService(SimpleService a) throws Exception {
        a.stop(d);
    }

    public void registerService(SimpleService a) throws Exception {
        a.start(d);
    }

    public String getNonCheckSummedPID() {
        return new ReaderSecurity().getPID();
    }

    public PageNumberManager getPageNumberManager() {
        ReaderSDKImpl a;
        return a.v;
    }

    public SharingManager getSharingManager() {
        ReaderSDKImpl a;
        return a.S;
    }

    public void postException(ReaderException a) {
        ReaderSDKImpl a2;
        a2.U.postErrorHandler(a);
    }

    public void postFatalException(ReaderException a) {
        ReaderSDKImpl a2;
        if (a.getExceptionLevel() != 0) {
            a = new ReaderException(0, (Throwable)a);
        }
        a2.postException(a);
    }

    public void postWarningException(ReaderException a) {
        ReaderSDKImpl a2;
        if (a.getExceptionLevel() != 65536) {
            a = new ReaderException(65536, (Throwable)a);
        }
        a2.postException(a);
    }

    public void postIgnoreException(ReaderException a) {
        ReaderSDKImpl a2;
        if (a.getExceptionLevel() != 131072) {
            a = new ReaderException(131072, (Throwable)a);
        }
        a2.postException(a);
    }

    public boolean saveClipArticle() {
        ReaderSDKImpl a;
        if (a.getCurrentBook() == null || a.getCurrentBook().getTOC() == null) {
            return false;
        }
        TableOfContentsEntry a2 = a.getCurrentBook().getTOC().getCurrentTOCNodeEntry();
        if (a2 == null || a2.getLength() == 0 || !"article".equals(a2.getNodeType())) {
            return false;
        }
        Position a3 = a2.getPosition();
        int a4 = a3.createSortableIndexKey();
        int a5 = a2.getLength();
        Position a6 = null;
        try {
            a6 = a.getBookController().getPositionFactory().createInstance(new Integer(a4 + a5).toString(), a.getCurrentBook());
        }
        catch (InvalidObjectException a7) {
            jA.error("Fail to find end position of article: " + a7);
        }
        catch (IOException a8) {
            jA.error("IOException when finding end position of article " + a8);
        }
        if (a6 == null) {
            return false;
        }
        AnnotationFactory a9 = a.X.getAnnotationFactory(3);
        if (a9 == null) {
            return false;
        }
        Annotation a10 = null;
        try {
            a10 = a9.createAnnotation(null, a3, a6);
        }
        catch (AnnotationException a11) {
            jA.warning("Cannot create Clip Article Annotation.");
        }
        if (a10 == null) {
            jA.error("Fail to save article as clipping");
            return false;
        }
        jA.info("Saving Clip Article Annotation.");
        a.R.addAnnotationEvent(a10);
        return true;
    }

    public void invokeLater(Runnable a) {
        ReaderSDKImpl a2;
        Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(a2.new ReaderInvocationEvent(a));
    }

    public void setTipsAndTricksURI(URI a) {
        ReaderSDKImpl a2;
        ReaderPlugin a3 = a2.getReaderPluginByName("TipsAndTricks");
        if (a3 != null && a3 instanceof TipsAndTricksViewProvider) {
            ((TipsAndTricksViewProvider)a3).setURI(a);
        }
    }

    static {
        j = new LogMessage("SWITCHTOBOOK", new String[]{"activeBookIdentifier", "currentBookIdentifier"});
        g = new LogMessage("getPositionFactoryFailure", new String[]{"currentBookIdentifier"});
    }

    private class ReaderInvocationEvent
    extends InvocationEvent {
        private AbstractBooklet owningBooklet;

        private ReaderInvocationEvent(Runnable a, Object a2, boolean a3) {
            ReaderInvocationEvent a4;
            super((Object)a4.ReaderSDKImpl.this, a, a2, a3);
            a4.owningBooklet = (AbstractBooklet)a4.ReaderSDKImpl.this.V;
        }

        private ReaderInvocationEvent(Runnable a) {
            a2(a, null, false);
            ReaderInvocationEvent a2;
        }

        public void dispatch() {
            ReaderInvocationEvent a;
            if (a.owningBooklet != null && a.owningBooklet.isActive()) {
                super.dispatch();
            } else {
                jA.info("InvokeLater cancelled because book context has closed");
            }
        }
    }
}

