/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ebook.booklet.reader.impl;

import com.amazon.ebook.booklet.reader.sdk.BookException;
import com.amazon.ebook.booklet.reader.sdk.ReaderPlugin;
import com.amazon.ebook.booklet.reader.sdk.ReaderSDK;
import com.amazon.ebook.booklet.reader.sdk.content.Book;
import com.amazon.ebook.booklet.reader.sdk.content.LastPageRead;
import com.amazon.ebook.booklet.reader.sdk.content.Position;
import com.amazon.ebook.booklet.reader.sdk.content.ScreenInfo;
import com.amazon.ebook.booklet.reader.sdk.content.Viewport;
import com.amazon.ebook.booklet.reader.sdk.event.EventHandler;
import com.amazon.ebook.booklet.reader.sdk.event.OpenBookHandler;
import com.amazon.ebook.booklet.reader.sdk.event.SaveStateHandler;
import com.amazon.ebook.booklet.reader.sdk.util.DataStoreFactory;
import com.amazon.ebook.booklet.reader.sdk.util.DataStoreObject;
import com.amazon.ebook.booklet.reader.sdk.util.InvalidSideCarFileException;
import com.amazon.ebook.booklet.reader.sdk.util.State;
import com.amazon.ebook.util.log.Log;
import java.io.IOException;
import java.util.HashMap;

public class LastPageReadProvider
extends ReaderPlugin
implements SaveStateHandler,
OpenBookHandler,
DataStoreFactory {
    private static final Log B = Log.getInstance((String)"LastPageReadProvider");
    private ReaderSDK D;

    public LastPageReadProvider() {
        LastPageReadProvider a;
    }

    public DataStoreObject getEmptyObject(Object a) {
        LastPageReadProvider a2;
        return new LastPageRead(a2.D);
    }

    public String getKey() {
        return "lpr";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveLastPageRead(Position a, Book a2) throws IOException, InvalidSideCarFileException {
        Book book = a2;
        synchronized (book) {
            State a3 = a2.getFreqUpdateBookState();
            if (a3 != null) {
                LastPageRead a4 = (LastPageRead)a3.get("lpr");
                if (a4 == null) {
                    LastPageReadProvider a5;
                    a4 = new LastPageRead(a5.D);
                    a3.add((DataStoreObject)a4);
                }
                a4.setLPR(a.convertToSerializablePosition());
            }
        }
    }

    public String getName() {
        return "Last Page Reader Provider";
    }

    public void pluginLoad(ReaderSDK a) throws BookException {
        LastPageReadProvider a2;
        a2.D = a;
        a.getRegistry().addFrequentUpdateBookStateFactory((DataStoreFactory)a2);
        a.getRegistry().registerHandler((EventHandler)a2);
    }

    public void pluginUnload() {
        LastPageReadProvider a;
        a.D.getRegistry().removeFrequentUpdateBookStateFactory((DataStoreFactory)a);
        a.D.getRegistry().deregisterHandler((EventHandler)a);
    }

    public HashMap getSupportedDataStoreFactories() {
        return null;
    }

    public void saveState(Book a) {
        Viewport a2;
        LastPageReadProvider a3;
        ScreenInfo a4 = a3.D.getUI().getLastDrawnScreenInfo();
        Position a5 = null;
        if (a4 != null && (a2 = a4.getViewport()) != null) {
            a5 = a2.getStartPosition();
        }
        try {
            if (a5 != null) {
                a3.saveLastPageRead(a5, a);
            } else {
                B.warning("No screenInfo found.  LPR not saved.");
            }
        }
        catch (Throwable a22) {
            B.error("Error saving last page read", a22);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openBookEvent(Book a, boolean a2) {
        Book book = a;
        synchronized (book) {
            try {
                LastPageRead a3;
                State a4 = a.getFreqUpdateBookState();
                if (a4 != null && (a3 = (LastPageRead)a4.get("lpr")) == null) {
                    LastPageReadProvider a5;
                    a3 = new LastPageRead(a5.D);
                    a4.add((DataStoreObject)a3);
                    a3.setLPR(a5.D.getBookNavigator().getCurrentPosition().convertToSerializablePosition());
                }
            }
            catch (InvalidSideCarFileException a6) {
                B.error("Failed to read sidecar file.", (Throwable)a6);
            }
        }
    }

    public void setSupportedDataStoreFactories(HashMap a) {
    }
}

