/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ebook.booklet.reader.impl;

import com.amazon.ebook.booklet.reader.impl.ReaderSDKImpl;
import com.amazon.ebook.booklet.reader.sdk.BookException;
import com.amazon.ebook.booklet.reader.sdk.content.dictionary.Dictionary;
import com.amazon.ebook.booklet.reader.sdk.content.dictionary.DictionaryManager;
import com.amazon.ebook.booklet.reader.sdk.content.dictionary.DictionaryPlugin;
import com.amazon.ebook.booklet.reader.sdk.event.EventHandler;
import com.amazon.ebook.booklet.reader.sdk.event.ReaderGlobalStateHandler;
import com.amazon.ebook.booklet.reader.sdk.util.DataStoreFactory;
import com.amazon.ebook.booklet.reader.sdk.util.DataStoreObject;
import com.amazon.ebook.booklet.reader.sdk.util.DefaultDataStore;
import com.amazon.ebook.booklet.reader.sdk.util.ReaderDataInput;
import com.amazon.ebook.booklet.reader.sdk.util.ReaderDataOutput;
import com.amazon.ebook.booklet.reader.sdk.util.State;
import com.amazon.ebook.booklet.reader.utils.FrameworkUtil;
import com.amazon.ebook.util.log.Log;
import com.amazon.ebook.util.log.PerformanceLog;
import com.amazon.kindle.content.catalog.CatalogEntry;
import com.amazon.kindle.content.catalog.CatalogService;
import com.amazon.kindle.content.catalog.Predicate;
import com.amazon.kindle.content.catalog.PredicateFactory;
import com.amazon.kindle.util.lipc.LipcEvent;
import com.amazon.kindle.util.lipc.LipcEventListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;

public class DictionaryManagerImpl
extends DictionaryManager
implements DataStoreFactory,
ReaderGlobalStateHandler,
LipcEventListener {
    private static final long c = 2000L;
    private static final String l = "com.amazon.ebook.booklet.reader.resources.DefaultDictionaries";
    private List k = new ArrayList();
    private static final String m = "dict.prefs.v2";
    private ReaderSDKImpl h;
    private LoadDictionaryTask A = null;
    private GlobalDictionaryData H = null;
    private HashMap b = new HashMap();
    private ArrayList K = new ArrayList();
    private static final Log B = Log.getInstance((String)"DictionaryManagerImpl");

    private DictionaryManagerImpl() {
        DictionaryManagerImpl a;
    }

    public DictionaryManagerImpl(ReaderSDKImpl a) {
        a2();
        DictionaryManagerImpl a2;
        a2.h = a;
        a.getRegistry().addReaderStateDataStoreFactory((DataStoreFactory)a2);
        a.getRegistry().registerHandler((EventHandler)a2);
    }

    public synchronized Set getAvailableDictionaryLanaguages() {
        DictionaryManagerImpl a;
        return a.b.keySet();
    }

    public synchronized List getAllDictionaries() {
        DictionaryManagerImpl a;
        return (List)a.K.clone();
    }

    public synchronized List getAvailableDictionariesByLanguage(String a) {
        DictionaryManagerImpl a2;
        if (a == null) {
            return new ArrayList();
        }
        String a3 = FrameworkUtil.getBaseLanguage((String)a);
        if (a3 == null) {
            return new ArrayList();
        }
        return (List)a2.b.get(a3);
    }

    public synchronized Dictionary getDefaultDictionary(String a) {
        DictionaryManagerImpl a2;
        String a3 = FrameworkUtil.getBaseLanguage((String)a);
        LinkedList a4 = (LinkedList)a2.b.get(a3);
        if (a4 == null || a4.size() == 0) {
            return null;
        }
        return (Dictionary)a4.get(0);
    }

    public synchronized boolean removeDictionaryPlugin(DictionaryPlugin a) {
        DictionaryManagerImpl a2;
        a2.k.remove(a);
        return true;
    }

    public synchronized boolean addDictionaryPlugin(DictionaryPlugin a) {
        DictionaryManagerImpl a2;
        a2.k.add(a);
        return true;
    }

    synchronized int numDictionaryPlugins() {
        DictionaryManagerImpl a;
        return a.k.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultDictionary(Dictionary a) {
        DictionaryManagerImpl a2;
        if (a == null) {
            return;
        }
        boolean a3 = false;
        String a4 = null;
        Dictionary a5 = null;
        DictionaryManagerImpl dictionaryManagerImpl = a2;
        synchronized (dictionaryManagerImpl) {
            a4 = FrameworkUtil.getBaseLanguage((String)a.getLanguageIn());
            LinkedList a6 = (LinkedList)a2.b.get(a4);
            if (a6 != null && (a5 = (Dictionary)a6.get(0)) == a) {
                return;
            }
            if (a6 == null || !a6.remove(a)) {
                B.error("Trying to set the default dictionary to one that is not in the active dictionary list.");
            } else {
                a6.addFirst(a);
                a2.H.setDefaultDictionaryLang(a4, a.getUniqueID());
                State a7 = a2.h.getGlobalState();
                try {
                    a7.save();
                }
                catch (IOException a8) {
                    B.warning("Failed to save global Reader State", (Throwable)a8);
                }
                a3 = true;
            }
        }
        if (a3) {
            a2.h.getEventManager().postDefaultDictionaryChangeEvent(a4, a5, a);
        }
    }

    public void globalStateReady(State a) {
        DictionaryManagerImpl a2;
        if (a2.H == null) {
            a2.H = (GlobalDictionaryData)a.get(m);
            if (a2.H == null) {
                a2.H = a2.new GlobalDictionaryData();
                a2.H.setDirty(true);
                a.add((DataStoreObject)a2.H);
            }
        }
    }

    public void loadDictionaries() {
        DictionaryManagerImpl a;
        a.doLoadDictList(a.getDictionaryList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doLoadDictList(List a) {
        DictionaryManagerImpl a2;
        PerformanceLog.logStart((String)"DictionaryManagerImpl_loadDictionaries");
        if (a2.H == null) {
            B.warning("Trying to load dictionary before global state ready");
            PerformanceLog.logEnd((String)"DictionaryManagerImpl_loadDictionaries");
            return;
        }
        DictionaryManagerImpl dictionaryManagerImpl = a2;
        synchronized (dictionaryManagerImpl) {
            a2.b.clear();
            a2.K.clear();
            Iterator a3 = a2.k.iterator();
            block9: while (true) {
                Iterator iterator = a3;
                while (iterator.hasNext()) {
                    List a4 = ((DictionaryPlugin)a3.next()).getDynamicDictionaries();
                    if (a4 == null) continue block9;
                    a.addAll(a4);
                    iterator = a3;
                }
                break;
            }
            Iterator a5 = a2.k.iterator();
            a5 = a.iterator();
            ResourceBundle a6 = ResourceBundle.getBundle(l);
            block11: while (a5.hasNext()) {
                String a7 = (String)a5.next();
                B.debug("Loading dictionary path/ID: " + a7);
                try {
                    for (int a8 = 0; a8 < a2.k.size(); ++a8) {
                        String a9;
                        Dictionary a10 = ((DictionaryPlugin)a2.k.get(a8)).load(a7);
                        if (a10 == null) continue;
                        String a11 = FrameworkUtil.getBaseLanguage((String)a10.getLanguageIn());
                        LinkedList<Dictionary> a12 = (LinkedList<Dictionary>)a2.b.get(a11);
                        if (a12 == null) {
                            a12 = new LinkedList<Dictionary>();
                            a2.b.put(a11, a12);
                        }
                        if ((a9 = a2.H.getDictionaryID(a11)) == null) {
                            try {
                                a9 = a6.getString(a11);
                            }
                            catch (MissingResourceException a13) {
                                // empty catch block
                            }
                        }
                        if (a9 != null && a10.getUniqueID().equals(a9)) {
                            a12.addFirst(a10);
                        } else {
                            a12.add(a10);
                        }
                        a2.K.add(a10);
                        continue block11;
                    }
                }
                catch (BookException a14) {
                    B.error("dictionary loading error " + a14.toString());
                }
            }
            a2.H.sync(a2.b);
            if (a2.H.isDirty()) {
                try {
                    a2.h.getGlobalState().save();
                }
                catch (IOException a15) {
                    B.error("Failed to update dictionary preferences.  Will try again later.");
                }
            }
        }
        if (a2.h != null) {
            a2.h.getEventManager().postDictionariesLoadedEvent();
        } else {
            B.warning("Failing to send post dictionary loaded event because sdk is null");
        }
        PerformanceLog.logEnd((String)"DictionaryManagerImpl_loadDictionaries");
    }

    public String getLanguageBucket(String a) {
        return FrameworkUtil.getBaseLanguage((String)a);
    }

    public DataStoreObject getEmptyObject(Object a) {
        DictionaryManagerImpl a2;
        return a2.new GlobalDictionaryData();
    }

    public String getKey() {
        return m;
    }

    public HashMap getSupportedDataStoreFactories() {
        return null;
    }

    private CatalogEntry[] getDictionaryCatalogEntries() {
        DictionaryManagerImpl a;
        CatalogService a2 = null;
        a2 = (CatalogService)a.h.getService(CatalogService.class);
        if (a2 == null) {
            B.error("Failed to Load CC! Dictionary list may be incorrect.");
            return null;
        }
        Predicate a3 = PredicateFactory.equals((String)"type", (String)"Entry:Item:Dictionary");
        return a2.find(a3, null, 100, 0);
    }

    private List getDictionaryList() {
        DictionaryManagerImpl a;
        CatalogEntry[] a2 = a.getDictionaryCatalogEntries();
        if (a2 == null) {
            return a.simulatorGetDictionaries();
        }
        ArrayList<String> a3 = null;
        if (a2 != null && a2.length > 0) {
            int a4;
            a3 = new ArrayList(a2.length);
            int n = a4 = 0;
            while (n < a2.length) {
                a3.add(a2[a4].getLocation());
                n = ++a4;
            }
        }
        return a3 == null ? new ArrayList<String>() : a3;
    }

    private List simulatorGetDictionaries() {
        Iterator a;
        List a2 = FrameworkUtil.getSimulatorDictionaryList();
        ArrayList<String> a3 = new ArrayList<String>(a2.size());
        Iterator iterator = a = a2.iterator();
        while (iterator.hasNext()) {
            a3.add((String)a.next());
            iterator = a;
        }
        return a3;
    }

    private boolean foundDictionary(String a) {
        DictionaryManagerImpl a2;
        Iterator a3 = a2.K.iterator();
        while (a3.hasNext()) {
            if (!new File(a).getAbsolutePath().equals(((Dictionary)a3.next()).getUniqueID())) continue;
            return true;
        }
        return false;
    }

    public void onLipcEvent(LipcEvent a) {
        DictionaryManagerImpl a2;
        if (a2.H == null) {
            return;
        }
        if (a2.A != null) {
            a2.A.cancel();
        }
        a2.A = a2.new LoadDictionaryTask();
        new Timer().schedule((TimerTask)a2.A, 2000L);
    }

    public void setSupportedDataStoreFactories(HashMap a) {
    }

    private class LoadDictionaryTask
    extends TimerTask {
        private LoadDictionaryTask() {
            LoadDictionaryTask a;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            LoadDictionaryTask a;
            boolean a2 = false;
            List a3 = a.DictionaryManagerImpl.this.getDictionaryList();
            DictionaryManagerImpl dictionaryManagerImpl = a.DictionaryManagerImpl.this;
            synchronized (dictionaryManagerImpl) {
                if (a3.size() != a.DictionaryManagerImpl.this.K.size()) {
                    a2 = true;
                } else {
                    int a4;
                    int n = a4 = 0;
                    while (n < a3.size()) {
                        if (!a.DictionaryManagerImpl.this.foundDictionary((String)a3.get(a4))) {
                            a2 = true;
                            break;
                        }
                        n = ++a4;
                    }
                }
            }
            if (a2) {
                a.DictionaryManagerImpl.this.doLoadDictList(a3);
            }
        }
    }

    private class GlobalDictionaryData
    extends DefaultDataStore {
        private HashMap B = new HashMap();

        public GlobalDictionaryData() {
            GlobalDictionaryData a;
        }

        public void sync(HashMap a) {
            Object a2;
            Iterator<Object> a3;
            GlobalDictionaryData a4;
            boolean a5 = true;
            if (a.size() != a4.B.size()) {
                a5 = false;
            } else if (!((Object)a.keySet()).equals(a4.B.keySet())) {
                a5 = false;
            } else {
                a3 = a4.B.keySet().iterator();
                while (a3.hasNext()) {
                    a2 = (String)a3.next();
                    if (a4.B.get(a2).equals(((List)a.get(a2)).get(0))) continue;
                    a5 = false;
                    break;
                }
            }
            if (!a5) {
                a4.B = new HashMap(a.size());
                a3 = a.entrySet().iterator();
                Iterator iterator = a3;
                while (iterator.hasNext()) {
                    a2 = (Map.Entry)a3.next();
                    a4.B.put(a2.getKey(), ((Dictionary)((List)a2.getValue()).get(0)).getUniqueID());
                    iterator = a3;
                }
                a4.DictionaryManagerImpl.this = (DictionaryManagerImpl)true;
            }
        }

        public void setDirty(boolean a) {
            a.DictionaryManagerImpl.this = (DictionaryManagerImpl)a;
        }

        public String getFactoryKey() {
            return DictionaryManagerImpl.m;
        }

        public void deserialize(ReaderDataInput a, Object a2, HashMap a3) throws IOException {
            int a4;
            int a5 = a.readInt();
            int n = a4 = 0;
            while (n < a5) {
                GlobalDictionaryData a6;
                a6.B.put(a.readUTF(), a.readUTF());
                n = ++a4;
            }
        }

        public void serialize(ReaderDataOutput a) throws IOException {
            Iterator a2;
            GlobalDictionaryData a3;
            a.writeInt(a3.B.size());
            Iterator iterator = a2 = a3.B.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry a4 = a2.next();
                a.writeUTF((String)a4.getKey());
                a.writeUTF((String)a4.getValue());
                iterator = a2;
            }
        }

        public String getDictionaryID(String a) {
            GlobalDictionaryData a2;
            return (String)a2.B.get(a);
        }

        public void setDefaultDictionaryLang(String a, String a2) {
            GlobalDictionaryData a3;
            String a4 = (String)a3.B.get(a);
            if (a4 != null && a4.equals(a2)) {
                return;
            }
            a3.B.put(a, a2);
            a3.DictionaryManagerImpl.this = (DictionaryManagerImpl)true;
        }
    }
}

