/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ebook.booklet.reader.impl;

import com.amazon.agui.swing.ConfirmationDialog;
import com.amazon.agui.swing.event.GestureDispatcher;
import com.amazon.agui.swing.event.GestureEvent;
import com.amazon.ebook.booklet.reader.errorhandler.ErrorHandler;
import com.amazon.ebook.booklet.reader.impl.NativeBookView;
import com.amazon.ebook.booklet.reader.impl.ReaderSDKImpl;
import com.amazon.ebook.booklet.reader.impl.ReaderStateData;
import com.amazon.ebook.booklet.reader.impl.RegistryImpl;
import com.amazon.ebook.booklet.reader.impl.ui.FontResizeDialog;
import com.amazon.ebook.booklet.reader.impl.ui.ImageDialog;
import com.amazon.ebook.booklet.reader.impl.ui.KeyboardInputModalDialog;
import com.amazon.ebook.booklet.reader.impl.ui.SelectionDialogImpl;
import com.amazon.ebook.booklet.reader.impl.ui.TableDialog;
import com.amazon.ebook.booklet.reader.plugin.notesandmarks.AnnotationViewProvider;
import com.amazon.ebook.booklet.reader.sdk.BookNavigator;
import com.amazon.ebook.booklet.reader.sdk.ReaderException;
import com.amazon.ebook.booklet.reader.sdk.ReaderSDK;
import com.amazon.ebook.booklet.reader.sdk.TOCException;
import com.amazon.ebook.booklet.reader.sdk.content.Book;
import com.amazon.ebook.booklet.reader.sdk.content.BookMetadata;
import com.amazon.ebook.booklet.reader.sdk.content.Element;
import com.amazon.ebook.booklet.reader.sdk.content.ElementActionHandler;
import com.amazon.ebook.booklet.reader.sdk.content.Position;
import com.amazon.ebook.booklet.reader.sdk.content.ScreenInfo;
import com.amazon.ebook.booklet.reader.sdk.content.TableOfContents;
import com.amazon.ebook.booklet.reader.sdk.content.TableOfContentsEntry;
import com.amazon.ebook.booklet.reader.sdk.content.Viewport;
import com.amazon.ebook.booklet.reader.sdk.content.ZoomViewport;
import com.amazon.ebook.booklet.reader.sdk.event.CloseBookHandler;
import com.amazon.ebook.booklet.reader.sdk.event.EventHandler;
import com.amazon.ebook.booklet.reader.sdk.event.PositionNotificationHandler;
import com.amazon.ebook.booklet.reader.sdk.internal.BookController;
import com.amazon.ebook.booklet.reader.sdk.internal.BookPreRenderer;
import com.amazon.ebook.booklet.reader.sdk.internal.BookView;
import com.amazon.ebook.booklet.reader.sdk.internal.FramingViewer;
import com.amazon.ebook.booklet.reader.sdk.ui.ReaderUI;
import com.amazon.ebook.booklet.reader.sdk.ui.ReaderUIContext;
import com.amazon.ebook.booklet.reader.sdk.util.State;
import com.amazon.ebook.booklet.reader.utils.ElementClickMap;
import com.amazon.ebook.booklet.reader.utils.FrameworkUtil;
import com.amazon.ebook.booklet.reader.utils.LayeredClickMap;
import com.amazon.ebook.util.log.Log;
import com.amazon.ebook.util.log.PerformanceLog;
import com.amazon.kindle.agui.util.NativeWindowSurface;
import com.amazon.kindle.booklet.BookletContext;
import com.amazon.kindle.booklet.ChromeHeaderBar;
import com.sun.me.gci.surface.GCIDrawingSurface;
import edu.emory.mathcs.backport.java.util.concurrent.ExecutorService;
import edu.emory.mathcs.backport.java.util.concurrent.Executors;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;

public class ContentPanel
extends ReaderUIContext
implements CloseBookHandler {
    private ReaderSDKImpl readerSDK;
    private GestureDispatcher gestureSupport;
    private ScreenInfo lastScreenInfo = null;
    private Viewport lastViewport = null;
    private volatile ScreenInfo nextScreenInfo;
    private ScreenInfo readyScreenInfo;
    private SelectionDialogImpl selectionDialog;
    private FontResizeDialog fontResizeDialog;
    private ImageDialog imageDialog;
    private MouseListener[] savedMouseListeners;
    private TableDialog tableDialog;
    char tablePanDirection = (char)120;
    private MousePanZoomTracker mpzt;
    private KeyboardInputModalDialog keyboardInputDialog;
    Rectangle holdClip = null;
    private List clickables;
    private ElementClickMap clickablesMap;
    private static Rectangle bookmarkTapArea;
    private final ExecutorService exec = Executors.newSingleThreadExecutor();
    private static final int FINGER_OFFSET = -10;
    private static final int FUZZ_FACTOR = 10;
    private CoalescingRunnableHolder preRenderRunnable;
    private static final Log LOG;
    private Book book;
    private boolean paintPending;
    private boolean scheduleNormalDraw;
    private boolean schedulePZDraw;
    private ElementClickMap cachedClickMap;
    private Element[] cachedElements;
    private LayeredClickMap cachedLayeredClickMap;
    private int doubleTapCounter;
    private Element zoomToElement;
    private boolean gotoAction;
    private int gotoNavigationMethod;
    private boolean previousPageAction;
    private Viewport previousPageActionViewportOfLastPage;
    private boolean nextPageAction;
    private Viewport nextPageActionViewportOfLastPage;
    private Point start;
    private Point end;

    public ContentPanel(ReaderSDKImpl a) {
        super((ReaderSDK)a);
        ContentPanel a2;
        a2.preRenderRunnable = a2.new CoalescingRunnableHolder(new Runnable(){
            {
                1 a;
            }

            public void run() {
                1 a;
                PerformanceLog.logStart((String)"preRenderRunnable");
                BookView a2 = a.ContentPanel.this.readerSDK.getBookController().getBookView();
                a.ContentPanel.this.nextScreenInfo = ((BookPreRenderer)a2).getNextScreenInfo();
                a.ContentPanel.this.readerSDK.getEventManager().postPreRenderEvent(a.ContentPanel.this.nextScreenInfo, true);
                PerformanceLog.logEnd((String)"preRenderRunnable");
            }
        });
        a2.book = null;
        a2.paintPending = false;
        a2.scheduleNormalDraw = false;
        a2.schedulePZDraw = false;
        a2.cachedClickMap = null;
        a2.cachedElements = null;
        a2.cachedLayeredClickMap = null;
        a2.doubleTapCounter = 0;
        a2.zoomToElement = null;
        a2.gotoAction = false;
        a2.previousPageAction = false;
        a2.previousPageActionViewportOfLastPage = null;
        a2.nextPageAction = false;
        a2.nextPageActionViewportOfLastPage = null;
        a2.start = null;
        a2.end = null;
        a2.readerSDK = a;
        a2.setFocusable(true);
        a2.requestFocusInWindow();
        a2.lastScreenInfo = null;
        a2.gestureSupport = new GestureDispatcher();
        a2.addMouseListener((MouseListener)a2.gestureSupport);
        a2.fontResizeDialog = new FontResizeDialog(a, a2);
        a2.addMouseListener(a2.fontResizeDialog);
        a2.resetActionMap();
        a2.mpzt = a2.new MousePanZoomTracker();
        a2.addMouseListener(a2.mpzt);
        a2.addMouseMotionListener(a2.mpzt);
        a2.selectionDialog = new SelectionDialogImpl(a);
        a2.keyboardInputDialog = new KeyboardInputModalDialog(null);
        a.getRegistry().registerHandler((EventHandler)a2);
    }

    public void reset() {
        ContentPanel a;
        a.mpzt.reset();
        a.lastScreenInfo = null;
    }

    public void cleanup() {
        ContentPanel a;
        a.tableDialog = null;
        a.imageDialog = null;
        a.restoreMouseListeners();
        BookletContext a2 = (BookletContext)a.readerSDK.getActiveContext();
        if (a2 != null) {
            a2.setDrawMode(BookletContext.DrawMode.DRAW_MODE_NORMAL);
        }
    }

    private Rectangle getInnerViewBounds() {
        ContentPanel a;
        Rectangle a2 = (Rectangle)a.getBounds().clone();
        ReaderUI a3 = a.readerSDK.getUI();
        a2.width -= a3.getContentLeftMargin() + a3.getContentRightMargin();
        a2.height -= a3.getContentTopMargin() + a3.getContentBottomMargin();
        a2.x += a3.getContentLeftMargin();
        a2.y += a3.getContentTopMargin();
        return a2;
    }

    private WinData getWinData() {
        ContentPanel a;
        BookletContext a2 = (BookletContext)a.readerSDK.getActiveContext();
        NativeWindowSurface a3 = a2.getNativeWindowSurface();
        a3.renderingBegin();
        Rectangle a4 = a2.getUIContainer().getBounds();
        return a.new WinData(a3.getPixelData(), a4.width, a4.height, a3.getFormat(), GCIDrawingSurface.getBitsPerPixel((int)a3.getFormat()));
    }

    private int getNativeSurface() {
        ContentPanel a;
        NativeWindowSurface a2 = ((BookletContext)a.readerSDK.getActiveContext()).getNativeWindowSurface();
        a2.renderingBegin();
        long a3 = a2.getSurfaceNativePeer();
        if (a3 > 0xFFFFFFFFL || a3 < Integer.MIN_VALUE) {
            throw new IllegalArgumentException("Can't downcast native surface ID to int");
        }
        return (int)a3;
    }

    private void renderingEnd(Graphics2D a) {
        ContentPanel a2;
        BookletContext a3 = (BookletContext)a2.readerSDK.getActiveContext();
        NativeWindowSurface a4 = a3.getNativeWindowSurface();
        Rectangle a5 = a3.getUIContainer().getBounds();
        a4.renderingEnd(a, 0, 0, a5.width, a5.height);
    }

    public void updateBookView() {
        ContentPanel a;
        a.viewChanged();
        if (a.readerSDK.getBookController().getCapabilities().isContentMarginChangeable()) {
            a.readerSDK.getBookController().getBookView().setBounds(a.getInnerViewBounds());
            Rectangle a2 = (Rectangle)ResourceBundle.getBundle("com.amazon.ebook.booklet.reader.impl.ui.resources.UIResourcesDNT").getObject("annotation.decoration.bookmark.tapAreaSize");
            bookmarkTapArea = new Rectangle(a.getBounds().width - a2.width, 0, a2.width, a2.height);
        } else {
            State a3 = a.readerSDK.getReaderStateManager().getCurrentState();
            ReaderStateData a4 = (ReaderStateData)a3.get("reader.state.preferences");
            if (a4 == null) {
                LOG.error("Unable to read margins from reader state, so not updating book view!");
                return;
            }
            Rectangle a5 = (Rectangle)a.getBounds().clone();
            Rectangle a6 = a4.getDefaultMargin();
            a5.x += a6.x;
            a5.y += a6.y;
            a5.width -= a6.width + a6.x;
            a5.height -= a6.height + a6.y;
            a.readerSDK.getBookController().getBookView().setBounds(a5);
        }
    }

    public void setBounds(int a, int a2, int a3, int a4) {
        ContentPanel a5;
        super.setBounds(a, a2, a3, a4);
        if (a5.readerSDK.getBookController() != null) {
            a5.updateBookView();
        }
    }

    private void doPreRender(BookView a, BookController a2) {
        ContentPanel a3;
        Runnable a4;
        if (a instanceof BookPreRenderer && a2.getBookNavigator().isNextPageAvailable() && (a4 = a3.preRenderRunnable.getRunnableIfAvailable()) != null) {
            a3.exec.execute(a4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void paintComponent(Graphics a) {
        ScreenInfo a2222;
        Viewport a3222;
        ContentPanel a4;
        Rectangle a5;
        block70: {
            ScreenInfo a2222;
            Viewport a3222;
            block69: {
                ScreenInfo a2222;
                Viewport a3222;
                block68: {
                    ((Graphics2D)a).setComposite(AlphaComposite.Src);
                    PerformanceLog.logEvent((String)"Invoke_paintComponent");
                    PerformanceLog.logStart((String)"ContentPanel_paintComponent");
                    a5 = a.getClipBounds();
                    a.setClip(a5 == null ? null : new Rectangle(a5.x, a5.y, Integer.MAX_VALUE, a5.height));
                    a4.viewChanged();
                    if (ErrorHandler.getDialogFlag()) {
                        ErrorHandler.setSkipDialogState((boolean)true);
                    }
                    ErrorHandler.setDialogFlag((boolean)false);
                    try {
                        int a6;
                        WinData a7;
                        BookController a8;
                        Graphics2D a9;
                        block72: {
                            block71: {
                                a9 = (Graphics2D)a;
                                a8 = a4.readerSDK.getBookController();
                                if (a8 == null) break block71;
                                if (a8.getCurrentBook() != null) break block72;
                            }
                            Object var14_5 = null;
                            break block68;
                        }
                        BookView a10 = a8.getBookView();
                        RegistryImpl a11 = (RegistryImpl)a4.readerSDK.getRegistry();
                        PerformanceLog.logEvent((String)"ContentPanel_getRegistry");
                        PerformanceLog.logStart((String)"ContentPanel_DrawPage");
                        if (a10 instanceof NativeBookView) {
                            a.setClip(null);
                            a7 = a4.getWinData();
                            try {
                                ((NativeBookView)a10).setNativeData(a7.A, a7.H, a7.b, a7.K, a7.B);
                                a10.drawPage(a9);
                                Object var9_20 = null;
                                a4.renderingEnd(a9);
                            }
                            catch (Throwable throwable) {
                                Object var9_21 = null;
                                a4.renderingEnd(a9);
                                throw throwable;
                            }
                        } else {
                            a10.drawPage(a9);
                        }
                        PerformanceLog.logEnd((String)"ContentPanel_DrawPage");
                        PerformanceLog.logEvent((String)"ContentPanel_pageDrawn");
                        PerformanceLog.logStart((String)"ContentPanel_DecoratePage");
                        if (!a4.mpzt.isPNZ() && !a4.readerSDK.getUI().isFlashSuppressed()) {
                            a4.readerSDK.getUI().doFlash(a10.doFlash());
                        }
                        a7 = a4.readerSDK.getBookNavigator();
                        if (a4.tableDialog != null) {
                            a4.drawTableBoundaries(a9);
                        }
                        if (a4.lastScreenInfo == null) {
                            ScreenInfo a12 = null;
                            if (a4.readyScreenInfo != null) {
                                a12 = a4.readyScreenInfo;
                                a4.readyScreenInfo = null;
                            } else if (a7.hasSelection()) {
                                a12 = a4.getLastViewedScreen();
                                a4.readerSDK.getEventManager().postPreRenderEvent(a12, false);
                            } else if (a11.getPageDecoratorCount() > 0) {
                                Viewport a13 = a4.getLastViewport();
                                int n = a6 = 0;
                                while (n < a11.getPageDecoratorCount()) {
                                    if (a11.getPageDecorator(a6).needsScreenInfo(a13)) {
                                        a12 = a4.getLastViewedScreen();
                                        a4.readerSDK.getEventManager().postPreRenderEvent(a4.getLastViewedScreen(), false);
                                        break;
                                    }
                                    n = ++a6;
                                }
                            }
                            if (a12 == null) {
                                a4.clickables = new ArrayList();
                                a4.clickablesMap = null;
                                int a14 = 0;
                                a6 = a11.getPageDecoratorCount();
                                int n = a14;
                                while (n < a6) {
                                    boolean a15 = a11.getPageDecorator(a14).drawsOutsideContents();
                                    if (!a15) {
                                        a4.clipToDisplayWithinScreen(a9);
                                    }
                                    List a16 = a11.getPageDecorator(a14).decoratePage(null, a9, a4.getBounds());
                                    if (!a15) {
                                        a4.reverseClipToDisplay(a9);
                                    }
                                    if (a16 != null) {
                                        a4.clickables.addAll(a16);
                                    }
                                    n = ++a14;
                                }
                                a4.doPreRender(a10, a8);
                                break block69;
                            }
                            a4.lastScreenInfo = a12;
                        }
                        a4.clickables = new ArrayList();
                        a4.clickablesMap = null;
                        int a17 = 0;
                        int a18 = a11.getPageDecoratorCount();
                        int n = a17;
                        while (n < a18) {
                            boolean bl = a11.getPageDecorator(a17).drawsOutsideContents();
                            a6 = bl ? 1 : 0;
                            if (!bl) {
                                a4.clipToDisplayWithinScreen(a9);
                            }
                            List a19 = a11.getPageDecorator(a17).decoratePage(a4.lastScreenInfo, a9, a4.getBounds());
                            if (a6 == 0) {
                                a4.reverseClipToDisplay(a9);
                            }
                            if (a19 != null) {
                                a4.clickables.addAll(a19);
                            }
                            n = ++a17;
                        }
                        a4.drawSelection(a9, a4.lastScreenInfo);
                        a4.doPreRender(a10, a8);
                        break block70;
                    }
                    catch (Throwable throwable) {
                        ScreenInfo a2222;
                        Viewport a3222;
                        Object var14_8 = null;
                        if (ErrorHandler.getSkipDialogState() && !ErrorHandler.getDialogFlag()) {
                            ErrorHandler.setSkipDialogState((boolean)false);
                        }
                        if (a4.nextPageAction) {
                            a4.nextPageAction = false;
                            if (a4.readerSDK.getEventManager().getNumNextPageListeners() > 0) {
                                a3222 = a4.nextPageActionViewportOfLastPage;
                                a2222 = a4.getLastViewedScreen();
                                a4.readerSDK.invokeLater(new Runnable(a2222, a3222){
                                    private final /* synthetic */ ScreenInfo K;
                                    private final /* synthetic */ Viewport B;
                                    {
                                        2 a;
                                        a.K = screenInfo;
                                        a.B = viewport;
                                    }

                                    public void run() {
                                        2 a;
                                        PerformanceLog.logStart((String)"postNextPageEvent");
                                        a.ContentPanel.this.readerSDK.getEventManager().postNextPageEvent(a.K, a.B);
                                        PerformanceLog.logEnd((String)"postNextPageEvent");
                                    }
                                });
                            }
                            a4.nextPageActionViewportOfLastPage = null;
                        }
                        if (a4.previousPageAction) {
                            a4.previousPageAction = false;
                            if (a4.readerSDK.getEventManager().getNumPreviousPageListeners() > 0) {
                                a3222 = a4.previousPageActionViewportOfLastPage;
                                a2222 = a4.getLastViewedScreen();
                                a4.readerSDK.invokeLater(new Runnable(a2222, a3222){
                                    private final /* synthetic */ ScreenInfo K;
                                    private final /* synthetic */ Viewport B;
                                    {
                                        3 a;
                                        a.K = screenInfo;
                                        a.B = viewport;
                                    }

                                    public void run() {
                                        3 a;
                                        PerformanceLog.logStart((String)"postPreviousPageEvent");
                                        a.ContentPanel.this.readerSDK.getEventManager().postPreviousPageEvent(a.K, a.B);
                                        PerformanceLog.logEnd((String)"postPreviousPageEvent");
                                    }
                                });
                            }
                            a4.previousPageActionViewportOfLastPage = null;
                        }
                        if (a4.gotoAction) {
                            a4.gotoAction = false;
                            a4.readerSDK.invokeLater(new Runnable(){
                                {
                                    4 a;
                                }

                                public void run() {
                                    4 a;
                                    PerformanceLog.logStart((String)"postGotoPositionEvent");
                                    a.ContentPanel.this.readerSDK.getEventManager().postGotoPositionEvent(a.ContentPanel.this.readerSDK.getBookNavigator().getCurrentPosition(), a.ContentPanel.this.gotoNavigationMethod);
                                    PerformanceLog.logEnd((String)"postGotoPositionEvent");
                                }
                            });
                        }
                        if ((a3222 = a4.readerSDK.getCurrentBook()) != a4.book) {
                            a4.book = a3222;
                            new Thread(new Runnable(){
                                {
                                    5 a;
                                }

                                public void run() {
                                    5 a;
                                    try {
                                        Thread.sleep(100L);
                                    }
                                    catch (InterruptedException interruptedException) {
                                        // empty catch block
                                    }
                                    a.ContentPanel.this.readerSDK.invokeLater(new Runnable(){
                                        {
                                            1 a;
                                        }

                                        public void run() {
                                            1 a;
                                            PerformanceLog.logStart((String)"postShownBookEvent");
                                            ContentPanel.this.readerSDK.getEventManager().postShownBookEvent(ContentPanel.this.book);
                                            PerformanceLog.logEnd((String)"postShownBookEvent");
                                        }
                                    });
                                }
                            }).start();
                        }
                        a4.paintPending = false;
                        a.setClip(a5);
                        PerformanceLog.logEnd((String)"ContentPanel_DecoratePage");
                        PerformanceLog.logEnd((String)"ContentPanel_paintComponent");
                        if (a4.scheduleNormalDraw) {
                            a2222 = (BookletContext)a4.readerSDK.getActiveContext();
                            a2222.setDrawMode(BookletContext.DrawMode.DRAW_MODE_NORMAL);
                        } else if (a4.schedulePZDraw) {
                            a2222 = (BookletContext)a4.readerSDK.getActiveContext();
                            a2222.setDrawMode(BookletContext.DrawMode.DRAW_MODE_PANZOOM);
                        }
                        a4.schedulePZDraw = false;
                        a4.scheduleNormalDraw = false;
                        PerformanceLog.logEvent((String)"ContentPanel_paintEnd");
                        throw throwable;
                    }
                }
                if (ErrorHandler.getSkipDialogState() && !ErrorHandler.getDialogFlag()) {
                    ErrorHandler.setSkipDialogState((boolean)false);
                }
                if (a4.nextPageAction) {
                    a4.nextPageAction = false;
                    if (a4.readerSDK.getEventManager().getNumNextPageListeners() > 0) {
                        a3222 = a4.nextPageActionViewportOfLastPage;
                        a2222 = a4.getLastViewedScreen();
                        a4.readerSDK.invokeLater(new /* invalid duplicate definition of identical inner class */);
                    }
                    a4.nextPageActionViewportOfLastPage = null;
                }
                if (a4.previousPageAction) {
                    a4.previousPageAction = false;
                    if (a4.readerSDK.getEventManager().getNumPreviousPageListeners() > 0) {
                        a3222 = a4.previousPageActionViewportOfLastPage;
                        a2222 = a4.getLastViewedScreen();
                        a4.readerSDK.invokeLater(new /* invalid duplicate definition of identical inner class */);
                    }
                    a4.previousPageActionViewportOfLastPage = null;
                }
                if (a4.gotoAction) {
                    a4.gotoAction = false;
                    a4.readerSDK.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
                if ((a3222 = a4.readerSDK.getCurrentBook()) != a4.book) {
                    a4.book = a3222;
                    new Thread(new /* invalid duplicate definition of identical inner class */).start();
                }
                a4.paintPending = false;
                a.setClip(a5);
                PerformanceLog.logEnd((String)"ContentPanel_DecoratePage");
                PerformanceLog.logEnd((String)"ContentPanel_paintComponent");
                if (a4.scheduleNormalDraw) {
                    a2222 = (BookletContext)a4.readerSDK.getActiveContext();
                    a2222.setDrawMode(BookletContext.DrawMode.DRAW_MODE_NORMAL);
                } else if (a4.schedulePZDraw) {
                    a2222 = (BookletContext)a4.readerSDK.getActiveContext();
                    a2222.setDrawMode(BookletContext.DrawMode.DRAW_MODE_PANZOOM);
                }
                a4.schedulePZDraw = false;
                a4.scheduleNormalDraw = false;
                PerformanceLog.logEvent((String)"ContentPanel_paintEnd");
                return;
            }
            Object var14_6 = null;
            if (ErrorHandler.getSkipDialogState() && !ErrorHandler.getDialogFlag()) {
                ErrorHandler.setSkipDialogState((boolean)false);
            }
            if (a4.nextPageAction) {
                a4.nextPageAction = false;
                if (a4.readerSDK.getEventManager().getNumNextPageListeners() > 0) {
                    a3222 = a4.nextPageActionViewportOfLastPage;
                    a2222 = a4.getLastViewedScreen();
                    a4.readerSDK.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
                a4.nextPageActionViewportOfLastPage = null;
            }
            if (a4.previousPageAction) {
                a4.previousPageAction = false;
                if (a4.readerSDK.getEventManager().getNumPreviousPageListeners() > 0) {
                    a3222 = a4.previousPageActionViewportOfLastPage;
                    a2222 = a4.getLastViewedScreen();
                    a4.readerSDK.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
                a4.previousPageActionViewportOfLastPage = null;
            }
            if (a4.gotoAction) {
                a4.gotoAction = false;
                a4.readerSDK.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
            if ((a3222 = a4.readerSDK.getCurrentBook()) != a4.book) {
                a4.book = a3222;
                new Thread(new /* invalid duplicate definition of identical inner class */).start();
            }
            a4.paintPending = false;
            a.setClip(a5);
            PerformanceLog.logEnd((String)"ContentPanel_DecoratePage");
            PerformanceLog.logEnd((String)"ContentPanel_paintComponent");
            if (a4.scheduleNormalDraw) {
                a2222 = (BookletContext)a4.readerSDK.getActiveContext();
                a2222.setDrawMode(BookletContext.DrawMode.DRAW_MODE_NORMAL);
            } else if (a4.schedulePZDraw) {
                a2222 = (BookletContext)a4.readerSDK.getActiveContext();
                a2222.setDrawMode(BookletContext.DrawMode.DRAW_MODE_PANZOOM);
            }
            a4.schedulePZDraw = false;
            a4.scheduleNormalDraw = false;
            PerformanceLog.logEvent((String)"ContentPanel_paintEnd");
            return;
        }
        Object var14_7 = null;
        if (ErrorHandler.getSkipDialogState() && !ErrorHandler.getDialogFlag()) {
            ErrorHandler.setSkipDialogState((boolean)false);
        }
        if (a4.nextPageAction) {
            a4.nextPageAction = false;
            if (a4.readerSDK.getEventManager().getNumNextPageListeners() > 0) {
                a3222 = a4.nextPageActionViewportOfLastPage;
                a2222 = a4.getLastViewedScreen();
                a4.readerSDK.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
            a4.nextPageActionViewportOfLastPage = null;
        }
        if (a4.previousPageAction) {
            a4.previousPageAction = false;
            if (a4.readerSDK.getEventManager().getNumPreviousPageListeners() > 0) {
                a3222 = a4.previousPageActionViewportOfLastPage;
                a2222 = a4.getLastViewedScreen();
                a4.readerSDK.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
            a4.previousPageActionViewportOfLastPage = null;
        }
        if (a4.gotoAction) {
            a4.gotoAction = false;
            a4.readerSDK.invokeLater(new /* invalid duplicate definition of identical inner class */);
        }
        if ((a3222 = a4.readerSDK.getCurrentBook()) != a4.book) {
            a4.book = a3222;
            new Thread(new /* invalid duplicate definition of identical inner class */).start();
        }
        a4.paintPending = false;
        a.setClip(a5);
        PerformanceLog.logEnd((String)"ContentPanel_DecoratePage");
        PerformanceLog.logEnd((String)"ContentPanel_paintComponent");
        if (a4.scheduleNormalDraw) {
            a2222 = (BookletContext)a4.readerSDK.getActiveContext();
            a2222.setDrawMode(BookletContext.DrawMode.DRAW_MODE_NORMAL);
        } else if (a4.schedulePZDraw) {
            a2222 = (BookletContext)a4.readerSDK.getActiveContext();
            a2222.setDrawMode(BookletContext.DrawMode.DRAW_MODE_PANZOOM);
        }
        a4.schedulePZDraw = false;
        a4.scheduleNormalDraw = false;
        PerformanceLog.logEvent((String)"ContentPanel_paintEnd");
    }

    private void drawSelection(Graphics2D a, ScreenInfo a2) {
        Position a3;
        ContentPanel a4;
        PerformanceLog.logStart((String)"ContentPanel_DrawSelection");
        BookNavigator a5 = a4.readerSDK.getBookNavigator();
        Position a6 = a5.getSelectionStart() != null ? a5.getSelectionStart().getStartPosition() : null;
        Position position = a3 = a5.getSelectionEnd() != null ? a5.getSelectionEnd().getEndPosition() : null;
        if (a6 == null || a3 == null) {
            return;
        }
        int a7 = a2.findFirstElementIndexInRange(a6, a3);
        if (a7 < 0) {
            return;
        }
        a4.clipToDisplayWithinScreen(a);
        a.setXORMode(Color.white);
        a.setColor(Color.black);
        Element[] a8 = a2.getElements();
        if (a8[a7] != a5.getSelectionStart()) {
            LOG.warning("element retrieved from findFirstElementIndexInRange does not match nav.getSelectionStart()");
        }
        Rectangle a9 = null;
        int a10 = -1;
        int a11 = 0;
        int a12 = 0;
        if (a2.getViewport() instanceof ZoomViewport) {
            a11 = ((ZoomViewport)a2.getViewport()).getXOffset();
            a12 = ((ZoomViewport)a2.getViewport()).getYOffset();
        }
        int n = a7;
        Element[] elementArray = a8;
        while (n < elementArray.length && a8[a7].getEndPosition().compareTo((Object)a3) <= 0) {
            if (a8[a7].isSelectable()) {
                int a13 = 0;
                int a14 = a8[a7].getBoundsCount();
                int n2 = a13;
                while (n2 < a14) {
                    if (a4.isImageZoomable(a8[a7])) {
                        a4.drawSelectionImageBoundaries(a, a8[a7]);
                    } else {
                        Rectangle a15 = a8[a7].getBounds(a13);
                        a15.x -= a11;
                        a15.y -= a12;
                        if (a9 == null) {
                            a9 = a15;
                        } else if (a10 != a8[a7].getBoundsRunID(a13)) {
                            if (a11 != 0) {
                                a9 = a9.intersection(a4.readerSDK.getBookController().getBookView().getBounds());
                            }
                            a.fillRect(a9.x, a9.y, a9.width, a9.height);
                            a9 = a15;
                        } else {
                            a9.add(a15);
                        }
                        a10 = a8[a7].getBoundsRunID(a13);
                    }
                    n2 = ++a13;
                }
            }
            n = ++a7;
            elementArray = a8;
        }
        if (a9 != null) {
            if (a11 != 0) {
                a9 = a9.intersection(a4.readerSDK.getBookController().getBookView().getBounds());
            }
            a.fillRect(a9.x, a9.y, a9.width, a9.height);
        }
        a.setPaintMode();
        a4.reverseClipToDisplay(a);
        PerformanceLog.logEnd((String)"ContentPanel_DrawSelection");
    }

    private void drawSelectionImageBoundaries(Graphics2D a, Element a2) {
        PerformanceLog.logStart((String)"ContentPanel_DrawSelectionImageBoundaries");
        int a3 = 3;
        int a4 = 4;
        Rectangle a5 = a2.getBounds(0);
        a.setPaintMode();
        Rectangle a6 = a.getClipBounds();
        a.setClip(null);
        a.fillRect(a5.x - 3 - 4, a5.y - 4, 3, a5.height + 12);
        a.fillRect(a5.x + a5.width + 4, a5.y - 4, 3, a5.height + 12);
        a.fillRect(a5.x - 3 - 4, a5.y - 3 - 2, a5.width + 12 - 1, 3);
        a.fillRect(a5.x - 3 - 4, a5.y + a5.height + 6 - 1, a5.width + 12 - 1, 3);
        a.setClip(a6);
        a.setXORMode(Color.white);
        a.setColor(Color.black);
        PerformanceLog.logEnd((String)"ContentPanel_DrawSelectionImageBoundaries");
    }

    private boolean isImageZoomable(Element a) {
        return a.supportsAction(4) && a.getBoundsCount() > 0;
    }

    private void drawTableBoundaries(Graphics2D a) {
        ContentPanel a2;
        if (a2.tableDialog == null) {
            return;
        }
        int a3 = 3;
        int a4 = a2.readerSDK.getUI().getContentLeftMargin();
        int a5 = a2.readerSDK.getUI().getContentRightMargin();
        int a6 = a2.readerSDK.getUI().getContentTopMargin();
        a2.tableDialog.recomputeTableRect(a2.tablePanDirection);
        Rectangle a7 = a2.tableDialog.getTableRect();
        Rectangle a8 = a2.getBounds();
        int a9 = a7.width;
        if (a7.width >= a8.width) {
            a9 = a8.width - a4;
        }
        Color a10 = a.getColor();
        a.setColor(Color.BLACK);
        if (a2.tableDialog.isLeftMost()) {
            if (a7.x < 0 || a7.width >= a8.width) {
                a.fillRect(a4 - 3 - 1, a7.y + a6, 3, a7.height);
            } else {
                a.fillRect(a7.x + a4 - 3 - 1, a7.y + a6, 3, a7.height);
            }
        }
        if (a2.tableDialog.isRightMost()) {
            if (a7.x < 0 || a7.width >= a8.width) {
                a.fillRect(a9, a7.y + a6, 3, a7.height);
            } else {
                a.fillRect(1 + a7.x + a4 + a7.width, a7.y + a6, 3, a7.height);
            }
        }
        int a11 = a4;
        if (!a2.tableDialog.isLeftMost()) {
            a11 = 0;
        }
        int a12 = a5;
        if (!a2.tableDialog.isRightMost()) {
            a12 = 0;
        }
        if (a2.tableDialog.isTop()) {
            if (a7.x < 0) {
                a.fillRect(a11, a7.y + a6 - 3 - 1, a8.width - a12, 3);
            } else {
                a.fillRect(a7.x + a11, a7.y + a6 - 3 - 1, a11 == 0 ? a7.width + a4 : a7.width, 3);
            }
        }
        if (a2.tableDialog.isBottom()) {
            if (a7.x < 0) {
                a.fillRect(a11, a7.y + a6 + a7.height + 3 - 1, a8.width - a12, 3);
            } else {
                a.fillRect(a7.x + a11, a7.y + a6 + a7.height + 3 - 1, a11 == 0 ? a7.width + a4 : a7.width, 3);
            }
        }
        a2.tablePanDirection = (char)120;
        a.setColor(a10);
    }

    public TableDialog getTableDialog() {
        ContentPanel a;
        return a.tableDialog;
    }

    public void dismissTableDialog() {
        ContentPanel a;
        a.hideAllDialogs();
        a.tableDialog = null;
    }

    private synchronized LayeredClickMap getClickMap() {
        ContentPanel a;
        ScreenInfo a2 = a.getLastViewedScreen();
        boolean a3 = false;
        if ((a.cachedElements == null || a.cachedClickMap == null) && a2 != null) {
            a.cachedElements = a2.getElements();
            a.cachedClickMap = new ElementClickMap(a.cachedElements, 10);
            a3 = true;
        }
        if (a.clickablesMap == null && a.clickables != null && a.clickables.size() > 0) {
            Element[] a4 = a.clickables.toArray(new Element[a.clickables.size()]);
            a.clickablesMap = new ElementClickMap(a4, 10);
            a3 = true;
        }
        if (a.cachedLayeredClickMap == null || a3) {
            a.cachedLayeredClickMap = a.clickablesMap != null ? new LayeredClickMap(a.clickablesMap, a.cachedClickMap) : new LayeredClickMap(a.cachedClickMap);
        }
        return a.cachedLayeredClickMap;
    }

    private Element[] getAllElementsAtPoint(int a, int a2) {
        ContentPanel a3;
        if (a3.cachedLayeredClickMap == null) {
            Element a4;
            int a5;
            ArrayList<Element> a6 = new ArrayList<Element>();
            if (a3.clickables != null) {
                int a7 = a3.clickables.size();
                int n = a5 = 0;
                while (n < a7) {
                    a4 = (Element)a3.clickables.get(a5);
                    if (ElementClickMap.contains((Element)a4, (int)a, (int)a2, (int)10)) {
                        a6.add(a4);
                    }
                    n = ++a5;
                }
            }
            Element[] a8 = a3.getLastViewedScreen().getElements();
            int n = a5 = 0;
            while (n < a8.length) {
                a4 = a8[a5];
                if (ElementClickMap.contains((Element)a4, (int)a, (int)a2, (int)10)) {
                    a6.add(a4);
                }
                n = ++a5;
            }
            return a6.toArray(new Element[a6.size()]);
        }
        return a3.cachedLayeredClickMap.getAll(a, a2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkFirstTap(int a, int a2) {
        int a3;
        block12: {
            block13: {
                boolean bl;
                Element[] a4;
                LayeredClickMap a5;
                ContentPanel a6;
                block11: {
                    PerformanceLog.logStart((String)"checkFirstTap");
                    a2 -= 10;
                    ZoomViewport a7 = null;
                    Viewport a8 = a6.getLastViewport();
                    if (a8 instanceof ZoomViewport) {
                        a7 = (ZoomViewport)a8;
                        a5 = a6.getClickMap();
                        a4 = a5.getAll(a += a7.getXOffset(), a2 += a7.getYOffset());
                    } else {
                        a4 = a6.getAllElementsAtPoint(a, a2);
                    }
                    if (a4 != null && a4.length != 0) break block11;
                    boolean a9 = false;
                    Object var10_8 = null;
                    PerformanceLog.logEnd((String)"checkFirstTap");
                    return a9;
                }
                try {
                    a5 = null;
                    int n = a3 = 0;
                    while (n < a4.length) {
                        if (a6.isImageZoomable(a4[a3])) {
                            a5 = null;
                            break;
                        }
                        if (a4[a3].supportsAction(1)) {
                            a5 = a4[a3];
                        }
                        n = ++a3;
                    }
                    if (a5 == null || (a = a5.getActionHandler(1)) == null) break block12;
                    if (!a.doAction(1, (Element)a5, (ReaderSDK)a6.readerSDK)) break block13;
                    if (a6.tableDialog != null && a6.tableDialog.isTablePanningActive()) {
                        a6.tableDialog.terminateTablePanning();
                    }
                    bl = true;
                    Object var10_9 = null;
                }
                catch (Throwable throwable) {
                    Object var10_12 = null;
                    PerformanceLog.logEnd((String)"checkFirstTap");
                    throw throwable;
                }
                PerformanceLog.logEnd((String)"checkFirstTap");
                return bl;
            }
            boolean bl = false;
            Object var10_10 = null;
            PerformanceLog.logEnd((String)"checkFirstTap");
            return bl;
        }
        a3 = 0;
        Object var10_11 = null;
        PerformanceLog.logEnd((String)"checkFirstTap");
        return a3 != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkDoubleTap(int a, int a2) {
        boolean a32;
        block11: {
            boolean bl;
            block10: {
                boolean bl2;
                block9: {
                    PerformanceLog.logStart((String)"checkDoubleTap");
                    try {
                        ContentPanel a4;
                        if (!a4.readerSDK.getBookController().getCapabilities().isPanZoomable()) {
                            bl2 = false;
                            Object var10_5 = null;
                            break block9;
                        }
                        boolean a5 = a4.readerSDK.getUI().getPanAndZoomMode();
                        if (!a5) {
                            int a6;
                            LayeredClickMap a7;
                            Element[] a8;
                            ZoomViewport a9 = null;
                            Viewport viewport = a4.getLastViewport();
                            if (viewport instanceof ZoomViewport) {
                                a9 = (ZoomViewport)viewport;
                                a += a9.getXOffset();
                                a2 += a9.getYOffset();
                            }
                            if ((a8 = (a7 = a4.getClickMap()).getAll(a, a2 -= 10)) == null || a8.length == 0) {
                                bl = false;
                                break block10;
                            }
                            int n = a6 = 0;
                            while (n < a8.length) {
                                if (a8[a6].supportsAction(2)) {
                                    a4.zoomToElement = a8[a6];
                                    a5 = true;
                                    break;
                                }
                                n = ++a6;
                            }
                        }
                        if (a5) {
                            final int a32 = a4.doubleTapCounter;
                            final int a10 = a;
                            final int a11 = a2;
                            Timer timer = new Timer();
                            timer.schedule(new TimerTask(){
                                {
                                    6 a;
                                }

                                public void run() {
                                    6 a;
                                    a.ContentPanel.this.readerSDK.invokeLater(new Runnable(){
                                        {
                                            1 a;
                                        }

                                        public void run() {
                                            1 a;
                                            PerformanceLog.logStart((String)"waitForDoubleTap");
                                            if (a32 == ContentPanel.this.doubleTapCounter) {
                                                ContentPanel.this.doTap(a10, a11, true);
                                            }
                                            PerformanceLog.logEnd((String)"waitForDoubleTap");
                                        }
                                    });
                                }
                            }, 250L);
                        }
                        a32 = a5;
                        break block11;
                    }
                    catch (Throwable throwable) {
                        Object var10_8 = null;
                        PerformanceLog.logEnd((String)"checkDoubleTap");
                        throw throwable;
                    }
                }
                PerformanceLog.logEnd((String)"checkDoubleTap");
                return bl2;
            }
            Object var10_6 = null;
            PerformanceLog.logEnd((String)"checkDoubleTap");
            return bl;
        }
        Object var10_7 = null;
        PerformanceLog.logEnd((String)"checkDoubleTap");
        return a32;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hideAllDialogs() {
        boolean bl;
        PerformanceLog.logStart((String)"hideAllDialogs");
        try {
            Book a;
            ContentPanel a2;
            boolean a3 = false;
            if (a2.fontResizeDialog != null && a2.fontResizeDialog.isShowing()) {
                a2.fontResizeDialog.getCloseAction().actionPerformed(null);
                a3 = true;
            }
            if (a2.selectionDialog.isShowing()) {
                a2.selectionDialog.getCloseAction().actionPerformed(null);
                a3 = true;
            }
            if (a2.imageDialog != null && a2.imageDialog.isShowing()) {
                a2.imageDialog.getCloseAction().actionPerformed(null);
                a3 = true;
            }
            if (a2.tableDialog != null && a2.tableDialog.isShowing()) {
                a2.tableDialog.getCloseAction().actionPerformed(null);
                a2.tableDialog = null;
                a2.readerSDK.getUI().getReaderPane().repaint();
                a3 = true;
            }
            if (a2.keyboardInputDialog != null && a2.keyboardInputDialog.isShowing()) {
                a2.keyboardInputDialog.dismiss();
                a3 = true;
            }
            if ((a = a2.readerSDK.getCurrentBook()) != null && a.getSearchWithinBookHandler() != null && a.getSearchWithinBookHandler().dismissUI()) {
                a3 = true;
            }
            bl = a3;
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            PerformanceLog.logEnd((String)"hideAllDialogs");
            throw throwable;
        }
        PerformanceLog.logEnd((String)"hideAllDialogs");
        return bl;
    }

    public boolean isDialogShowing() {
        ContentPanel a;
        boolean a2 = a.imageDialog != null && a.imageDialog.isShowing() || a.tableDialog != null && (a.tableDialog.isShowing() || a.tableDialog.isTablePanningActive()) || a.keyboardInputDialog != null && a.keyboardInputDialog.isShowing() || a.fontResizeDialog != null && a.fontResizeDialog.isShowing() || a.selectionDialog != null && a.selectionDialog.isShowing();
        return a2;
    }

    public void handleGotoAction(int a) {
        ContentPanel a2;
        a2.viewChanged();
        Viewport a3 = a2.getLastViewport();
        a2.readerSDK.getEventManager().postNavigationEvent(a3, PositionNotificationHandler.UserNavigationEvent.D);
        a2.setFullScreen();
        a2.gotoAction = true;
        a2.gotoNavigationMethod = a;
    }

    public void handlePanZoomAction() {
        ContentPanel a;
        a.readerSDK.getUI().getReaderPane().repaint();
    }

    private boolean setFullScreen() {
        ContentPanel a;
        BookletContext a2 = (BookletContext)a.readerSDK.getActiveContext();
        boolean a3 = false;
        if (a2 != null) {
            ReaderUIContext a4;
            ReaderUI a5;
            ChromeHeaderBar a6 = (ChromeHeaderBar)a2.getService(ChromeHeaderBar.class);
            if (!a.readerSDK.getUI().isSpinning() && a6 != null && a6.getStyle(a2) == ChromeHeaderBar.Style.TITLE_ONLY) {
                a6.setStyle(a2, ChromeHeaderBar.Style.NO_HEADER);
                a3 = true;
            }
            if ((a5 = a.readerSDK.getUI()) != null && (a4 = a5.getUIContext()) != null) {
                a4.setBookMargins();
            }
        } else {
            LOG.warning("No active context in setFullScreen");
        }
        return a3;
    }

    public void doPrevPageAction() {
        ContentPanel a;
        PerformanceLog.logStart((String)"doPrevPageAction");
        if (a.hideAllDialogs()) {
            PerformanceLog.logEnd((String)"doPrevPageAction");
            return;
        }
        a.readerSDK.getUI().setFlashSuppressed(false);
        PerformanceLog.logEvent((String)"PreviousPage");
        if (!a.readerSDK.getUI().getColumnMode()) {
            a.clearZoom();
        }
        a.previousPageActionViewportOfLastPage = a.getLastViewport();
        BookNavigator a2 = a.readerSDK.getBookNavigator();
        PerformanceLog.logStart((String)"Navigator_PrevPage");
        a2.previousPage((ReaderSDK)a.readerSDK);
        a.viewChanged();
        PerformanceLog.logEnd((String)"Navigator_PrevPage");
        a.readerSDK.getEventManager().postNavigationEvent(a2.getViewport(), PositionNotificationHandler.UserNavigationEvent.B);
        if (!a.setFullScreen()) {
            a.readerSDK.getUI().getReaderPane().repaint();
        }
        a.previousPageAction = true;
        a.nextPageAction = false;
        PerformanceLog.logEnd((String)"doPrevPageAction");
    }

    public void clearZoom() {
        ContentPanel a;
        if (a.mpzt != null) {
            a.mpzt.reset();
        } else {
            a.clearSDKZoom();
        }
    }

    private void clearSDKZoom() {
        ContentPanel a;
        if (a.readerSDK != null) {
            BookNavigator a2;
            ReaderUI a3 = a.readerSDK.getUI();
            boolean a4 = false;
            if (a3 != null) {
                a4 = a3.getPanAndZoomMode();
                a3.setPanAndZoomMode(false);
                a3.setColumnMode(false);
            }
            if ((a2 = a.readerSDK.getBookNavigator()) != null) {
                a2.zoomPage(1.0, 0, 0);
            }
            if (a4) {
                a.viewChanged();
            }
        }
    }

    public void doNextPageAction() {
        ContentPanel a;
        PerformanceLog.logStart((String)"doNextPageAction");
        if (a.hideAllDialogs()) {
            PerformanceLog.logEnd((String)"doNextPageAction");
            return;
        }
        a.readerSDK.getUI().setFlashSuppressed(false);
        PerformanceLog.logEvent((String)"NextPage");
        if (!a.readerSDK.getUI().getColumnMode()) {
            a.clearZoom();
        }
        if (!a.preRenderRunnable.isAvailable()) {
            try {
                a.exec.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
            }
            catch (InterruptedException a2) {
                // empty catch block
            }
        }
        a.readyScreenInfo = a.nextScreenInfo;
        PerformanceLog.logStart((String)"getViewport");
        a.nextPageActionViewportOfLastPage = a.getLastViewport();
        PerformanceLog.logEnd((String)"getViewport");
        BookNavigator a3 = a.readerSDK.getBookNavigator();
        Position a4 = a3.getViewport().getStartPosition();
        PerformanceLog.logStart((String)"Navigator_NextPage");
        a3.nextPage((ReaderSDK)a.readerSDK);
        a.viewChanged();
        PerformanceLog.logEnd((String)"Navigator_NextPage");
        Viewport a5 = a3.getViewport();
        boolean a6 = !a4.equals((Object)a5.getStartPosition());
        a.readerSDK.getEventManager().postNavigationEvent(a5, PositionNotificationHandler.UserNavigationEvent.K);
        if (!a6) {
            a.readerSDK.getEventManager().postNextPageFailed();
        }
        if (!a.setFullScreen()) {
            a.readerSDK.getUI().getReaderPane().repaint();
        }
        a.nextPageAction = true;
        a.previousPageAction = false;
        PerformanceLog.logEnd((String)"doNextPageAction");
    }

    private void doTablePanHorizontalAction(int a) {
        ContentPanel a2;
        BookNavigator a3 = a2.readerSDK.getBookNavigator();
        if (a3.moveTableHorizontally(a)) {
            a2.readerSDK.getEventManager().postNavigationEvent(a3.getViewport(), PositionNotificationHandler.UserNavigationEvent.D);
            a2.readerSDK.getUI().getReaderPane().repaint();
        }
    }

    public boolean isTablePanningActive() {
        ContentPanel a;
        return a.tableDialog != null && a.tableDialog.isTablePanningActive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doTap(int a, int a2, boolean a3) {
        block13: {
            block16: {
                block15: {
                    block14: {
                        block12: {
                            block11: {
                                PerformanceLog.logStart((String)"doTap");
                                try {
                                    ContentPanel a4;
                                    block18: {
                                        block17: {
                                            if (a4.hideAllDialogs() || a4.checkFirstTap(a, a2)) break block17;
                                            if (a4.tableDialog == null || !a4.tableDialog.isTablePanningActive()) break block18;
                                        }
                                        Object var9_4 = null;
                                        break block11;
                                    }
                                    if (FrameworkUtil.setChromeVisible((ReaderSDK)a4.readerSDK, (boolean)false)) {
                                        break block12;
                                    }
                                    PerformanceLog.logEvent((String)"Tap");
                                    a4.zoomToElement = null;
                                    if (!a3 && a4.checkDoubleTap(a, a2)) break block13;
                                    BookMetadata a5 = a4.book.getMetadata();
                                    if (bookmarkTapArea != null && bookmarkTapArea.contains(a, a2)) {
                                        if (a5 != null && a5.isAnnotationEnabled() && a5.isBookmarksEnabled()) {
                                            AnnotationViewProvider.getInstance().getBookmarkAction().actionPerformed(null);
                                            a4.repaint();
                                            break block14;
                                        }
                                        if (a5 != null && a5.isSample()) {
                                            ResourceBundle a6 = ResourceBundle.getBundle("com.amazon.ebook.booklet.reader.impl.ui.resources.UIResources");
                                            String a7 = a6.getString("annotation.disabled.bookmark.reason.samplebook");
                                            String a8 = a6.getString("annotation.disabled.bookmark.alert.title");
                                            ConfirmationDialog.showDialog((String)((BookletContext)a4.readerSDK.getActiveContext()).getName(), (String)a7, (String)a8, (int)4);
                                            a4.readerSDK.getBookNavigator().clearSelection();
                                            a4.repaint();
                                            break block15;
                                        }
                                    }
                                    if ((float)a2 < 0.2f * (float)a4.readerSDK.getUI().getReaderPane().getHeight() && FrameworkUtil.setChromeVisible((ReaderSDK)a4.readerSDK, (boolean)true)) {
                                        a4.readerSDK.getUI().setFlashSuppressed(false);
                                        break block16;
                                    }
                                    if (!a4.readerSDK.getUI().getColumnMode() && a4.isZoomed()) break block13;
                                    if ((float)a < 0.15f * (float)a4.readerSDK.getUI().getReaderPane().getWidth()) {
                                        a4.doPrevPageAction();
                                        break block13;
                                    } else {
                                        a4.doNextPageAction();
                                    }
                                    break block13;
                                }
                                catch (Throwable throwable) {
                                    Object var9_10 = null;
                                    PerformanceLog.logEnd((String)"doTap");
                                    throw throwable;
                                }
                            }
                            PerformanceLog.logEnd((String)"doTap");
                            return;
                        }
                        Object var9_5 = null;
                        PerformanceLog.logEnd((String)"doTap");
                        return;
                    }
                    Object var9_6 = null;
                    PerformanceLog.logEnd((String)"doTap");
                    return;
                }
                Object var9_7 = null;
                PerformanceLog.logEnd((String)"doTap");
                return;
            }
            Object var9_8 = null;
            PerformanceLog.logEnd((String)"doTap");
            return;
        }
        Object var9_9 = null;
        PerformanceLog.logEnd((String)"doTap");
    }

    public synchronized ScreenInfo getLastViewedScreen() {
        ContentPanel a;
        if (a.lastScreenInfo == null) {
            ScreenInfo a2;
            a.lastScreenInfo = a2 = a.readerSDK.getBookController().getBookView().getScreenInfo();
            return a2;
        }
        return a.lastScreenInfo;
    }

    public synchronized Viewport getLastViewport() {
        ContentPanel a;
        if (a.lastViewport == null) {
            Viewport a2;
            a.lastViewport = a2 = a.readerSDK.getBookNavigator().getViewport();
        }
        return a.lastViewport;
    }

    public SelectionDialogImpl getSelectionDialog() {
        ContentPanel a;
        return a.selectionDialog;
    }

    public KeyboardInputModalDialog getKeyboardInputDialog() {
        ContentPanel a;
        return a.keyboardInputDialog;
    }

    private boolean isZoomed() {
        ContentPanel a;
        return a.readerSDK != null && a.readerSDK.getUI() != null && a.readerSDK.getUI().getPanAndZoomMode();
    }

    private boolean isRightEdge() {
        ContentPanel a;
        BookView a2 = a.readerSDK.getBookController().getBookView();
        return !a.isZoomed() || a2 instanceof FramingViewer && ((FramingViewer)a2).getHorizontalScreenEnd() >= 1.0f;
    }

    private boolean isLeftEdge() {
        ContentPanel a;
        BookView a2 = a.readerSDK.getBookController().getBookView();
        return !a.isZoomed() || a2 instanceof FramingViewer && ((FramingViewer)a2).getHorizontalScreenStart() <= 0.0f;
    }

    private static final int dist2(int a, int a2, int a3, int a4) {
        int a5 = a - a3;
        int a6 = a2 - a4;
        return a5 * a5 + a6 * a6;
    }

    public MouseListener[] getSavedMouseListeners() {
        ContentPanel a;
        return a.savedMouseListeners;
    }

    public void setSavedMouseListeners(MouseListener[] a) {
        if (a == null) {
            return;
        }
        a.savedMouseListeners = a;
    }

    public void recordMouseListeners() {
        ContentPanel a;
        a.savedMouseListeners = a.getMouseListeners();
    }

    public void restoreMouseListeners() {
        ContentPanel a;
        a.replaceMouseListeners(a.savedMouseListeners);
    }

    public void replaceMouseListeners(MouseListener[] a) {
        int a2;
        ContentPanel a3;
        if (a == null) {
            return;
        }
        MouseListener[] a4 = a3.getMouseListeners();
        int n = a2 = 0;
        while (n < a4.length) {
            if (Log.isDebugOn()) {
                LOG.debug("REMOVED MouseListener = " + a4[a2].getClass().getName());
            }
            a3.removeMouseListener(a4[a2]);
            n = ++a2;
        }
        int n2 = a2 = 0;
        while (n2 < a.length) {
            if (Log.isDebugOn()) {
                LOG.debug("ADDED MouseListener = " + a.getClass().getName());
            }
            a3.addMouseListener(a[a2]);
            n2 = ++a2;
        }
    }

    private void clipToDisplayWithinScreen(Graphics2D a) {
        ContentPanel a2;
        a2.holdClip = a.getClipBounds();
        Rectangle a3 = a2.readerSDK.getBookController().getBookView().getBounds();
        if (a3 != null) {
            a.setClip(a3);
        }
    }

    private void reverseClipToDisplay(Graphics2D a) {
        ContentPanel a2;
        a.setClip(a2.holdClip);
    }

    public int availableMenuTypes() {
        return 31;
    }

    public boolean isFullScreen() {
        ContentPanel a;
        return a.readerSDK.getCurrentBook().getMetadata().getContentType() != 4;
    }

    public boolean hasFirstOpenHeader() {
        return true;
    }

    public boolean isChromePersistent() {
        ContentPanel a;
        return a.readerSDK.getCurrentBook().getMetadata().getContentType() == 4;
    }

    public boolean showFooter() {
        return true;
    }

    public void viewChanged() {
        a.lastScreenInfo = null;
        a.lastViewport = null;
        a.cachedElements = null;
        a.cachedClickMap = null;
        a.cachedLayeredClickMap = null;
        a.nextScreenInfo = null;
    }

    public void setPageFooter() {
        ContentPanel a;
        if (!a.readerSDK.getUI().isFooterSet()) {
            super.setPageFooter();
        }
    }

    private TableOfContentsEntry getAdjacentItem(TableOfContentsEntry a, boolean a2) throws TOCException {
        TableOfContentsEntry a3;
        ContentPanel a4;
        TableOfContents a5 = a4.readerSDK.getCurrentBook().getTOC();
        TableOfContentsEntry tableOfContentsEntry = a3 = a2 ? a5.getNextEntry(a) : a5.getPreviousEntry(a);
        if (a3 == null) {
            int a6;
            TableOfContentsEntry a7 = null;
            TableOfContentsEntry a8 = a;
            int a9 = 0;
            do {
                if ((a8 = a5.getParent(a8)) == null) {
                    return null;
                }
                a7 = a2 ? a5.getNextEntry(a8) : a5.getPreviousEntry(a8);
                ++a9;
            } while (a7 == null);
            TableOfContentsEntry a10 = a7;
            int n = a6 = 0;
            int n2 = a9;
            while (n < n2 && a10 != null) {
                a3 = a10;
                a10 = a2 ? a5.getChild(a10) : a5.getLastChild(a10);
                n = ++a6;
                n2 = a9;
            }
            if (a10 != null) {
                a3 = a10;
            }
        }
        return a3;
    }

    public void resetActionMap() {
        ContentPanel a;
        ActionMap a2 = a.getActionMap();
        a2.put("east", a.new PreviousPageAction());
        a2.put("west", a.new NextPageAction());
        a2.put("tap", a.new TapAction());
        a2.put("doubleTap", a.new DoubleTapAction());
        a2.put("hold", a.new SelectStartAction());
        a2.put("north", a.new NorthAction());
        a2.put("south", a.new SouthAction());
        a2.put("grow", a.fontResizeDialog.getIncreaseAction());
        a2.put("shrink", a.fontResizeDialog.getDecreaseAction());
    }

    public void closeBookEvent(Book a, boolean a2) {
        a.lastScreenInfo = null;
        a.lastViewport = null;
        a.nextScreenInfo = null;
        a.readyScreenInfo = null;
        a.book = null;
        a.clickables = null;
        a.cachedElements = null;
        a.cachedLayeredClickMap = null;
        a.cachedClickMap = null;
        a.previousPageActionViewportOfLastPage = null;
        a.nextPageActionViewportOfLastPage = null;
    }

    static {
        LOG = Log.getInstance((String)"ContentPanel");
    }

    private class SouthAction
    extends AbstractAction {
        private SouthAction() {
            SouthAction a;
        }

        public void actionPerformed(ActionEvent a) {
            SouthAction a2;
            Book a3 = a2.ContentPanel.this.readerSDK.getCurrentBook();
            if (a3 == null) {
                return;
            }
            a2.ContentPanel.this.readerSDK.getUI().setFlashSuppressed(false);
            TableOfContents a4 = a3.getTOC();
            if (!((ContentPanel)((Object)a2.ContentPanel.this.readerSDK.getUI().getBookContentPanel())).hideAllDialogs() && a4 != null && !a2.ContentPanel.this.isZoomed()) {
                TableOfContentsEntry a5 = a4.getCurrentTOCNodeEntry();
                try {
                    Position a6;
                    TableOfContentsEntry a7 = a2.ContentPanel.this.getAdjacentItem(a5, false);
                    Position a8 = a2.ContentPanel.this.readerSDK.getBookNavigator().getCurrentPosition();
                    if (a5 != null && a8 != null && a8.compareTo((Object)(a6 = a5.getPosition())) > 0) {
                        a7 = a5;
                    }
                    if (a7 != null) {
                        a2.ContentPanel.this.readerSDK.recordPageHistory();
                        a2.ContentPanel.this.readerSDK.getBookNavigator().goTo(a7);
                        a2.ContentPanel.this.readerSDK.getUI().generateUserGoToEvent();
                    }
                }
                catch (TOCException a9) {
                    LOG.error("Failed to jump to previous chapter.", (Throwable)a9);
                }
            }
        }
    }

    private class NorthAction
    extends AbstractAction {
        private NorthAction() {
            NorthAction a;
        }

        public void actionPerformed(ActionEvent a) {
            NorthAction a2;
            Book a3 = a2.ContentPanel.this.readerSDK.getCurrentBook();
            if (a3 == null) {
                return;
            }
            a2.ContentPanel.this.readerSDK.getUI().setFlashSuppressed(false);
            TableOfContents a4 = a3.getTOC();
            if (!((ContentPanel)((Object)a2.ContentPanel.this.readerSDK.getUI().getBookContentPanel())).hideAllDialogs() && a4 != null && !a2.ContentPanel.this.isZoomed()) {
                TableOfContentsEntry a5 = a4.getCurrentTOCNodeEntry();
                try {
                    a5 = a2.ContentPanel.this.getAdjacentItem(a5, true);
                    if (a5 != null) {
                        a2.ContentPanel.this.readerSDK.recordPageHistory();
                        a2.ContentPanel.this.readerSDK.getBookNavigator().goTo(a5);
                        a2.ContentPanel.this.readerSDK.getUI().generateUserGoToEvent();
                    }
                }
                catch (TOCException a6) {
                    LOG.error("Failed to jump to next chapter.", (Throwable)a6);
                }
            }
        }
    }

    private final class MousePanZoomTracker
    implements MouseMotionListener,
    MouseListener {
        private int O = -1;
        private int x = -1;
        private boolean f = false;
        private int M = -1;
        private int J = -1;
        private int G = -1;
        private int a = -1;
        private double i = -1.0;
        private int E = -1;
        private double C = 1.0;
        private double d = 1.0;
        private boolean j = false;
        private boolean g = false;
        private boolean e = false;
        private boolean I = false;
        private boolean F = false;
        private static final double L = 10.0;
        static final int c = 1;
        static final int l = 2;
        static final int k = 7;
        static final int m = 8;
        static final int h = 9;
        private static final int A = 40;
        private static final int H = 40;
        private static final int b = 400;
        private static final int K = 2500;
        private static final int B = 250;

        private MousePanZoomTracker() {
            MousePanZoomTracker a;
        }

        private void clamp(Point a, Rectangle a2) {
            if (a.x < a2.x) {
                a.x = a2.x;
            }
            if (a.y < a2.y) {
                a.y = a2.y;
            }
            if (a.x > a2.x + a2.width) {
                a.x = a2.x + a2.width;
            }
            if (a.y > a2.y + a2.height) {
                a.y = a2.y + a2.height;
            }
        }

        void doHandlePan(MouseEvent a) {
            MousePanZoomTracker a2;
            if (!a2.ContentPanel.this.isZoomed() || a2.ContentPanel.this.paintPending) {
                return;
            }
            if (a2.ContentPanel.this.end != null && a2.ContentPanel.this.start != null) {
                if (a2.ContentPanel.this.readerSDK.getUI().getColumnMode()) {
                    ((ContentPanel)a2.ContentPanel.this).end.x = ((ContentPanel)a2.ContentPanel.this).start.x;
                }
                if (((ContentPanel)a2.ContentPanel.this).end.y != ((ContentPanel)a2.ContentPanel.this).start.y || ((ContentPanel)a2.ContentPanel.this).end.x != ((ContentPanel)a2.ContentPanel.this).start.x) {
                    a2.setPNZ(true);
                    a2.ContentPanel.this.readerSDK.getBookNavigator().panPage(((ContentPanel)a2.ContentPanel.this).start.x - ((ContentPanel)a2.ContentPanel.this).end.x, ((ContentPanel)a2.ContentPanel.this).start.y - ((ContentPanel)a2.ContentPanel.this).end.y);
                    a2.ContentPanel.this.viewChanged();
                    a2.M = ((ContentPanel)a2.ContentPanel.this).end.x;
                    a2.J = ((ContentPanel)a2.ContentPanel.this).end.y;
                    a2.ContentPanel.this.repaint();
                    a2.ContentPanel.this.paintPending = true;
                    PerformanceLog.logEvent((String)"Pan_PaintEnd");
                }
            }
            a2.ContentPanel.this.start = a2.ContentPanel.this.end;
            a2.ContentPanel.this.end = a == null ? null : a.getPoint();
        }

        public void mouseClicked(MouseEvent a) {
        }

        public void mouseEntered(MouseEvent a) {
        }

        public void mouseExited(MouseEvent a) {
        }

        public boolean isPNZ() {
            MousePanZoomTracker a;
            return a.e;
        }

        private void setPNZ(boolean a) {
            MousePanZoomTracker a2;
            if (a2.e != a) {
                if (a) {
                    a2.ContentPanel.this.schedulePZDraw = true;
                } else {
                    a2.ContentPanel.this.scheduleNormalDraw = true;
                    if (!a2.ContentPanel.this.paintPending) {
                        a2.ContentPanel.this.repaint();
                    }
                }
            }
            a2.e = a;
        }

        public boolean startedLeft() {
            MousePanZoomTracker a;
            return a.F;
        }

        public boolean startedRight() {
            MousePanZoomTracker a;
            return a.I;
        }

        public void reset() {
            MousePanZoomTracker a;
            a.E = -1;
            a.a = -1;
            a.G = -1;
            a.J = -1;
            a.M = -1;
            a.x = -1;
            a.O = -1;
            a.i = -1.0;
            a.d = 1.0;
            a.C = 1.0;
            a.F = false;
            a.I = false;
            a.f = false;
            a.g = false;
            a.j = false;
            a.ContentPanel.this.start = (a.ContentPanel.this.end = null);
            a.setPNZ(false);
            a.ContentPanel.this.clearSDKZoom();
        }

        private void doZoom(int a, int a2, boolean a3) {
            double d;
            MousePanZoomTracker a4;
            a4.setPNZ(true);
            if (a4.ContentPanel.this.paintPending) {
                return;
            }
            if (a4.i + (double)a4.E < 0.0) {
                a4.i = -a4.E;
            }
            double a5 = ((double)a4.E + a4.i) / a4.i;
            double a6 = a4.C * a5;
            if (d < 1.0) {
                a6 = 1.0;
                a5 = 1.0 / a4.C;
            }
            if (a6 > 10.0) {
                a6 = 10.0;
                a5 = 10.0 / a4.C;
            }
            a4.d = a5;
            if (!a4.ContentPanel.this.isZoomed() && a6 == 1.0) {
                return;
            }
            a4.ContentPanel.this.viewChanged();
            if (a4.ContentPanel.this.readerSDK != null && a4.ContentPanel.this.readerSDK.getUI() != null) {
                a4.ContentPanel.this.readerSDK.getUI().setPanAndZoomMode(true);
            }
            a4.M = a;
            a4.J = a2;
            a4.ContentPanel.this.readerSDK.getBookNavigator().panPage(a4.G - a, a4.a - a2);
            a4.G = a;
            a4.a = a2;
            if (!a3) {
                a4.ContentPanel.this.readerSDK.getBookNavigator().zoomPage(a6, a4.G, a4.a);
                a4.ContentPanel.this.readerSDK.getUI().setColumnMode(false);
                if (a6 == 1.0 && a4.ContentPanel.this.readerSDK != null && a4.ContentPanel.this.readerSDK.getUI() != null) {
                    a4.ContentPanel.this.readerSDK.getUI().setPanAndZoomMode(false);
                }
            }
            a4.ContentPanel.this.repaint();
            a4.ContentPanel.this.paintPending = true;
            PerformanceLog.logEvent((String)"Zoom_PaintEnd");
        }

        /*
         * Enabled aggressive block sorting
         */
        public void mousePressed(MouseEvent a) {
            MousePanZoomTracker a2;
            if (!a2.ContentPanel.this.readerSDK.getBookController().getCapabilities().isPanZoomable()) return;
            if (a2.ContentPanel.this.isZoomed()) {
                a2.ContentPanel.this.hideAllDialogs();
            }
            int a3 = a.getX();
            int a4 = a.getY();
            switch (a.getButton()) {
                case 1: {
                    a2.O = a3;
                    a2.x = a4;
                    a2.f = false;
                    a2.ContentPanel.this.start = null;
                    a2.ContentPanel.this.end = a.getPoint();
                    a2.j = true;
                    a2.g = false;
                    a2.F = a2.ContentPanel.this.isLeftEdge();
                    a2.I = a2.ContentPanel.this.isRightEdge();
                    return;
                }
                case 2: {
                    a2.g = true;
                    a2.j = false;
                    if (a3 == a2.O && a4 == a2.x) {
                        a2.i = 250.0;
                        LOG.error("No initial tap received with two finger tap");
                    } else {
                        int a5 = (a2.ContentPanel.this.start == null ? a2.O : ((ContentPanel)a2.ContentPanel.this).start.x) - a3;
                        int a6 = (a2.ContentPanel.this.start == null ? a2.x : ((ContentPanel)a2.ContentPanel.this).start.y) - a4;
                        a2.i = 2.0 * Math.sqrt(a5 * a5 + a6 * a6);
                    }
                    a2.ContentPanel.this.start = null;
                    a2.ContentPanel.this.end = null;
                    a2.G = a3;
                    a2.a = a4;
                    a2.E = 0;
                    a2.C *= a2.d;
                    a2.d = 1.0;
                    return;
                }
                case 8: {
                    a2.g = true;
                    a2.j = false;
                    a2.ContentPanel.this.start = null;
                    a2.ContentPanel.this.end = null;
                    a2.E += 40;
                    a2.doZoom(a3, a4, false);
                    return;
                }
                case 7: {
                    a2.g = true;
                    a2.j = false;
                    a2.ContentPanel.this.start = null;
                    a2.ContentPanel.this.end = null;
                    a2.E -= 40;
                    a2.doZoom(a3, a4, false);
                    return;
                }
                case 9: {
                    if (a2.e) return;
                    a2.j = false;
                    a2.ContentPanel.this.start = null;
                    a2.ContentPanel.this.end = null;
                    return;
                }
            }
        }

        public void mouseReleased(MouseEvent a) {
            MousePanZoomTracker a2;
            int a3 = a.getX();
            int a4 = a.getY();
            int a5 = a.getButton();
            if (a5 == 1) {
                if (a2.j) {
                    if (a2.ContentPanel.this.start == null) {
                        a2.ContentPanel.this.start = a2.ContentPanel.this.end;
                    }
                    a2.ContentPanel.this.end = a.getPoint();
                    a2.ContentPanel.this.paintPending = false;
                    a2.doHandlePan(null);
                }
                a2.I = false;
                a2.F = false;
                a2.j = false;
                a2.g = false;
                a2.ContentPanel.this.start = (a2.ContentPanel.this.end = null);
                a2.E = 0;
                a2.setPNZ(false);
            } else if (a5 == 2) {
                if (a2.g) {
                    a2.ContentPanel.this.paintPending = false;
                    a2.doZoom(a3, a4, false);
                }
                a2.O = -1;
                a2.x = -1;
                a2.f = true;
                a2.ContentPanel.this.start = null;
                a2.ContentPanel.this.end = null;
                a2.j = true;
                a2.g = false;
                a2.F = a2.ContentPanel.this.isLeftEdge();
                a2.I = a2.ContentPanel.this.isRightEdge();
            }
        }

        public boolean checkRefresh(int a, int a2) {
            MousePanZoomTracker a3;
            if (a3.M == -1 && a3.J == -1) {
                return true;
            }
            int a4 = a - a3.M;
            a4 *= a4;
            int a5 = a2 - a3.J;
            return a4 + (a5 *= a5) >= 400;
        }

        public void mouseDragged(MouseEvent a) {
            MousePanZoomTracker a2;
            if (a2.O == -1 && a2.x == -1 && a != null) {
                a2.O = a.getX();
                a2.x = a.getY();
            }
            if (a2.ContentPanel.this.readerSDK.getBookController().getCapabilities().isPanZoomable()) {
                if (a == null) {
                    return;
                }
                int a3 = a.getX();
                int a4 = a.getY();
                if (a2.ContentPanel.this.selectionDialog.isShowing() || !a2.checkRefresh(a3, a4)) {
                    return;
                }
                if (a2.j) {
                    if (!a2.f && ContentPanel.dist2(a2.O, a2.x, a3, a4) < 2500) {
                        return;
                    }
                    a2.f = true;
                    if (a2.ContentPanel.this.readerSDK != null && a2.ContentPanel.this.readerSDK.getUI() != null && a2.ContentPanel.this.readerSDK.getUI().getPanAndZoomMode()) {
                        a2.doHandlePan(a);
                    }
                } else if (a2.g) {
                    a2.doZoom(a3, a4, true);
                }
            }
        }

        public void mouseMoved(MouseEvent a) {
        }
    }

    private final class MouseSelectionTracker
    implements MouseMotionListener,
    MouseListener,
    WindowListener {
        private MouseEvent K;
        private Element B;

        private MouseSelectionTracker() {
            MouseSelectionTracker a;
        }

        private void doHandleSelection(MouseEvent a) {
            int a2;
            int a3;
            MouseSelectionTracker a4;
            a4.K = a;
            Point a5 = a.getPoint();
            BookNavigator a6 = a4.ContentPanel.this.readerSDK.getBookNavigator();
            ScreenInfo a7 = a4.ContentPanel.this.getLastViewedScreen();
            Rectangle a8 = null;
            Position a9 = a6.getCurrentSelectionPosition();
            Element[] a10 = a7.getElements();
            LayeredClickMap a11 = a4.ContentPanel.this.getClickMap();
            int a12 = -1;
            boolean a13 = false;
            ZoomViewport a14 = null;
            int a15 = 0;
            int a16 = 0;
            if (a7.getViewport() instanceof ZoomViewport) {
                a14 = (ZoomViewport)a7.getViewport();
                a15 = a14.getXOffset();
                a16 = a14.getYOffset();
                a5.x += a15;
                a5.y += a16;
            }
            a5.y += -10;
            int[] a17 = a11.getAllIndices(a5.x, a5.y);
            if (a17 != null && a17.length != 0) {
                int n = a3 = 0;
                int[] nArray = a17;
                while (n < nArray.length) {
                    if (a10[a17[a3]].isSelectable()) {
                        a13 = true;
                        a12 = a17[a3];
                        a4.B = a10[a17[a3]];
                        if (!a6.selectUpdate(a4.B, a4.B)) break;
                        a8 = a4.B.getBounds(0);
                        int a18 = 1;
                        a2 = a4.B.getBoundsCount();
                        int n2 = a18;
                        while (n2 < a2) {
                            a8.add(a4.B.getBounds(a18));
                            n2 = ++a18;
                        }
                        break;
                    }
                    n = ++a3;
                    nArray = a17;
                }
            }
            if (!a13) {
                a17 = a11.getNearestIndices(a5.x, a5.y);
                Element a19 = null;
                Element a20 = null;
                if (a17[0] != -1) {
                    a19 = a10[a17[0]];
                }
                if (a17[1] != -1) {
                    a20 = a10[a17[1]];
                }
                if (a19 != null || a20 != null) {
                    if (a6.selectUpdate(a19, a20)) {
                        a4.B = a6.isSelectionReversed() ? a20 : a19;
                        a8 = a4.B.getBounds(0);
                        a2 = 1;
                        int a21 = a4.B.getBoundsCount();
                        int n = a2;
                        while (n < a21) {
                            a8.add(a4.B.getBounds(a2));
                            n = ++a2;
                        }
                    }
                } else {
                    LOG.error("getClickMap().getNearest(" + a5.x + ',' + a5.y + ") returned no elements!");
                }
            }
            if (a12 != -1) {
                if (a9 == null) {
                    return;
                }
                a3 = a12;
                if (a4.ContentPanel.this.isImageZoomable(a4.B)) {
                    a4.ContentPanel.this.readerSDK.getBookNavigator().addZoomableElement(a4.B);
                }
                if (a9.compareTo((Object)a6.getCurrentSelectionPosition()) < 0) {
                    --a3;
                    while (a3 >= 0 && a10[a3].getStartPosition().compareTo((Object)a9) >= 0) {
                        a8 = a4.addToRepaint(a10, a3, a8);
                        --a3;
                    }
                } else {
                    int n = ++a3;
                    Element[] elementArray = a10;
                    while (n < elementArray.length && a10[a3].getStartPosition().compareTo((Object)a9) <= 0) {
                        a8 = a4.addToRepaint(a10, a3, a8);
                        n = ++a3;
                        elementArray = a10;
                    }
                }
            }
            if (a8 != null) {
                a8.x -= a15;
                a8.y -= a16;
                a4.ContentPanel.this.repaint();
            }
        }

        private Rectangle addToRepaint(Element[] a, int a2, Rectangle a3) {
            if (a[a2].isSelectable()) {
                a3 = a[a2].getBounds(0);
                int a4 = 1;
                int a5 = a[a2].getBoundsCount();
                int n = a4;
                while (n < a5) {
                    MouseSelectionTracker a6;
                    a3.add(a[a2].getBounds(a4));
                    if (a6.ContentPanel.this.isImageZoomable(a[a2])) {
                        a6.ContentPanel.this.readerSDK.getBookNavigator().addZoomableElement(a[a2]);
                    }
                    n = ++a4;
                }
            }
            return a3;
        }

        public void mouseMoved(MouseEvent a) {
            MouseSelectionTracker a2;
            if (a2.ContentPanel.this.mpzt.isPNZ()) {
                return;
            }
            a2.doHandleSelection(a);
        }

        public void mouseReleased(MouseEvent a) {
            MouseSelectionTracker a2;
            try {
                if (a2.K == null) {
                    a2.mouseMoved(a);
                }
                a2.K = null;
                BookletContext a3 = (BookletContext)a2.ContentPanel.this.readerSDK.getActiveContext();
                a3.setDrawMode(BookletContext.DrawMode.DRAW_MODE_NORMAL);
                a2.ContentPanel.this.removeMouseListener(a2);
                a2.ContentPanel.this.removeMouseMotionListener(a2);
                a2.ContentPanel.this.removeMouseListener((MouseListener)a2.ContentPanel.this.gestureSupport);
                a2.ContentPanel.this.addMouseListener((MouseListener)a2.ContentPanel.this.gestureSupport);
                Point a4 = a.getPoint();
                int a5 = a2.ContentPanel.this.readerSDK.getUI().getContentLeftMargin();
                Rectangle a6 = new Rectangle();
                if (a2.ContentPanel.this.tableDialog == null && a4.x > a5 && a2.ContentPanel.this.readerSDK.getBookNavigator().isInsideTable(a4, a6)) {
                    a2.ContentPanel.this.tablePanDirection = (char)120;
                    a2.ContentPanel.this.tableDialog = new TableDialog(a2.ContentPanel.this.readerSDK, a6, a4, a2.ContentPanel.this);
                    a2.ContentPanel.this.tableDialog.postDialog();
                    a2.ContentPanel.this.repaint();
                } else {
                    Element a7 = a2.ContentPanel.this.readerSDK.getBookNavigator().getSelectionStart();
                    Element a8 = a2.ContentPanel.this.readerSDK.getBookNavigator().getSelectionEnd();
                    if (a7 != null && a8 != null && a7.compareTo((Object)a8) == 0 && a2.ContentPanel.this.isImageZoomable(a7)) {
                        a2.ContentPanel.this.imageDialog = new ImageDialog(a2.ContentPanel.this.readerSDK, a7, a2.ContentPanel.this);
                        a2.ContentPanel.this.imageDialog.postDialog();
                    }
                    if (a2.ContentPanel.this.selectionDialog.selectionUpdated(a2.ContentPanel.this.getLastViewedScreen())) {
                        PerformanceLog.logEvent((String)"Selection_PaintEnd");
                        a2.ContentPanel.this.selectionDialog.postDialog(a2.B, true, a2);
                        PerformanceLog.logEvent((String)"SelectionDialog_Posted");
                        a2.B = null;
                    }
                }
            }
            catch (Exception a9) {
                a2.ContentPanel.this.readerSDK.getBookNavigator().clearSelection();
                a2.ContentPanel.this.repaint();
                a2.ContentPanel.this.readerSDK.postException(new ReaderException(131072, (Throwable)a9));
            }
        }

        public void mouseDragged(MouseEvent a) {
            MouseSelectionTracker a2;
            a2.doHandleSelection(a);
        }

        public void mouseClicked(MouseEvent a) {
        }

        public void mousePressed(MouseEvent a) {
        }

        public void mouseEntered(MouseEvent a) {
        }

        public void mouseExited(MouseEvent a) {
        }

        public void windowActivated(WindowEvent a) {
        }

        public void windowClosed(WindowEvent a) {
            MouseSelectionTracker a2;
            BookNavigator a3 = a2.ContentPanel.this.readerSDK.getBookNavigator();
            if (a3 != null) {
                a3.clearSelection();
            }
            a2.ContentPanel.this.selectionDialog.removeTrackedWindowListener();
            a2.ContentPanel.this.repaint();
        }

        public void windowClosing(WindowEvent a) {
        }

        public void windowDeactivated(WindowEvent a) {
        }

        public void windowDeiconified(WindowEvent a) {
        }

        public void windowIconified(WindowEvent a) {
        }

        public void windowOpened(WindowEvent a) {
        }
    }

    private class SelectStartAction
    extends AbstractAction {
        private SelectStartAction() {
            SelectStartAction a;
        }

        public void actionPerformed(ActionEvent a) {
            SelectStartAction a2;
            LOG.info("Press and hold action start");
            PerformanceLog.logEvent((String)"PressAndHold");
            if (a2.ContentPanel.this.hideAllDialogs()) {
                return;
            }
            Point a3 = ((GestureEvent)a).getLocation();
            int a4 = a2.ContentPanel.this.readerSDK.getUI().getContentLeftMargin();
            Rectangle a5 = new Rectangle();
            if (a2.ContentPanel.this.mpzt.isPNZ() || a2.ContentPanel.this.tableDialog != null && a2.ContentPanel.this.tableDialog.isTablePanningActive() && a3.x > a4 && !a2.ContentPanel.this.readerSDK.getBookNavigator().isInsideTable(a3, a5)) {
                return;
            }
            BookNavigator a6 = a2.ContentPanel.this.readerSDK.getBookNavigator();
            a6.clearSelection();
            Rectangle a7 = null;
            boolean a8 = false;
            LayeredClickMap a9 = a2.ContentPanel.this.getClickMap();
            ZoomViewport a10 = null;
            int a11 = 0;
            int a12 = 0;
            Viewport a13 = a2.ContentPanel.this.getLastViewport();
            if (a13 instanceof ZoomViewport) {
                a10 = (ZoomViewport)a13;
                a11 = a10.getXOffset();
                a12 = a10.getYOffset();
                a3.x += a11;
                a3.y += a12;
            }
            a3.y += -10;
            Element[] a14 = a9.getAll(a3.x, a3.y);
            if (a14 != null && a14.length != 0) {
                int a15;
                int n = a15 = 0;
                while (n < a14.length) {
                    if (a14[a15].isSelectable()) {
                        if (a2.ContentPanel.this.isImageZoomable(a14[a15])) {
                            a2.ContentPanel.this.readerSDK.getBookNavigator().addZoomableElement(a14[a15]);
                        }
                        if (a14[a15].getStartPosition() == null || a14[a15].getEndPosition() == null) {
                            LOG.error("Unable to start selection on element: " + a14[a15]);
                        } else {
                            a2.ContentPanel.this.readerSDK.getBookNavigator().selectBegin(a14[a15], a14[a15]);
                            a8 = true;
                            a7 = a14[a15].getBounds(0);
                            int a16 = 1;
                            int a17 = a14[a15].getBoundsCount();
                            int n2 = a16;
                            while (n2 < a17) {
                                a7.add(a14[a15].getBounds(a16));
                                n2 = ++a16;
                            }
                        }
                    }
                    n = ++a15;
                }
            }
            if (!a8) {
                a14 = a9.getNearest(a3.x, a3.y);
                Element a18 = null;
                Element a19 = null;
                if (a14[0] != null) {
                    a18 = a14[0];
                }
                if (a14[1] != null) {
                    a19 = a14[1];
                }
                if (a18 != null || a19 != null) {
                    a2.ContentPanel.this.readerSDK.getBookNavigator().selectBegin(a18, a19);
                    a8 = true;
                } else {
                    LOG.error("getClickMap().getNearest(" + a3.x + ',' + a3.y + ") returned no elements!");
                }
            }
            if (a8) {
                a2.ContentPanel.this.removeMouseListener((MouseListener)a2.ContentPanel.this.gestureSupport);
                MouseSelectionTracker a20 = new MouseSelectionTracker();
                a2.ContentPanel.this.addMouseMotionListener(a20);
                a2.ContentPanel.this.addMouseListener(a20);
                BookletContext a21 = (BookletContext)a2.ContentPanel.this.readerSDK.getActiveContext();
                a21.setDrawMode(BookletContext.DrawMode.DRAW_MODE_HIGHLIGHT);
            }
            if (a7 != null) {
                a7.x -= a11;
                a7.y -= a12;
                a2.ContentPanel.this.repaint(a7);
            }
        }
    }

    private class TapAction
    extends AbstractAction {
        private TapAction() {
            TapAction a;
        }

        public void actionPerformed(ActionEvent a) {
            TapAction a2;
            LOG.info("Tap action start");
            Point a3 = ((GestureEvent)a).getLocation();
            a2.ContentPanel.this.doTap(a3.x, a3.y, false);
        }
    }

    private class DoubleTapAction
    extends AbstractAction {
        private DoubleTapAction() {
            DoubleTapAction a;
        }

        public void actionPerformed(ActionEvent a) {
            DoubleTapAction a2;
            LOG.info("Double tap action start");
            a2.ContentPanel.this.doubleTapCounter++;
            Point a3 = ((GestureEvent)a).getLocation();
            if (a2.ContentPanel.this.zoomToElement != null) {
                a2.ContentPanel.this.readerSDK.getBookNavigator().setLastTap(a3);
                ElementActionHandler a4 = a2.ContentPanel.this.zoomToElement.getActionHandler(2);
                if (a4 != null && a4.doAction(2, a2.ContentPanel.this.zoomToElement, (ReaderSDK)a2.ContentPanel.this.readerSDK)) {
                    a2.ContentPanel.this.readerSDK.getUI().setColumnMode(true);
                    a2.ContentPanel.this.viewChanged();
                }
                a2.ContentPanel.this.readerSDK.getBookNavigator().setLastTap(null);
            } else if (a2.ContentPanel.this.readerSDK.getUI().getPanAndZoomMode()) {
                a2.ContentPanel.this.clearZoom();
                a2.ContentPanel.this.repaint();
                PerformanceLog.logEvent((String)"Dismiss_Column_Zoom_PaintEnd");
            } else {
                a2.ContentPanel.this.doTap(a3.x, a3.y, true);
            }
        }
    }

    public class TablePanRightAction
    extends AbstractAction {
        public TablePanRightAction() {
            TablePanRightAction a;
        }

        public void actionPerformed(ActionEvent a) {
            TablePanRightAction a2;
            LOG.info("Pan right action start");
            if (a2.ContentPanel.this.tableDialog != null) {
                if (a2.ContentPanel.this.tableDialog.isRightMost() && !a2.ContentPanel.this.tableDialog.isBottom()) {
                    a2.ContentPanel.this.tablePanDirection = (char)110;
                    a2.ContentPanel.this.doNextPageAction();
                } else {
                    a2.ContentPanel.this.tablePanDirection = (char)119;
                    a2.ContentPanel.this.doTablePanHorizontalAction(0);
                }
            }
        }
    }

    public class TablePanLeftAction
    extends AbstractAction {
        public TablePanLeftAction() {
            TablePanLeftAction a;
        }

        public void actionPerformed(ActionEvent a) {
            TablePanLeftAction a2;
            LOG.info("Pan Left action start");
            if (a2.ContentPanel.this.tableDialog != null) {
                a2.ContentPanel.this.tablePanDirection = (char)101;
                a2.ContentPanel.this.doTablePanHorizontalAction(2);
            }
        }
    }

    private class NextPageAction
    extends AbstractAction {
        private NextPageAction() {
            NextPageAction a;
        }

        public void actionPerformed(ActionEvent a) {
            NextPageAction a2;
            LOG.info("Next Page action start");
            if (a2.ContentPanel.this.tableDialog != null && a2.ContentPanel.this.tableDialog.isTablePanningActive()) {
                a2.ContentPanel.this.tablePanDirection = (char)110;
            }
            if (!(!a2.ContentPanel.this.readerSDK.getUI().getColumnMode() && !a2.ContentPanel.this.isRightEdge() || a2.ContentPanel.this.tableDialog != null && a2.ContentPanel.this.tableDialog.isTablePanningActive() && a2.ContentPanel.this.tableDialog.isBottom())) {
                a2.ContentPanel.this.doNextPageAction();
            }
        }
    }

    private class PreviousPageAction
    extends AbstractAction {
        private PreviousPageAction() {
            PreviousPageAction a;
        }

        public void actionPerformed(ActionEvent a) {
            PreviousPageAction a2;
            LOG.info("Previous Page action start");
            if (a2.ContentPanel.this.tableDialog != null && a2.ContentPanel.this.tableDialog.isTablePanningActive()) {
                a2.ContentPanel.this.tablePanDirection = (char)115;
            }
            if (!(!a2.ContentPanel.this.readerSDK.getUI().getColumnMode() && !a2.ContentPanel.this.isLeftEdge() || a2.ContentPanel.this.tableDialog != null && a2.ContentPanel.this.tableDialog.isTablePanningActive() && a2.ContentPanel.this.tableDialog.isTop())) {
                a2.ContentPanel.this.doPrevPageAction();
            }
        }
    }

    private class WinData {
        public final long A;
        public final int H;
        public final int b;
        public final int K;
        public final int B;

        public WinData(long a, int a2, int a3, int a4, int a5) {
            WinData a6;
            a6.A = a;
            a6.H = a2;
            a6.b = a3;
            a6.K = a4;
            a6.B = a5;
        }
    }

    private class CoalescingRunnableHolder {
        private final AtomicBoolean b = new AtomicBoolean(true);
        private final Runnable K;
        private final Runnable B;

        public CoalescingRunnableHolder(Runnable a) {
            CoalescingRunnableHolder a2;
            a2.B = a;
            a2.K = new Runnable(){
                {
                    1 a;
                }

                public void run() {
                    1 a;
                    PerformanceLog.logStart((String)"CoalescingRunnableHolder");
                    a.CoalescingRunnableHolder.this.B.run();
                    a.CoalescingRunnableHolder.this.b.set(true);
                    PerformanceLog.logEnd((String)"CoalescingRunnableHolder");
                }
            };
        }

        public boolean isAvailable() {
            CoalescingRunnableHolder a;
            return a.b.get();
        }

        public Runnable getRunnableIfAvailable() {
            CoalescingRunnableHolder a;
            if (a.b.getAndSet(false)) {
                return a.K;
            }
            return null;
        }
    }
}

