/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.kindle.control.widget;

import com.amazon.agui.swing.PagingContainer;
import com.amazon.kindle.control.DCBooklet;
import com.amazon.kindle.control.util.PageUtils;
import com.amazon.kindle.control.widget.DCLandingPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class DCPagedLandingPanel
extends DCLandingPanel {
    private PagingContainer mPagedWidgetContainer;
    private List mWidgetList;
    private int mSeparatorStyle;

    public DCPagedLandingPanel(DCBooklet a, List a2) {
        super(a);
        DCPagedLandingPanel a3;
        if (a2 == null || a2.isEmpty()) {
            throw new IllegalArgumentException("Input widget list for DCPagedLandingPanel can't be null");
        }
        a3.mWidgetList = a2;
        a3.mBooklet = a;
        a3.mSeparatorStyle = 3;
    }

    public void setSeparatorStyle(int a) {
        if (a != 1 && a != 3 && a != 2 && a != 0) {
            throw new IllegalArgumentException("illegal separtor style");
        }
        a.mSeparatorStyle = a;
    }

    public void nextPage() {
        DCPagedLandingPanel a;
        a.mPagedWidgetContainer.nextVisiblePage();
        a.delta();
    }

    public void prevPage() {
        DCPagedLandingPanel a;
        a.mPagedWidgetContainer.previousVisiblePage();
        a.delta();
    }

    private void initWidgetComponents() {
        DCPagedLandingPanel a;
        Border a2 = (Border)ResourceBundle.getBundle("com.amazon.kindle.control.resources.WidgetResources").getObject("widget.border");
        a.mPagedWidgetContainer = new PagingContainer(1, a.mFillHorizontal, a.mNumberOfColumns, a.mNumberOfRows);
        a.mPagedWidgetContainer.setSeparatorStyle(a.mSeparatorStyle);
        Iterator a3 = a.mWidgetList.iterator();
        while (a3.hasNext()) {
            Object a4 = a3.next();
            if (!(a4 instanceof JComponent)) continue;
            ((JComponent)a4).setBorder(a2);
            a.mPagedWidgetContainer.addItem((Component)((JComponent)a4));
        }
    }

    public void initGUI() {
        DCPagedLandingPanel a;
        a.setLayout(new BorderLayout());
        boolean a2 = a.isDescriptionBarEnabled();
        boolean a3 = a.isHeaderBarEnabled();
        if (a2 || a3) {
            if (a2 && !a3) {
                a.initDescriptionWidget(a.mDescription);
                a.add((Component)a.mDescriptionWidget, "North");
            } else if (!a2 && a3) {
                a.initHeaderBar();
                a.add((Component)a.mHeaderBar, "North");
            } else {
                a.initDescriptionWidget(a.mDescription);
                a.initHeaderBar();
                JPanel a4 = new JPanel();
                a4.setLayout(new BorderLayout());
                a4.add((Component)a.mHeaderBar, "North");
                a4.add((Component)a.mDescriptionWidget, "South");
                a.add((Component)a4, "North");
            }
        }
        a.initWidgetComponents();
        a.add((Component)a.mPagedWidgetContainer, "Center");
        if (a.isFooterBarEnabled()) {
            a.initFooterBar();
            a.add((Component)a.mFooterBar, "South");
        }
    }

    public int getCurrentPageNumber() {
        DCPagedLandingPanel a;
        return Math.max(PageUtils.getCurrentPageNumber(0, a.mNumberOfColumns * a.mNumberOfRows), a.mPagedWidgetContainer.getCurrentPage() + 1);
    }

    public int getTotalPageNumber() {
        DCPagedLandingPanel a;
        return Math.max(PageUtils.getTotalPageNumber(a.mWidgetList.size(), a.mNumberOfColumns * a.mNumberOfRows), a.mPagedWidgetContainer.getPageCount());
    }

    public void removeAllItems() {
        DCPagedLandingPanel a;
        a.mPagedWidgetContainer.removeAllItems();
        super.removeAll();
    }
}

