/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.kindle.control.widget;

import com.amazon.agui.swing.list.CheckBoxListCellRenderer;
import com.amazon.agui.swing.list.PagedListScrollPane;
import com.amazon.agui.swing.list.RadioButtonListCellRenderer;
import com.amazon.kindle.control.DCBooklet;
import com.amazon.kindle.control.behavior.event.PageTurnEvent;
import com.amazon.kindle.control.util.PageUtils;
import com.amazon.kindle.control.widget.DCLandingPanel;
import com.amazon.kindle.control.widget.JListDataTransferObject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DCListLandingPanel
extends DCLandingPanel {
    private Object[] mObjectArray;
    private ListModel mModel;
    private JList mJList;
    private PagedListScrollPane mPagedListScrollPane;
    private boolean mIsSingleSelection;

    public DCListLandingPanel(DCBooklet a, Object[] a2, boolean a3) {
        super(a);
        DCListLandingPanel a4;
        if (a2 == null) {
            throw new IllegalArgumentException("Input data array for DCListLandingPanel can't be null");
        }
        a4.mObjectArray = a2;
        a4.mIsSingleSelection = a3;
    }

    public void initGUI() {
        DCListLandingPanel a;
        a.setLayout(new BorderLayout());
        boolean a2 = a.isDescriptionBarEnabled();
        boolean a3 = a.isHeaderBarEnabled();
        if (a2 || a3) {
            if (a2 && !a3) {
                a.initDescriptionWidget(a.mDescription);
                a.add((Component)a.mDescriptionWidget, "North");
            } else if (!a2 && a3) {
                a.initHeaderBar();
                a.add((Component)a.mHeaderBar, "North");
            } else {
                a.initDescriptionWidget(a.mDescription);
                a.initHeaderBar();
                JPanel a4 = new JPanel();
                a4.setLayout(new BorderLayout());
                a4.add((Component)a.mHeaderBar, "North");
                a4.add((Component)a.mDescriptionWidget, "South");
                a.add((Component)a4, "North");
            }
        }
        a.initListScrollPane();
        a.add((Component)a.mPagedListScrollPane, "Center");
        if (a.isFooterBarEnabled()) {
            a.initFooterBar();
            a.add((Component)a.mFooterBar, "South");
        }
    }

    private void initListScrollPane() {
        Object a;
        DCListLandingPanel a2;
        a2.mModel = new DefaultComboBoxModel<Object>(a2.mObjectArray);
        a2.mJList = new JList(a2.mModel);
        ResourceBundle a3 = ResourceBundle.getBundle("com.amazon.kindle.control.resources.WidgetResources");
        a2.mJList.setFixedCellHeight((Integer)a3.getObject("default.row.height"));
        a2.mJList.putClientProperty("separator.style", new Integer(2));
        if (a2.mIsSingleSelection) {
            int a4;
            a2.mJList.setSelectionMode(0);
            a = new RadioButtonListCellRenderer(a2.mJList, 10, 0);
            a.putClientProperty((Object)"columnWidth", (Object)new Integer(1));
            a.putClientProperty((Object)"maxColumns", (Object)((Integer)a3.getObject("default.row.width")));
            a2.mJList.setCellRenderer(a);
            int n = a4 = 0;
            while (n < a2.mObjectArray.length) {
                JListDataTransferObject a5 = (JListDataTransferObject)a2.mObjectArray[a4];
                if (a5.isPreSelected()) {
                    a2.mJList.setSelectedIndex(a4);
                    break;
                }
                n = ++a4;
            }
        } else {
            int a6;
            a2.mJList.setSelectionMode(2);
            a = new CheckBoxListCellRenderer(a2.mJList, 10, 0);
            a.putClientProperty((Object)"columnWidth", (Object)new Integer(1));
            a.putClientProperty((Object)"maxColumns", (Object)((Integer)a3.getObject("default.row.width")));
            a2.mJList.setCellRenderer(a);
            ArrayList<Integer> a7 = new ArrayList<Integer>();
            int n = a6 = 0;
            while (n < a2.mObjectArray.length) {
                if (((JListDataTransferObject)a2.mObjectArray[a6]).isPreSelected()) {
                    a7.add(new Integer(a6));
                }
                n = ++a6;
            }
            a2.mJList.setSelectedIndices(a2.toIntArray(a7));
        }
        a2.mPagedListScrollPane = new PagedListScrollPane((Component)a2.mJList);
        a2.mPagedListScrollPane.setBorder((Border)a3.getObject("scrollpane.border"));
        if (a2.isFooterBarEnabled()) {
            a = a2.mJList.getSelectionModel();
            a.addListSelectionListener(a2.new ListSelectionHandler());
        }
        if (a2.isUpdateChromeWhenPagingEnabled()) {
            a = a2.new DefaultMouseAdapter();
            a2.mJList.addMouseListener((MouseListener)a);
        }
    }

    private int[] toIntArray(List a) {
        Iterator a2;
        int[] a3 = new int[a.size()];
        int a4 = 0;
        Iterator iterator = a2 = a.iterator();
        while (iterator.hasNext()) {
            a3[a4] = (Integer)a2.next();
            ++a4;
            iterator = a2;
        }
        return a3;
    }

    public int getCurrentPageNumber() {
        DCListLandingPanel a;
        return PageUtils.getCurrentPageNumber(a.mJList.getFirstVisibleIndex(), a.mJList.getVisibleRowCount());
    }

    public int getTotalPageNumber() {
        DCListLandingPanel a;
        return PageUtils.getTotalPageNumber(a.mJList.getModel().getSize(), a.mJList.getVisibleRowCount());
    }

    public Object getSelectedValue() {
        DCListLandingPanel a;
        return a.mJList.getSelectedValue();
    }

    public Object[] getSelectedValues() {
        DCListLandingPanel a;
        return a.mJList.getSelectedValues();
    }

    public void setSelectedIndex(int a) {
        DCListLandingPanel a2;
        a2.mJList.setSelectedIndex(a);
    }

    public void setSelectedIndices(int[] a) {
        DCListLandingPanel a2;
        a2.mJList.setSelectedIndices(a);
    }

    public void nextPage() {
    }

    public void prevPage() {
    }

    private class DefaultMouseAdapter
    extends MouseAdapter {
        private DefaultMouseAdapter() {
            DefaultMouseAdapter a;
        }

        public void mouseReleased(MouseEvent a) {
            int a2 = ((JList)a.getSource()).locationToIndex(a.getPoint());
            if (a2 > 0) {
                DefaultMouseAdapter a3;
                PageTurnEvent.getInstance().fireEvent();
                a3.DCListLandingPanel.this.delta();
            }
        }
    }

    private class ListSelectionHandler
    implements ListSelectionListener {
        private ListSelectionHandler() {
            ListSelectionHandler a;
        }

        public void valueChanged(ListSelectionEvent a) {
            ListSelectionHandler a2;
            if (((ListSelectionModel)a.getSource()).isSelectionEmpty()) {
                a2.DCListLandingPanel.this.mOKAction.setEnabled(false);
            } else if (!a2.DCListLandingPanel.this.mOKAction.isEnabled()) {
                a2.DCListLandingPanel.this.mOKAction.setEnabled(true);
            }
        }
    }
}

