/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.kindle.control.widget;

import com.amazon.agui.swing.CommandBar;
import com.amazon.agui.swing.Description;
import com.amazon.agui.swing.HeaderBar;
import com.amazon.kindle.control.DCBooklet;
import com.amazon.kindle.control.util.BookletUtils;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.border.Border;

public abstract class DCLandingPanel
extends JPanel {
    private static final int DEFAULT_NUM_COLUMNS = 1;
    private static final int DEFAULT_NUM_ROWS = 0;
    protected HeaderBar mHeaderBar;
    protected String mDescription;
    protected Description mDescriptionWidget;
    protected CommandBar mFooterBar;
    protected Action mCancelAction;
    protected Action mOKAction;
    protected String mCancelActionLabel;
    protected String mOKActionLabel;
    protected DCBooklet mBooklet;
    protected boolean mIsHeaderBarEnabled;
    protected boolean mUpdateChromeWhenPaging;
    protected boolean mFillHorizontal;
    protected int mNumberOfRows;
    protected int mNumberOfColumns;

    public DCLandingPanel(DCBooklet a) {
        DCLandingPanel a2;
        if (a == null) {
            throw new IllegalArgumentException("input booket for DCLandingPanel can't be null");
        }
        a2.mHeaderBar = null;
        a2.mDescription = null;
        a2.mDescriptionWidget = null;
        a2.mFooterBar = null;
        a2.mCancelAction = null;
        a2.mOKAction = null;
        a2.mCancelActionLabel = null;
        a2.mOKActionLabel = null;
        a2.mBooklet = a;
        a2.mIsHeaderBarEnabled = false;
        a2.mUpdateChromeWhenPaging = false;
        a2.mFillHorizontal = true;
        a2.mNumberOfColumns = 1;
        a2.mNumberOfRows = 0;
    }

    public String getDescription() {
        DCLandingPanel a;
        return a.mDescription;
    }

    public Action getCancelAction() {
        DCLandingPanel a;
        return a.mCancelAction;
    }

    public Action getOKAction() {
        DCLandingPanel a;
        return a.mOKAction;
    }

    public String getCancelActionLabel() {
        DCLandingPanel a;
        return a.mCancelActionLabel;
    }

    public String getOKActionLabel() {
        DCLandingPanel a;
        return a.mOKActionLabel;
    }

    public void setHeaderBarText(int a, String a2) {
        DCLandingPanel a3;
        if (a3.isHeaderBarEnabled() && a3.mHeaderBar != null) {
            a3.mHeaderBar.setText(a, a2);
        }
    }

    public void setHeaderBarText(String a, String a2, String a3) {
        DCLandingPanel a4;
        if (a4.isHeaderBarEnabled() && a4.mHeaderBar != null) {
            a4.mHeaderBar.setText(a, a2, a3);
        }
    }

    public void setDescription(String a) {
        a.mDescription = a;
    }

    public void setCancelAction(Action a) {
        a.mCancelAction = a;
    }

    public void setOKAction(Action a) {
        a.mOKAction = a;
    }

    public void setCancelActionLabel(String a) {
        DCLandingPanel a2;
        if (a2.isFooterBarEnabled()) {
            a2.mCancelActionLabel = a;
        }
    }

    public void setOKActionLabel(String a) {
        DCLandingPanel a2;
        if (a2.isFooterBarEnabled()) {
            a2.mOKActionLabel = a;
        }
    }

    public void setLayoutParams(boolean a, int a2, int a3) {
        a.mFillHorizontal = a;
        a.mNumberOfRows = a3;
        a.mNumberOfColumns = a2;
    }

    public void setHeaderBarEnabled(boolean a) {
        a.mIsHeaderBarEnabled = a;
    }

    public boolean isHeaderBarEnabled() {
        DCLandingPanel a;
        return a.mIsHeaderBarEnabled;
    }

    public boolean isDescriptionBarEnabled() {
        DCLandingPanel a;
        return a.mDescription != null;
    }

    public boolean isFooterBarEnabled() {
        DCLandingPanel a;
        return a.mOKAction != null && a.mCancelAction != null;
    }

    public boolean isUpdateChromeWhenPagingEnabled() {
        DCLandingPanel a;
        return a.mUpdateChromeWhenPaging;
    }

    public void enableUpdateChromeWhenPaging(boolean a) {
        a.mUpdateChromeWhenPaging = a;
    }

    public abstract void initGUI();

    public void initHeaderBar() {
        a.mHeaderBar = new HeaderBar();
    }

    public void initDescriptionWidget(String a) {
        DCLandingPanel a2;
        a2.mDescriptionWidget = new Description(a);
        ResourceBundle a3 = ResourceBundle.getBundle("com.amazon.kindle.control.resources.WidgetResources");
        a2.mDescriptionWidget.setMaxRows(((Integer)a3.getObject("description.max.row")).intValue());
        a2.mDescriptionWidget.setBorder((Border)a3.getObject("description.border"));
    }

    public void initFooterBar() {
        DCLandingPanel a;
        ResourceBundle a2 = ResourceBundle.getBundle("com.amazon.kindle.control.resources.WidgetResources");
        a.mFooterBar = new CommandBar();
        a.mFooterBar.setButtonWidthPreserved(false);
        a.mFooterBar.setButtonPreferredSize(null);
        a.mCancelAction.putValue("Name", a.mCancelActionLabel == null ? a2.getString("footer.button.label.cancel") : a.mCancelActionLabel);
        a.mFooterBar.add(a.mCancelAction);
        a.mOKAction.putValue("Name", a.mOKActionLabel == null ? a2.getString("footer.button.label.ok") : a.mOKActionLabel);
        a.mFooterBar.add(a.mOKAction);
    }

    protected void delta() {
        DCLandingPanel a;
        if (a.isUpdateChromeWhenPagingEnabled()) {
            BookletUtils.updateChromeInAWT(a.mBooklet);
        }
    }

    public abstract int getCurrentPageNumber();

    public abstract int getTotalPageNumber();

    public abstract void nextPage();

    public abstract void prevPage();
}

