/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.kindle.control.util;

import com.amazon.agui.swing.PendingStateModel;
import com.amazon.ebook.util.text.StringUtil;
import com.amazon.kindle.apps.util.LogUtils;
import com.amazon.kindle.booklet.Booklet;
import com.amazon.kindle.booklet.BookletContext;
import com.amazon.kindle.content.catalog.CatalogItem;
import com.amazon.kindle.control.behavior.TransferClientData;
import com.amazon.kindle.restricted.net.transfer.Transfer;
import com.amazon.kindle.restricted.net.transfer.TransferService;
import com.amazon.kindle.restricted.net.transfer.TransferStatus;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;

public class TransferUtils {
    public TransferUtils() {
        TransferUtils a;
    }

    public static void populatePendingStateModel(PendingStateModel a, TransferStatus a2) {
        if (a == null || a2 == null) {
            return;
        }
        String a3 = TransferUtils.populatePendingStateMessage(a2);
        boolean a4 = TransferUtils.isPending(a2.getStatus());
        String a5 = a.getText();
        if (a5 == null || a3 != null && !a5.equals(a3)) {
            a.setProperties(a3, 0, a4);
        }
    }

    public static String populatePendingStateMessage(TransferStatus a) {
        if (a == null) {
            return null;
        }
        long a2 = a.getBytesTransferred();
        long a3 = a.getTotalLength();
        long a4 = 0L;
        if (a3 > 0L) {
            a4 = 100L * a2 / a3;
        }
        int a5 = a.getStatus();
        boolean a6 = TransferUtils.isPending(a5);
        String a7 = "";
        ResourceBundle a8 = ResourceBundle.getBundle("com.amazon.kindle.control.resources.UtilResources");
        if (a6) {
            a7 = a8.getString("download.status.pending");
        } else if (TransferUtils.isDeferred(a5)) {
            int a9 = a.getDeferralCode();
            a7 = TransferUtils.isWiFiRequired(a9) ? a8.getString("download.status.wifirequired") : (TransferUtils.isWirelessRequired(a9) || TransferUtils.isNetworkDown(a9) ? a8.getString("download.status.wirelessrequired") : (TransferUtils.isInsufficientSpace(a9) ? a8.getString("download.status.insufficientspace") : a8.getString("download.status.pending")));
        } else if (TransferUtils.isDownloading(a5)) {
            String a10 = a8.getString("download.status.downloading.template");
            a7 = MessageFormat.format(a10, new Double((double)a4 / 100.0));
        } else {
            a7 = TransferUtils.isDownloadComplete(a5) ? a8.getString("download.status.complete") : (TransferUtils.isFailed(a5) || TransferUtils.isCanceled(a5) ? a8.getString("download.status.failed") : a8.getString("download.status.default"));
        }
        return a7;
    }

    public static String getPending() {
        return ResourceBundle.getBundle("com.amazon.kindle.control.resources.UtilResources").getString("download.status.pending");
    }

    private static boolean isPending(int a) {
        return a == 1 || a == 2 || a == 3 || a == 4;
    }

    private static boolean isDownloading(int a) {
        return a == 5;
    }

    public static boolean isDownloadComplete(int a) {
        return a == 8;
    }

    public static boolean isFailed(int a) {
        return a == 9;
    }

    public static boolean isDeferred(int a) {
        return a == 6;
    }

    public static boolean isCanceled(int a) {
        return a == 1000;
    }

    public static boolean isWiFiRequired(int a) {
        return a == 5;
    }

    public static boolean isWirelessRequired(int a) {
        return a == 4;
    }

    public static boolean isNetworkDown(int a) {
        return a == 6;
    }

    public static boolean isInsufficientSpace(int a) {
        return a == 2 || a == 3;
    }

    public static List getUniqueKeysOfCurrentTransfers(Booklet a) {
        if (a == null) {
            LogUtils.logBookletIsNull();
            return null;
        }
        BookletContext a2 = a.getBookletContext();
        if (a2 == null) {
            LogUtils.logBookletContextIsNull();
            return null;
        }
        Map a3 = ((TransferService)a2.getService(TransferService.class)).getPendingTransfers();
        Collection a4 = a3.values();
        if (a4 != null && a4.size() > 0) {
            ArrayList<String> a5 = new ArrayList<String>();
            Iterator a6 = a4.iterator();
            while (a6.hasNext()) {
                TransferClientData a7;
                Object a8 = a6.next();
                if (a8 == null || (a7 = TransferClientData.getInstance(((Transfer)a8).getClientData())) == null) continue;
                a5.add(a7.getUniqueKey());
            }
            return a5;
        }
        return Collections.EMPTY_LIST;
    }

    public static String getItemUniqueKey(CatalogItem a) {
        if (a == null) {
            return null;
        }
        return TransferUtils.getUniqueKey(a.getCDEKey(), a.getCDEType());
    }

    public static String getUniqueKey(String a, String a2) {
        if (StringUtil.isEmpty((String)a) || StringUtil.isEmpty((String)a2)) {
            return null;
        }
        return a + "_" + a2;
    }
}

