/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.kindle.control.util;

import com.amazon.agui.swing.ConfirmationDialog;
import com.amazon.agui.swing.KDialog;
import com.amazon.ebook.util.log.Log;
import com.amazon.ebook.util.text.StringUtil;
import com.amazon.ebook.util.thread.ThreadPool;
import com.amazon.kindle.apps.util.CommunicationUtils;
import com.amazon.kindle.apps.util.LogUtils;
import com.amazon.kindle.apps.util.MetadataUtils;
import com.amazon.kindle.booklet.Booklet;
import com.amazon.kindle.booklet.BookletContext;
import com.amazon.kindle.content.catalog.CatalogEntry;
import com.amazon.kindle.content.catalog.CatalogItem;
import com.amazon.kindle.control.DCBooklet;
import com.amazon.kindle.control.DisplayController;
import com.amazon.kindle.control.behavior.TransferClientData;
import com.amazon.kindle.control.menu.MenuItemFactory;
import com.amazon.kindle.control.util.TransferUtils;
import com.amazon.kindle.net.Wireless;
import com.amazon.kindle.restricted.net.transfer.Transfer;
import com.amazon.kindle.restricted.net.transfer.TransferService;
import com.sun.java.swing.text.PlainDocument;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;

public class DialogUtils {
    private static final Log b = Log.getInstance((String)"DialogUtils");
    private static boolean K = false;
    static /* synthetic */ Class B;

    public DialogUtils() {
        DialogUtils a;
    }

    public static JButton getCancelButton(KDialog a) {
        ResourceBundle a2 = ResourceBundle.getBundle("com.amazon.kindle.control.resources.UtilResources");
        return DialogUtils.getDismissButton(a, a2.getString("cancel.button.label"));
    }

    public static JButton getDismissButton(KDialog a, String a2) {
        DismissAction a3 = new DismissAction(a);
        JButton a4 = new JButton(a3);
        a4.setText(a2);
        return a4;
    }

    public static JButton getActionButton(AbstractAction a, String a2) {
        a.putValue("Name", a2);
        return new JButton(a);
    }

    public static JButton getOKButton(AbstractAction a) {
        ResourceBundle a2 = ResourceBundle.getBundle("com.amazon.kindle.control.resources.UtilResources");
        return DialogUtils.getActionButton(a, a2.getString("ok.button.label"));
    }

    public static PlainDocument getLimitedCharacterDocument(int a) {
        return new LimitedCharacterDocument(a);
    }

    public static void showWiFiRequiredDialog(DCBooklet a, CatalogItem a2) {
        if (a == null) {
            LogUtils.logBookletIsNull();
            return;
        }
        final BookletContext a3 = a.getBookletContext();
        if (a3 == null) {
            LogUtils.logBookletContextIsNull();
            return;
        }
        ResourceBundle a4 = ResourceBundle.getBundle("com.amazon.kindle.control.resources.UtilResources");
        int a5 = (Integer)a4.getObject("cancel.index");
        int a6 = (Integer)a4.getObject("connectwifi.index");
        String a7 = MessageFormat.format(a4.getString(MetadataUtils.isPDoc((CatalogEntry)a2) ? "defer.wifirequired.pdoc.message.template" : "defer.wifirequired.message.template"), a2.getTitles()[0].getDisplay());
        if (ConfirmationDialog.showDialog((String)a.getName(), (String)a7, (String)a4.getString("defer.wifirequired.title"), (String[])a4.getStringArray("defer.wifirequired.labels"), (int[])new int[]{a5, a6}) == a6) {
            ThreadPool.getInstance().runIt(new Runnable(){
                {
                    1 a;
                }

                public void run() {
                    1 a;
                    ((Wireless)a.a3.getService(B == null ? (B = DialogUtils.class$("com.amazon.kindle.net.Wireless")) : B)).showWifiNetworks();
                }
            }, "show wifi networks");
        }
    }

    public static void showWirelessRequiredDialog(DCBooklet a, CatalogItem a2) {
        if (a == null) {
            LogUtils.logBookletIsNull();
            return;
        }
        ResourceBundle a3 = ResourceBundle.getBundle("com.amazon.kindle.control.resources.UtilResources");
        String a4 = MessageFormat.format(a3.getString("defer.wirelessrequired.message.template"), a2.getTitles()[0].getDisplay());
        if (ConfirmationDialog.showDialog((String)a.getName(), (String)a4, (String)a3.getString("defer.wirelessrequired.title"), (int)1) == 0) {
            MenuItemFactory.getSystemActionItem(a, "TURN_WIRELESS_ON_OFF_ACTION").actionPerformed(null);
        }
    }

    public static void showInsufficientSpaceDialog(DCBooklet a, CatalogItem a2) {
        if (a == null) {
            LogUtils.logBookletIsNull();
            return;
        }
        ResourceBundle a3 = ResourceBundle.getBundle("com.amazon.kindle.control.resources.UtilResources");
        int a4 = (Integer)a3.getObject("close.index");
        String a5 = MessageFormat.format(a3.getString("defer.insufficientspace.message.template"), a2.getTitles()[0].getDisplay());
        ConfirmationDialog.showDialog((String)a.getName(), (String)a5, (String)a3.getString("defer.insufficientspace.title"), (String[])a3.getStringArray("defer.insufficientspace.labels"), (int[])new int[]{a4});
    }

    public static void showDeferralDialog(DisplayController a, CatalogItem a2) {
        final DCBooklet a3 = a.getBooklet();
        if (a3 == null) {
            LogUtils.logBookletIsNull();
            return;
        }
        BookletContext a4 = a3.getBookletContext();
        if (a4 == null) {
            LogUtils.logBookletContextIsNull();
            return;
        }
        Map a5 = ((TransferService)a4.getService(TransferService.class)).getPendingTransfers();
        String a6 = TransferUtils.getItemUniqueKey(a2);
        if (StringUtil.isEmpty((String)a6)) {
            return;
        }
        Iterator a7 = a5.values().iterator();
        while (a7.hasNext()) {
            Transfer a8;
            TransferClientData a9;
            Object a10 = a7.next();
            if (!(a10 instanceof Transfer) || (a9 = TransferClientData.getInstance((a8 = (Transfer)a10).getClientData())) == null || !TransferUtils.isDeferred(a8.getStatus()) || !a6.equals(a9.getUniqueKey())) continue;
            int a11 = a8.getDeferralCode();
            if (TransferUtils.isWiFiRequired(a11)) {
                DialogUtils.showWiFiRequiredDialog(a3, a2);
                break;
            }
            if (TransferUtils.isNetworkDown(a11)) {
                if (K) break;
                K = true;
                ThreadPool.getInstance().runIt(new Runnable(){
                    {
                        2 a;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            2 a;
                            CommunicationUtils.ensureConnection((Booklet)a.a3);
                        }
                        catch (Exception a) {
                            b.error("Error while acquiring connection.");
                        }
                        finally {
                            K = false;
                        }
                    }
                }, "Ensuring connection.");
                break;
            }
            if (TransferUtils.isWirelessRequired(a11)) {
                DialogUtils.showWirelessRequiredDialog(a3, a2);
                break;
            }
            if (TransferUtils.isInsufficientSpace(a11)) {
                DialogUtils.showInsufficientSpaceDialog(a3, a2);
                break;
            }
            b.error("unknown deferral code");
            break;
        }
    }

    private static class LimitedCharacterDocument
    extends PlainDocument {
        private int maxNumChars;

        public LimitedCharacterDocument(int a) {
            LimitedCharacterDocument a2;
            a2.maxNumChars = a;
        }

        public synchronized void insertString(int a, String a2, AttributeSet a3) throws BadLocationException {
            LimitedCharacterDocument a4;
            if (a2.length() + a4.getLength() > a4.maxNumChars) {
                return;
            }
            super.insertString(a, a2, a3);
        }
    }

    private static class DismissAction
    extends AbstractAction {
        private KDialog dialog;

        public DismissAction(KDialog a) {
            DismissAction a2;
            a2.dialog = a;
        }

        public void actionPerformed(ActionEvent a) {
            DismissAction a2;
            a2.dialog.getCloseAction().actionPerformed(a);
        }
    }
}

