/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.kindle.control.util;

import com.amazon.ebook.util.file.FileSystemUtil;
import com.amazon.ebook.util.lang.UUID;
import com.amazon.ebook.util.log.Log;
import com.amazon.ebook.util.text.LString;
import com.amazon.kindle.apps.util.AudioUtils;
import com.amazon.kindle.apps.util.LogUtils;
import com.amazon.kindle.apps.util.MetadataUtils;
import com.amazon.kindle.apps.util.QueryUtils;
import com.amazon.kindle.apps.util.sidecar.SidecarFileUtil;
import com.amazon.kindle.booklet.Booklet;
import com.amazon.kindle.booklet.BookletContext;
import com.amazon.kindle.content.catalog.CatalogEntry;
import com.amazon.kindle.content.catalog.CatalogEntryCollection;
import com.amazon.kindle.content.catalog.CatalogItem;
import com.amazon.kindle.content.catalog.CatalogService;
import com.amazon.kindle.content.catalog.CatalogTransaction;
import com.amazon.kindle.content.catalog.CollationCriteria;
import com.amazon.kindle.content.catalog.Credit;
import com.amazon.kindle.content.catalog.MutableCollection;
import com.amazon.kindle.content.catalog.MutableEntry;
import com.amazon.kindle.content.catalog.MutableItem;
import com.amazon.kindle.content.catalog.Predicate;
import com.amazon.kindle.content.catalog.PredicateFactory;
import com.amazon.kindle.control.DCBooklet;
import com.amazon.kindle.restricted.webservices.whispersync.v1.WhisperSyncV1;
import java.io.File;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class CatalogUtils {
    public static final String e = "appSearchResults";
    private static final Log I = Log.getInstance((String)"CatalogUtils");
    private static final int F = 1;
    private static final int L = 2;
    private static final int c = 3;
    private static Object l = new Object();
    private static boolean k = false;
    private static int m = 0;
    private static final long h = 45000L;
    private static final String A = "ref";
    private static Object H = new Object();
    private static CollationCriteria[] b;
    private static CollationCriteria[] K;

    public CatalogUtils() {
        CatalogUtils a;
    }

    public static synchronized CatalogEntry[] findCatalogResults(Booklet a, Predicate a2, CollationCriteria[] a3, int a4) {
        return CatalogUtils.findCatalogResults(a, a2, a3, 0, a4, false);
    }

    public static synchronized CatalogEntry getCatalogEntryWithTitle(Booklet a, String a2) {
        Predicate a3 = CatalogUtils.getBookWithTitleFilter(a2);
        if (a3 == null) {
            return null;
        }
        CatalogEntry[] a4 = CatalogUtils.findCatalogResults(a, a3, CollationCriteria.SORT_BY_MOST_RECENT, 0, 2, true);
        if (a4 != null && a4.length > 0) {
            return a4[0];
        }
        return null;
    }

    private static Predicate getBookWithTitleFilter(String a) {
        if (a == null) {
            return null;
        }
        return PredicateFactory.and((Predicate[])new Predicate[]{PredicateFactory.isTrue((String)"isVisibleInHome"), PredicateFactory.startsWith((String)"titles[0].display", (String)a)});
    }

    public static synchronized CatalogEntry[] getCatalogEntriesWithUUID(Booklet a, String[] a2) {
        Predicate a3 = CatalogUtils.getBookWithUUIDFilter(a2);
        if (a3 == null) {
            return null;
        }
        return CatalogUtils.findCatalogResults(a, a3, CollationCriteria.SORT_BY_MOST_RECENT, 0, a2.length, true);
    }

    private static Predicate getBookWithUUIDFilter(String[] a) {
        if (a == null) {
            return null;
        }
        return PredicateFactory.and((Predicate[])new Predicate[]{PredicateFactory.isTrue((String)"isVisibleInHome"), PredicateFactory.inList((String)"uuid", (String[])a)});
    }

    public static synchronized CatalogEntry[] findCatalogResults(Booklet a, Predicate a2, CollationCriteria[] a3, int a4, int a5, boolean a6) {
        if (a == null) {
            LogUtils.logBookletIsNull();
            return null;
        }
        BookletContext a7 = a.getBookletContext();
        if (a7 == null) {
            LogUtils.logBookletContextIsNull();
            return null;
        }
        return QueryUtils.findCatalogResults((BookletContext)a7, (Predicate)a2, (CollationCriteria[])a3, (int)a4, (int)a5, (boolean)a6);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized int findNumResults(Booklet a, Predicate a2) {
        if (a2 == null) {
            return -1;
        }
        m = 0;
        k = false;
        if (a == null) {
            LogUtils.logBookletIsNull();
            return 0;
        }
        BookletContext a3 = a.getBookletContext();
        if (a3 == null) {
            LogUtils.logBookletContextIsNull();
            return 0;
        }
        ((CatalogService)a3.getService(CatalogService.class)).find(a2, CollationCriteria.SORT_BY_TITLE, 0, 0, new CatalogService.QueryResults(){
            {
                1 a;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void queryComplete(boolean a, int a2, int a3, CatalogEntry[] a4, Map a5) {
                Object object = l;
                synchronized (object) {
                    if (a) {
                        m = a2;
                    }
                    k = true;
                    l.notify();
                }
            }
        }, CatalogService.QueryResultDepth.FULL);
        Object object = l;
        synchronized (object) {
            block5: while (true) {
                boolean bl = k;
                while (!bl) {
                    try {
                        l.wait();
                    }
                    catch (Exception exception) {
                        bl = k;
                        continue;
                    }
                    continue block5;
                }
                break;
            }
        }
        return m;
    }

    public static boolean isPdocFromCloud(Booklet a, CatalogItem a2) {
        return "PDOC".equals(a2.getCDEType()) && CatalogUtils.isArchivedItem(a, a2);
    }

    private static boolean isArchivedItem(Booklet a, CatalogItem a2) {
        if (a == null) {
            LogUtils.logBookletIsNull();
            return false;
        }
        BookletContext a3 = a.getBookletContext();
        if (a3 == null) {
            LogUtils.logBookletContextIsNull();
            return false;
        }
        return QueryUtils.hasArchivedCopy((BookletContext)a3, (CatalogItem)a2);
    }

    public static boolean doesCollectionContainItem(Booklet a, UUID a2, UUID a3) {
        UUID[] a4;
        if (a == null) {
            LogUtils.logBookletIsNull();
            return false;
        }
        BookletContext a5 = a.getBookletContext();
        if (a5 == null) {
            LogUtils.logBookletContextIsNull();
            return false;
        }
        CatalogEntry[] a6 = ((CatalogService)a5.getService(CatalogService.class)).lookup(new UUID[]{a2}, true);
        CatalogEntryCollection a7 = null;
        if (a6 != null && a6.length > 0 && a3 != null && (a4 = (a7 = (CatalogEntryCollection)a6[0]).getMembers()) != null) {
            int a8;
            int n = a8 = 0;
            while (n < a4.length) {
                if (a3.equals((Object)a4[a8])) {
                    return true;
                }
                n = ++a8;
            }
        }
        return false;
    }

    public static synchronized boolean doesCollectionExist(Booklet a, String a2) {
        int a3;
        Predicate a4 = CatalogUtils.getCollectionFilter(a2);
        CatalogEntry[] a5 = CatalogUtils.findCatalogResults(a, a4, CollationCriteria.SORT_BY_MOST_RECENT, a3 = 1);
        return a5 != null && a5.length > 0;
    }

    public static synchronized CatalogEntry findCollectionByTitle(Booklet a, String a2) {
        int a3;
        Predicate a4 = CatalogUtils.getCollectionFilter(a2);
        CatalogEntry[] a5 = CatalogUtils.findCatalogResults(a, a4, CollationCriteria.SORT_BY_MOST_RECENT, a3 = 1);
        if (a5 != null && a5.length > 0 && a5[0] instanceof CatalogEntryCollection) {
            return a5[0];
        }
        return null;
    }

    public static synchronized boolean addCollection(Booklet a, String a2, CatalogItem a3) {
        if (CatalogUtils.doesCollectionExist(a, a2)) {
            return false;
        }
        if (a == null) {
            LogUtils.logBookletIsNull();
            return false;
        }
        BookletContext a4 = a.getBookletContext();
        if (a4 == null) {
            LogUtils.logBookletContextIsNull();
            return false;
        }
        MutableCollection a5 = ((CatalogService)a4.getService(CatalogService.class)).createMutableCollection(new UUID());
        a5.setTitles(new LString[]{new LString(a2)});
        a5.setIsVisibleInHome(true);
        a5.setLastAccessDate(new Date());
        CatalogUtils.submitTransaction(a, a5, 1);
        if (a3 != null) {
            CatalogUtils.addItemToCollection(a, a5.getUUID(), a3.getUUID(), false);
        }
        CatalogUtils.uploadCollectionJournal(a);
        return true;
    }

    public static synchronized boolean doesItemWithGivenTypeExist(Booklet a, String a2) {
        Predicate a3 = PredicateFactory.equals((String)"type", (String)a2);
        return CatalogUtils.findNumResults(a, a3) > 0;
    }

    private static synchronized boolean updateItemTitleIfNeeded(Booklet a, String a2, String a3, String a4) {
        CatalogEntry[] a5 = CatalogUtils.findCatalogResults(a, PredicateFactory.equals((String)"type", (String)a4), CollationCriteria.SORT_BY_TITLE, 0, 1, true);
        if (a5 == null || a5.length == 0) {
            if (Log.isDebugOn()) {
                I.debug("Item not found");
            }
            return false;
        }
        CatalogEntry a6 = a5[0];
        if (a2.equals(a6.getTitles()[0].getDisplay())) {
            return false;
        }
        if (a == null) {
            LogUtils.logBookletIsNull();
            return false;
        }
        BookletContext a7 = a.getBookletContext();
        if (a7 == null) {
            LogUtils.logBookletContextIsNull();
            return false;
        }
        MutableItem a8 = ((CatalogService)a7.getService(CatalogService.class)).createMutableItem(a6.getUUID());
        a8.setTitles(new LString[]{new LString(a2)});
        a8.setEntryType(a6.getEntryType());
        if (a3 != null) {
            a8.setCredits(new Credit[]{new Credit(Credit.Kind.AUTHOR, new LString(a3))});
        }
        CatalogUtils.submitTransactionAsync(a, a8, 3);
        return true;
    }

    public static synchronized boolean addSpecialItem(Booklet a, String a2, String a3, String a4, boolean a5, Date a6) {
        if (CatalogUtils.doesItemWithGivenTypeExist(a, a4)) {
            return CatalogUtils.updateItemTitleIfNeeded(a, a2, a3, a4);
        }
        if (a == null) {
            LogUtils.logBookletIsNull();
            return false;
        }
        BookletContext a7 = a.getBookletContext();
        if (a7 == null) {
            LogUtils.logBookletContextIsNull();
            return false;
        }
        MutableItem a8 = ((CatalogService)a7.getService(CatalogService.class)).createMutableItem(new UUID());
        a8.setTitles(new LString[]{new LString(a2)});
        a8.setEntryType(a4);
        if (a3 != null) {
            a8.setCredits(new Credit[]{new Credit(Credit.Kind.AUTHOR, new LString(a3))});
            HashMap<String, String> a9 = new HashMap<String, String>();
            a9.put(A, "titles");
            HashMap<String, String> a10 = new HashMap<String, String>();
            a10.put(A, "credits");
            Map[] a11 = new Map[]{a9, a10};
            a8.setDisplayObjects(a11);
        }
        a8.setIsVisibleInHome(a5);
        a8.setPercentFinished(-1.0f);
        if (a6 != null) {
            a8.setLastAccessDate(a6);
        }
        CatalogUtils.submitTransaction(a, a8, 1);
        return true;
    }

    public static void updateItemLastAccessTime(Booklet a, CatalogEntry a2, Date a3) {
        if (a3 == null) {
            a3 = new Date();
        }
        if (a2 != null) {
            if (a == null) {
                LogUtils.logBookletIsNull();
                return;
            }
            BookletContext a4 = a.getBookletContext();
            if (a4 == null) {
                LogUtils.logBookletContextIsNull();
                return;
            }
            MutableItem a5 = ((CatalogService)a4.getService(CatalogService.class)).createMutableItem(a2.getUUID());
            a5.setEntryType(a2.getEntryType());
            a5.setLastAccessDate(a3);
            CatalogUtils.submitTransactionAsync(a, a5, 3);
        }
    }

    public static synchronized void removeCollection(Booklet a, UUID a2) {
        CatalogUtils.submitTransaction(a, a2, 2);
        CatalogUtils.uploadCollectionJournal(a);
    }

    public static synchronized boolean renameCollection(Booklet a, UUID a2, String a3) {
        if (CatalogUtils.doesCollectionExist(a, a3)) {
            return false;
        }
        if (a == null) {
            LogUtils.logBookletIsNull();
            return false;
        }
        BookletContext a4 = a.getBookletContext();
        if (a4 == null) {
            LogUtils.logBookletContextIsNull();
            return false;
        }
        MutableCollection a5 = ((CatalogService)a4.getService(CatalogService.class)).createMutableCollection(a2);
        a5.setTitles(new LString[]{new LString(a3)});
        a5.setIsVisibleInHome(true);
        CatalogUtils.submitTransaction(a, a5, 3);
        CatalogUtils.uploadCollectionJournal(a);
        return true;
    }

    public static void addItemToCollection(Booklet a, UUID a2, UUID a3) {
        CatalogUtils.addItemToCollection(a, a2, a3, true);
    }

    public static void addItemToCollection(Booklet a, UUID a2, UUID a3, boolean a4) {
        CatalogUtils.deltaItemToCollection(a, a2, a3, true);
        if (a4) {
            CatalogUtils.uploadCollectionJournal(a);
        }
    }

    public static void removeItemFromCollection(Booklet a, UUID a2, UUID a3) {
        CatalogUtils.removeItemFromCollection(a, a2, a3, true);
    }

    public static void removeItemFromCollection(Booklet a, UUID a2, UUID a3, boolean a4) {
        CatalogUtils.deltaItemToCollection(a, a2, a3, false);
        if (a4) {
            CatalogUtils.uploadCollectionJournal(a);
        }
    }

    private static synchronized void deltaItemToCollection(Booklet a, UUID a2, UUID a3, boolean a4) {
        if (a3 == null || a2 == null) {
            return;
        }
        if (a == null) {
            LogUtils.logBookletIsNull();
            return;
        }
        BookletContext a5 = a.getBookletContext();
        if (a5 == null) {
            LogUtils.logBookletContextIsNull();
            return;
        }
        MutableCollection a6 = ((CatalogService)a5.getService(CatalogService.class)).createMutableCollection(a2);
        UUID[] a7 = CatalogUtils.getMembers(a, (CatalogEntryCollection)a6);
        boolean a8 = a4;
        int a9 = 0;
        if (a7 != null) {
            int a10;
            int n = a10 = 0;
            while (n < a7.length) {
                UUID a11 = a7[a10];
                if (a11.equals((Object)a3)) {
                    if (a4) {
                        return;
                    }
                    a8 = true;
                } else {
                    a6.addMember(a11);
                    ++a9;
                }
                n = ++a10;
            }
        }
        if (a4) {
            a6.addMember(a3);
            ++a9;
        }
        if (a9 == 0) {
            a6.setMembers(new UUID[0]);
        }
        if (a8) {
            CatalogUtils.submitTransaction(a, a6, 3);
        }
    }

    public static CatalogEntryCollection getFreshCollection(Booklet a, CatalogEntryCollection a2) {
        if (a2 == null) {
            return null;
        }
        UUID a3 = a2.getUUID();
        CatalogEntry[] a4 = CatalogUtils.getFreshEntries(a, new UUID[]{a3});
        if (a4 != null && a4.length > 0 && a4[0] instanceof CatalogEntryCollection) {
            return (CatalogEntryCollection)a4[0];
        }
        return null;
    }

    public static void uploadCollectionJournal(Booklet a) {
        if (a == null) {
            LogUtils.logBookletIsNull();
            return;
        }
        BookletContext a2 = a.getBookletContext();
        if (a2 == null) {
            LogUtils.logBookletContextIsNull();
            return;
        }
        WhisperSyncV1 a3 = (WhisperSyncV1)a2.getService(WhisperSyncV1.class);
        if (a3 != null) {
            a3.scheduleUploadJournal(45000L);
        }
    }

    public static synchronized void deleteItem(Booklet a, CatalogEntry a2, boolean a3) {
        if (a != null && a2 != null) {
            File a4;
            if (MetadataUtils.isAudible((CatalogEntry)a2) || MetadataUtils.isAudibleSample((CatalogEntry)a2) || MetadataUtils.isMP3((CatalogEntry)a2)) {
                AudioUtils.deleteAudioItem((CatalogEntry)a2);
                return;
            }
            String a5 = a2.getLocation();
            if (a5 != null && (a4 = new File(a5)).isFile()) {
                a4.delete();
                if (a3 && !FileSystemUtil.deleteNonEmptyDir((File)(a4 = new File(SidecarFileUtil.getSidecarDirectory((File)a4))))) {
                    I.error("Unable to delete sidecar directory");
                }
                return;
            }
            CatalogUtils.submitTransaction(a, a2.getUUID(), 2);
        }
    }

    public static UUID[] getMembers(Booklet a, CatalogEntryCollection a2) {
        return CatalogUtils.getFreshCollection(a, a2).getMembers();
    }

    public static int getCollectionCount(Booklet a) {
        return CatalogUtils.findNumResults(a, CatalogUtils.getAllCollectionsFilter());
    }

    private static CatalogEntry[] getFreshEntries(Booklet a, UUID[] a2) {
        if (a == null) {
            LogUtils.logBookletIsNull();
            return null;
        }
        BookletContext a3 = a.getBookletContext();
        if (a3 == null) {
            LogUtils.logBookletContextIsNull();
            return null;
        }
        return ((CatalogService)a3.getService(CatalogService.class)).lookup(a2, true);
    }

    private static synchronized void submitTransaction(Booklet a, Object a2, int a3) {
        CatalogUtils.submitTransactionImpl(a, a2, a3, true);
    }

    private static synchronized void submitTransactionAsync(Booklet a, Object a2, int a3) {
        CatalogUtils.submitTransactionImpl(a, a2, a3, false);
    }

    private static synchronized void submitTransactionImpl(Booklet a, Object a2, int a3, boolean a4) {
        if (a2 == null) {
            return;
        }
        if (a == null) {
            LogUtils.logBookletIsNull();
            return;
        }
        BookletContext a5 = a.getBookletContext();
        if (a5 == null) {
            LogUtils.logBookletContextIsNull();
            return;
        }
        CatalogService a6 = (CatalogService)a5.getService(CatalogService.class);
        CatalogTransaction a7 = a4 ? a6.openTransaction() : a6.openTransaction(new CatalogTransaction.TransactionResultsHandler(){
            {
                2 a;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void transactionComplete(boolean a, int a2, String a3) {
                Object object = H;
                synchronized (object) {
                    if (!a) {
                        I.error("Error in transaction:" + a3);
                    }
                }
            }
        });
        if (a3 == 1 && a2 instanceof MutableEntry) {
            a7.addEntry((MutableEntry)a2);
        } else if (a3 == 2 && a2 instanceof UUID) {
            a7.deleteEntry((UUID)a2);
        } else if (a3 == 3 && a2 instanceof MutableEntry) {
            a7.updateEntry((MutableEntry)a2);
        } else {
            I.error("Invalid transaction type: " + a3);
        }
        if (a4) {
            CatalogTransaction.TransactionResult a8 = a7.commitSync();
            if (!a8.isSuccessful()) {
                I.error("Error in transaction:" + a8.getErrorMsg());
            }
        } else {
            a7.commit();
        }
    }

    private static Predicate getCollectionFilter(String a) {
        return PredicateFactory.and((Predicate[])new Predicate[]{PredicateFactory.isTrue((String)"isVisibleInHome"), PredicateFactory.inList((String)"type", (String[])new String[]{"Collection"}), PredicateFactory.inList((String)"titles[0].display", (String[])new String[]{a})});
    }

    private static Predicate getAllCollectionsFilter() {
        return PredicateFactory.and((Predicate[])new Predicate[]{PredicateFactory.isTrue((String)"isVisibleInHome"), PredicateFactory.inList((String)"type", (String[])new String[]{"Collection"})});
    }

    public static final synchronized CollationCriteria[] getSortByNumberOfHits(String a) {
        if (b == null) {
            String a2 = MessageFormat.format("matchInfo[\"{0}\"].matchCount", a);
            b = new CollationCriteria[]{new CollationCriteria("isArchived", false), new CollationCriteria(a2, false), new CollationCriteria("titles[0].collation"), new CollationCriteria("publicationDate", false)};
        }
        return b;
    }

    public static synchronized CollationCriteria[] getSortByCollection() {
        if (K == null) {
            K = new CollationCriteria[]{new CollationCriteria("type"), new CollationCriteria("lastAccess", false), new CollationCriteria("titles[0].collation")};
        }
        return K;
    }

    public static boolean isSortedByCollection(CollationCriteria[] a) {
        if (K == null) {
            return false;
        }
        return a == K;
    }

    public static void updateCollectionLastAccessTime(DCBooklet a, CatalogEntryCollection a2, Date a3) {
        if (a == null) {
            LogUtils.logBookletIsNull();
            return;
        }
        BookletContext a4 = a.getBookletContext();
        if (a4 == null) {
            LogUtils.logBookletContextIsNull();
            return;
        }
        if (a3 == null) {
            a3 = new Date();
        }
        MutableCollection a5 = ((CatalogService)a4.getService(CatalogService.class)).createMutableCollection(a2.getUUID());
        a5.setLastAccessDate(a3);
        CatalogUtils.submitTransactionAsync((Booklet)a, a5, 3);
    }
}

