/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.kindle.control.util;

import com.amazon.agui.swing.ConfirmationDialog;
import com.amazon.ebook.util.log.Log;
import com.amazon.ebook.util.log.LogMessage;
import com.amazon.ebook.util.net.URIUtility;
import com.amazon.ebook.util.thread.ThreadPool;
import com.amazon.kindle.apps.util.LogUtils;
import com.amazon.kindle.apps.util.MetadataUtils;
import com.amazon.kindle.booklet.Booklet;
import com.amazon.kindle.booklet.BookletContext;
import com.amazon.kindle.booklet.ChromeException;
import com.amazon.kindle.booklet.ChromeHeaderBar;
import com.amazon.kindle.content.catalog.CatalogEntry;
import com.amazon.kindle.content.catalog.CatalogEntryCollection;
import com.amazon.kindle.content.catalog.CatalogItem;
import com.amazon.kindle.control.util.CatalogUtils;
import com.amazon.kindle.util.lipc.LipcException;
import com.amazon.kindle.util.lipc.LipcService;
import com.amazon.kindle.util.lipc.LipcTarget;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ResourceBundle;

public class ActionUtils {
    private static final Log k = Log.getInstance((String)"ActionUtils");
    private static final LogMessage m = new LogMessage("RemoveItemFailed", new String[]{"reason"});
    private static final LogMessage h = new LogMessage("DeleteItemFailed", new String[]{"reason"});
    private static final String A = "com.lab126.appmgrd";
    private static final String H = "start";
    private static final String b = "ACTION_UTILS";
    private static final int K = 10000;
    private static final int B = 0;

    public ActionUtils() {
        ActionUtils a;
    }

    public static void sendLipcCommand(String a) {
        LipcTarget a2 = LipcService.getInstance().getDefaultSource().getTarget(A);
        try {
            a2.setProperty(H, a);
        }
        catch (LipcException a3) {
            k.critical(Log.LIPC_EX, new String[]{Integer.toString(a3.getErrorCode())}, null, null);
        }
    }

    public static void openBook(CatalogEntry a) {
        if (a.getLocation() != null) {
            try {
                ActionUtils.sendLipcCommand(URIUtility.getFileURI((String)a.getLocation()).toString());
            }
            catch (URISyntaxException a2) {
                k.error(Log.CATCHALL_EX, null, "URICreation failed", (Throwable)a2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean removeItem(Booklet a, CatalogEntry a2) {
        boolean a3;
        block13: {
            if (a == null) {
                LogUtils.logBookletIsNull();
                return false;
            }
            BookletContext a4 = a.getBookletContext();
            if (a4 == null) {
                LogUtils.logBookletContextIsNull();
                return false;
            }
            ChromeHeaderBar a5 = (ChromeHeaderBar)a4.getService(ChromeHeaderBar.class);
            a3 = false;
            if (a2 instanceof CatalogItem) {
                a5.enableActivityIndicator(b, 10000, 0);
                CatalogUtils.deleteItem(a, a2, true);
                a3 = true;
                try {
                    a5.disableActivityIndicator(b);
                }
                catch (Exception a6) {
                    k.error(m, new String[]{"fail to disable activity indicator"}, null, (Throwable)a6);
                }
                break block13;
                catch (Exception a7) {
                    try {
                        k.error(m, new String[]{"fail to enable activity indicator"}, null, (Throwable)a7);
                    }
                    catch (Throwable throwable) {
                        try {
                            a5.disableActivityIndicator(b);
                        }
                        catch (Exception a8) {
                            k.error(m, new String[]{"fail to disable activity indicator"}, null, (Throwable)a8);
                        }
                        throw throwable;
                    }
                    try {
                        a5.disableActivityIndicator(b);
                    }
                    catch (Exception a9) {
                        k.error(m, new String[]{"fail to disable activity indicator"}, null, (Throwable)a9);
                    }
                }
            }
        }
        return a3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean deleteItem(final Booklet a, final CatalogEntry a2) {
        boolean a3;
        block39: {
            ResourceBundle a4;
            block40: {
                if (a == null) {
                    LogUtils.logBookletIsNull();
                    return false;
                }
                BookletContext a5 = a.getBookletContext();
                if (a5 == null) {
                    LogUtils.logBookletContextIsNull();
                    return false;
                }
                ChromeHeaderBar a6 = (ChromeHeaderBar)a5.getService(ChromeHeaderBar.class);
                a4 = ResourceBundle.getBundle("com.amazon.kindle.control.resources.UtilResources");
                a3 = false;
                if (!(a2 instanceof CatalogItem)) break block40;
                CatalogItem a7 = (CatalogItem)a2;
                String a8 = null;
                String a9 = null;
                if (MetadataUtils.isReceipt((CatalogEntry)a7)) {
                    a8 = a4.getString("delete.receipt.title");
                    a9 = MessageFormat.format(a4.getString("delete.receipt.template"), a7.getTitles()[0].getDisplay());
                } else if (MetadataUtils.isNotice((CatalogEntry)a7)) {
                    a8 = a4.getString("delete.notice.title");
                    a9 = MessageFormat.format(a4.getString("delete.notice.template"), a7.getTitles()[0].getDisplay());
                } else if (MetadataUtils.isBook((CatalogEntry)a7)) {
                    a8 = a4.getString("delete.book.title");
                    a9 = MessageFormat.format(a4.getString("delete.book.template"), a7.getTitles()[0].getDisplay());
                } else if (MetadataUtils.isNewspaper((CatalogEntry)a7) || MetadataUtils.isMagazine((CatalogEntry)a7)) {
                    a8 = a4.getString("delete.issue.title");
                    a9 = ((MessageFormat)a4.getObject("delete.issue.template")).format(new Object[]{a7.getTitles()[0].getDisplay(), a7.getPublicationDate()});
                } else if (MetadataUtils.isSample((CatalogEntry)a7)) {
                    a8 = a4.getString("delete.sample.title");
                    a9 = MessageFormat.format(a4.getString("delete.sample.template"), a7.getTitles()[0].getDisplay());
                } else if (MetadataUtils.isBlog((CatalogEntry)a7)) {
                    a8 = a4.getString("delete.blog.title");
                    a9 = MessageFormat.format(a4.getString("delete.blog.template"), a7.getTitles()[0].getDisplay());
                } else if (MetadataUtils.isApp((CatalogEntry)a7)) {
                    a8 = a4.getString("delete.app.title");
                    a9 = MessageFormat.format(a4.getString("delete.app.template"), a7.getTitles()[0].getDisplay());
                } else if (MetadataUtils.isAudible((CatalogEntry)a7)) {
                    a8 = a4.getString("delete.audible.title");
                    a9 = MessageFormat.format(a4.getString("delete.audible.template"), a7.getTitles()[0].getDisplay());
                } else if (MetadataUtils.isMP3((CatalogEntry)a7)) {
                    a8 = a4.getString("delete.mp3.title");
                    a9 = MessageFormat.format(a4.getString("delete.mp3.template"), a7.getTitles()[0].getDisplay());
                } else if (MetadataUtils.isPDoc((CatalogEntry)a7)) {
                    a8 = a4.getString("delete.document.title");
                    a9 = MessageFormat.format(a4.getString("delete.document.template"), a7.getTitles()[0].getDisplay());
                } else if (MetadataUtils.isOOBE((CatalogEntry)a7)) {
                    a8 = a4.getString("delete.oobe.title");
                    a9 = MessageFormat.format(a4.getString("delete.oobe.template"), a7.getTitles()[0].getDisplay());
                } else if (MetadataUtils.isLetter((CatalogEntry)a7)) {
                    a8 = a4.getString("delete.letter.title");
                    a9 = MessageFormat.format(a4.getString("delete.letter.template"), a7.getTitles()[0].getDisplay());
                } else {
                    a8 = a4.getString("delete.default.title");
                    a9 = MessageFormat.format(a4.getString("delete.default.template"), a7.getTitles()[0].getDisplay());
                }
                if (ConfirmationDialog.showDialog((String)a.getBookletContext().getName(), (String)a9, (String)a8, (String[])new String[]{a4.getString("cancel.label"), a4.getString("delete.label")}, (int[])new int[]{(Integer)a4.getObject("cancel.index"), (Integer)a4.getObject("delete.index")}) != (Integer)a4.getObject("delete.index")) break block39;
                a6.enableActivityIndicator(b, 10000, 0);
                ThreadPool.getInstance().runIt(new Runnable(){
                    {
                        1 a3;
                    }

                    public void run() {
                        1 a3;
                        CatalogUtils.deleteItem(a3.a, a3.a2, MetadataUtils.isPeriodical((CatalogEntry)a3.a2));
                    }
                }, "DeleteItemAction");
                a3 = true;
                try {
                    a6.disableActivityIndicator(b);
                }
                catch (ChromeException a10) {
                    k.error(h, new String[]{"fail to disable activity indicator"}, null, (Throwable)a10);
                }
                break block39;
                catch (ChromeException a11) {
                    try {
                        k.error(h, new String[]{"fail to enable activity indicator"}, null, (Throwable)a11);
                    }
                    catch (Throwable throwable) {
                        try {
                            a6.disableActivityIndicator(b);
                        }
                        catch (ChromeException a12) {
                            k.error(h, new String[]{"fail to disable activity indicator"}, null, (Throwable)a12);
                        }
                        throw throwable;
                    }
                    try {
                        a6.disableActivityIndicator(b);
                    }
                    catch (ChromeException a13) {
                        k.error(h, new String[]{"fail to disable activity indicator"}, null, (Throwable)a13);
                    }
                    break block39;
                }
            }
            if (a2 instanceof CatalogEntryCollection) {
                int a14 = ConfirmationDialog.showDialog((String)a.getBookletContext().getName(), (String)MessageFormat.format(a4.getString("delete.collection.template"), a2.getTitles()[0].getDisplay(), new Integer(((CatalogEntryCollection)a2).getMemberCount())), (String)a4.getString("delete.collection.title"), (String[])new String[]{a4.getString("cancel.label"), a4.getString("delete.label")}, (int[])new int[]{(Integer)a4.getObject("cancel.index"), (Integer)a4.getObject("delete.index")});
                if (a14 == (Integer)a4.getObject("delete.index")) {
                    CatalogUtils.removeCollection(a, a2.getUUID());
                    a3 = true;
                }
            } else {
                k.error(h, new String[]{"Unhandled item type"}, null);
            }
        }
        return a3;
    }
}

