/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.kindle.control.dialog;

import com.amazon.agui.swing.CommandBar;
import com.amazon.agui.swing.InteractiveList;
import com.amazon.agui.swing.KDialog;
import com.amazon.ebook.util.log.Log;
import com.amazon.ebook.util.text.StringUtil;
import com.amazon.kindle.booklet.Booklet;
import com.amazon.kindle.content.catalog.Predicate;
import com.amazon.kindle.content.catalog.PredicateFactory;
import com.amazon.kindle.control.ContentBasedDisplayController;
import com.amazon.kindle.control.behavior.event.PageTurnEvent;
import com.amazon.kindle.control.content.ContentManager;
import com.amazon.kindle.control.util.CatalogUtils;
import com.amazon.kindle.control.util.DialogUtils;
import com.amazon.kindle.control.util.PageUtils;
import com.amazon.kindle.control.util.SortUtils;
import com.amazon.kindle.control.widget.InteractiveListWrapper;
import com.amazon.kindle.keyboard.KeyboardUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class GoToPageDialog
extends KDialog {
    private static final Log LOG = Log.getInstance((String)"GoToPageDialog");
    private static final String TITLE_FIELD = "title";
    private static final String CREDITS_FIELD = "credits";
    private static final int FIRST_PAGE = 1;
    private JLabel mPageNumLabel;
    private JLabel mPrefixLabel;
    private JTextField mPageNumField;
    private JTextField mPrefixField;
    private JButton mOkButton;
    private final ContentBasedDisplayController mController;
    private final int mItemsPerPage;
    private String mQueryField;
    private FocusAdapter mFocusListener;
    private DocumentListener mDocumentListener;
    private KeyAdapter mKeyAdapter;

    public GoToPageDialog(ContentBasedDisplayController a) {
        super(a.getBooklet().getName(), true, "pad");
        GoToPageDialog a2;
        a2.mFocusListener = new FocusAdapter(){
            {
                3 a;
            }

            public void focusGained(FocusEvent a) {
                3 a2;
                Object a3 = a.getSource();
                if (a3 == a2.GoToPageDialog.this.mPageNumField) {
                    a2.GoToPageDialog.this.mPrefixField.setText("");
                } else if (a3 == a2.GoToPageDialog.this.mPrefixField) {
                    a2.GoToPageDialog.this.mPageNumField.setText("");
                }
            }
        };
        a2.mDocumentListener = new DocumentListener(){
            {
                4 a;
            }

            public void changedUpdate(DocumentEvent a) {
                4 a2;
                a2.GoToPageDialog.this.updateOKButton();
            }

            public void insertUpdate(DocumentEvent a) {
                4 a2;
                a2.GoToPageDialog.this.updateOKButton();
            }

            public void removeUpdate(DocumentEvent a) {
                4 a2;
                a2.GoToPageDialog.this.updateOKButton();
            }
        };
        a2.mKeyAdapter = new KeyAdapter(){
            {
                5 a;
            }

            public void keyReleased(KeyEvent a) {
                if (a.getKeyCode() == 10) {
                    5 a2;
                    a.consume();
                    a2.GoToPageDialog.this.onOK();
                }
            }
        };
        if (a == null) {
            throw new IllegalArgumentException("DisplayController is null.");
        }
        ContentManager a3 = a.getContentManager();
        if (a3 == null) {
            throw new IllegalArgumentException("Underlying ContentManager is null.");
        }
        String a4 = SortUtils.getSortOptionKey(a3.getSortOption(), a3.getDefaultSortOption());
        a2.mQueryField = "author".equals(a4) ? CREDITS_FIELD : TITLE_FIELD;
        JPanel a5 = a.getPanel();
        if (!(a5 instanceof InteractiveListWrapper)) {
            throw new IllegalArgumentException("DisplayController does not contain an InteractiveListWrapper.");
        }
        InteractiveList a6 = ((InteractiveListWrapper)a5).getInteractiveList();
        if (a6 == null) {
            throw new IllegalArgumentException("Underlying InteractiveList is null.");
        }
        a2.mItemsPerPage = a6.getPageItemCount();
        a2.mController = a;
        a2.initGUI();
    }

    private void initGUI() {
        GoToPageDialog a;
        ResourceBundle a2 = ResourceBundle.getBundle("com.amazon.kindle.control.resources.DialogResources");
        a.setTitleBarEnabled(true);
        a.setTitle(a2.getString("gotoPage.dialog.title"));
        a.setCloseIconButtonEnabled(false);
        a.setCommandBarPosition(2);
        Container a3 = a.getContentPane();
        a3.setLayout(new GridBagLayout());
        Dimension a4 = (Dimension)a2.getObject("gotoPage.inputField.size");
        int a5 = (Integer)a2.getObject("gotoPage.inputField.horzAlignment");
        a.mPageNumField = new JTextField();
        KeyboardUtils.configure((JComponent)a.mPageNumField, (String)":pad:");
        a.mPageNumField.setDocument((Document)DialogUtils.getLimitedCharacterDocument((Integer)a2.getObject("gotoPage.pageInput.maxChars")));
        a.mPageNumField.addKeyListener(a.mKeyAdapter);
        a.mPageNumField.addFocusListener(a.mFocusListener);
        a.mPageNumField.getDocument().addDocumentListener(a.mDocumentListener);
        a.mPageNumField.setHorizontalAlignment(a5);
        a.mPageNumField.setPreferredSize(a4);
        a.mPageNumField.setMinimumSize(a4);
        a3.add((Component)a.mPageNumField, (GridBagConstraints)a2.getObject("gotoPage.pageInput.layout"));
        a.mPageNumLabel = new JLabel(a.getPageNumLabel());
        a.mPageNumLabel.setVerticalTextPosition(0);
        a3.add((Component)a.mPageNumLabel, (GridBagConstraints)a2.getObject("gotoPage.pageInput.label.layout"));
        a.mPrefixField = new JTextField();
        a.mPrefixField.setDocument((Document)DialogUtils.getLimitedCharacterDocument((Integer)a2.getObject("gotoPage.prefixInput.maxChars")));
        a.mPrefixField.addKeyListener(a.mKeyAdapter);
        a.mPrefixField.addFocusListener(a.mFocusListener);
        a.mPrefixField.getDocument().addDocumentListener(a.mDocumentListener);
        a.mPrefixField.setHorizontalAlignment(a5);
        a.mPrefixField.setPreferredSize(a4);
        a.mPrefixField.setMinimumSize(a4);
        a3.add((Component)a.mPrefixField, (GridBagConstraints)a2.getObject("gotoPage.prefixInput.layout"));
        a.mPrefixLabel = new JLabel(a.getPrefixLabel());
        a.mPrefixLabel.setVerticalTextPosition(0);
        a3.add((Component)a.mPrefixLabel, (GridBagConstraints)a2.getObject("gotoPage.prefixInput.label.layout"));
        AbstractAction a6 = new AbstractAction(){
            {
                1 a;
            }

            public void actionPerformed(ActionEvent a) {
                1 a2;
                a2.GoToPageDialog.this.onOK();
            }
        };
        a.mOkButton = DialogUtils.getActionButton(a6, a2.getString("gotoPage.okButton.label"));
        a.mOkButton.setEnabled(false);
        CommandBar a7 = a.getCommandBar();
        a7.add((Component)DialogUtils.getCancelButton(a));
        a7.add((Component)a.mOkButton);
        a7.setButtonWidthPreserved(false);
        a7.setButtonPreferredSize(null);
        Rectangle a8 = a.getDialogBounds();
        a8.setSize((Dimension)a2.getObject("gotoPage.dialog.size"));
        a.setDialogBounds(a8);
        SwingUtilities.invokeLater(new Runnable(){
            {
                2 a;
            }

            public void run() {
                2 a;
                a.GoToPageDialog.this.mPrefixField.requestFocus();
            }
        });
    }

    private void updateOKButton() {
        GoToPageDialog a;
        a.mOkButton.setEnabled(StringUtil.isNotEmpty((String)a.mPageNumField.getText()) || StringUtil.isNotEmpty((String)a.mPrefixField.getText()));
    }

    private void onOK() {
        GoToPageDialog a;
        if (!a.mOkButton.isEnabled()) {
            return;
        }
        boolean a2 = false;
        if (StringUtil.isNotEmpty((String)a.mPageNumField.getText())) {
            a2 = a.goToPageNumber();
        } else if (StringUtil.isNotEmpty((String)a.mPrefixField.getText())) {
            a2 = a.goToPageContainingPrefix();
        }
        if (a2) {
            PageTurnEvent.getInstance().fireEvent();
        } else {
            LOG.error("Go to page operation failed.");
        }
        a.closeDialog();
    }

    private String getPageNumLabel() {
        GoToPageDialog a;
        return MessageFormat.format(ResourceBundle.getBundle("com.amazon.kindle.control.resources.DialogResources").getString("gotoPage.pageInput.label.template"), new Integer(a.getNumOfPages()));
    }

    private String getPrefixLabel() {
        GoToPageDialog a;
        if (a.mController.getContentManager() == null) {
            return "";
        }
        ResourceBundle a2 = ResourceBundle.getBundle("com.amazon.kindle.control.resources.DialogResources");
        return a2.getString("gotoPage.prefixInput.label." + a.mQueryField);
    }

    private int getNumOfPages() {
        GoToPageDialog a;
        ContentManager a2 = a.mController.getContentManager();
        if (a2 != null) {
            return PageUtils.getTotalPageNumber(a2.getSize(), a.mItemsPerPage);
        }
        return 1;
    }

    private boolean goToPageContainingPrefix() {
        GoToPageDialog a;
        ContentManager a2 = a.mController.getContentManager();
        if (a2 == null) {
            return false;
        }
        String a3 = SortUtils.getSortOptionKey(a2.getSortOption(), a2.getDefaultSortOption());
        if (a.mQueryField.equals(TITLE_FIELD) && !a3.equals(TITLE_FIELD)) {
            a2.setSortOption(SortUtils.getSortOption(TITLE_FIELD, TITLE_FIELD));
        }
        String a4 = a.mPrefixField.getText();
        Predicate a5 = a2.getPrimaryFilter();
        if (StringUtil.isEmpty((String)a4) || a5 == null) {
            return false;
        }
        Predicate a6 = PredicateFactory.and((Predicate[])new Predicate[]{a5, PredicateFactory.prefixQueryCount((String)a4, (String)a.mQueryField, (String)a.mController.getViewKey())});
        int a7 = a2.getSize() - 1;
        int a8 = CatalogUtils.findNumResults((Booklet)a.mController.getBooklet(), a6);
        if ((a8 += a2.getPrimaryContentOffset()) > a7) {
            a8 = a7;
        }
        a8 -= a8 % a.mItemsPerPage;
        a2.setCursor(a8);
        return true;
    }

    private boolean goToPageNumber() {
        int a;
        GoToPageDialog a2;
        ContentManager a3 = a2.mController.getContentManager();
        if (a3 == null) {
            return false;
        }
        int a4 = PageUtils.getTotalPageNumber(a3.getSize(), a2.mItemsPerPage);
        if (a4 < 2) {
            return false;
        }
        try {
            a = Integer.parseInt(a2.mPageNumField.getText());
        }
        catch (NumberFormatException a5) {
            return false;
        }
        if (a < 1) {
            a = 1;
        } else if (a > a4) {
            a = a4;
        }
        a3.setCursor((a - 1) * a2.mItemsPerPage);
        return true;
    }
}

